/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.util;

import apoc.export.util.FormatUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.neo4j.cypher.export.SubGraph;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;

public class MetaInformation {
    public static final Set<String> GRAPHML_ALLOWED = new HashSet<String>(Arrays.asList("boolean", "int", "long", "float", "double", "string"));

    public static Map<String, Class> collectPropTypesForNodes(SubGraph graph) {
        LinkedHashMap<String, Class> propTypes = new LinkedHashMap<String, Class>();
        for (Node node : graph.getNodes()) {
            MetaInformation.updateKeyTypes(propTypes, (PropertyContainer)node);
        }
        return propTypes;
    }

    public static Map<String, Class> collectPropTypesForRelationships(SubGraph graph) {
        LinkedHashMap<String, Class> propTypes = new LinkedHashMap<String, Class>();
        for (Relationship node : graph.getRelationships()) {
            MetaInformation.updateKeyTypes(propTypes, (PropertyContainer)node);
        }
        return propTypes;
    }

    public static void updateKeyTypes(Map<String, Class> keyTypes, PropertyContainer pc) {
        for (String prop : pc.getPropertyKeys()) {
            Object value = pc.getProperty(prop);
            Class storedClass = keyTypes.get(prop);
            if (storedClass == null) {
                keyTypes.put(prop, value.getClass());
                continue;
            }
            if (storedClass == Void.TYPE || storedClass.equals(value.getClass())) continue;
            keyTypes.put(prop, Void.TYPE);
        }
    }

    public static String typeFor(Class value, Set<String> allowed) {
        if (value == Void.TYPE) {
            return null;
        }
        if (value.isArray()) {
            return MetaInformation.typeFor(value.getComponentType(), allowed);
        }
        String name = value.getSimpleName().toLowerCase();
        if (name.equals("integer")) {
            name = "int";
        }
        if (allowed == null || allowed.contains(name)) {
            return name;
        }
        if (Number.class.isAssignableFrom(value)) {
            return "int";
        }
        return null;
    }

    public static String getLabelsString(Node node) {
        if (!node.getLabels().iterator().hasNext()) {
            return "";
        }
        String delimiter = ":";
        return ":" + FormatUtils.joinLabels(node, delimiter);
    }
}

