/*
 * Decompiled with CFR 0.152.
 */
package apoc.get;

import apoc.result.NodeResult;
import apoc.result.RelationshipResult;
import apoc.util.Util;
import java.util.stream.Stream;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class Get {
    @Context
    public GraphDatabaseService db;

    public Get(GraphDatabaseService db) {
        this.db = db;
    }

    public Get() {
    }

    @Procedure
    @Description(value="apoc.get.nodes(node|id|[ids]) - quickly returns all nodes with these id's")
    public Stream<NodeResult> nodes(@Name(value="nodes") Object ids) {
        return Util.nodeStream(this.db, ids).map(NodeResult::new);
    }

    @Procedure
    @Description(value="apoc.get.rels(rel|id|[ids]) - quickly returns all relationships with these id's")
    public Stream<RelationshipResult> rels(@Name(value="relationships") Object ids) {
        return Util.relsStream(this.db, ids).map(RelationshipResult::new);
    }
}

