/*
 * Decompiled with CFR 0.152.
 */
package apoc.graph;

import apoc.cypher.Cypher;
import apoc.result.VirtualGraph;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class Graphs {
    @Context
    public GraphDatabaseService db;

    @Description(value="apoc.graph.fromData([nodes],[relationships],'name',{properties}) | creates a virtual graph object for later processing")
    @Procedure
    public Stream<VirtualGraph> fromData(@Name(value="nodes") List<Node> nodes, @Name(value="relationships") List<Relationship> relationships, @Name(value="name") String name, @Name(value="properties") Map<String, Object> properties) {
        return Stream.of(new VirtualGraph(name, nodes, relationships, properties));
    }

    @Description(value="apoc.graph.from(data,'name',{properties}) | creates a virtual graph object for later processing it tries its best to extract the graph information from the data you pass in")
    @Procedure
    public Stream<VirtualGraph> from(@Name(value="data") Object data, @Name(value="name") String name, @Name(value="properties") Map<String, Object> properties) {
        HashSet<Node> nodes = new HashSet<Node>(1000);
        HashSet<Relationship> rels = new HashSet<Relationship>(10000);
        Graphs.extract(data, nodes, rels);
        return Stream.of(new VirtualGraph(name, nodes, rels, properties));
    }

    public static boolean extract(Object data, Set<Node> nodes, Set<Relationship> rels) {
        boolean found;
        block9: {
            block11: {
                block10: {
                    block8: {
                        found = false;
                        if (data == null) {
                            return false;
                        }
                        if (data instanceof Node) {
                            nodes.add((Node)data);
                            return true;
                        }
                        if (data instanceof Relationship) {
                            rels.add((Relationship)data);
                            return true;
                        }
                        if (data instanceof Path) {
                            Iterables.addAll(nodes, (Iterable)((Path)data).nodes());
                            Iterables.addAll(rels, (Iterable)((Path)data).relationships());
                            return true;
                        }
                        if (!(data instanceof Iterable)) break block8;
                        for (Object o : (Iterable)data) {
                            found |= Graphs.extract(o, nodes, rels);
                        }
                        break block9;
                    }
                    if (!(data instanceof Map)) break block10;
                    for (Object o : ((Map)data).values()) {
                        found |= Graphs.extract(o, nodes, rels);
                    }
                    break block9;
                }
                if (!(data instanceof Iterator)) break block11;
                Iterator it = (Iterator)data;
                while (it.hasNext()) {
                    found |= Graphs.extract(it.next(), nodes, rels);
                }
                break block9;
            }
            if (!(data instanceof Object[])) break block9;
            for (Object o : (Object[])data) {
                found |= Graphs.extract(o, nodes, rels);
            }
        }
        return found;
    }

    @Description(value="apoc.graph.fromPaths(path,'name',{properties}) - creates a virtual graph object for later processing")
    @Procedure
    public Stream<VirtualGraph> fromPath(@Name(value="path") Path paths, @Name(value="name") String name, @Name(value="properties") Map<String, Object> properties) {
        return Stream.of(new VirtualGraph(name, paths.nodes(), paths.relationships(), properties));
    }

    @Description(value="apoc.graph.fromPaths([paths],'name',{properties}) - creates a virtual graph object for later processing")
    @Procedure
    public Stream<VirtualGraph> fromPaths(@Name(value="paths") List<Path> paths, @Name(value="name") String name, @Name(value="properties") Map<String, Object> properties) {
        ArrayList<Node> nodes = new ArrayList<Node>(1000);
        ArrayList<Relationship> rels = new ArrayList<Relationship>(1000);
        for (Path path : paths) {
            Iterables.addAll(nodes, (Iterable)path.nodes());
            Iterables.addAll(rels, (Iterable)path.relationships());
        }
        return Stream.of(new VirtualGraph(name, nodes, rels, properties));
    }

    @Description(value="apoc.graph.fromDB('name',{properties}) - creates a virtual graph object for later processing")
    @Procedure
    public Stream<VirtualGraph> fromDB(@Name(value="name") String name, @Name(value="properties") Map<String, Object> properties) {
        return Stream.of(new VirtualGraph(name, (Iterable<Node>)this.db.getAllNodes(), (Iterable<Relationship>)this.db.getAllRelationships(), properties));
    }

    @Description(value="apoc.graph.fromCypher('statement',{params},'name',{properties}) - creates a virtual graph object for later processing")
    @Procedure
    public Stream<VirtualGraph> fromCypher(@Name(value="statement") String statement, @Name(value="params") Map<String, Object> params, @Name(value="name") String name, @Name(value="properties") Map<String, Object> properties) {
        params = params == null ? Collections.emptyMap() : params;
        HashSet<Node> nodes = new HashSet<Node>(1000);
        HashSet<Relationship> rels = new HashSet<Relationship>(1000);
        HashMap<String, Object> props = new HashMap<String, Object>(properties);
        this.db.execute(Cypher.withParamMapping(statement, params.keySet()), params).stream().forEach(row -> row.forEach((k, v) -> {
            if (!Graphs.extract(v, nodes, rels)) {
                props.put((String)k, v);
            }
        }));
        return Stream.of(new VirtualGraph(name, nodes, rels, props));
    }
}

