/*
 * Decompiled with CFR 0.152.
 */
package apoc.index;

import apoc.meta.Meta;
import apoc.result.WeightedNodeResult;
import apoc.result.WeightedRelationshipResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.graphdb.index.IndexManager;
import org.neo4j.graphdb.index.RelationshipIndex;
import org.neo4j.index.impl.lucene.legacy.LuceneIndexImplementation;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class FulltextIndex {
    private static final Map<String, String> FULL_TEXT = LuceneIndexImplementation.FULLTEXT_CONFIG;
    public static final String NODE = Meta.Types.NODE.name();
    public static final String RELATIONSHIP = Meta.Types.RELATIONSHIP.name();
    @Context
    public GraphDatabaseService db;
    @Context
    public Log log;

    @Description(value="apoc.index.nodes('Label','prop:value*') YIELD node - lucene query on node index with the given label name")
    @Procedure(mode=Mode.READ)
    public Stream<WeightedNodeResult> nodes(@Name(value="label") String label, @Name(value="query") String query) throws Exception {
        if (!this.db.index().existsForNodes(label)) {
            return Stream.empty();
        }
        return this.toWeightedNodeResult((IndexHits<Node>)this.db.index().forNodes(label).query((Object)query));
    }

    @Description(value="apoc.index.forNodes('name',{config}) YIELD type,name,config - gets or creates node index")
    @Procedure(mode=Mode.WRITE)
    public Stream<IndexInfo> forNodes(@Name(value="name") String name, @Name(value="config", defaultValue="") Map<String, String> config) {
        Index<Node> index = this.getNodeIndex(name, config);
        return Stream.of(new IndexInfo(NODE, name, this.db.index().getConfiguration(index)));
    }

    private Index<Node> getNodeIndex(String name, Map<String, String> config) {
        IndexManager mgr = this.db.index();
        return config == null ? mgr.forNodes(name) : mgr.forNodes(name, config);
    }

    @Description(value="apoc.index.forRelationships('name',{config}) YIELD type,name,config - gets or creates relationship index")
    @Procedure(mode=Mode.WRITE)
    public Stream<IndexInfo> forRelationships(@Name(value="name") String name, @Name(value="config", defaultValue="") Map<String, String> config) {
        RelationshipIndex index = this.getRelationshipIndex(name, config);
        return Stream.of(new IndexInfo(RELATIONSHIP, name, this.db.index().getConfiguration((Index)index)));
    }

    private RelationshipIndex getRelationshipIndex(String name, Map<String, String> config) {
        IndexManager mgr = this.db.index();
        return config == null ? mgr.forRelationships(name) : mgr.forRelationships(name, config);
    }

    @Description(value="apoc.index.remove('name') YIELD type,name,config - removes an manual index")
    @Procedure(mode=Mode.WRITE)
    public Stream<IndexInfo> remove(@Name(value="name") String name) {
        Index index;
        IndexManager mgr = this.db.index();
        ArrayList<IndexInfo> indexInfos = new ArrayList<IndexInfo>(2);
        if (mgr.existsForNodes(name)) {
            index = mgr.forNodes(name);
            indexInfos.add(new IndexInfo(NODE, name, mgr.getConfiguration(index)));
            index.delete();
        }
        if (mgr.existsForRelationships(name)) {
            index = mgr.forRelationships(name);
            indexInfos.add(new IndexInfo(RELATIONSHIP, name, mgr.getConfiguration(index)));
            index.delete();
        }
        return indexInfos.stream();
    }

    @Description(value="apoc.index.list() - YIELD type,name,config - lists all manual indexes")
    @Procedure(mode=Mode.READ)
    public Stream<IndexInfo> list() {
        Index index;
        IndexManager mgr = this.db.index();
        ArrayList<IndexInfo> indexInfos = new ArrayList<IndexInfo>(100);
        for (String name : mgr.nodeIndexNames()) {
            index = mgr.forNodes(name);
            indexInfos.add(new IndexInfo(NODE, name, mgr.getConfiguration(index)));
        }
        for (String name : mgr.relationshipIndexNames()) {
            index = mgr.forRelationships(name);
            indexInfos.add(new IndexInfo(RELATIONSHIP, name, mgr.getConfiguration(index)));
        }
        return indexInfos.stream();
    }

    private Stream<WeightedNodeResult> toWeightedNodeResult(IndexHits<Node> hits) {
        ArrayList<WeightedNodeResult> results = new ArrayList<WeightedNodeResult>(hits.size());
        while (hits.hasNext()) {
            results.add(new WeightedNodeResult((Node)hits.next(), hits.currentScore()));
        }
        return results.stream();
    }

    private Stream<WeightedRelationshipResult> toWeightedRelationshipResult(IndexHits<Relationship> hits) {
        ArrayList<WeightedRelationshipResult> results = new ArrayList<WeightedRelationshipResult>(hits.size());
        while (hits.hasNext()) {
            results.add(new WeightedRelationshipResult((Relationship)hits.next(), hits.currentScore()));
        }
        return results.stream();
    }

    @Description(value="apoc.index.relationships('TYPE','prop:value*') YIELD rel - lucene query on relationship index with the given type name")
    @Procedure(mode=Mode.READ)
    public Stream<WeightedRelationshipResult> relationships(@Name(value="type") String type, @Name(value="query") String query) throws Exception {
        if (!this.db.index().existsForRelationships(type)) {
            return Stream.empty();
        }
        return this.toWeightedRelationshipResult((IndexHits<Relationship>)this.db.index().forRelationships(type).query((Object)query, null, null));
    }

    @Description(value="apoc.index.between(node1,'TYPE',node2,'prop:value*') YIELD rel - lucene query on relationship index with the given type name bound by either or both sides (each node parameter can be null)")
    @Procedure(mode=Mode.READ)
    public Stream<WeightedRelationshipResult> between(@Name(value="from") Node from, @Name(value="type") String type, @Name(value="to") Node to, @Name(value="query") String query) throws Exception {
        if (!this.db.index().existsForRelationships(type)) {
            return Stream.empty();
        }
        return this.toWeightedRelationshipResult((IndexHits<Relationship>)this.db.index().forRelationships(type).query((Object)query, from, to));
    }

    @Procedure(mode=Mode.READ)
    @Description(value="out(node,'TYPE','prop:value*') YIELD node - lucene query on relationship index with the given type name for *outgoing* relationship of the given node, *returns end-nodes*")
    public Stream<WeightedNodeResult> out(@Name(value="from") Node from, @Name(value="type") String type, @Name(value="query") String query) throws Exception {
        if (!this.db.index().existsForRelationships(type)) {
            return Stream.empty();
        }
        return this.toWeightedRelationshipResult((IndexHits<Relationship>)this.db.index().forRelationships(type).query((Object)query, from, null)).map(w -> new WeightedNodeResult(w.rel.getEndNode(), w.weight));
    }

    @Procedure(mode=Mode.READ)
    @Description(value="apoc.index.in(node,'TYPE','prop:value*') YIELD node lucene query on relationship index with the given type name for *incoming* relationship of the given node, *returns start-nodes*")
    public Stream<WeightedNodeResult> in(@Name(value="to") Node to, @Name(value="type") String type, @Name(value="query") String query) throws Exception {
        if (!this.db.index().existsForRelationships(type)) {
            return Stream.empty();
        }
        return this.toWeightedRelationshipResult((IndexHits<Relationship>)this.db.index().forRelationships(type).query((Object)query, null, to)).map(w -> new WeightedNodeResult(w.rel.getStartNode(), w.weight));
    }

    @Procedure(mode=Mode.WRITE)
    @Description(value="apoc.index.addNode(node,['prop1',...]) add node to an index for each label it has")
    public void addNode(@Name(value="node") Node node, @Name(value="properties") List<String> propKeys) {
        for (Label label : node.getLabels()) {
            this.addNodeByLabel(label.name(), node, propKeys);
        }
    }

    @Procedure(mode=Mode.WRITE)
    @Description(value="apoc.index.addNodeMap(node,{key:value}) add node to an index for each label it has with the given attributes which can also be computed")
    public void addNodeMap(@Name(value="node") Node node, @Name(value="properties") Map<String, Object> document) {
        for (Label label : node.getLabels()) {
            this.addNodeMapByName(label.name(), node, document);
        }
    }

    @Procedure(mode=Mode.WRITE)
    @Description(value="apoc.index.addNodeMapByName(index, node,{key:value}) add node to an index for each label it has with the given attributes which can also be computed")
    public void addNodeMapByName(@Name(value="index") String index, @Name(value="node") Node node, @Name(value="properties") Map<String, Object> document) {
        this.indexEntityWithMap(node, document, this.getNodeIndex(index, FULL_TEXT));
    }

    @Procedure(mode=Mode.WRITE)
    @Description(value="apoc.index.addNodeByLabel(node,'Label',['prop1',...]) add node to an index for the given label")
    public void addNodeByLabel(@Name(value="label") String label, @Name(value="node") Node node, @Name(value="properties") List<String> propKeys) {
        this.indexEntityProperties(node, propKeys, this.getNodeIndex(label, FULL_TEXT));
    }

    @Procedure(mode=Mode.WRITE)
    @Description(value="apoc.index.addNodeByName('name',node,['prop1',...]) add node to an index for the given name")
    public void addNodeByName(@Name(value="name") String name, @Name(value="node") Node node, @Name(value="properties") List<String> propKeys) {
        Index<Node> index = this.getNodeIndex(name, null);
        this.indexEntityProperties(node, propKeys, index);
    }

    @Procedure(mode=Mode.WRITE)
    @Description(value="apoc.index.addRelationship(rel,['prop1',...]) add relationship to an index for its type")
    public void addRelationship(@Name(value="relationship") Relationship rel, @Name(value="properties") List<String> propKeys) {
        RelationshipIndex index = this.getRelationshipIndex(rel.getType().name(), FULL_TEXT);
        this.indexEntityProperties((PropertyContainer)rel, propKeys, (Index)index);
    }

    @Procedure(mode=Mode.WRITE)
    @Description(value="apoc.index.addRelationshipMap(rel,{key:value}) add relationship to an index for its type indexing the given document which can be computed")
    public void addRelationshipMap(@Name(value="relationship") Relationship rel, @Name(value="docuemnt") Map<String, Object> document) {
        this.addRelationshipMapByName(rel.getType().name(), rel, document);
    }

    @Procedure(mode=Mode.WRITE)
    @Description(value="apoc.index.addRelationshipMapByName(index, rel,{key:value}) add relationship to an index for its type indexing the given document which can be computed")
    public void addRelationshipMapByName(@Name(value="index") String indexName, @Name(value="relationship") Relationship rel, @Name(value="docuemnt") Map<String, Object> document) {
        this.indexEntityWithMap((PropertyContainer)rel, document, (Index)this.getRelationshipIndex(indexName, FULL_TEXT));
    }

    @Procedure(mode=Mode.WRITE)
    @Description(value="apoc.index.addRelationshipByName('name',rel,['prop1',...]) add relationship to an index for the given name")
    public void addRelationshipByName(@Name(value="name") String name, @Name(value="relationship") Relationship rel, @Name(value="properties") List<String> propKeys) {
        RelationshipIndex index = this.getRelationshipIndex(name, null);
        this.indexEntityProperties((PropertyContainer)rel, propKeys, (Index)index);
    }

    private <T extends PropertyContainer> void indexEntityProperties(T pc, List<String> propKeys, Index<T> index) {
        Map properties = pc.getProperties(propKeys.toArray(new String[propKeys.size()]));
        this.indexEntityWithMap(pc, properties, index);
    }

    private <T extends PropertyContainer> void indexEntityWithMap(T pc, Map<String, Object> document, Index<T> index) {
        index.remove(pc);
        document.forEach((key, value) -> {
            index.remove(pc, key);
            index.add(pc, key, value);
        });
    }

    @Procedure(mode=Mode.WRITE)
    @Description(value="apoc.index.removeNodeByName('name',node) remove node from an index for the given name")
    public void removeNodeByName(@Name(value="name") String name, @Name(value="node") Node node) {
        Index<Node> index = this.getNodeIndex(name, null);
        index.remove((PropertyContainer)node);
    }

    @Procedure(mode=Mode.WRITE)
    @Description(value="apoc.index.removeRelationshipByName('name',rel) remove relationship from an index for the given name")
    public void removeRelationshipByName(@Name(value="name") String name, @Name(value="relationship") Relationship rel) {
        RelationshipIndex index = this.getRelationshipIndex(name, null);
        index.remove((PropertyContainer)rel);
    }

    public static class IndexInfo {
        public final String type;
        public final String name;
        public final Map<String, String> config;

        public IndexInfo(String type, String name, Map<String, String> config) {
            this.type = type;
            this.name = name;
            this.config = config;
        }
    }
}

