/*
 * Decompiled with CFR 0.152.
 */
package apoc.index;

import apoc.ApocConfiguration;
import apoc.Pools;
import apoc.util.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.commons.lang3.time.StopWatch;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.event.LabelEntry;
import org.neo4j.graphdb.event.PropertyEntry;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.graphdb.event.TransactionEventHandler;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexManager;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.logging.Log;

public class IndexUpdateTransactionEventHandler
extends TransactionEventHandler.Adapter<Collection<Consumer<Void>>> {
    private final GraphDatabaseService graphDatabaseService;
    private final boolean async;
    private final BlockingQueue<Consumer<Void>> indexCommandQueue;
    private final boolean stopWatchEnabled;
    private final Log log;
    private Map<String, Map<String, Collection<Index<Node>>>> indexesByLabelAndProperty;
    private ScheduledFuture<?> configUpdateFuture = null;

    public IndexUpdateTransactionEventHandler(GraphDatabaseAPI graphDatabaseService, Log log, boolean async, int queueCapacity, boolean stopWatchEnabled) {
        this.graphDatabaseService = graphDatabaseService;
        this.log = log;
        this.async = async;
        this.indexCommandQueue = new LinkedBlockingQueue<Consumer<Void>>(queueCapacity);
        this.stopWatchEnabled = stopWatchEnabled;
    }

    public BlockingQueue<Consumer<Void>> getIndexCommandQueue() {
        return this.indexCommandQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object logDuration(String message, Supplier supplier) {
        if (this.stopWatchEnabled) {
            StopWatch sw = new StopWatch();
            try {
                sw.start();
                Object t = supplier.get();
                return t;
            }
            finally {
                sw.stop();
                this.log.info(message + " took " + sw.getTime() + " millsi");
            }
        }
        return supplier.get();
    }

    public Collection<Consumer<Void>> beforeCommit(TransactionData data) throws Exception {
        return (Collection)this.logDuration("beforeCommit", () -> {
            this.getIndexesByLabelAndProperty();
            LinkedList state = this.async ? new LinkedList() : null;
            this.iterateNodePropertyChange(Iterables.stream((Iterable)data.assignedNodeProperties()), false, (index, node, key, value, oldValue) -> this.indexUpdate(state, aVoid -> {
                if (oldValue != null) {
                    index.remove((PropertyContainer)node, key);
                    index.remove((PropertyContainer)node, "search");
                }
                index.add((PropertyContainer)node, key, value);
                index.add((PropertyContainer)node, "search", value);
            }));
            this.iterateNodePropertyChange(Iterables.stream((Iterable)data.removedNodeProperties()).filter(nodePropertyEntry -> !Iterators.contains(data.deletedNodes().iterator(), (Object)nodePropertyEntry.entity())), true, (index, node, key, value, oldValue) -> this.indexUpdate(state, aVoid -> {
                index.remove((PropertyContainer)node, key);
                index.remove((PropertyContainer)node, "search");
            }));
            Set createdNodes = Iterables.asSet((Iterable)data.createdNodes());
            Set deletedNodes = Iterables.asSet((Iterable)data.deletedNodes());
            this.iterateLabelChanges(Iterables.stream((Iterable)data.assignedLabels()).filter(labelEntry -> !createdNodes.contains(labelEntry.node())), (index, node, key, value, ignore) -> this.indexUpdate(state, aVoid -> {
                index.add((PropertyContainer)node, key, value);
                index.add((PropertyContainer)node, "search", value);
            }));
            this.iterateLabelChanges(Iterables.stream((Iterable)data.removedLabels()).filter(labelEntry -> !deletedNodes.contains(labelEntry.node())), (index, node, key, value, ignore) -> this.indexUpdate(state, aVoid -> {
                index.remove((PropertyContainer)node, key);
                index.remove((PropertyContainer)node, "search");
            }));
            return state;
        });
    }

    public void afterCommit(TransactionData data, Collection<Consumer<Void>> state) {
        this.logDuration("afterCommit", () -> {
            if (this.async) {
                for (Consumer consumer : state) {
                    try {
                        this.indexCommandQueue.put(consumer);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            return null;
        });
    }

    private void iterateNodePropertyChange(Stream<PropertyEntry<Node>> stream, boolean propertyRemoved, IndexFunction<Index<Node>, Node, String, Object, Object> function) {
        stream.forEach(nodePropertyEntry -> {
            Node entity = (Node)nodePropertyEntry.entity();
            String key = nodePropertyEntry.key();
            Object value = propertyRemoved ? null : nodePropertyEntry.value();
            entity.getLabels().forEach(label -> {
                Collection<Index<Node>> indices;
                String labelName = label.name();
                Map<String, Collection<Index<Node>>> propertyIndexMap = this.indexesByLabelAndProperty.get(labelName);
                if (propertyIndexMap != null && (indices = propertyIndexMap.get(key)) != null) {
                    for (Index<Node> index : indices) {
                        String indexKey = labelName + "." + key;
                        function.apply(index, entity, indexKey, value, nodePropertyEntry.previouslyCommitedValue());
                    }
                }
            });
        });
    }

    private void iterateLabelChanges(Stream<LabelEntry> stream, IndexFunction<Index<Node>, Node, String, Object, Void> function) {
        stream.forEach(labelEntry -> {
            String labelName = labelEntry.label().name();
            Map<String, Collection<Index<Node>>> propertyIndicesMap = this.indexesByLabelAndProperty.get(labelName);
            if (propertyIndicesMap != null) {
                Node entity = labelEntry.node();
                for (String key : entity.getPropertyKeys()) {
                    Collection<Index<Node>> indices = propertyIndicesMap.get(key);
                    if (indices == null) continue;
                    for (Index<Node> index : indices) {
                        Object value = entity.getProperty(key);
                        String indexKey = labelName + "." + key;
                        function.apply(index, entity, indexKey, value, null);
                    }
                }
            }
        });
    }

    private Void indexUpdate(Collection<Consumer<Void>> state, Consumer<Void> indexAction) {
        if (state == null) {
            indexAction.accept(null);
        } else {
            state.add(indexAction);
        }
        return null;
    }

    public Map<String, Map<String, Collection<Index<Node>>>> getIndexesByLabelAndProperty() {
        if (this.indexesByLabelAndProperty == null) {
            this.indexesByLabelAndProperty = this.initIndexConfiguration();
        }
        return this.indexesByLabelAndProperty;
    }

    public void resetConfiguration() {
        this.indexesByLabelAndProperty = null;
    }

    private synchronized Map<String, Map<String, Collection<Index<Node>>>> initIndexConfiguration() {
        HashMap<String, Map<String, Collection<Index<Node>>>> indexesByLabelAndProperty = new HashMap<String, Map<String, Collection<Index<Node>>>>();
        try (Transaction tx = this.graphDatabaseService.beginTx();){
            IndexManager indexManager = this.graphDatabaseService.index();
            for (String indexName : indexManager.nodeIndexNames()) {
                Index index = indexManager.forNodes(indexName);
                Map indexConfig = indexManager.getConfiguration(index);
                if (!Util.toBoolean(indexConfig.get("autoUpdate"))) continue;
                String labels = indexConfig.getOrDefault("labels", "");
                for (String label : labels.split(":")) {
                    String[] keysForLabel;
                    Map propertyKeyToIndexMap = indexesByLabelAndProperty.computeIfAbsent(label, s -> new HashMap());
                    for (String property : keysForLabel = indexConfig.getOrDefault("keysForLabel:" + label, "").split(":")) {
                        propertyKeyToIndexMap.computeIfAbsent(property, s -> new ArrayList()).add(index);
                    }
                }
            }
            tx.success();
        }
        return indexesByLabelAndProperty;
    }

    private void startPeriodicIndexConfigChangeUpdates(long indexConfigUpdateInternal) {
        this.configUpdateFuture = Pools.SCHEDULED.scheduleAtFixedRate(() -> {
            this.indexesByLabelAndProperty = this.initIndexConfiguration();
        }, indexConfigUpdateInternal, indexConfigUpdateInternal, TimeUnit.SECONDS);
    }

    private void stopPeriodicIndexConfigChangeUpdates() {
        if (this.configUpdateFuture != null) {
            this.configUpdateFuture.cancel(true);
        }
    }

    public static class LifeCycle {
        private final GraphDatabaseAPI db;
        private final Log log;
        private IndexUpdateTransactionEventHandler indexUpdateTransactionEventHandler;

        public LifeCycle(GraphDatabaseAPI db, Log log) {
            this.db = db;
            this.log = log;
        }

        public void start() {
            boolean enabled = ApocConfiguration.isEnabled("autoIndex.enabled");
            if (enabled) {
                boolean async = ApocConfiguration.isEnabled("autoIndex.async");
                boolean stopWatchEnabled = ApocConfiguration.isEnabled("autoIndex.tx_handler_stopwatch");
                int queueCapacity = Integer.parseInt(ApocConfiguration.get("autoIndex.queue_capacity", "100000"));
                this.indexUpdateTransactionEventHandler = new IndexUpdateTransactionEventHandler(this.db, this.log, async, queueCapacity, stopWatchEnabled);
                if (async) {
                    this.startIndexTrackingThread(this.db, this.indexUpdateTransactionEventHandler.getIndexCommandQueue(), Long.parseLong(ApocConfiguration.get("autoIndex.async_rollover_opscount", "50000")), Long.parseLong(ApocConfiguration.get("autoIndex.async_rollover_millis", "5000")), this.log);
                }
                this.db.registerTransactionEventHandler((TransactionEventHandler)this.indexUpdateTransactionEventHandler);
                long indexConfigUpdateInternal = Util.toLong(ApocConfiguration.get("autoIndex.configUpdateInterval", 10L));
                if (indexConfigUpdateInternal > 0L) {
                    this.indexUpdateTransactionEventHandler.startPeriodicIndexConfigChangeUpdates(indexConfigUpdateInternal);
                }
            }
        }

        private void startIndexTrackingThread(GraphDatabaseAPI db, BlockingQueue<Consumer<Void>> indexCommandQueue, long opsCountRollover, long millisRollover, Log log) {
            new Thread(() -> {
                Transaction tx = db.beginTx();
                int opsCount = 0;
                long lastCommit = System.currentTimeMillis();
                try {
                    while (true) {
                        Consumer indexCommand = (Consumer)indexCommandQueue.poll(millisRollover, TimeUnit.MILLISECONDS);
                        long now = System.currentTimeMillis();
                        if (opsCount > 0 && (now - lastCommit > millisRollover || (long)opsCount >= opsCountRollover)) {
                            tx.success();
                            tx.close();
                            tx = db.beginTx();
                            log.info("background indexing thread doing tx rollover, opscount " + opsCount + ", millis since last rollover " + (now - lastCommit));
                            lastCommit = now;
                            opsCount = 0;
                        }
                        if (indexCommand == null) {
                            boolean running = ((LifeSupport)db.getDependencyResolver().resolveDependency(LifeSupport.class)).isRunning();
                            if (running) {
                                if (opsCount != 0) continue;
                                lastCommit = now;
                                continue;
                            }
                            log.info("system shutdown detected, terminating indexing background thread");
                            break;
                        }
                        ++opsCount;
                        indexCommand.accept(null);
                    }
                }
                catch (InterruptedException e) {
                    log.error(e.getMessage(), (Throwable)e);
                    throw new RuntimeException(e);
                }
                finally {
                    tx.success();
                    tx.close();
                    log.info("stopping background thread for async index updates");
                }
            }).start();
            log.info("started background thread for async index updates");
        }

        public void stop() {
            if (this.indexUpdateTransactionEventHandler != null) {
                this.db.unregisterTransactionEventHandler((TransactionEventHandler)this.indexUpdateTransactionEventHandler);
                this.indexUpdateTransactionEventHandler.stopPeriodicIndexConfigChangeUpdates();
            }
        }

        public void resetConfiguration() {
            if (this.indexUpdateTransactionEventHandler != null) {
                this.indexUpdateTransactionEventHandler.resetConfiguration();
            }
        }
    }

    @FunctionalInterface
    static interface IndexFunction<A, B, C, D, E> {
        public void apply(A var1, B var2, C var3, D var4, E var5);
    }
}

