/*
 * Decompiled with CFR 0.152.
 */
package apoc.index;

import apoc.result.ListResult;
import apoc.result.NodeResult;
import apoc.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.Sort;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.index.IndexNotApplicableKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.DuplicateSchemaRuleException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.impl.schema.reader.SimpleIndexReader;
import org.neo4j.kernel.api.impl.schema.reader.SortedIndexReader;
import org.neo4j.kernel.api.schema.IndexQuery;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class SchemaIndex {
    @Context
    public GraphDatabaseService db;
    @Context
    public KernelTransaction tx;

    @Procedure
    @Description(value="apoc.index.relatedNodes([nodes],label,key,'<TYPE'/'TYPE>'/'TYPE',limit) yield node - schema range scan which keeps index order and adds limit and checks opposite node of relationship against the given set of nodes")
    public Stream<NodeResult> related(@Name(value="nodes") List<Node> nodes, @Name(value="label") String label, @Name(value="key") String key, @Name(value="relationship") String relationship, @Name(value="limit") long limit) throws SchemaRuleNotFoundException, IndexNotFoundKernelException, IOException, DuplicateSchemaRuleException, IndexNotApplicableKernelException {
        int keyId;
        HashSet<Node> nodeSet = new HashSet<Node>(nodes);
        Direction dir = Direction.BOTH;
        if (relationship.startsWith("<")) {
            dir = Direction.INCOMING;
            relationship = relationship.substring(1);
        }
        if (relationship.endsWith(">")) {
            dir = Direction.OUTGOING;
            relationship = relationship.substring(0, relationship.length() - 1);
        }
        RelationshipType type = RelationshipType.withName((String)relationship);
        ArrayList<Node> result = new ArrayList<Node>((int)limit);
        boolean reverse = false;
        try (Statement stmt = this.tx.acquireStatement();){
            keyId = stmt.readOperations().propertyKeyGetForName(key);
        }
        IndexQuery.NumberRangePredicate numberRangePredicate = IndexQuery.range((int)keyId, (Number)Long.MIN_VALUE, (boolean)true, (Number)Long.MAX_VALUE, (boolean)true);
        PrimitiveLongIterator it = this.getIndexReader(label, key).query(new IndexQuery[]{numberRangePredicate});
        block9: while (it.hasNext() && (long)result.size() < limit) {
            Node node = this.db.getNodeById(it.next());
            for (Relationship rel : node.getRelationships(dir, new RelationshipType[]{type})) {
                Node other = rel.getOtherNode(node);
                if (!nodeSet.contains(other)) continue;
                result.add(node);
                continue block9;
            }
        }
        return result.stream().map(NodeResult::new);
    }

    @Procedure
    @Description(value="apoc.index.orderedRange(label,key,min,max,sort-relevance,limit) yield node - schema range scan which keeps index order and adds limit, values can be null, boundaries are inclusive")
    public Stream<NodeResult> orderedRange(@Name(value="label") String label, @Name(value="key") String key, @Name(value="min") Object min, @Name(value="max") Object max, @Name(value="relevance") boolean relevance, @Name(value="limit") long limit) throws SchemaRuleNotFoundException, IndexNotFoundKernelException, DuplicateSchemaRuleException {
        SortedIndexReader sortedIndexReader = this.getSortedIndexReader(label, key, limit, this.getSort(min, max, relevance));
        PrimitiveLongIterator it = this.queryForRange(sortedIndexReader, min, max);
        return Util.toLongStream(it).mapToObj(id -> new NodeResult(this.db.getNodeById(id)));
    }

    public Sort getSort(Object min, Object max, boolean relevance) {
        return Sort.RELEVANCE;
    }

    private PrimitiveLongIterator queryForRange(SortedIndexReader sortedIndexReader, Object min, Object max) {
        if ((min == null || min instanceof Number) && (max == null || max instanceof Number)) {
            return sortedIndexReader.rangeSeekByNumberInclusive((Number)min, (Number)max);
        }
        String minValue = min == null ? null : min.toString();
        String maxValue = max == null ? null : max.toString();
        return sortedIndexReader.rangeSeekByString(minValue, true, maxValue, true);
    }

    @Procedure
    @Description(value="apoc.index.orderedByText(label,key,operator,value,sort-relevance,limit) yield node - schema string search which keeps index order and adds limit, operator is 'STARTS WITH' or 'CONTAINS'")
    public Stream<NodeResult> orderedByText(@Name(value="label") String label, @Name(value="key") String key, @Name(value="operator") String operator, @Name(value="value") String value, @Name(value="relevance") boolean relevance, @Name(value="limit") long limit) throws SchemaRuleNotFoundException, IndexNotFoundKernelException, DuplicateSchemaRuleException {
        SortedIndexReader sortedIndexReader = this.getSortedIndexReader(label, key, limit, this.getSort(value, value, relevance));
        PrimitiveLongIterator it = this.queryForString(sortedIndexReader, operator, value);
        return Util.toLongStream(it).mapToObj(id -> new NodeResult(this.db.getNodeById(id)));
    }

    private PrimitiveLongIterator queryForString(SortedIndexReader sortedIndexReader, String operator, String value) {
        switch (operator.trim().toUpperCase()) {
            case "CONTAINS": {
                return sortedIndexReader.containsString(value);
            }
            case "STARTS WITH": {
                return sortedIndexReader.rangeSeekByPrefix(value);
            }
        }
        throw new IllegalArgumentException("Unknown Operator " + operator);
    }

    private SortedIndexReader getSortedIndexReader(String label, String key, long limit, Sort sort) throws SchemaRuleNotFoundException, IndexNotFoundKernelException, DuplicateSchemaRuleException {
        SimpleIndexReader reader = (SimpleIndexReader)this.getIndexReader(label, key);
        return new SortedIndexReader(reader, limit, sort);
    }

    private org.neo4j.storageengine.api.schema.IndexReader getIndexReader(String label, String key) throws SchemaRuleNotFoundException, IndexNotFoundKernelException, DuplicateSchemaRuleException {
        try (KernelStatement stmt = (KernelStatement)this.tx.acquireStatement();){
            ReadOperations reads = stmt.readOperations();
            LabelSchemaDescriptor labelSchemaDescriptor = new LabelSchemaDescriptor(reads.labelGetForName(label), new int[]{reads.propertyKeyGetForName(key)});
            IndexDescriptor descriptor = reads.indexGetForSchema(labelSchemaDescriptor);
            org.neo4j.storageengine.api.schema.IndexReader indexReader = stmt.getStoreStatement().getIndexReader(descriptor);
            return indexReader;
        }
    }

    @Procedure(value="apoc.schema.properties.distinct")
    @Description(value="apoc.schema.properties.distinct(label, key) - quickly returns all distinct values for a given key")
    public Stream<ListResult> distinct(@Name(value="label") String label, @Name(value="key") String key) throws SchemaRuleNotFoundException, IndexNotFoundKernelException, IOException, DuplicateSchemaRuleException {
        List<Object> values = this.distinctTerms(label, key);
        return Stream.of(new ListResult(values));
    }

    private List<Object> distinctTerms(@Name(value="label") String label, @Name(value="key") String key) throws SchemaRuleNotFoundException, IndexNotFoundKernelException, IOException, DuplicateSchemaRuleException {
        try (KernelStatement stmt = (KernelStatement)this.tx.acquireStatement();){
            ReadOperations reads = stmt.readOperations();
            LabelSchemaDescriptor labelSchemaDescriptor = new LabelSchemaDescriptor(reads.labelGetForName(label), new int[]{reads.propertyKeyGetForName(key)});
            IndexDescriptor descriptor = reads.indexGetForSchema(labelSchemaDescriptor);
            SimpleIndexReader reader = (SimpleIndexReader)stmt.getStoreStatement().getIndexReader(descriptor);
            SortedIndexReader sortedIndexReader = new SortedIndexReader(reader, 0L, Sort.INDEXORDER);
            LinkedHashSet<String> values = new LinkedHashSet<String>(100);
            Fields fields = MultiFields.getFields((IndexReader)sortedIndexReader.getIndexSearcher().getIndexReader());
            Terms terms = fields.terms("string");
            if (terms != null) {
                TermsEnum termsEnum = terms.iterator();
                while (termsEnum.next() != null) {
                    values.add(termsEnum.term().utf8ToString());
                }
            }
            ArrayList<Object> arrayList = new ArrayList<Object>(values);
            return arrayList;
        }
    }

    @Procedure(value="apoc.schema.properties.distinctCount")
    @Description(value="apoc.schema.properties.distinctCount([label], [key]) YIELD label, key, value, count - quickly returns all distinct values and counts for a given key")
    public Stream<PropertyValueCount> distinctCount(@Name(value="label", defaultValue="") String labelName, @Name(value="key", defaultValue="") String keyName) throws SchemaRuleNotFoundException, IndexNotFoundKernelException, IOException {
        Iterable labels = labelName.isEmpty() ? this.db.schema().getIndexes() : this.db.schema().getIndexes(Label.label((String)labelName));
        return StreamSupport.stream(labels.spliterator(), false).filter(i -> keyName.isEmpty() || this.isKeyIndexed((IndexDefinition)i, keyName)).flatMap(index -> {
            List<String> keys = keyName.isEmpty() ? index.getPropertyKeys() : Collections.singletonList(keyName);
            return StreamSupport.stream(keys.spliterator(), false).flatMap(key -> {
                String label = index.getLabel().name();
                return this.distinctTermsCount(label, (String)key).entrySet().stream().map(e -> new PropertyValueCount(label, (String)key, (String)e.getKey(), ((Integer)e.getValue()).intValue()));
            });
        });
    }

    private boolean isKeyIndexed(@Name(value="index") IndexDefinition index, @Name(value="key") String key) {
        return StreamSupport.stream(index.getPropertyKeys().spliterator(), false).anyMatch(k -> k.equals(key));
    }

    private Map<String, Integer> distinctTermsCount(@Name(value="label") String label, @Name(value="key") String key) {
        try {
            SortedIndexReader sortedIndexReader = this.getSortedIndexReader(label, key, 0L, Sort.INDEXORDER);
            Fields fields = MultiFields.getFields((IndexReader)sortedIndexReader.getIndexSearcher().getIndexReader());
            HashMap<String, Integer> values = new HashMap<String, Integer>();
            Terms terms = fields.terms("string");
            if (terms != null) {
                TermsEnum termsEnum = terms.iterator();
                while (termsEnum.next() != null) {
                    values.put(termsEnum.term().utf8ToString(), termsEnum.docFreq());
                }
            }
            return values;
        }
        catch (Exception e) {
            throw new RuntimeException("Error collecting distinct terms of label: " + label + " and key: " + key, e);
        }
    }

    public static class PropertyValueCount {
        public String label;
        public String key;
        public String value;
        public long count;

        public PropertyValueCount(String label, String key, String value, long count) {
            this.label = label;
            this.key = key;
            this.value = value;
            this.count = count;
        }
    }
}

