/*
 * Decompiled with CFR 0.152.
 */
package apoc.load;

import apoc.ApocConfiguration;
import apoc.result.RowResult;
import apoc.util.MapUtil;
import java.io.InputStream;
import java.net.URI;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.compress.utils.IOUtils;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class Jdbc {
    @Context
    public Log log;

    private static Connection getConnection(String jdbcUrl) throws Exception {
        URI uri = new URI(jdbcUrl.substring("jdbc:".length()));
        String userInfo = uri.getUserInfo();
        if (userInfo != null) {
            String[] user = userInfo.split(":");
            String cleanUrl = jdbcUrl.substring(0, jdbcUrl.indexOf("://") + 3) + jdbcUrl.substring(jdbcUrl.indexOf("@") + 1);
            return DriverManager.getConnection(cleanUrl, user[0], user[1]);
        }
        return DriverManager.getConnection(jdbcUrl);
    }

    @Procedure
    @Description(value="apoc.load.driver('org.apache.derby.jdbc.EmbeddedDriver') register JDBC driver of source database")
    public void driver(@Name(value="driverClass") String driverClass) {
        Jdbc.loadDriver(driverClass);
    }

    private static void loadDriver(@Name(value="driverClass") String driverClass) {
        try {
            Class.forName(driverClass);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not load driver class " + driverClass + " " + e.getMessage());
        }
    }

    @Procedure
    @Description(value="apoc.load.jdbc('key or url','table or statement') YIELD row - load from relational database, from a full table or a sql statement")
    public Stream<RowResult> jdbc(@Name(value="jdbc") String urlOrKey, @Name(value="tableOrSql") String tableOrSelect, @Name(value="params", defaultValue="[]") List<Object> params) {
        return this.executeQuery(urlOrKey, tableOrSelect, params.toArray(new Object[params.size()]));
    }

    @Procedure
    @Deprecated
    @Description(value="deprecated - please use: apoc.load.jdbc('key or url','statement',[params]) YIELD row - load from relational database, from a sql statement with parameters")
    public Stream<RowResult> jdbcParams(@Name(value="jdbc") String urlOrKey, @Name(value="sql") String select, @Name(value="params") List<Object> params) {
        return this.executeQuery(urlOrKey, select, params.toArray(new Object[params.size()]));
    }

    private Stream<RowResult> executeQuery(String urlOrKey, String tableOrSelect, Object ... params) {
        String url = urlOrKey.contains(":") ? urlOrKey : Jdbc.getJdbcUrl(urlOrKey);
        String query = tableOrSelect.indexOf(32) == -1 ? "SELECT * FROM " + tableOrSelect : tableOrSelect;
        try {
            Connection connection = Jdbc.getConnection(url);
            try {
                PreparedStatement stmt = connection.prepareStatement(query);
                try {
                    for (int i = 0; i < params.length; ++i) {
                        stmt.setObject(i + 1, params[i]);
                    }
                    ResultSet rs = stmt.executeQuery();
                    rs.setFetchSize(5000);
                    ResultSetIterator supplier = new ResultSetIterator(this.log, rs, true);
                    Spliterator<Map<String, Object>> spliterator = Spliterators.spliteratorUnknownSize(supplier, 16);
                    return (Stream)StreamSupport.stream(spliterator, false).map(RowResult::new).onClose(() -> Jdbc.closeIt(this.log, stmt, connection));
                }
                catch (Exception sqle) {
                    Jdbc.closeIt(this.log, stmt);
                    throw sqle;
                }
            }
            catch (Exception sqle) {
                Jdbc.closeIt(this.log, connection);
                throw sqle;
            }
        }
        catch (Exception e) {
            this.log.error(String.format("Cannot execute SQL statement `%s`.%nError:%n%s", query, e.getMessage()), (Throwable)e);
            String errorMessage = "Cannot execute SQL statement `%s`.%nError:%n%s";
            if (e.getMessage().contains("No suitable driver")) {
                errorMessage = "Cannot execute SQL statement `%s`.%nError:%n%s%n%s";
            }
            throw new RuntimeException(String.format(errorMessage, query, e.getMessage(), "Please download and copy the JDBC driver into $NEO4J_HOME/plugins,more details at https://neo4j-contrib.github.io/neo4j-apoc-procedures/#_load_jdbc_resources"), e);
        }
    }

    @Procedure
    @Description(value="apoc.load.jdbcUpdate('key or url','statement',[params]) YIELD row - update relational database, from a SQL statement with optional parameters")
    public Stream<RowResult> jdbcUpdate(@Name(value="jdbc") String urlOrKey, @Name(value="query") String query, @Name(value="params", defaultValue="[]") List<Object> params) {
        this.log.info(String.format("Executing SQL update: %s", query));
        return this.executeUpdate(urlOrKey, query, params.toArray(new Object[params.size()]));
    }

    private Stream<RowResult> executeUpdate(String urlOrKey, String query, Object ... params) {
        String url = urlOrKey.contains(":") ? urlOrKey : Jdbc.getJdbcUrl(urlOrKey);
        try {
            Connection connection = Jdbc.getConnection(url);
            try {
                PreparedStatement stmt = connection.prepareStatement(query);
                try {
                    for (int i = 0; i < params.length; ++i) {
                        stmt.setObject(i + 1, params[i]);
                    }
                    int updateCount = stmt.executeUpdate();
                    Jdbc.closeIt(this.log, stmt, connection);
                    Map<String, Object> result = MapUtil.map("count", updateCount);
                    return Stream.of(result).map(RowResult::new);
                }
                catch (Exception sqle) {
                    Jdbc.closeIt(this.log, stmt);
                    throw sqle;
                }
            }
            catch (Exception sqle) {
                Jdbc.closeIt(this.log, connection);
                throw sqle;
            }
        }
        catch (Exception e) {
            this.log.error(String.format("Cannot execute SQL statement `%s`.%nError:%n%s", query, e.getMessage()), (Throwable)e);
            String errorMessage = "Cannot execute SQL statement `%s`.%nError:%n%s";
            if (e.getMessage().contains("No suitable driver")) {
                errorMessage = "Cannot execute SQL statement `%s`.%nError:%n%s%n%s";
            }
            throw new RuntimeException(String.format(errorMessage, query, e.getMessage(), "Please download and copy the JDBC driver into $NEO4J_HOME/plugins,more details at https://neo4j-contrib.github.io/neo4j-apoc-procedures/#_load_jdbc_resources"), e);
        }
    }

    static void closeIt(Log log, AutoCloseable ... closeables) {
        for (AutoCloseable c : closeables) {
            try {
                if (c == null) continue;
                c.close();
            }
            catch (Exception e) {
                log.warn(String.format("Error closing %s: %s", c.getClass().getSimpleName(), c), (Throwable)e);
            }
        }
    }

    private static String getJdbcUrl(String key) {
        Object value = ApocConfiguration.get("jdbc").get(key + ".url");
        if (value == null) {
            throw new RuntimeException("No apoc.jdbc." + key + ".url jdbc url specified");
        }
        return value.toString();
    }

    public static <T> T ignore(FailingSupplier<T> fun) {
        try {
            return fun.get();
        }
        catch (Exception exception) {
            return null;
        }
    }

    static {
        ApocConfiguration.get("jdbc").forEach((k, v) -> {
            if (k.endsWith("driver")) {
                Jdbc.loadDriver(v.toString());
            }
        });
    }

    static interface FailingSupplier<T> {
        public T get() throws Exception;
    }

    private static class ResultSetIterator
    implements Iterator<Map<String, Object>> {
        private final Log log;
        private final ResultSet rs;
        private final String[] columns;
        private final boolean closeConnection;
        private Map<String, Object> map;

        public ResultSetIterator(Log log, ResultSet rs, boolean closeConnection) throws SQLException {
            this.log = log;
            this.rs = rs;
            this.columns = this.getMetaData(rs);
            this.closeConnection = closeConnection;
            this.map = this.get();
        }

        private String[] getMetaData(ResultSet rs) throws SQLException {
            ResultSetMetaData meta = rs.getMetaData();
            int cols = meta.getColumnCount();
            String[] columns = new String[cols + 1];
            for (int col = 1; col <= cols; ++col) {
                columns[col] = meta.getColumnLabel(col);
            }
            return columns;
        }

        @Override
        public boolean hasNext() {
            return this.map != null;
        }

        @Override
        public Map<String, Object> next() {
            Map<String, Object> current = this.map;
            this.map = this.get();
            return current;
        }

        public Map<String, Object> get() {
            try {
                if (this.handleEndOfResults()) {
                    return null;
                }
                LinkedHashMap<String, Object> row = new LinkedHashMap<String, Object>(this.columns.length);
                for (int col = 1; col < this.columns.length; ++col) {
                    int sqlType = this.rs.getMetaData().getColumnType(col);
                    row.put(this.columns[col], this.convert(col, sqlType));
                }
                return row;
            }
            catch (Exception e) {
                this.log.error(String.format("Cannot execute read result-set.%nError:%n%s", e.getMessage()), (Throwable)e);
                this.closeRs();
                throw new RuntimeException("Cannot execute read result-set.", e);
            }
        }

        private Object convert(int col, int type) throws SQLException {
            Object value = this.rs.getObject(col);
            switch (type) {
                case 93: {
                    return this.rs.getTimestamp(col).getTime();
                }
                case 91: {
                    return this.rs.getTimestamp(col).getTime();
                }
                case 1111: {
                    return value.toString();
                }
                case -5: {
                    return value.toString();
                }
                case 3: {
                    return value.toString();
                }
                case 2004: {
                    Blob blob = (Blob)value;
                    return this.getValue(blob.getBinaryStream());
                }
                case 2005: {
                    Clob clob = (Clob)value;
                    return this.getValue(clob.getAsciiStream());
                }
                case -2: {
                    byte[] bytes = (byte[])value;
                    value = new String(bytes);
                }
            }
            return value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object getValue(InputStream is) {
            try {
                String string = new String(IOUtils.toByteArray((InputStream)is));
                return string;
            }
            catch (Exception e) {
                String string = "";
                return string;
            }
            finally {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }

        private boolean handleEndOfResults() throws SQLException {
            Boolean closed = Jdbc.ignore(this.rs::isClosed);
            if (closed != null && closed.booleanValue()) {
                return true;
            }
            if (!this.rs.next()) {
                this.closeRs();
                return true;
            }
            return false;
        }

        private void closeRs() {
            Boolean closed = Jdbc.ignore(this.rs::isClosed);
            if (closed == null || !closed.booleanValue()) {
                AutoCloseable[] autoCloseableArray = new AutoCloseable[2];
                autoCloseableArray[0] = Jdbc.ignore(this.rs::getStatement);
                autoCloseableArray[1] = this.closeConnection ? (AutoCloseable)Jdbc.ignore(() -> this.rs.getStatement().getConnection()) : null;
                Jdbc.closeIt(this.log, autoCloseableArray);
            }
        }
    }
}

