/*
 * Decompiled with CFR 0.152.
 */
package apoc.merge;

import apoc.result.NodeResult;
import apoc.result.RelationshipResult;
import apoc.util.Util;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class Merge {
    @Context
    public GraphDatabaseService db;

    @Procedure(mode=Mode.WRITE)
    @Description(value="apoc.merge.node(['Label'], {key:value, ...}, {key:value,...}) - merge node with dynamic labels")
    public Stream<NodeResult> node(@Name(value="label") List<String> labelNames, @Name(value="identProps") Map<String, Object> identProps, @Name(value="props") Map<String, Object> props) {
        if (identProps == null || identProps.isEmpty()) {
            throw new IllegalArgumentException("you need to supply at least one identifying property for a merge");
        }
        String labels = labelNames.stream().map(s -> this.wrapInBacktics((String)s)).collect(Collectors.joining(":"));
        HashMap<String, Map<String, Object>> params = new HashMap<String, Map<String, Object>>();
        params.put("props", Util.merge(identProps, props));
        String identPropsString = this.buildIdentPropsString(identProps);
        String cypher = "MERGE (n:" + labels + "{" + identPropsString + "}) ON CREATE SET n += $props RETURN n";
        Node node = (Node)Iterators.single((Iterator)this.db.execute(cypher, params).columnAs("n"));
        return Stream.of(new NodeResult(node));
    }

    private String wrapInBacktics(String s) {
        return "`" + s + "`";
    }

    @Procedure(mode=Mode.WRITE)
    @Description(value="apoc.merge.relationship(startNode, relType,  {key:value, ...}, {key:value, ...}, endNode) - merge relationship with dynamic type")
    public Stream<RelationshipResult> relationship(@Name(value="startNode") Node startNode, @Name(value="relationshipType") String relType, @Name(value="identProps") Map<String, Object> identProps, @Name(value="props") Map<String, Object> props, @Name(value="endNode") Node endNode) {
        String identPropsString = this.buildIdentPropsString(identProps);
        HashMap<String, Map<String, Object>> params = new HashMap<String, Map<String, Object>>();
        params.put("props", Util.merge(identProps, props));
        params.put("startNode", (Map<String, Object>)startNode);
        params.put("endNode", (Map<String, Object>)endNode);
        String cypher = "WITH $startNode as startNode, $endNode as endNode MERGE (startNode)-[r:" + this.wrapInBacktics(relType) + "{" + identPropsString + "}]->(endNode) ON CREATE SET r+= $props RETURN r";
        Relationship rel = (Relationship)Iterators.single((Iterator)this.db.execute(cypher, params).columnAs("r"));
        return Stream.of(new RelationshipResult(rel));
    }

    private String buildIdentPropsString(Map<String, Object> identProps) {
        if (identProps == null) {
            return "";
        }
        return identProps.keySet().stream().map(s -> "`" + s + "`:$props.`" + s + "`").collect(Collectors.joining(","));
    }

    private Map<String, Object> buildParams(Map<String, Object> identProps, Map<String, Object> props) {
        HashMap<String, Object> map = identProps == null ? new HashMap<String, Object>() : new HashMap<String, Object>(identProps);
        map.put("props", props == null ? Collections.EMPTY_MAP : props);
        return map;
    }
}

