/*
 * Decompiled with CFR 0.152.
 */
package apoc.meta;

import apoc.result.GraphResult;
import apoc.result.MapResult;
import apoc.result.VirtualNode;
import apoc.result.VirtualRelationship;
import apoc.util.MapUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.UserFunction;

public class Meta {
    @Context
    public GraphDatabaseService db;
    @Context
    public GraphDatabaseAPI api;
    @Context
    public KernelTransaction kernelTx;
    static final int SAMPLE = 100;

    @UserFunction
    @Description(value="apoc.meta.type(value) - type name of a value (INTEGER,FLOAT,STRING,BOOLEAN,RELATIONSHIP,NODE,PATH,NULL,UNKNOWN,MAP,LIST)")
    public String type(@Name(value="value") Object value) {
        return this.typeName(value);
    }

    @UserFunction
    @Description(value="apoc.meta.typeName(value) - type name of a value (INTEGER,FLOAT,STRING,BOOLEAN,RELATIONSHIP,NODE,PATH,NULL,UNKNOWN,MAP,LIST)")
    public String typeName(@Name(value="value") Object value) {
        String typeName;
        Types type = Types.of(value);
        String string = typeName = type == Types.UNKNOWN ? value.getClass().getSimpleName() : type.name();
        if (value != null && value.getClass().isArray()) {
            typeName = typeName + "[]";
        }
        return typeName;
    }

    @UserFunction
    @Description(value="apoc.meta.types(node-relationship-map)  - returns a map of keys to types")
    public Map<String, Object> types(@Name(value="properties") Object target) {
        Map properties = Collections.emptyMap();
        if (target instanceof Node) {
            properties = ((Node)target).getAllProperties();
        }
        if (target instanceof Relationship) {
            properties = ((Relationship)target).getAllProperties();
        }
        if (target instanceof Map) {
            properties = (Map)target;
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(properties.size());
        properties.forEach((key, value) -> {
            String typeName;
            Types type = Types.of(value);
            String string = typeName = type == Types.UNKNOWN ? value.getClass().getSimpleName() : type.name();
            if (value != null && value.getClass().isArray()) {
                typeName = typeName + "[]";
            }
            result.put((String)key, typeName);
        });
        return result;
    }

    @UserFunction
    @Description(value="apoc.meta.isType(value,type) - returns a row if type name matches none if not (INTEGER,FLOAT,STRING,BOOLEAN,RELATIONSHIP,NODE,PATH,NULL,UNKNOWN,MAP,LIST)")
    public boolean isType(@Name(value="value") Object value, @Name(value="type") String type) {
        String typeName = Types.of(value).name();
        if (value != null && value.getClass().isArray()) {
            typeName = typeName + "[]";
        }
        return type.equalsIgnoreCase(typeName);
    }

    @Procedure
    @Description(value="apoc.meta.stats  yield labelCount, relTypeCount, propertyKeyCount, nodeCount, relCount, labels, relTypes, stats | returns the information stored in the transactional database statistics")
    public Stream<MetaStats> stats() {
        return Stream.of(this.collectStats());
    }

    private MetaStats collectStats() {
        final LinkedHashMap<String, Long> relStatsCount = new LinkedHashMap<String, Long>();
        try (Statement stmt = this.kernelTx.acquireStatement();){
            ReadOperations ops = stmt.readOperations();
            int labelCount = ops.labelCount();
            int relTypeCount = ops.relationshipTypeCount();
            final LinkedHashMap<String, Long> labelStats = new LinkedHashMap<String, Long>(labelCount);
            final LinkedHashMap<String, Long> relStats = new LinkedHashMap<String, Long>(2 * relTypeCount);
            this.collectStats(null, null, new StatsCallback(){

                @Override
                public void label(int labelId, String labelName, long count) {
                    if (count > 0L) {
                        labelStats.put(labelName, count);
                    }
                }

                @Override
                public void rel(int typeId, String typeName, long count) {
                    if (count > 0L) {
                        relStats.put("()-[:" + typeName + "]->()", count);
                    }
                }

                @Override
                public void rel(int typeId, String typeName, int labelId, String labelName, long out, long in) {
                    if (out > 0L) {
                        relStatsCount.put(typeName, relStatsCount.getOrDefault(typeName, 0L) + out);
                        relStats.put("(:" + labelName + ")-[:" + typeName + "]->()", out);
                    }
                    if (in > 0L) {
                        relStats.put("()-[:" + typeName + "]->(:" + labelName + ")", in);
                    }
                }
            });
            MetaStats metaStats = new MetaStats(labelCount, relTypeCount, ops.propertyKeyCount(), ops.nodesGetCount(), ops.relationshipsGetCount(), labelStats, relStats, relStatsCount);
            return metaStats;
        }
    }

    private void collectStats(Collection<String> labelNames, Collection<String> relTypeNames, StatsCallback cb) {
        try (Statement stmt = this.kernelTx.acquireStatement();){
            ReadOperations ops = stmt.readOperations();
            Map<String, Integer> labels = this.labelsInUse(ops, labelNames);
            Map<String, Integer> relTypes = this.relTypesInUse(ops, relTypeNames);
            labels.forEach((name, id) -> {
                long count = ops.countsForNodeWithoutTxState(id.intValue());
                if (count > 0L) {
                    cb.label((int)id, (String)name, count);
                    relTypes.forEach((typeName, typeId) -> {
                        long relCountOut = ops.countsForRelationship(id.intValue(), typeId.intValue(), -1);
                        long relCountIn = ops.countsForRelationship(-1, typeId.intValue(), id.intValue());
                        cb.rel((int)typeId, (String)typeName, (int)id, (String)name, relCountOut, relCountIn);
                    });
                }
            });
            relTypes.forEach((typeName, typeId) -> cb.rel((int)typeId, (String)typeName, ops.countsForRelationship(-1, typeId.intValue(), -1)));
        }
    }

    private Map<String, Integer> relTypesInUse(ReadOperations ops, Collection<String> relTypeNames) {
        Stream<String> types = relTypeNames == null || relTypeNames.isEmpty() ? this.db.getAllRelationshipTypesInUse().stream().map(RelationshipType::name) : relTypeNames.stream();
        return types.collect(Collectors.toMap(t -> t, arg_0 -> ((ReadOperations)ops).relationshipTypeGetForName(arg_0)));
    }

    private Map<String, Integer> labelsInUse(ReadOperations ops, Collection<String> labelNames) {
        Stream<String> labels = labelNames == null || labelNames.isEmpty() ? this.db.getAllLabelsInUse().stream().map(Label::name) : labelNames.stream();
        return labels.collect(Collectors.toMap(t -> t, arg_0 -> ((ReadOperations)ops).labelGetForName(arg_0)));
    }

    @Procedure
    @Description(value="apoc.meta.data  - examines a subset of the graph to provide a tabular meta information")
    public Stream<MetaResult> data() {
        return this.collectMetaData().values().stream().flatMap(x -> x.values().stream());
    }

    @Procedure
    @Description(value="apoc.meta.schema  - examines a subset of the graph to provide a map-like meta information")
    public Stream<MapResult> schema() {
        MetaStats metaStats = this.collectStats();
        Map<String, Map<String, MetaResult>> metaData = this.collectMetaData();
        Map<String, Object> relationships = this.collectRelationshipsMetaData(metaStats, metaData);
        Map<String, Object> nodes = this.collectNodesMetaData(metaStats, metaData, relationships);
        nodes.putAll(relationships);
        return Stream.of(new MapResult(nodes));
    }

    private Map<String, Map<String, MetaResult>> collectMetaData() {
        LinkedHashMap<String, Map<String, MetaResult>> metaData = new LinkedHashMap<String, Map<String, MetaResult>>(100);
        Schema schema = this.db.schema();
        HashMap<String, Iterable<ConstraintDefinition>> relConstraints = new HashMap<String, Iterable<ConstraintDefinition>>(20);
        for (RelationshipType type : this.db.getAllRelationshipTypesInUse()) {
            metaData.put(type.name(), new LinkedHashMap(10));
            relConstraints.put(type.name(), schema.getConstraints(type));
        }
        for (Label label : this.db.getAllLabelsInUse()) {
            LinkedHashMap<String, MetaResult> nodeMeta = new LinkedHashMap<String, MetaResult>(50);
            String labelName = label.name();
            metaData.put(labelName, nodeMeta);
            Iterable constraints = schema.getConstraints(label);
            LinkedHashSet<String> indexed = new LinkedHashSet<String>();
            for (IndexDefinition index : schema.getIndexes(label)) {
                for (String prop : index.getPropertyKeys()) {
                    indexed.add(prop);
                }
            }
            ResourceIterator nodes = this.db.findNodes(label);
            Throwable throwable = null;
            try {
                int count = 0;
                while (nodes.hasNext() && count++ < 100) {
                    Node node = (Node)nodes.next();
                    this.addRelationships(metaData, nodeMeta, labelName, node, relConstraints);
                    this.addProperties(nodeMeta, labelName, constraints, indexed, (PropertyContainer)node, node);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (nodes == null) continue;
                if (throwable != null) {
                    try {
                        nodes.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                nodes.close();
            }
        }
        return metaData;
    }

    private Map<String, Object> collectNodesMetaData(MetaStats metaStats, Map<String, Map<String, MetaResult>> metaData, Map<String, Object> relationships) {
        LinkedHashMap<String, Object> nodes = new LinkedHashMap<String, Object>();
        HashMap<String, List<Map<String, Object>>> startNodeNameToRelationshipsMap = new HashMap<String, List<Map<String, Object>>>();
        for (String entityName : metaData.keySet()) {
            Map<String, MetaResult> entityData = metaData.get(entityName);
            LinkedHashMap<String, Map<String, Object>> entityProperties = new LinkedHashMap<String, Map<String, Object>>();
            LinkedHashMap<String, Map<String, Object>> entityRelationships = new LinkedHashMap<String, Map<String, Object>>();
            LinkedHashMap incomingRelationships = new LinkedHashMap();
            List<Object> labels = new LinkedList();
            boolean isNode = true;
            for (String entityDataKey : entityData.keySet()) {
                MetaResult metaResult = entityData.get(entityDataKey);
                if (metaResult.elementType.equals("relationship")) {
                    isNode = false;
                    break;
                }
                if (metaResult.unique) {
                    labels = metaResult.otherLabels;
                }
                if (!metaResult.type.equals("RELATIONSHIP")) {
                    entityProperties.put(entityDataKey, MapUtil.map("type", metaResult.type, "indexed", metaResult.index, "unique", metaResult.unique, "existence", metaResult.existence));
                    continue;
                }
                entityRelationships.put(metaResult.property, MapUtil.map("direction", "out", "count", metaResult.rightCount, "labels", metaResult.other, "properties", ((Map)relationships.get(metaResult.property)).get("properties")));
                metaResult.other.forEach(o -> {
                    LinkedHashMap<String, Map<String, Object>> mirroredRelationship = new LinkedHashMap<String, Map<String, Object>>();
                    mirroredRelationship.put(metaResult.property, MapUtil.map("direction", "in", "count", metaResult.leftCount, "labels", new LinkedList<String>(Arrays.asList(metaResult.label)), "properties", ((Map)relationships.get(metaResult.property)).get("properties")));
                    if (startNodeNameToRelationshipsMap.containsKey(o)) {
                        ((List)startNodeNameToRelationshipsMap.get(o)).add(mirroredRelationship);
                    } else {
                        LinkedList<LinkedHashMap<String, Map<String, Object>>> relList = new LinkedList<LinkedHashMap<String, Map<String, Object>>>();
                        relList.add(mirroredRelationship);
                        startNodeNameToRelationshipsMap.put((String)o, (List<Map<String, Object>>)relList);
                    }
                });
            }
            if (!isNode) continue;
            nodes.put(entityName, MapUtil.map("type", "node", "count", metaStats.labels.get(entityName), "labels", labels, "properties", entityProperties, "relationships", entityRelationships));
        }
        this.setIncomingRelationships(nodes, startNodeNameToRelationshipsMap);
        return nodes;
    }

    private void setIncomingRelationships(Map<String, Object> nodes, Map<String, List<Map<String, Object>>> nodeNameToRelationshipsMap) {
        nodes.keySet().forEach(k -> {
            if (nodeNameToRelationshipsMap.containsKey(k)) {
                Map node = (Map)nodes.get(k);
                List relationshipsToAddList = (List)nodeNameToRelationshipsMap.get(k);
                relationshipsToAddList.forEach(relationshipNameToRelationshipMap -> {
                    Map actualRelationshipsList = (Map)node.get("relationships");
                    relationshipNameToRelationshipMap.keySet().forEach(relationshipName -> {
                        if (actualRelationshipsList.containsKey(relationshipName)) {
                            Map relToAdd = (Map)relationshipNameToRelationshipMap.get(relationshipName);
                            Map existingRel = (Map)actualRelationshipsList.get(relationshipName);
                            List labels = (List)existingRel.get("labels");
                            labels.addAll((List)relToAdd.get("labels"));
                        } else {
                            actualRelationshipsList.put(relationshipName, relationshipNameToRelationshipMap.get(relationshipName));
                        }
                    });
                });
            }
        });
    }

    private Map<String, Object> collectRelationshipsMetaData(MetaStats metaStats, Map<String, Map<String, MetaResult>> metaData) {
        LinkedHashMap<String, Object> relationships = new LinkedHashMap<String, Object>();
        for (String entityName : metaData.keySet()) {
            Map<String, MetaResult> entityData = metaData.get(entityName);
            LinkedHashMap<String, Map<String, Object>> entityProperties = new LinkedHashMap<String, Map<String, Object>>();
            boolean isRelationship = true;
            for (String entityDataKey : entityData.keySet()) {
                MetaResult metaResult = entityData.get(entityDataKey);
                if (!metaResult.elementType.equals("relationship")) {
                    isRelationship = false;
                    break;
                }
                if (metaResult.type.equals("RELATIONSHIP")) continue;
                entityProperties.put(entityDataKey, MapUtil.map("type", metaResult.type, "array", metaResult.array, "existence", metaResult.existence));
            }
            if (!isRelationship) continue;
            relationships.put(entityName, MapUtil.map("type", "relationship", "count", metaStats.relTypesCount.get(entityName), "properties", entityProperties));
        }
        return relationships;
    }

    private void addProperties(Map<String, MetaResult> properties, String labelName, Iterable<ConstraintDefinition> constraints, Set<String> indexed, PropertyContainer pc, Node node) {
        for (String prop : pc.getPropertyKeys()) {
            if (properties.containsKey(prop)) continue;
            MetaResult res = this.metaResultForProp(pc, labelName, prop);
            res.elementType(Types.of(pc).name());
            this.addSchemaInfo(res, prop, constraints, indexed, node);
            properties.put(prop, res);
        }
    }

    private void addRelationships(Map<String, Map<String, MetaResult>> metaData, Map<String, MetaResult> nodeMeta, String labelName, Node node, Map<String, Iterable<ConstraintDefinition>> relConstraints) {
        for (RelationshipType type : node.getRelationshipTypes()) {
            Map<String, MetaResult> typeMeta;
            int out = node.getDegree(type, Direction.OUTGOING);
            if (out == 0) continue;
            String typeName = type.name();
            Iterable<ConstraintDefinition> constraints = relConstraints.get(typeName);
            if (!nodeMeta.containsKey(typeName)) {
                nodeMeta.put(typeName, new MetaResult(labelName, typeName));
            }
            if (!(typeMeta = metaData.get(typeName)).containsKey(labelName)) {
                typeMeta.put(labelName, new MetaResult(typeName, labelName));
            }
            MetaResult relMeta = nodeMeta.get(typeName);
            this.addOtherNodeInfo(node, labelName, out, type, relMeta, typeMeta, constraints);
        }
    }

    private void addOtherNodeInfo(Node node, String labelName, int out, RelationshipType type, MetaResult relMeta, Map<String, MetaResult> typeMeta, Iterable<ConstraintDefinition> relConstraints) {
        MetaResult relNodeMeta = typeMeta.get(labelName);
        relMeta.elementType(Types.of(node).name());
        for (Relationship rel : node.getRelationships(type, Direction.OUTGOING)) {
            Node endNode = rel.getEndNode();
            List<String> labels = this.toStrings(endNode.getLabels());
            int in = endNode.getDegree(type, Direction.INCOMING);
            relMeta.inc().other(labels).rel(out, in);
            relNodeMeta.inc().other(labels).rel(out, in);
            this.addProperties(typeMeta, type.name(), relConstraints, Collections.emptySet(), (PropertyContainer)rel, node);
            relNodeMeta.elementType(Types.RELATIONSHIP.name());
        }
    }

    private void addSchemaInfo(MetaResult res, String prop, Iterable<ConstraintDefinition> constraints, Set<String> indexed, Node node) {
        if (indexed.contains(prop)) {
            res.index = true;
        }
        if (constraints == null) {
            return;
        }
        for (ConstraintDefinition constraint : constraints) {
            for (String key : constraint.getPropertyKeys()) {
                if (!key.equals(prop)) continue;
                switch (constraint.getConstraintType()) {
                    case UNIQUENESS: {
                        res.unique = true;
                        node.getLabels().forEach(l -> {
                            if (res.label != l.name()) {
                                res.addLabel(l.name());
                            }
                        });
                        break;
                    }
                    case NODE_PROPERTY_EXISTENCE: {
                        res.existence = true;
                        break;
                    }
                    case RELATIONSHIP_PROPERTY_EXISTENCE: {
                        res.existence = true;
                    }
                }
            }
        }
    }

    private MetaResult metaResultForProp(PropertyContainer pc, String labelName, String prop) {
        MetaResult res = new MetaResult(labelName, prop);
        Object value = pc.getProperty(prop);
        res.type(Types.of(value).name());
        res.elementType(Types.of(pc).name());
        if (value.getClass().isArray()) {
            res.array = true;
        }
        return res;
    }

    private List<String> toStrings(Iterable<Label> labels) {
        ArrayList<String> res = new ArrayList<String>(10);
        for (Label label : labels) {
            String name = label.name();
            res.add(name);
        }
        return res;
    }

    public void sample(GraphDatabaseService db, Sampler sampler, int sampleSize) {
        for (Label label : db.getAllLabelsInUse()) {
            ResourceIterator nodes = db.findNodes(label);
            int count = 0;
            while (nodes.hasNext() && count++ < sampleSize) {
                Node node = (Node)nodes.next();
                sampler.sample(label, count, node);
                for (RelationshipType type : node.getRelationshipTypes()) {
                    this.sampleRels(sampleSize, sampler, label, count, node, type);
                }
            }
            nodes.close();
        }
    }

    private void sampleRels(int sampleSize, Sampler sampler, Label label, int count, Node node, RelationshipType type) {
        Direction direction = Direction.OUTGOING;
        int degree = node.getDegree(type, direction);
        sampler.sample(label, count, node, type, direction, degree, null);
        if (degree == 0) {
            return;
        }
        ResourceIterator relIt = ((ResourceIterable)node.getRelationships(direction, new RelationshipType[]{type})).iterator();
        int relCount = 0;
        while (relIt.hasNext() && relCount++ < sampleSize) {
            sampler.sample(label, count, node, type, direction, degree, (Relationship)relIt.next());
        }
        relIt.close();
    }

    @Procedure
    @Description(value="apoc.meta.graph - examines the full graph to create the meta-graph")
    public Stream<GraphResult> graph() {
        return this.metaGraph(null, null, true);
    }

    private Stream<GraphResult> metaGraph(Collection<String> labelNames, Collection<String> relTypeNames, boolean removeMissing) {
        try (Statement stmt = this.kernelTx.acquireStatement();){
            ReadOperations ops = stmt.readOperations();
            Map<String, Integer> labels = this.labelsInUse(ops, labelNames);
            Map<String, Integer> relTypes = this.relTypesInUse(ops, relTypeNames);
            TreeMap vNodes = new TreeMap();
            HashMap<Pattern, Relationship> vRels = new HashMap<Pattern, Relationship>(relTypes.size() * 2);
            labels.forEach((labelName, id) -> {
                long count = ops.countsForNodeWithoutTxState(id.intValue());
                if (count > 0L) {
                    this.mergeMetaNode(Label.label((String)labelName), vNodes, count);
                }
            });
            relTypes.forEach((typeName, typeId) -> {
                long global = ops.countsForRelationshipWithoutTxState(-1, typeId.intValue(), -1);
                labels.forEach((labelNameA, labelIdA) -> {
                    long relCountOut = ops.countsForRelationshipWithoutTxState(labelIdA.intValue(), typeId.intValue(), -1);
                    if (relCountOut > 0L) {
                        labels.forEach((labelNameB, labelIdB) -> {
                            long relCountIn = ops.countsForRelationshipWithoutTxState(-1, typeId.intValue(), labelIdB.intValue());
                            if (relCountIn > 0L) {
                                Node nodeA = (Node)vNodes.get(labelNameA);
                                Node nodeB = (Node)vNodes.get(labelNameB);
                                Relationship vRel = new VirtualRelationship(nodeA, nodeB, RelationshipType.withName((String)typeName)).withProperties(MapUtil.map("type", typeName, "out", relCountOut, "in", relCountIn, "count", global));
                                vRels.put(Pattern.of(labelNameA, typeName, labelNameB), vRel);
                            }
                        });
                    }
                });
            });
            if (removeMissing) {
                this.filterNonExistingRelationships(vRels);
            }
            GraphResult graphResult = new GraphResult(new ArrayList<Node>(vNodes.values()), new ArrayList<Relationship>(vRels.values()));
            Stream<GraphResult> stream = Stream.of(graphResult);
            return stream;
        }
    }

    private void filterNonExistingRelationships(Map<Pattern, Relationship> vRels) {
        Set<Pattern> rels = vRels.keySet();
        HashMap<Pair<String, String>, Set<Pattern>> aggregated = new HashMap<Pair<String, String>, Set<Pattern>>();
        for (Pattern rel : rels) {
            this.combine(aggregated, (Pair<String, String>)Pair.of((Object)rel.from, (Object)rel.type), rel);
            this.combine(aggregated, (Pair<String, String>)Pair.of((Object)rel.type, (Object)rel.to), rel);
        }
        aggregated.values().stream().filter(c -> c.size() > 1).flatMap(Collection::stream).filter(p -> !this.relationshipExists((Pattern)p, (Relationship)vRels.get(p))).forEach(vRels::remove);
    }

    private boolean relationshipExists(Pattern p, Relationship relationship) {
        double degreeTo;
        if (relationship == null) {
            return false;
        }
        double degreeFrom = (double)((Long)relationship.getProperty("out")).longValue() / (double)((Long)relationship.getStartNode().getProperty("count")).longValue();
        return degreeFrom < (degreeTo = (double)((Long)relationship.getProperty("in")).longValue() / (double)((Long)relationship.getEndNode().getProperty("count")).longValue()) ? this.relationshipExists(p.labelFrom(), p.labelTo(), p.relationshipType(), Direction.OUTGOING) : this.relationshipExists(p.labelTo(), p.labelFrom(), p.relationshipType(), Direction.INCOMING);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean relationshipExists(Label labelFromLabel, Label labelToLabel, RelationshipType relationshipType, Direction direction) {
        int maxTotal = 300;
        try (ResourceIterator nodes = this.db.findNodes(labelFromLabel);){
            block12: while (nodes.hasNext()) {
                if (maxTotal <= 0) return false;
                Node node = (Node)nodes.next();
                int maxRels = 30;
                Iterator iterator = node.getRelationships(direction, new RelationshipType[]{relationshipType}).iterator();
                do {
                    Node otherNode;
                    if (!iterator.hasNext()) continue block12;
                    Relationship rel = (Relationship)iterator.next();
                    Node node2 = otherNode = direction == Direction.OUTGOING ? rel.getEndNode() : rel.getStartNode();
                    if (!otherNode.hasLabel(labelToLabel)) continue;
                    boolean bl = true;
                    return bl;
                } while (maxRels-- != 0 && maxTotal-- != 0);
            }
            return false;
        }
    }

    private void combine(Map<Pair<String, String>, Set<Pattern>> aggregated, Pair<String, String> p, Pattern rel) {
        if (!aggregated.containsKey(p)) {
            aggregated.put(p, new HashSet());
        }
        aggregated.get(p).add(rel);
    }

    @Procedure
    @Description(value="apoc.meta.graphSample() - examines the database statistics to build the meta graph, very fast, might report extra relationships")
    public Stream<GraphResult> graphSample() {
        return this.metaGraph(null, null, false);
    }

    @Procedure
    @Description(value="apoc.meta.subGraph({labels:[labels],rels:[rel-types], excludes:[labels,rel-types]}) - examines a sample sub graph to create the meta-graph")
    public Stream<GraphResult> subGraph(@Name(value="config") Map<String, Object> config) {
        Collection includeLabels = config.getOrDefault("labels", Collections.emptyList());
        Collection includeRels = config.getOrDefault("rels", Collections.emptyList());
        HashSet<String> excludes = new HashSet<String>(config.getOrDefault("excludes", Collections.emptyList()));
        return this.filterResultStream(excludes, this.metaGraph(includeLabels, includeRels, true));
    }

    private Stream<GraphResult> filterResultStream(Set<String> excludes, Stream<GraphResult> graphResultStream) {
        if (excludes == null || excludes.isEmpty()) {
            return graphResultStream;
        }
        return graphResultStream.map(gr -> {
            Iterator<Node> it = gr.nodes.iterator();
            while (it.hasNext()) {
                Node node = it.next();
                if (!this.containsLabelName(excludes, node)) continue;
                it.remove();
            }
            Iterator<Relationship> it2 = gr.relationships.iterator();
            while (it2.hasNext()) {
                Relationship relationship = it2.next();
                if (!excludes.contains(relationship.getType().name()) && !this.containsLabelName(excludes, relationship.getStartNode()) && !this.containsLabelName(excludes, relationship.getEndNode())) continue;
                it2.remove();
            }
            return gr;
        });
    }

    private boolean containsLabelName(Set<String> excludes, Node node) {
        for (Label label : node.getLabels()) {
            if (!excludes.contains(label.name())) continue;
            return true;
        }
        return false;
    }

    private Node mergeMetaNode(Label label, Map<String, Node> labels, long increment) {
        String name = label.name();
        Node vNode = labels.get(name);
        if (vNode == null) {
            vNode = new VirtualNode(new Label[]{label}, Collections.singletonMap("name", name), this.db);
            labels.put(name, vNode);
        }
        if (increment > 0L) {
            vNode.setProperty("count", (Object)(((Number)vNode.getProperty("count", (Object)0L)).longValue() + increment));
        }
        return vNode;
    }

    private void addRel(Map<List<String>, Relationship> rels, Map<String, Node> labels, Relationship rel, boolean strict) {
        String typeName = rel.getType().name();
        Node startNode = rel.getStartNode();
        Node endNode = rel.getEndNode();
        for (Label labelA : startNode.getLabels()) {
            Node nodeA;
            Node node = nodeA = strict ? labels.get(labelA.name()) : this.mergeMetaNode(labelA, labels, 0L);
            if (nodeA == null) continue;
            for (Label labelB : endNode.getLabels()) {
                List<String> key = Arrays.asList(labelA.name(), labelB.name(), typeName);
                Relationship vRel = rels.get(key);
                if (vRel == null) {
                    Node nodeB;
                    Node node2 = nodeB = strict ? labels.get(labelB.name()) : this.mergeMetaNode(labelB, labels, 0L);
                    if (nodeB == null) continue;
                    vRel = new VirtualRelationship(nodeA, nodeB, rel.getType()).withProperties(Collections.singletonMap("type", typeName));
                    rels.put(key, vRel);
                }
                vRel.setProperty("count", (Object)((Long)vRel.getProperty("count", (Object)0L) + 1L));
            }
        }
    }

    static class NodeInfo {
        final Set<String> labels = new HashSet<String>();
        final Set<String> properties = new HashSet<String>();
        long count;
        long minDegree;
        long maxDegree;
        long sumDegree;

        NodeInfo() {
        }

        private void add(Node node) {
            ++this.count;
            int degree = node.getDegree();
            this.sumDegree += (long)degree;
            if ((long)degree > this.maxDegree) {
                this.maxDegree = degree;
            }
            if ((long)degree < this.minDegree) {
                this.minDegree = degree;
            }
            for (Label label : node.getLabels()) {
                this.labels.add(label.name());
            }
            for (String key : node.getPropertyKeys()) {
                this.properties.add(key);
            }
        }

        Map<String, Object> toMap() {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("labels", this.labels.toArray());
            map.put("properties", this.properties.toArray());
            map.put("count", this.count);
            map.put("minDegree", this.minDegree);
            map.put("maxDegree", this.maxDegree);
            map.put("avgDegree", this.sumDegree / this.count);
            return map;
        }

        public boolean equals(Object o) {
            return this == o || o instanceof NodeInfo && this.labels.equals(((NodeInfo)o).labels);
        }

        public int hashCode() {
            return this.labels.hashCode();
        }
    }

    static class RelInfo {
        final Set<String> properties = new HashSet<String>();
        final NodeInfo from;
        final NodeInfo to;
        final String type;
        int count;

        public RelInfo(NodeInfo from, NodeInfo to, String type) {
            this.from = from;
            this.to = to;
            this.type = type;
        }

        public void add(Relationship relationship) {
            for (String key : relationship.getPropertyKeys()) {
                this.properties.add(key);
            }
            ++this.count;
        }
    }

    static class Pattern {
        private final String from;
        private final String type;
        private final String to;

        private Pattern(String from, String type, String to) {
            this.from = from;
            this.type = type;
            this.to = to;
        }

        public static Pattern of(String labelFrom, String type, String labelTo) {
            return new Pattern(labelFrom, type, labelTo);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof Pattern) {
                Pattern pattern = (Pattern)o;
                return this.from.equals(pattern.from) && this.type.equals(pattern.type) && this.to.equals(pattern.to);
            }
            return false;
        }

        public int hashCode() {
            return 31 * (31 * this.from.hashCode() + this.type.hashCode()) + this.to.hashCode();
        }

        public Label labelTo() {
            return Label.label((String)this.to);
        }

        public Label labelFrom() {
            return Label.label((String)this.from);
        }

        public RelationshipType relationshipType() {
            return RelationshipType.withName((String)this.type);
        }
    }

    static interface Sampler {
        public void sample(Label var1, int var2, Node var3);

        public void sample(Label var1, int var2, Node var3, RelationshipType var4, Direction var5, int var6, Relationship var7);
    }

    static interface StatsCallback {
        public void label(int var1, String var2, long var3);

        public void rel(int var1, String var2, long var3);

        public void rel(int var1, String var2, int var3, String var4, long var5, long var7);
    }

    public static class MetaStats {
        public final long labelCount;
        public final long relTypeCount;
        public final long propertyKeyCount;
        public final long nodeCount;
        public final long relCount;
        public final Map<String, Long> labels;
        public final Map<String, Long> relTypes;
        public final Map<String, Long> relTypesCount;
        public final Map<String, Object> stats;

        public MetaStats(long labelCount, long relTypeCount, long propertyKeyCount, long nodeCount, long relCount, Map<String, Long> labels, Map<String, Long> relTypes, Map<String, Long> relTypesCount) {
            this.labelCount = labelCount;
            this.relTypeCount = relTypeCount;
            this.propertyKeyCount = propertyKeyCount;
            this.nodeCount = nodeCount;
            this.relCount = relCount;
            this.labels = labels;
            this.relTypes = relTypes;
            this.relTypesCount = relTypesCount;
            this.stats = MapUtil.map("labelCount", labelCount, "relTypeCount", relTypeCount, "propertyKeyCount", propertyKeyCount, "nodeCount", nodeCount, "relCount", relCount, "labels", labels, "relTypes", relTypes);
        }
    }

    public static class MetaResult {
        public String label;
        public String property;
        public long count;
        public boolean unique;
        public boolean index;
        public boolean existence;
        public String type;
        public boolean array;
        public List<Object> sample;
        public long leftCount;
        public long rightCount;
        public long left;
        public long right;
        public List<String> other = new ArrayList<String>();
        public List<String> otherLabels = new ArrayList<String>();
        public String elementType;

        public MetaResult addLabel(String label) {
            this.otherLabels.add(label);
            return this;
        }

        public MetaResult(String label, String name) {
            this.label = label;
            this.property = name;
        }

        public MetaResult inc() {
            ++this.count;
            return this;
        }

        public MetaResult rel(long out, long in) {
            this.type = Types.RELATIONSHIP.name();
            if (out > 1L) {
                this.array = true;
            }
            this.leftCount += out;
            this.rightCount += in;
            this.left = this.leftCount / this.count;
            this.right = this.rightCount / this.count;
            return this;
        }

        public MetaResult other(List<String> labels) {
            for (String l : labels) {
                if (this.other.contains(l)) continue;
                this.other.add(l);
            }
            return this;
        }

        public MetaResult type(String type) {
            this.type = type;
            return this;
        }

        public MetaResult array(boolean array) {
            this.array = array;
            return this;
        }

        public MetaResult elementType(String elementType) {
            switch (elementType) {
                case "NODE": {
                    this.elementType = "node";
                    break;
                }
                case "RELATIONSHIP": {
                    this.elementType = "relationship";
                }
            }
            return this;
        }
    }

    public static enum Types {
        INTEGER,
        FLOAT,
        STRING,
        BOOLEAN,
        RELATIONSHIP,
        NODE,
        PATH,
        NULL,
        UNKNOWN,
        MAP,
        LIST;


        public static Types of(Object value) {
            return Types.of(value == null ? null : value.getClass());
        }

        public static Types of(Class<?> type) {
            if (type == null) {
                return NULL;
            }
            if (type.isArray()) {
                type = type.getComponentType();
            }
            if (Number.class.isAssignableFrom(type)) {
                return Double.TYPE.isAssignableFrom(type) || Double.class.isAssignableFrom(type) || Float.class.isAssignableFrom(type) || Float.TYPE.isAssignableFrom(type) ? FLOAT : INTEGER;
            }
            if (type == Boolean.class || type == Boolean.TYPE) {
                return BOOLEAN;
            }
            if (String.class.isAssignableFrom(type)) {
                return STRING;
            }
            if (Map.class.isAssignableFrom(type)) {
                return MAP;
            }
            if (Node.class.isAssignableFrom(type)) {
                return NODE;
            }
            if (Relationship.class.isAssignableFrom(type)) {
                return RELATIONSHIP;
            }
            if (Path.class.isAssignableFrom(type)) {
                return PATH;
            }
            if (Iterable.class.isAssignableFrom(type)) {
                return LIST;
            }
            return UNKNOWN;
        }

        public static Types from(String typeName) {
            typeName = typeName.toUpperCase();
            for (Types type : Types.values()) {
                if (!type.name().startsWith(typeName)) continue;
                return type;
            }
            return STRING;
        }
    }
}

