/*
 * Decompiled with CFR 0.152.
 */
package apoc.nodes;

import apoc.Description;
import apoc.Pools;
import apoc.result.GraphResult;
import apoc.result.VirtualNode;
import apoc.util.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class Grouping {
    private static final int BATCHSIZE = 10000;
    private static final String ASTERISK = "*";
    @Context
    public GraphDatabaseService db;
    @Context
    public Log log;

    @Procedure
    @Description(value="Group all nodes and their relationships by given keys, create virtual nodes and relationships for the summary information, you can provide an aggregations map [{kids:'sum',age:['min','max','avg'],gender:'collect'},{`*`,'count'}]")
    public Stream<GraphResult> group(@Name(value="labels") List<String> labels, @Name(value="groupByProperties") List<String> groupByProperties, @Name(value="aggregations", defaultValue="[{\"*\":\"count\"},{\"*\":\"count\"}]") List<Map<String, Object>> aggregations) {
        String[] keys = groupByProperties.toArray(new String[groupByProperties.size()]);
        Map nodeAggNames = aggregations.size() > 0 ? this.toStringListMap(aggregations.get(0)) : Collections.emptyMap();
        String[] nodeAggKeys = this.keyArray(nodeAggNames, ASTERISK);
        Map relAggNames = aggregations.size() > 1 ? this.toStringListMap(aggregations.get(1)) : Collections.emptyMap();
        String[] relAggKeys = this.keyArray(relAggNames, ASTERISK);
        ConcurrentHashMap grouped = new ConcurrentHashMap();
        ConcurrentHashMap virtualNodes = new ConcurrentHashMap();
        ConcurrentHashMap virtualRels = new ConcurrentHashMap();
        ArrayList<Future> futures = new ArrayList<Future>(1000);
        ExecutorService pool = Pools.DEFAULT;
        for (String labelName : labels) {
            Label label = Label.label((String)labelName);
            Label[] singleLabel = new Label[]{label};
            ResourceIterator nodes = labelName.equals(ASTERISK) ? this.db.getAllNodes().iterator() : this.db.findNodes(label);
            Throwable throwable = null;
            try {
                while (nodes.hasNext()) {
                    List batch = Util.take(nodes, 10000);
                    futures.add(Util.inTxFuture(pool, this.db, () -> {
                        try {
                            for (Node node : batch) {
                                NodeKey key = this.keyFor(node, labelName, keys);
                                grouped.compute(key, (k, v) -> {
                                    if (v == null) {
                                        v = new HashSet<Node>();
                                    }
                                    v.add(node);
                                    return v;
                                });
                                virtualNodes.compute(key, (k, v) -> {
                                    if (v == null) {
                                        v = new VirtualNode(singleLabel, this.propertiesFor(node, keys), this.db);
                                    }
                                    Node vn = v;
                                    if (!nodeAggNames.isEmpty()) {
                                        this.aggregate((PropertyContainer)vn, nodeAggNames, nodeAggKeys.length > 0 ? node.getProperties(nodeAggKeys) : Collections.emptyMap());
                                    }
                                    return vn;
                                });
                            }
                        }
                        catch (Exception e) {
                            this.log.debug("Error grouping nodes", (Throwable)e);
                        }
                        return null;
                    }));
                    Util.removeFinished(futures);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (nodes == null) continue;
                if (throwable != null) {
                    try {
                        nodes.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                nodes.close();
            }
        }
        Util.waitForFutures(futures);
        futures.clear();
        Iterator entries = grouped.entrySet().iterator();
        int size = 0;
        ArrayList batch = new ArrayList();
        while (entries.hasNext()) {
            Map.Entry outerEntry = entries.next();
            batch.add(outerEntry);
            if ((size += ((Set)outerEntry.getValue()).size()) <= 10000 && entries.hasNext()) continue;
            ArrayList submitted = new ArrayList(batch);
            batch.clear();
            size = 0;
            futures.add(Util.inTxFuture(pool, this.db, () -> {
                try {
                    for (Map.Entry entry : submitted) {
                        for (Node node : (Set)entry.getValue()) {
                            NodeKey startKey = (NodeKey)entry.getKey();
                            Node v1 = (Node)virtualNodes.get(startKey);
                            for (Relationship rel : node.getRelationships(Direction.OUTGOING)) {
                                Node endNode = rel.getEndNode();
                                for (NodeKey endKey : this.keysFor(endNode, labels, keys)) {
                                    Node v2 = (Node)virtualNodes.get(endKey);
                                    if (v2 == null) continue;
                                    virtualRels.compute(new RelKey(startKey, endKey, rel), (rk, vRel) -> {
                                        if (vRel == null) {
                                            vRel = v1.createRelationshipTo(v2, rel.getType());
                                        }
                                        if (!relAggNames.isEmpty()) {
                                            this.aggregate((PropertyContainer)vRel, relAggNames, relAggKeys.length > 0 ? rel.getProperties(relAggKeys) : Collections.emptyMap());
                                        }
                                        return vRel;
                                    });
                                }
                            }
                        }
                    }
                }
                catch (Exception e) {
                    this.log.debug("Error grouping relationships", (Throwable)e);
                }
                return null;
            }));
            Util.removeFinished(futures);
        }
        Util.waitForFutures(futures);
        return this.fixAggregates(virtualNodes.values()).stream().map(n -> new GraphResult(Collections.singletonList(n), this.fixAggregates(Iterables.asList((Iterable)n.getRelationships()))));
    }

    private Map<String, List<String>> toStringListMap(Map<String, Object> input) {
        LinkedHashMap<String, List<String>> nodeAggNames = new LinkedHashMap<String, List<String>>(input.size());
        input.forEach((k, v) -> nodeAggNames.put((String)k, (List<String>)(v instanceof List ? ((List)v).stream().map(Object::toString).collect(Collectors.toList()) : Collections.singletonList(v.toString()))));
        return nodeAggNames;
    }

    private String[] keyArray(Map<String, ?> map, String ... removeKeys) {
        ArrayList<String> keys = new ArrayList<String>(map.keySet());
        for (String key : removeKeys) {
            keys.remove(key);
        }
        return keys.toArray(new String[keys.size()]);
    }

    private <C extends Collection<T>, T extends PropertyContainer> C fixAggregates(C pcs) {
        for (PropertyContainer pc : pcs) {
            pc.getAllProperties().entrySet().forEach(entry -> {
                Object v = entry.getValue();
                String k = (String)entry.getKey();
                if (k.matches("^(min|max|sum)_.+") && v instanceof Number && ((Number)v).doubleValue() == (double)((Number)v).longValue()) {
                    entry.setValue(((Number)v).longValue());
                }
                if (k.matches("^avg_.+") && v instanceof double[]) {
                    double[] values = (double[])v;
                    entry.setValue(values[1] == 0.0 ? 0.0 : values[0] / values[1]);
                }
                if (k.matches("^collect_.+") && v instanceof Collection) {
                    entry.setValue(((Collection)v).toArray());
                }
            });
        }
        return pcs;
    }

    private void aggregate(PropertyContainer pc, Map<String, List<String>> aggregations, Map<String, Object> properties) {
        aggregations.forEach((k2, aggNames) -> {
            for (String aggName : aggNames) {
                String key = aggName + "_" + k2;
                if ("count_*".equals(key)) {
                    pc.setProperty(key, (Object)(((Number)pc.getProperty(key, (Object)0)).longValue() + 1L));
                    continue;
                }
                Object value = properties.get(k2);
                if (value == null) continue;
                switch (aggName) {
                    case "collect": {
                        List existing = (List)pc.getProperty(key, new ArrayList());
                        existing.add(value);
                        pc.setProperty(key, (Object)existing);
                        break;
                    }
                    case "count": {
                        pc.setProperty(key, (Object)(((Number)pc.getProperty(key, (Object)0)).longValue() + 1L));
                        break;
                    }
                    case "sum": {
                        pc.setProperty(key, (Object)(((Number)pc.getProperty(key, (Object)0)).doubleValue() + Util.toDouble(value)));
                        break;
                    }
                    case "min": {
                        pc.setProperty(key, (Object)Math.min(((Number)pc.getProperty(key, (Object)Double.MAX_VALUE)).doubleValue(), Util.toDouble(value)));
                        break;
                    }
                    case "max": {
                        pc.setProperty(key, (Object)Math.max(((Number)pc.getProperty(key, (Object)Double.MIN_VALUE)).doubleValue(), Util.toDouble(value)));
                        break;
                    }
                    case "avg": {
                        double[] avg = (double[])pc.getProperty(key, (Object)new double[2]);
                        avg[0] = avg[0] + Util.toDouble(value);
                        avg[1] = avg[1] + 1.0;
                        pc.setProperty(key, (Object)avg);
                        break;
                    }
                }
            }
        });
    }

    private Map<String, Object> propertiesFor(Node node, String[] keys) {
        HashMap<String, Object> props = new HashMap<String, Object>(keys.length);
        for (String key : keys) {
            props.put(key, node.getProperty(key, null));
        }
        return props;
    }

    private NodeKey keyFor(Node node, String label, String[] keys) {
        return new NodeKey(label, this.propertiesFor(node, keys));
    }

    private Collection<NodeKey> keysFor(Node node, List<String> labels, String[] keys) {
        Map<String, Object> props = this.propertiesFor(node, keys);
        ArrayList<NodeKey> result = new ArrayList<NodeKey>(labels.size());
        if (labels.contains(ASTERISK)) {
            result.add(new NodeKey(ASTERISK, props));
        } else {
            for (Label label : node.getLabels()) {
                if (!labels.contains(label.name())) continue;
                result.add(new NodeKey(label.name(), props));
            }
        }
        return result;
    }

    private static class RelKey {
        private final int hash;
        private final NodeKey startKey;
        private final NodeKey endKey;
        private final String type;

        RelKey(NodeKey startKey, NodeKey endKey, Relationship rel) {
            this.startKey = startKey;
            this.endKey = endKey;
            this.type = rel.getType().name();
            this.hash = 31 * (31 * startKey.hashCode() + endKey.hashCode()) + this.type.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RelKey relKey = (RelKey)o;
            return this.startKey.equals(relKey.startKey) && this.endKey.equals(relKey.endKey) && this.type.equals(relKey.type);
        }

        public int hashCode() {
            return this.hash;
        }
    }

    static class NodeKey {
        private final int hash;
        private final String label;
        private final Map<String, Object> values;

        NodeKey(String label, Map<String, Object> values) {
            this.label = label;
            this.values = values;
            this.hash = 31 * label.hashCode() + values.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NodeKey key = (NodeKey)o;
            return this.label.equals(key.label) && this.values.equals(key.values);
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

