/*
 * Decompiled with CFR 0.152.
 */
package apoc.nodes;

import apoc.path.RelationshipTypeAndDirections;
import apoc.result.LongResult;
import apoc.result.NodeResult;
import apoc.result.RelationshipResult;
import apoc.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.api.store.RelationshipIterator;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.UserFunction;
import org.neo4j.storageengine.api.Token;

public class Nodes {
    @Context
    public GraphDatabaseService db;
    @Context
    public KernelTransaction ktx;

    @Procedure(mode=Mode.WRITE)
    @Description(value="apoc.nodes.link([nodes],'REL_TYPE') - creates a linked list of nodes from first to last")
    public void link(@Name(value="nodes") List<Node> nodes, @Name(value="type") String type) {
        Iterator<Node> it = nodes.iterator();
        if (it.hasNext()) {
            RelationshipType relType = RelationshipType.withName((String)type);
            Node node = it.next();
            while (it.hasNext()) {
                Node next = it.next();
                node.createRelationshipTo(next, relType);
                node = next;
            }
        }
    }

    @Procedure
    @Description(value="apoc.nodes.get(node|nodes|id|[ids]) - quickly returns all nodes with these ids")
    public Stream<NodeResult> get(@Name(value="nodes") Object ids) {
        return Util.nodeStream(this.db, ids).map(NodeResult::new);
    }

    @Procedure(mode=Mode.WRITE)
    @Description(value="apoc.nodes.delete(node|nodes|id|[ids]) - quickly delete all nodes with these ids")
    public Stream<LongResult> delete(@Name(value="nodes") Object ids, @Name(value="batchSize") long batchSize) {
        Iterator it = Util.nodeStream(this.db, ids).iterator();
        long count = 0L;
        while (it.hasNext()) {
            List batch = Util.take(it, (int)batchSize);
            count += (long)Util.inTx(this.db, () -> {
                this.db.execute("FOREACH (n in {nodes} | DETACH DELETE n)", Util.map("nodes", batch)).close();
                return batch.size();
            }).intValue();
        }
        return Stream.of(new LongResult(count));
    }

    @Procedure
    @Description(value="apoc.get.rels(rel|id|[ids]) - quickly returns all relationships with these ids")
    public Stream<RelationshipResult> rels(@Name(value="relationships") Object ids) {
        return Util.relsStream(this.db, ids).map(RelationshipResult::new);
    }

    @UserFunction(value="apoc.node.relationship.exists")
    @Description(value="apoc.node.relationship.exists(node, rel-direction-pattern) - returns true when the node has the relationships of the pattern")
    public boolean hasRelationship(@Name(value="node") Node node, @Name(value="types", defaultValue="") String types) throws EntityNotFoundException {
        if (types == null || types.isEmpty()) {
            return node.hasRelationship();
        }
        long id = node.getId();
        try (Statement stmt = this.ktx.acquireStatement();){
            ReadOperations ops = stmt.readOperations();
            boolean dense = ops.nodeIsDense(id);
            for (Pair<RelationshipType, Direction> pair : RelationshipTypeAndDirections.parse(types)) {
                boolean hasRelationship;
                int typeId = ops.relationshipTypeGetForName(((RelationshipType)pair.first()).name());
                Direction direction = (Direction)pair.other();
                boolean bl = dense ? ops.nodeGetDegree(id, direction, typeId) > 0 : (hasRelationship = ops.nodeGetRelationships(id, direction, new int[]{typeId}).hasNext());
                if (!hasRelationship) continue;
                boolean bl2 = true;
                return bl2;
            }
        }
        return false;
    }

    @UserFunction(value="apoc.nodes.connected")
    @Description(value="apoc.nodes.connected(start, end, rel-direction-pattern) - returns true when the node is connected to the other node, optimized for dense nodes")
    public boolean connected(@Name(value="start") Node start, @Name(value="start") Node end, @Name(value="types", defaultValue="") String types) throws EntityNotFoundException {
        if (start == null || end == null) {
            return false;
        }
        if (start.equals(end)) {
            return true;
        }
        long startId = start.getId();
        long endId = end.getId();
        List<Pair<RelationshipType, Direction>> pairs = types == null || types.isEmpty() ? null : RelationshipTypeAndDirections.parse(types);
        try (Statement stmt = this.ktx.acquireStatement();){
            ReadOperations ops = stmt.readOperations();
            boolean startDense = ops.nodeIsDense(startId);
            boolean endDense = ops.nodeIsDense(endId);
            if (!startDense) {
                boolean bl = this.connected(ops, startId, endId, this.typedDirections(ops, pairs, true));
                return bl;
            }
            if (!endDense) {
                boolean bl = this.connected(ops, endId, startId, this.typedDirections(ops, pairs, false));
                return bl;
            }
            boolean bl = this.connectedDense(ops, startId, endId, pairs);
            return bl;
        }
    }

    private boolean connected(ReadOperations ops, long start, long end, int[][] typedDirections) throws EntityNotFoundException {
        MatchingRelationshipVisitor matcher = typedDirections == null ? new MatchingRelationshipAllVisitor(end) : new MatchingRelationshipTypesDirectionVisitor(typedDirections, end);
        return Nodes.checkRelationships(ops.nodeGetRelationships(start, Direction.BOTH), matcher);
    }

    private int[][] typedDirections(ReadOperations ops, List<Pair<RelationshipType, Direction>> pairs, boolean outgoing) {
        if (pairs == null) {
            return null;
        }
        int from = 0;
        int to = 0;
        int both = 0;
        int[][] result = new int[Direction.values().length][pairs.size()];
        int outIdx = Direction.OUTGOING.ordinal();
        int inIdx = Direction.INCOMING.ordinal();
        int bothIdx = Direction.BOTH.ordinal();
        for (Pair<RelationshipType, Direction> pair : pairs) {
            int type = ops.relationshipTypeGetForName(((RelationshipType)pair.first()).name());
            if (type == -1) continue;
            if (pair.other() != Direction.INCOMING) {
                result[outIdx][from++] = type;
            }
            if (pair.other() != Direction.OUTGOING) {
                result[inIdx][to++] = type;
            }
            result[bothIdx][both++] = type;
        }
        result[outIdx] = Arrays.copyOf(result[outIdx], from);
        result[inIdx] = Arrays.copyOf(result[inIdx], to);
        result[bothIdx] = Arrays.copyOf(result[bothIdx], both);
        if (!outgoing) {
            int[] tmp = result[outIdx];
            result[outIdx] = result[inIdx];
            result[inIdx] = tmp;
        }
        return result;
    }

    public static boolean checkRelationships(RelationshipIterator it, MatchingRelationshipVisitor matcher) {
        while (it.hasNext()) {
            long id = it.next();
            it.relationshipVisit(id, (RelationshipVisitor)matcher);
            if (!matcher.matched()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean connectedDense(ReadOperations ops, long start, long end, List<Pair<RelationshipType, Direction>> pairs) throws EntityNotFoundException {
        int length;
        Object types;
        BitSet given;
        int totalTypes;
        ArrayList<Degree> degrees = new ArrayList<Degree>(32);
        int[][] typedDirectionsOut = this.typedDirections(ops, pairs, true);
        if (pairs == null) {
            void var14_16;
            totalTypes = ops.relationshipTypeCount();
            given = new BitSet(totalTypes);
            Iterator tokens = ops.relationshipTypesGetAllTokens();
            while (tokens.hasNext()) {
                given.set(((Token)tokens.next()).id());
            }
            types = this.typesOf(ops, totalTypes, given, start);
            ((BitSet)types).and(this.typesOf(ops, totalTypes, given, end));
            if (((BitSet)types).isEmpty()) {
                return false;
            }
            length = ((BitSet)types).length();
            boolean bl = false;
            while (var14_16 < length) {
                if (((BitSet)types).get((int)var14_16)) {
                    this.addSmallestDegree(ops, degrees, start, end, (int)var14_16, Direction.OUTGOING);
                    this.addSmallestDegree(ops, degrees, start, end, (int)var14_16, Direction.INCOMING);
                }
                ++var14_16;
            }
        } else {
            void var14_21;
            Object type;
            void var14_19;
            totalTypes = typedDirectionsOut.length;
            given = new BitSet(totalTypes);
            for (Object object : (Iterator)typedDirectionsOut[Direction.BOTH.ordinal()]) {
                given.set((int)object);
            }
            BitSet types2 = this.typesOf(ops, totalTypes, given, start);
            types2.and(this.typesOf(ops, totalTypes, given, end));
            types = typedDirectionsOut[Direction.OUTGOING.ordinal()];
            length = ((Object)types).length;
            boolean bl = false;
            while (var14_19 < length) {
                type = types[var14_19];
                this.addSmallestDegree(ops, degrees, start, end, (int)type, Direction.OUTGOING);
                ++var14_19;
            }
            types = typedDirectionsOut[Direction.INCOMING.ordinal()];
            length = ((Object)types).length;
            boolean bl2 = false;
            while (var14_21 < length) {
                type = types[var14_21];
                this.addSmallestDegree(ops, degrees, start, end, (int)type, Direction.INCOMING);
                ++var14_21;
            }
        }
        Collections.sort(degrees);
        MatchingRelationshipAllVisitor startMatcher = new MatchingRelationshipAllVisitor(start);
        MatchingRelationshipAllVisitor endMatcher = new MatchingRelationshipAllVisitor(end);
        for (Degree degree : degrees) {
            MatchingRelationshipAllVisitor matcher;
            if (!degree.isConnected(ops, matcher = degree.other == start ? startMatcher : endMatcher)) continue;
            return true;
        }
        return false;
    }

    private BitSet typesOf(ReadOperations ops, int totalTypes, BitSet given, long node) throws EntityNotFoundException {
        BitSet types = new BitSet(totalTypes);
        PrimitiveIntIterator it = ops.nodeGetRelationshipTypes(node);
        while (it.hasNext()) {
            int type = it.next();
            if (!given.get(type)) continue;
            types.set(type);
        }
        return types;
    }

    private void addSmallestDegree(ReadOperations ops, List<Degree> degrees, long start, long end, int type, Direction direction) throws EntityNotFoundException {
        int startDegree = ops.nodeGetDegree(start, direction, type);
        if (startDegree == 0) {
            return;
        }
        Direction reverse = direction.reverse();
        int endDegree = ops.nodeGetDegree(end, reverse, type);
        if (endDegree == 0) {
            return;
        }
        if (startDegree < endDegree) {
            degrees.add(new Degree(start, type, direction, startDegree, end));
        } else {
            degrees.add(new Degree(end, type, reverse, endDegree, start));
        }
    }

    private <T> List<T> asList(Iterable<T> types) {
        return types instanceof List ? (List)types : Iterables.asList(types);
    }

    @UserFunction(value="apoc.node.degree")
    @Description(value="apoc.node.degree(node, rel-direction-pattern) - returns total degrees of the given relationships in the pattern, can use '>' or '<' for all outgoing or incoming relationships")
    public long degree(@Name(value="node") Node node, @Name(value="types", defaultValue="") String types) throws EntityNotFoundException {
        if (types == null || types.isEmpty()) {
            return node.getDegree();
        }
        long degree = 0L;
        for (Pair<RelationshipType, Direction> pair : RelationshipTypeAndDirections.parse(types)) {
            degree += (long)this.getDegreeSafe(node, (RelationshipType)pair.first(), (Direction)pair.other());
        }
        return degree;
    }

    @UserFunction(value="apoc.node.relationship.types")
    @Description(value="apoc.node.relationship.types(node, rel-direction-pattern) - returns a list of distinct relationship types")
    public List<String> relationshipTypes(@Name(value="node") Node node, @Name(value="types", defaultValue="") String types) {
        if (node == null) {
            return null;
        }
        List relTypes = Iterables.asList((Iterable)Iterables.map(RelationshipType::name, (Iterable)node.getRelationshipTypes()));
        if (types == null || types.isEmpty()) {
            return relTypes;
        }
        ArrayList<String> result = new ArrayList<String>(relTypes.size());
        for (Pair<RelationshipType, Direction> p : RelationshipTypeAndDirections.parse(types)) {
            String name = ((RelationshipType)p.first()).name();
            if (!relTypes.contains(name) || !node.hasRelationship((RelationshipType)p.first(), (Direction)p.other())) continue;
            result.add(name);
        }
        return result;
    }

    @UserFunction
    @Description(value="apoc.nodes.isDense(node) - returns true if it is a dense node")
    public boolean isDense(@Name(value="node") Node node) {
        try (Statement stmt = this.ktx.acquireStatement();){
            boolean bl = this.isDense(stmt.readOperations(), node);
            return bl;
        }
    }

    private boolean isDense(ReadOperations ops, Node n) {
        try {
            return ops.nodeIsDense(n.getId());
        }
        catch (EntityNotFoundException e) {
            return false;
        }
    }

    private int getDegreeSafe(Node node, RelationshipType relType, Direction direction) {
        if (relType == null) {
            return node.getDegree(direction);
        }
        return node.getDegree(relType, direction);
    }

    private int getDegreeSafe(ReadOperations ops, long id, Direction direction, int typeId) throws EntityNotFoundException {
        if (typeId != -1) {
            return ops.nodeGetDegree(id, direction, typeId);
        }
        return ops.nodeGetDegree(id, direction);
    }

    private static class MatchingRelationshipTypesDirectionVisitor
    implements MatchingRelationshipVisitor {
        private final int[][] typedDirections;
        final long targetId;
        boolean matched;

        private MatchingRelationshipTypesDirectionVisitor(int[][] typedDirections, long targetId) {
            this.typedDirections = typedDirections;
            this.targetId = targetId;
        }

        public void visit(long relationshipId, int typeId, long startNodeId, long endNodeId) throws RuntimeException {
            this.matched = false;
            if (endNodeId == this.targetId) {
                for (int type : this.typedDirections[Direction.OUTGOING.ordinal()]) {
                    if (type != typeId) continue;
                    this.matched = true;
                }
            }
            if (startNodeId == this.targetId) {
                for (int type : this.typedDirections[Direction.INCOMING.ordinal()]) {
                    if (type != typeId) continue;
                    this.matched = true;
                }
            }
        }

        @Override
        public boolean matched() {
            return this.matched;
        }

        @Override
        public void reset() {
            this.matched = false;
        }
    }

    private static class MatchingRelationshipAllVisitor
    implements MatchingRelationshipVisitor {
        final long targetId;
        boolean matched;

        private MatchingRelationshipAllVisitor(long targetId) {
            this.targetId = targetId;
        }

        public void visit(long relationshipId, int typeId, long startNodeId, long endNodeId) throws RuntimeException {
            this.matched = endNodeId == this.targetId || startNodeId == this.targetId;
        }

        @Override
        public boolean matched() {
            return this.matched;
        }

        @Override
        public void reset() {
            this.matched = false;
        }
    }

    static interface MatchingRelationshipVisitor
    extends RelationshipVisitor<RuntimeException> {
        public boolean matched();

        public void reset();
    }

    public static class DenseNodeResult {
        public final Node node;
        public final boolean dense;

        public DenseNodeResult(Node node, boolean dense) {
            this.node = node;
            this.dense = dense;
        }
    }

    static class Degree
    implements Comparable<Degree> {
        public final long node;
        public final int type;
        public final Direction direction;
        public final int degree;
        public final long other;

        public Degree(long node, int type, Direction direction, int degree, long other) {
            this.node = node;
            this.type = type;
            this.direction = direction;
            this.degree = degree;
            this.other = other;
        }

        @Override
        public int compareTo(Degree o) {
            return Integer.compare(this.degree, o.degree);
        }

        public boolean isConnected(ReadOperations ops, MatchingRelationshipVisitor matcher) throws EntityNotFoundException {
            if (this.degree == 0) {
                return false;
            }
            if (this.other == this.node) {
                return true;
            }
            matcher.reset();
            int[] types = new int[]{this.type};
            if (this.direction == Direction.OUTGOING) {
                return Nodes.checkRelationships(ops.nodeGetRelationships(this.node, Direction.OUTGOING, types), matcher);
            }
            if (this.direction == Direction.INCOMING) {
                return Nodes.checkRelationships(ops.nodeGetRelationships(this.node, Direction.INCOMING, types), matcher);
            }
            return Nodes.checkRelationships(ops.nodeGetRelationships(this.node, Direction.BOTH, types), matcher);
        }
    }
}

