/*
 * Decompiled with CFR 0.152.
 */
package apoc.path;

import apoc.algo.Cover;
import apoc.path.LabelMatcherGroup;
import apoc.path.RelationshipSequenceExpander;
import apoc.result.GraphResult;
import apoc.result.NodeResult;
import apoc.result.PathResult;
import apoc.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.traversal.Evaluation;
import org.neo4j.graphdb.traversal.Evaluator;
import org.neo4j.graphdb.traversal.Evaluators;
import org.neo4j.graphdb.traversal.PathEvaluator;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.graphdb.traversal.Traverser;
import org.neo4j.graphdb.traversal.Uniqueness;
import org.neo4j.graphdb.traversal.UniquenessFactory;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class PathExplorer {
    private static final String VERSION = "0.5";
    public static final Uniqueness UNIQUENESS = Uniqueness.RELATIONSHIP_PATH;
    public static final boolean BFS = true;
    @Context
    public GraphDatabaseService db;
    @Context
    public Log log;

    @Procedure(value="apoc.path.expand")
    @Description(value="apoc.path.expand(startNode <id>|Node|list, 'TYPE|TYPE_OUT>|<TYPE_IN', '+YesLabel|-NoLabel', minLevel, maxLevel ) yield path - expand from start node following the given relationships from min to max-level adhering to the label filters")
    public Stream<PathResult> explorePath(@Name(value="start") Object start, @Name(value="relationshipFilter") String pathFilter, @Name(value="labelFilter") String labelFilter, @Name(value="minLevel") long minLevel, @Name(value="maxLevel") long maxLevel) throws Exception {
        List<Node> nodes = this.startToNodes(start);
        return this.explorePathPrivate(nodes, pathFilter, labelFilter, minLevel, maxLevel, true, UNIQUENESS, false, -1L, Collections.emptyList(), Collections.emptyList(), null, true).map(PathResult::new);
    }

    @Procedure(value="apoc.path.expandConfig")
    @Description(value="apoc.path.expandConfig(startNode <id>|Node|list, {minLevel,maxLevel,uniqueness,relationshipFilter,labelFilter,uniqueness:'RELATIONSHIP_PATH',bfs:true, filterStartNode:false, limit:-1, optional:false, endNodes:[], terminatorNodes:[], sequence, beginSequenceAtStart:true}) yield path - expand from start node following the given relationships from min to max-level adhering to the label filters. ")
    public Stream<PathResult> expandConfig(@Name(value="start") Object start, @Name(value="config") Map<String, Object> config) throws Exception {
        return this.expandConfigPrivate(start, config).map(PathResult::new);
    }

    @Procedure(value="apoc.path.subgraphNodes")
    @Description(value="apoc.path.subgraphNodes(startNode <id>|Node|list, {maxLevel,relationshipFilter,labelFilter,bfs:true, filterStartNode:false, limit:-1, optional:false, endNodes:[], terminatorNodes:[], sequence, beginSequenceAtStart:true}) yield node - expand the subgraph nodes reachable from start node following relationships to max-level adhering to the label filters")
    public Stream<NodeResult> subgraphNodes(@Name(value="start") Object start, @Name(value="config") Map<String, Object> config) throws Exception {
        HashMap<String, Object> configMap = new HashMap<String, Object>(config);
        configMap.put("uniqueness", "NODE_GLOBAL");
        if (config.containsKey("minLevel")) {
            throw new IllegalArgumentException("minLevel not supported in subgraphNodes");
        }
        return this.expandConfigPrivate(start, configMap).map(path -> path == null ? new NodeResult(null) : new NodeResult(path.endNode()));
    }

    @Procedure(value="apoc.path.subgraphAll")
    @Description(value="apoc.path.subgraphAll(startNode <id>|Node|list, {maxLevel,relationshipFilter,labelFilter,bfs:true, filterStartNode:false, limit:-1, endNodes:[], terminatorNodes:[], sequence, beginSequenceAtStart:true}) yield nodes, relationships - expand the subgraph reachable from start node following relationships to max-level adhering to the label filters, and also return all relationships within the subgraph")
    public Stream<GraphResult> subgraphAll(@Name(value="start") Object start, @Name(value="config") Map<String, Object> config) throws Exception {
        HashMap<String, Object> configMap = new HashMap<String, Object>(config);
        configMap.remove("optional");
        configMap.put("uniqueness", "NODE_GLOBAL");
        if (config.containsKey("minLevel")) {
            throw new IllegalArgumentException("minLevel not supported in subgraphAll");
        }
        List<Node> subgraphNodes = this.expandConfigPrivate(start, configMap).map(Path::endNode).collect(Collectors.toList());
        List<Relationship> subgraphRels = Cover.coverNodes(subgraphNodes).collect(Collectors.toList());
        return Stream.of(new GraphResult(subgraphNodes, subgraphRels));
    }

    @Procedure(value="apoc.path.spanningTree")
    @Description(value="apoc.path.spanningTree(startNode <id>|Node|list, {maxLevel,relationshipFilter,labelFilter,bfs:true, filterStartNode:false, limit:-1, optional:false, endNodes:[], terminatorNodes:[], sequence, beginSequenceAtStart:true}) yield path - expand a spanning tree reachable from start node following relationships to max-level adhering to the label filters")
    public Stream<PathResult> spanningTree(@Name(value="start") Object start, @Name(value="config") Map<String, Object> config) throws Exception {
        HashMap<String, Object> configMap = new HashMap<String, Object>(config);
        configMap.put("uniqueness", "NODE_GLOBAL");
        if (config.containsKey("minLevel")) {
            throw new IllegalArgumentException("minLevel not supported in spanningTree");
        }
        return this.expandConfigPrivate(start, configMap).map(PathResult::new);
    }

    private Uniqueness getUniqueness(String uniqueness) {
        for (Uniqueness u : Uniqueness.values()) {
            if (!u.name().equalsIgnoreCase(uniqueness)) continue;
            return u;
        }
        return UNIQUENESS;
    }

    private List<Node> startToNodes(Object start) throws Exception {
        if (start == null) {
            return Collections.emptyList();
        }
        if (start instanceof Node) {
            return Collections.singletonList((Node)start);
        }
        if (start instanceof Number) {
            return Collections.singletonList(this.db.getNodeById(((Number)start).longValue()));
        }
        if (start instanceof List) {
            List list = (List)start;
            if (list.isEmpty()) {
                return Collections.emptyList();
            }
            Object first = list.get(0);
            if (first instanceof Node) {
                return list;
            }
            if (first instanceof Number) {
                ArrayList<Node> nodes = new ArrayList<Node>();
                for (Number n : list) {
                    nodes.add(this.db.getNodeById(n.longValue()));
                }
                return nodes;
            }
        }
        throw new Exception("Unsupported data type for start parameter a Node or an Identifier (long) of a Node must be given!");
    }

    private Stream<Path> expandConfigPrivate(@Name(value="start") Object start, @Name(value="config") Map<String, Object> config) throws Exception {
        List<Node> nodes = this.startToNodes(start);
        String uniqueness = (String)config.getOrDefault("uniqueness", UNIQUENESS.name());
        String relationshipFilter = config.getOrDefault("relationshipFilter", null);
        String labelFilter = config.getOrDefault("labelFilter", null);
        long minLevel = Util.toLong(config.getOrDefault("minLevel", "-1"));
        long maxLevel = Util.toLong(config.getOrDefault("maxLevel", "-1"));
        boolean bfs = Util.toBoolean(config.getOrDefault("bfs", true));
        boolean filterStartNode = Util.toBoolean(config.getOrDefault("filterStartNode", false));
        long limit = Util.toLong(config.getOrDefault("limit", "-1"));
        boolean optional = Util.toBoolean(config.getOrDefault("optional", false));
        List<Node> endNodes = this.startToNodes(config.get("endNodes"));
        List<Node> terminatorNodes = this.startToNodes(config.get("terminatorNodes"));
        String sequence = config.getOrDefault("sequence", null);
        boolean beginSequenceAtStart = Util.toBoolean(config.getOrDefault("beginSequenceAtStart", true));
        Stream<Path> results = this.explorePathPrivate(nodes, relationshipFilter, labelFilter, minLevel, maxLevel, bfs, this.getUniqueness(uniqueness), filterStartNode, limit, endNodes, terminatorNodes, sequence, beginSequenceAtStart);
        if (optional) {
            return this.optionalStream(results);
        }
        return results;
    }

    private Stream<Path> explorePathPrivate(Iterable<Node> startNodes, String pathFilter, String labelFilter, long minLevel, long maxLevel, boolean bfs, Uniqueness uniqueness, boolean filterStartNode, long limit, List<Node> endNodes, List<Node> terminatorNodes, String sequence, boolean beginSequenceAtStart) {
        Traverser traverser = PathExplorer.traverse(this.db.traversalDescription(), startNodes, pathFilter, labelFilter, minLevel, maxLevel, uniqueness, bfs, filterStartNode, endNodes, terminatorNodes, sequence, beginSequenceAtStart);
        if (limit == -1L) {
            return traverser.stream();
        }
        return traverser.stream().limit(limit);
    }

    private Stream<Path> optionalStream(Stream<Path> stream) {
        Stream<Object> optionalStream;
        Iterator itr = stream.iterator();
        if (itr.hasNext()) {
            optionalStream = StreamSupport.stream(Spliterators.spliteratorUnknownSize(itr, 0), false);
        } else {
            ArrayList listOfNull = new ArrayList();
            listOfNull.add(null);
            optionalStream = listOfNull.stream();
        }
        return optionalStream;
    }

    public static Traverser traverse(TraversalDescription traversalDescription, Iterable<Node> startNodes, String pathFilter, String labelFilter, long minLevel, long maxLevel, Uniqueness uniqueness, boolean bfs, boolean filterStartNode, List<Node> endNodes, List<Node> terminatorNodes, String sequence, boolean beginSequenceAtStart) {
        Node[] nodes;
        TraversalDescription td = traversalDescription;
        TraversalDescription traversalDescription2 = td = bfs ? td.breadthFirst() : td.depthFirst();
        if (sequence != null && !sequence.trim().isEmpty()) {
            String[] sequenceSteps = sequence.split(",");
            ArrayList<String> labelSequenceList = new ArrayList<String>();
            ArrayList<String> relSequenceList = new ArrayList<String>();
            for (int index = 0; index < sequenceSteps.length; ++index) {
                ArrayList<Object> seq = (beginSequenceAtStart ? index : index - 1) % 2 == 0 ? labelSequenceList : relSequenceList;
                seq.add(sequenceSteps[index]);
            }
            td = td.expand((PathExpander)new RelationshipSequenceExpander(relSequenceList, beginSequenceAtStart));
            td = td.evaluator((Evaluator)new LabelSequenceEvaluator(labelSequenceList, filterStartNode, beginSequenceAtStart, (int)minLevel));
        } else {
            if (pathFilter != null && !pathFilter.trim().isEmpty()) {
                td = td.expand((PathExpander)new RelationshipSequenceExpander(pathFilter.trim(), beginSequenceAtStart));
            }
            if (labelFilter != null && sequence == null && !labelFilter.trim().isEmpty()) {
                td = td.evaluator((Evaluator)new LabelSequenceEvaluator(labelFilter.trim(), filterStartNode, beginSequenceAtStart, (int)minLevel));
            }
        }
        if (minLevel != -1L) {
            td = td.evaluator(Evaluators.fromDepth((int)((int)minLevel)));
        }
        if (maxLevel != -1L) {
            td = td.evaluator(Evaluators.toDepth((int)((int)maxLevel)));
        }
        PathEvaluator endNodeEvaluator = null;
        PathEvaluator terminatorNodeEvaluator = null;
        if (!endNodes.isEmpty()) {
            nodes = endNodes.toArray(new Node[endNodes.size()]);
            endNodeEvaluator = Evaluators.includeWhereEndNodeIs((Node[])nodes);
        }
        if (!terminatorNodes.isEmpty()) {
            nodes = terminatorNodes.toArray(new Node[terminatorNodes.size()]);
            terminatorNodeEvaluator = Evaluators.pruneWhereEndNodeIs((Node[])nodes);
        }
        if (endNodeEvaluator != null || terminatorNodeEvaluator != null) {
            td = td.evaluator((Evaluator)new EndAndTerminatorNodeEvaluator((Evaluator)endNodeEvaluator, (Evaluator)terminatorNodeEvaluator));
        }
        td = td.uniqueness((UniquenessFactory)uniqueness);
        return td.traverse(startNodes);
    }

    public static class EndAndTerminatorNodeEvaluator
    implements Evaluator {
        private Evaluator endNodeEvaluator;
        private Evaluator terminatorNodeEvaluator;

        public EndAndTerminatorNodeEvaluator(Evaluator endNodeEvaluator, Evaluator terminatorNodeEvaluator) {
            this.endNodeEvaluator = endNodeEvaluator;
            this.terminatorNodeEvaluator = terminatorNodeEvaluator;
        }

        public Evaluation evaluate(Path path) {
            boolean includes = this.evalIncludes(this.endNodeEvaluator, path) || this.evalIncludes(this.terminatorNodeEvaluator, path);
            boolean continues = this.terminatorNodeEvaluator == null || this.terminatorNodeEvaluator.evaluate(path).continues();
            return Evaluation.of((boolean)includes, (boolean)continues);
        }

        private boolean evalIncludes(Evaluator eval, Path path) {
            return eval != null && eval.evaluate(path).includes();
        }
    }

    public static class LabelSequenceEvaluator
    implements Evaluator {
        private List<LabelMatcherGroup> sequenceMatchers;
        private Evaluation whitelistAllowedEvaluation;
        private boolean endNodesOnly;
        private boolean filterStartNode;
        private boolean beginSequenceAtStart;
        private long minLevel = -1L;

        public LabelSequenceEvaluator(String labelSequence, boolean filterStartNode, boolean beginSequenceAtStart, int minLevel) {
            List<String> labelSequenceList = labelSequence != null && !labelSequence.isEmpty() ? Arrays.asList(labelSequence.split(",")) : Collections.emptyList();
            this.initialize(labelSequenceList, filterStartNode, beginSequenceAtStart, minLevel);
        }

        public LabelSequenceEvaluator(List<String> labelSequenceList, boolean filterStartNode, boolean beginSequenceAtStart, int minLevel) {
            this.initialize(labelSequenceList, filterStartNode, beginSequenceAtStart, minLevel);
        }

        private void initialize(List<String> labelSequenceList, boolean filterStartNode, boolean beginSequenceAtStart, int minLevel) {
            this.filterStartNode = filterStartNode;
            this.beginSequenceAtStart = beginSequenceAtStart;
            this.minLevel = minLevel;
            this.sequenceMatchers = new ArrayList<LabelMatcherGroup>(labelSequenceList.size());
            for (String labelFilterString : labelSequenceList) {
                LabelMatcherGroup matcherGroup = new LabelMatcherGroup().addLabels(labelFilterString.trim());
                this.sequenceMatchers.add(matcherGroup);
                this.endNodesOnly = this.endNodesOnly || matcherGroup.isEndNodesOnly();
            }
            if (this.endNodesOnly) {
                for (LabelMatcherGroup group : this.sequenceMatchers) {
                    group.setEndNodesOnly(this.endNodesOnly);
                }
            }
            this.whitelistAllowedEvaluation = this.endNodesOnly ? Evaluation.EXCLUDE_AND_CONTINUE : Evaluation.INCLUDE_AND_CONTINUE;
        }

        public Evaluation evaluate(Path path) {
            boolean belowMinLevel;
            int depth = path.length();
            Node node = path.endNode();
            boolean bl = belowMinLevel = (long)depth < this.minLevel;
            if (!(depth != 0 || this.filterStartNode && this.beginSequenceAtStart)) {
                return this.whitelistAllowedEvaluation;
            }
            LabelMatcherGroup matcherGroup = this.sequenceMatchers.get((this.beginSequenceAtStart ? depth : depth - 1) % this.sequenceMatchers.size());
            return matcherGroup.evaluate(node, belowMinLevel);
        }
    }
}

