/*
 * Decompiled with CFR 0.152.
 */
package apoc.refactor;

import apoc.Pools;
import apoc.refactor.NodeRefactorResult;
import apoc.refactor.RelationshipRefactorResult;
import apoc.refactor.util.PropertiesManager;
import apoc.refactor.util.RefactorConfig;
import apoc.result.NodeResult;
import apoc.result.RelationshipResult;
import apoc.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Stream;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class GraphRefactoring {
    @Context
    public GraphDatabaseService db;
    @Context
    public Log log;

    private Stream<NodeRefactorResult> doCloneNodes(@Name(value="nodes") List<Node> nodes, @Name(value="withRelationships") boolean withRelationships, List<String> skipProperties) {
        if (nodes == null) {
            return Stream.empty();
        }
        return nodes.stream().map(node -> {
            NodeRefactorResult result = new NodeRefactorResult(node.getId());
            try {
                Node newNode = this.copyLabels((Node)node, this.db.createNode());
                Map properties = node.getAllProperties();
                if (skipProperties != null && !skipProperties.isEmpty()) {
                    for (String skip : skipProperties) {
                        properties.remove(skip);
                    }
                }
                Node copy = this.copyProperties(properties, newNode);
                if (withRelationships) {
                    this.copyRelationships((Node)node, copy, false);
                }
                return result.withOther(copy);
            }
            catch (Exception e) {
                return result.withError(e);
            }
        });
    }

    @Procedure(mode=Mode.WRITE)
    @Description(value="apoc.refactor.extractNode([rel1,rel2,...], [labels],'OUT','IN') extract node from relationships")
    public Stream<NodeRefactorResult> extractNode(@Name(value="relationships") Object rels, @Name(value="labels") List<String> labels, @Name(value="outType") String outType, @Name(value="inType") String inType) {
        return Util.relsStream(this.db, rels).map(rel -> {
            NodeRefactorResult result = new NodeRefactorResult(rel.getId());
            try {
                Node copy = this.copyProperties((PropertyContainer)rel, this.db.createNode(Util.labels(labels)));
                copy.createRelationshipTo(rel.getEndNode(), RelationshipType.withName((String)outType));
                rel.getStartNode().createRelationshipTo(copy, RelationshipType.withName((String)inType));
                rel.delete();
                return result.withOther(copy);
            }
            catch (Exception e) {
                return result.withError(e);
            }
        });
    }

    @Procedure(mode=Mode.WRITE)
    @Description(value="apoc.refactor.collapseNode([node1,node2],'TYPE') collapse node to relationship, node with one rel becomes self-relationship")
    public Stream<RelationshipRefactorResult> collapseNode(@Name(value="nodes") Object nodes, @Name(value="type") String type) {
        return Util.nodeStream(this.db, nodes).map(node -> {
            RelationshipRefactorResult result = new RelationshipRefactorResult(node.getId());
            try {
                Iterable outRels = node.getRelationships(Direction.OUTGOING);
                Iterable inRels = node.getRelationships(Direction.INCOMING);
                if (node.getDegree(Direction.OUTGOING) == 1 && node.getDegree(Direction.INCOMING) == 1) {
                    Relationship outRel = (Relationship)outRels.iterator().next();
                    Relationship inRel = (Relationship)inRels.iterator().next();
                    Relationship newRel = inRel.getStartNode().createRelationshipTo(outRel.getEndNode(), RelationshipType.withName((String)type));
                    newRel = this.copyProperties((PropertyContainer)node, this.copyProperties((PropertyContainer)inRel, this.copyProperties((PropertyContainer)outRel, newRel)));
                    for (Relationship r : inRels) {
                        r.delete();
                    }
                    for (Relationship r : outRels) {
                        r.delete();
                    }
                    node.delete();
                    return result.withOther(newRel);
                }
                return result.withError(String.format("Node %d has more that 1 outgoing %d or incoming %d relationships", node.getId(), node.getDegree(Direction.OUTGOING), node.getDegree(Direction.INCOMING)));
            }
            catch (Exception e) {
                return result.withError(e);
            }
        });
    }

    @Procedure(mode=Mode.WRITE)
    @Description(value="apoc.refactor.cloneNodes([node1,node2,...]) clone nodes with their labels and properties")
    public Stream<NodeRefactorResult> cloneNodes(@Name(value="nodes") List<Node> nodes, @Name(value="withRelationships", defaultValue="false") boolean withRelationships, @Name(value="skipProperties", defaultValue="[]") List<String> skipProperties) {
        return this.doCloneNodes(nodes, withRelationships, skipProperties);
    }

    @Procedure(mode=Mode.WRITE)
    @Deprecated
    @Description(value="apoc.refactor.cloneNodesWithRelationships([node1,node2,...]) clone nodes with their labels, properties and relationships")
    public Stream<NodeRefactorResult> cloneNodesWithRelationships(@Name(value="nodes") List<Node> nodes) {
        return this.doCloneNodes(nodes, true, Collections.emptyList());
    }

    @Procedure(mode=Mode.WRITE)
    @Description(value="apoc.refactor.mergeNodes([node1,node2],[{properties:'override' or 'discard' or 'combine'}]) merge nodes onto first in list")
    public Stream<NodeResult> mergeNodes(@Name(value="nodes") List<Node> nodes, @Name(value="config", defaultValue="") Map<String, Object> config) {
        if (nodes == null || nodes.isEmpty()) {
            return Stream.empty();
        }
        try (Transaction tx = this.db.beginTx();){
            nodes.stream().distinct().sorted(Comparator.comparingLong(Node::getId)).forEach(arg_0 -> ((Transaction)tx).acquireWriteLock(arg_0));
            tx.success();
        }
        RefactorConfig conf = new RefactorConfig(config);
        Node first = nodes.get(0);
        nodes.stream().skip(1L).distinct().forEach(node -> this.mergeNodes((Node)node, first, true, conf));
        return Stream.of(new NodeResult(first));
    }

    @Procedure(mode=Mode.WRITE)
    @Description(value="apoc.refactor.mergeRelationships([rel1,rel2]) merge relationships onto first in list")
    public Stream<RelationshipResult> mergeRelationships(@Name(value="rels") List<Relationship> relationships, @Name(value="config", defaultValue="") Map<String, Object> config) {
        if (relationships == null || relationships.isEmpty()) {
            return Stream.empty();
        }
        RefactorConfig conf = new RefactorConfig(config);
        Iterator<Relationship> it = relationships.iterator();
        Relationship first = it.next();
        while (it.hasNext()) {
            Relationship other = it.next();
            if (first.getStartNode().equals(other.getStartNode()) && first.getEndNode().equals(other.getEndNode())) {
                this.mergeRels(other, first, true, conf);
                continue;
            }
            throw new RuntimeException("All Relationships must have the same start and end nodes.");
        }
        return Stream.of(new RelationshipResult(first));
    }

    @Procedure(mode=Mode.WRITE)
    @Description(value="apoc.refactor.setType(rel, 'NEW-TYPE') change relationship-type")
    public Stream<RelationshipRefactorResult> setType(@Name(value="relationship") Relationship rel, @Name(value="newType") String newType) {
        if (rel == null) {
            return Stream.empty();
        }
        RelationshipRefactorResult result = new RelationshipRefactorResult(rel.getId());
        try {
            Relationship newRel = rel.getStartNode().createRelationshipTo(rel.getEndNode(), RelationshipType.withName((String)newType));
            this.copyProperties((PropertyContainer)rel, newRel);
            rel.delete();
            return Stream.of(result.withOther(newRel));
        }
        catch (Exception e) {
            return Stream.of(result.withError(e));
        }
    }

    @Procedure(mode=Mode.WRITE)
    @Description(value="apoc.refactor.to(rel, endNode) redirect relationship to use new end-node")
    public Stream<RelationshipRefactorResult> to(@Name(value="relationship") Relationship rel, @Name(value="newNode") Node newNode) {
        if (rel == null || newNode == null) {
            return Stream.empty();
        }
        RelationshipRefactorResult result = new RelationshipRefactorResult(rel.getId());
        try {
            Relationship newRel = rel.getStartNode().createRelationshipTo(newNode, rel.getType());
            this.copyProperties((PropertyContainer)rel, newRel);
            rel.delete();
            return Stream.of(result.withOther(newRel));
        }
        catch (Exception e) {
            return Stream.of(result.withError(e));
        }
    }

    @Procedure(mode=Mode.WRITE)
    @Description(value="apoc.refactor.invert(rel) inverts relationship direction")
    public Stream<RelationshipRefactorResult> invert(@Name(value="relationship") Relationship rel) {
        if (rel == null) {
            return Stream.empty();
        }
        RelationshipRefactorResult result = new RelationshipRefactorResult(rel.getId());
        try {
            Relationship newRel = rel.getEndNode().createRelationshipTo(rel.getStartNode(), rel.getType());
            this.copyProperties((PropertyContainer)rel, newRel);
            rel.delete();
            return Stream.of(result.withOther(newRel));
        }
        catch (Exception e) {
            return Stream.of(result.withError(e));
        }
    }

    @Procedure(mode=Mode.WRITE)
    @Description(value="apoc.refactor.from(rel, startNode) redirect relationship to use new start-node")
    public Stream<RelationshipRefactorResult> from(@Name(value="relationship") Relationship rel, @Name(value="newNode") Node newNode) {
        if (rel == null || newNode == null) {
            return Stream.empty();
        }
        RelationshipRefactorResult result = new RelationshipRefactorResult(rel.getId());
        try {
            Relationship newRel = newNode.createRelationshipTo(rel.getEndNode(), rel.getType());
            this.copyProperties((PropertyContainer)rel, newRel);
            rel.delete();
            return Stream.of(result.withOther(newRel));
        }
        catch (Exception e) {
            return Stream.of(result.withError(e));
        }
    }

    @Procedure(mode=Mode.WRITE)
    @Description(value="apoc.refactor.normalizeAsBoolean(entity, propertyKey, true_values, false_values) normalize/convert a property to be boolean")
    public void normalizeAsBoolean(@Name(value="entity") Object entity, @Name(value="propertyKey") String propertyKey, @Name(value="true_values") List<Object> trueValues, @Name(value="false_values") List<Object> falseValues) {
        PropertyContainer pc;
        Object value;
        if (entity instanceof PropertyContainer && (value = (pc = (PropertyContainer)entity).getProperty(propertyKey, null)) != null) {
            boolean isTrue = trueValues.contains(value);
            boolean isFalse = falseValues.contains(value);
            if (isTrue && !isFalse) {
                pc.setProperty(propertyKey, (Object)true);
            }
            if (!isTrue && isFalse) {
                pc.setProperty(propertyKey, (Object)false);
            }
            if (!isTrue && !isFalse) {
                pc.removeProperty(propertyKey);
            }
        }
    }

    @Procedure(mode=Mode.WRITE)
    @Description(value="apoc.refactor.categorize(sourceKey, type, outgoing, label, targetKey, copiedKeys, batchSize) turn each unique propertyKey into a category node and connect to it")
    public void categorize(@Name(value="sourceKey") String sourceKey, @Name(value="type") String relationshipType, @Name(value="outgoing") Boolean outgoing, @Name(value="label") String label, @Name(value="targetKey") String targetKey, @Name(value="copiedKeys") List<String> copiedKeys, @Name(value="batchSize") long batchSize) throws ExecutionException {
        if (sourceKey == null) {
            throw new IllegalArgumentException("Invalid (null) sourceKey");
        }
        if (targetKey == null) {
            throw new IllegalArgumentException("Invalid (null) targetKey");
        }
        copiedKeys.remove(targetKey);
        ArrayList<Node> batch = null;
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
        try (Transaction tx = this.db.beginTx();){
            for (Node node : this.db.getAllNodes()) {
                if (batch == null) {
                    batch = new ArrayList<Node>((int)batchSize);
                }
                batch.add(node);
                if ((long)batch.size() != batchSize) continue;
                futures.add(this.categorizeNodes(batch, sourceKey, relationshipType, outgoing, label, targetKey, copiedKeys));
                batch = null;
            }
            if (batch != null) {
                futures.add(this.categorizeNodes(batch, sourceKey, relationshipType, outgoing, label, targetKey, copiedKeys));
            }
            for (Future future : futures) {
                Pools.force(future);
            }
            tx.success();
        }
    }

    private Future<Void> categorizeNodes(List<Node> batch, String sourceKey, String relationshipType, Boolean outgoing, String label, String targetKey, List<String> copiedKeys) {
        return Pools.processBatch(batch, this.db, node -> {
            Object value = node.getProperty(sourceKey, null);
            if (value != null) {
                String q = "WITH {node} AS n MERGE (cat:`" + label + "` {`" + targetKey + "`: {value}}) " + (outgoing != false ? "MERGE (n)-[:`" + relationshipType + "`]->(cat) " : "MERGE (n)<-[:`" + relationshipType + "`]-(cat) ") + "RETURN cat";
                HashMap<String, Object> params = new HashMap<String, Object>(2);
                params.put("node", node);
                params.put("value", value);
                Result result = this.db.execute(q, params);
                if (result.hasNext()) {
                    Node cat = (Node)result.next().get("cat");
                    for (String copiedKey : copiedKeys) {
                        Object copiedValue = node.getProperty(copiedKey, null);
                        if (copiedValue == null) continue;
                        Object catValue = cat.getProperty(copiedKey, null);
                        if (catValue == null) {
                            cat.setProperty(copiedKey, copiedValue);
                            node.removeProperty(copiedKey);
                            continue;
                        }
                        if (!copiedValue.equals(catValue)) continue;
                        node.removeProperty(copiedKey);
                    }
                }
                assert (!result.hasNext());
                result.close();
                node.removeProperty(sourceKey);
            }
        });
    }

    private Node mergeNodes(Node source, Node target, boolean delete, RefactorConfig conf) {
        try {
            Map properties = source.getAllProperties();
            this.copyRelationships(source, this.copyLabels(source, target), delete);
            if (delete) {
                source.delete();
            }
            PropertiesManager.mergeProperties(properties, (PropertyContainer)target, conf);
        }
        catch (NotFoundException e) {
            this.log.warn("skipping a node for merging: " + e.getCause().getMessage());
        }
        return target;
    }

    private Relationship mergeRels(Relationship source, Relationship target, boolean delete, RefactorConfig conf) {
        Map properties = source.getAllProperties();
        if (delete) {
            source.delete();
        }
        PropertiesManager.mergeProperties(properties, (PropertyContainer)target, conf);
        return target;
    }

    private Node copyRelationships(Node source, Node target, boolean delete) {
        for (Relationship rel : source.getRelationships()) {
            this.copyRelationship(rel, source, target);
            if (!delete) continue;
            rel.delete();
        }
        return target;
    }

    private Node copyLabels(Node source, Node target) {
        for (Label label : source.getLabels()) {
            if (target.hasLabel(label)) continue;
            target.addLabel(label);
        }
        return target;
    }

    private <T extends PropertyContainer> T copyProperties(PropertyContainer source, T target) {
        return this.copyProperties(source.getAllProperties(), target);
    }

    private <T extends PropertyContainer> T copyProperties(Map<String, Object> source, T target) {
        for (Map.Entry<String, Object> prop : source.entrySet()) {
            target.setProperty(prop.getKey(), prop.getValue());
        }
        return target;
    }

    private Relationship copyRelationship(Relationship rel, Node source, Node target) {
        Node startNode = rel.getStartNode();
        Node endNode = rel.getEndNode();
        if (startNode.getId() == source.getId()) {
            startNode = target;
        }
        if (endNode.getId() == source.getId()) {
            endNode = target;
        }
        Relationship newrel = startNode.createRelationshipTo(endNode, rel.getType());
        return this.copyProperties((PropertyContainer)rel, newrel);
    }
}

