/*
 * Decompiled with CFR 0.152.
 */
package apoc.refactor.util;

import java.util.Collections;
import java.util.Map;

public class RefactorConfig {
    public static final String COMBINE = "combine";
    public static final String DISCARD = "discard";
    public static final String OVERWRITE = "overwrite";
    private static String MATCH_ALL = ".*";
    private Map<String, String> propertiesManagement = Collections.singletonMap(MATCH_ALL, "overwrite");

    public RefactorConfig(Map<String, Object> config) {
        Object value = config.get("properties");
        if (value instanceof String) {
            this.propertiesManagement = Collections.singletonMap(MATCH_ALL, value.toString());
        } else if (value instanceof Map) {
            this.propertiesManagement = (Map)value;
        }
    }

    public String getMergeMode(String name) {
        for (String key : this.propertiesManagement.keySet()) {
            if (key.equals(MATCH_ALL) || !name.matches(key)) continue;
            return this.propertiesManagement.get(key);
        }
        return this.propertiesManagement.getOrDefault(name, this.propertiesManagement.getOrDefault(MATCH_ALL, OVERWRITE));
    }
}

