/*
 * Decompiled with CFR 0.152.
 */
package apoc.stats;

import apoc.Pools;
import apoc.path.RelationshipTypeAndDirections;
import apoc.util.Util;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Future;
import java.util.stream.Stream;
import org.HdrHistogram.AtomicHistogram;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.storageengine.api.Token;

public class DegreeDistribution {
    @Context
    public GraphDatabaseAPI db;

    @Procedure
    public Stream<DegreeStats.Result> degrees(@Name(value="types", defaultValue="") String types) {
        return Util.withStatement(this.db, (st, ops) -> {
            List<DegreeStats> stats = this.prepareStats(types, (ReadOperations)ops);
            PrimitiveLongIterator it = ops.nodesGetAll();
            ArrayList<Future> futures = new ArrayList<Future>();
            do {
                long[] batch = Util.takeIds(it, 10000);
                futures.add(Util.inTxFuture(Pools.DEFAULT, this.db, (stmt, ro) -> this.computeDegree((ReadOperations)ro, stats, batch)));
                Util.removeFinished(futures);
            } while (it.hasNext());
            Util.waitForFutures(futures);
            return stats.stream().map(DegreeStats::done);
        });
    }

    public int computeDegree(ReadOperations ops, List<DegreeStats> stats, long[] batch) {
        for (long id : batch) {
            stats.forEach(s -> s.computeDegree(ops, id));
        }
        return batch.length;
    }

    public List<DegreeStats> prepareStats(@Name(value="types", defaultValue="") String types, ReadOperations ops) {
        ArrayList<DegreeStats> stats = new ArrayList<DegreeStats>();
        if ("*".equals(types)) {
            Iterator tokens = ops.relationshipTypesGetAllTokens();
            while (tokens.hasNext()) {
                Token token = (Token)tokens.next();
                long total = ops.countsForRelationship(-1, token.id(), -1);
                stats.add(new DegreeStats(token.name(), token.id(), Direction.OUTGOING, total));
                stats.add(new DegreeStats(token.name(), token.id(), Direction.INCOMING, total));
            }
            return stats;
        }
        List<Pair<RelationshipType, Direction>> pairs = RelationshipTypeAndDirections.parse(types);
        for (Pair<RelationshipType, Direction> pair : pairs) {
            String typeName = pair.first() == null ? null : ((RelationshipType)pair.first()).name();
            int type = typeName == null ? -1 : ops.relationshipTypeGetForName(typeName);
            long total = ops.countsForRelationship(-1, type, -1);
            stats.add(new DegreeStats(typeName, type, (Direction)pair.other(), total));
        }
        return stats;
    }

    public static class DegreeStats {
        public final String typeName;
        public final long total;
        private final int type;
        private final Direction direction;
        private transient AtomicHistogram histogram;

        public void computeDegree(ReadOperations ops, long id) {
            try {
                int degree = this.type == -1 ? ops.nodeGetDegree(id, this.direction) : ops.nodeGetDegree(id, this.direction, this.type);
                this.record(degree);
            }
            catch (EntityNotFoundException entityNotFoundException) {
                // empty catch block
            }
        }

        public DegreeStats(String typeName, int type, Direction direction, long total) {
            this.typeName = typeName == null ? null : typeName;
            this.type = type;
            this.direction = direction;
            this.total = total;
            this.histogram = new AtomicHistogram(total, 3);
        }

        public void record(long value) {
            this.histogram.recordValue(value);
        }

        public Result done() {
            Result result = new Result();
            result.type = this.typeName;
            result.direction = this.direction.name();
            result.total = this.total;
            result.max = this.histogram.getMaxValue();
            result.min = this.histogram.getMinValue();
            result.mean = this.histogram.getMean();
            result.p50 = this.histogram.getValueAtPercentile(50.0);
            result.p75 = this.histogram.getValueAtPercentile(75.0);
            result.p90 = this.histogram.getValueAtPercentile(90.0);
            result.p95 = this.histogram.getValueAtPercentile(95.0);
            result.p99 = this.histogram.getValueAtPercentile(99.0);
            result.p999 = this.histogram.getValueAtPercentile(99.9);
            this.histogram.reset();
            this.histogram = null;
            return result;
        }

        public static class Result {
            public String type;
            public String direction;
            public long total;
            public long p50;
            public long p75;
            public long p90;
            public long p95;
            public long p99;
            public long p999;
            public long max;
            public long min;
            public double mean;
        }
    }
}

