/*
 * Decompiled with CFR 0.152.
 */
package apoc.trigger;

import apoc.ApocConfiguration;
import apoc.Description;
import apoc.coll.SetBackedList;
import apoc.util.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.event.LabelEntry;
import org.neo4j.graphdb.event.PropertyEntry;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.graphdb.event.TransactionEventHandler;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.impl.core.GraphProperties;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.PerformsWrites;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.UserFunction;

public class Trigger {
    @Context
    public GraphDatabaseService db;

    @UserFunction
    @Description(value="function to filter labelEntries by label, to be used within a trigger statement with {assignedLabels}, {removedLabels}, {assigned/removedNodeProperties}")
    public List<Node> nodesByLabel(@Name(value="labelEntries") Object entries, @Name(value="label") String labelString) {
        List list;
        if (!(entries instanceof Map)) {
            return Collections.emptyList();
        }
        Map map = (Map)entries;
        if (map.isEmpty()) {
            return Collections.emptyList();
        }
        Object result = ((Map)entries).get(labelString);
        if (result instanceof List) {
            return (List)result;
        }
        Object anEntry = map.values().iterator().next();
        if (anEntry instanceof List && !(list = (List)anEntry).isEmpty()) {
            if (list.get(0) instanceof Map) {
                HashSet<Node> nodeSet = new HashSet<Node>(100);
                Label label = labelString == null ? null : Label.label((String)labelString);
                for (List entry : map.values()) {
                    for (Map propertyEntry : entry) {
                        Object node = propertyEntry.get("node");
                        if (!(node instanceof Node) || label != null && !((Node)node).hasLabel(label)) continue;
                        nodeSet.add((Node)node);
                    }
                }
                if (!nodeSet.isEmpty()) {
                    return new SetBackedList<Node>(nodeSet);
                }
            } else if (list.get(0) instanceof Node && labelString == null) {
                HashSet nodeSet = new HashSet(map.size() * list.size());
                map.values().forEach(l -> nodeSet.addAll((Collection)l));
                return new SetBackedList<Node>(nodeSet);
            }
        }
        return Collections.emptyList();
    }

    @UserFunction
    @Description(value="function to filter propertyEntries by property-key, to be used within a trigger statement with {assignedNode/RelationshipProperties} and {removedNode/RelationshipProperties}. Returns [{old,new,key,node,relationship}]")
    public List<Map<String, Object>> propertiesByKey(@Name(value="propertyEntries") Map<String, List<Map<String, Object>>> propertyEntries, @Name(value="key") String key) {
        return propertyEntries.getOrDefault(key, Collections.emptyList());
    }

    @Procedure(mode=Mode.WRITE)
    @Description(value="add a trigger statement under a name, in the statement you can use {createdNodes}, {deletedNodes} etc., the selector is {phase:'before/after/rollback'} returns previous and new trigger information")
    public Stream<TriggerInfo> add(@Name(value="name") String name, @Name(value="statement") String statement, @Name(value="selector") Map<String, Object> selector) {
        Map<String, Object> removed = TriggerHandler.add(name, statement, selector);
        if (removed != null) {
            return Stream.of(new TriggerInfo(name, (String)removed.get("statement"), (Map)removed.get("selector"), false, false), new TriggerInfo(name, statement, selector, true, false));
        }
        return Stream.of(new TriggerInfo(name, statement, selector, true, false));
    }

    @Procedure(mode=Mode.WRITE)
    @Description(value="remove previously added trigger, returns trigger information")
    public Stream<TriggerInfo> remove(@Name(value="name") String name) {
        Map<String, Object> removed = TriggerHandler.remove(name);
        if (removed == null) {
            Stream.of(new TriggerInfo(name, null, null, false, false));
        }
        return Stream.of(new TriggerInfo(name, (String)removed.get("statement"), (Map)removed.get("selector"), false, false));
    }

    @PerformsWrites
    @Procedure
    @Description(value="list all installed triggers")
    public Stream<TriggerInfo> list() {
        return TriggerHandler.list().entrySet().stream().map(e -> new TriggerInfo((String)e.getKey(), (String)((Map)e.getValue()).get("statement"), (Map)((Map)e.getValue()).get("selector"), true, (Boolean)((Map)e.getValue()).get("paused")));
    }

    @Procedure(mode=Mode.WRITE)
    @Description(value="CALL apoc.trigger.pause(name) | it pauses the trigger")
    public Stream<TriggerInfo> pause(@Name(value="name") String name) {
        Map<String, Object> paused = TriggerHandler.paused(name);
        return Stream.of(new TriggerInfo(name, (String)paused.get("statement"), (Map)paused.get("selector"), true, true));
    }

    @Procedure(mode=Mode.WRITE)
    @Description(value="CALL apoc.trigger.resume(name) | it resumes the paused trigger")
    public Stream<TriggerInfo> resume(@Name(value="name") String name) {
        Map<String, Object> resume = TriggerHandler.resume(name);
        return Stream.of(new TriggerInfo(name, (String)resume.get("statement"), (Map)resume.get("selector"), true, false));
    }

    private static Map<String, Object> txDataParams(TransactionData txData, String phase) {
        return Util.map("transactionId", phase.equals("after") ? txData.getTransactionId() : -1L, "commitTime", phase.equals("after") ? txData.getCommitTime() : -1L, "createdNodes", txData.createdNodes(), "createdRelationships", txData.createdRelationships(), "deletedNodes", txData.deletedNodes(), "deletedRelationships", txData.deletedRelationships(), "removedLabels", Trigger.aggregateLabels(txData.removedLabels()), "removedNodeProperties", Trigger.aggregatePropertyKeys(txData.removedNodeProperties(), true, true), "removedRelationshipProperties", Trigger.aggregatePropertyKeys(txData.removedRelationshipProperties(), false, true), "assignedLabels", Trigger.aggregateLabels(txData.assignedLabels()), "assignedNodeProperties", Trigger.aggregatePropertyKeys(txData.assignedNodeProperties(), true, false), "assignedRelationshipProperties", Trigger.aggregatePropertyKeys(txData.assignedRelationshipProperties(), false, false));
    }

    private static <T extends PropertyContainer> Map<String, List<Map<String, Object>>> aggregatePropertyKeys(Iterable<PropertyEntry<T>> entries, boolean nodes, boolean removed) {
        if (!entries.iterator().hasNext()) {
            return Collections.emptyMap();
        }
        HashMap<String, List<Map<String, Object>>> result = new HashMap<String, List<Map<String, Object>>>();
        String entityType = nodes ? "node" : "relationship";
        for (PropertyEntry entry : entries) {
            result.compute(entry.key(), (k, v) -> {
                if (v == null) {
                    v = new ArrayList<Map<String, Object>>(100);
                }
                Map<String, Object> map = Util.map("key", k, entityType, entry.entity(), "old", entry.previouslyCommitedValue());
                if (!removed) {
                    map.put("new", entry.value());
                }
                v.add(map);
                return v;
            });
        }
        return result;
    }

    private static Map<String, List<Node>> aggregateLabels(Iterable<LabelEntry> labelEntries) {
        if (!labelEntries.iterator().hasNext()) {
            return Collections.emptyMap();
        }
        HashMap<String, List<Node>> result = new HashMap<String, List<Node>>();
        for (LabelEntry entry : labelEntries) {
            result.compute(entry.label().name(), (k, v) -> {
                if (v == null) {
                    v = new ArrayList<Node>(100);
                }
                v.add(entry.node());
                return v;
            });
        }
        return result;
    }

    public static class LifeCycle {
        private final GraphDatabaseAPI db;
        private final Log log;
        private TriggerHandler triggerHandler;

        public LifeCycle(GraphDatabaseAPI db, Log log) {
            this.db = db;
            this.log = log;
        }

        public void start() {
            boolean enabled = Util.toBoolean(ApocConfiguration.get("trigger.enabled", null));
            if (!enabled) {
                return;
            }
            this.triggerHandler = new TriggerHandler(this.db, this.log);
            this.db.registerTransactionEventHandler((TransactionEventHandler)this.triggerHandler);
        }

        public void stop() {
            if (this.triggerHandler == null) {
                return;
            }
            this.db.unregisterTransactionEventHandler((TransactionEventHandler)this.triggerHandler);
        }
    }

    public static class TriggerHandler
    implements TransactionEventHandler {
        public static final String APOC_TRIGGER = "apoc.trigger";
        static ConcurrentHashMap<String, Map<String, Object>> triggers = new ConcurrentHashMap<String, Object>(Util.map("", Util.map(new Object[0])));
        private static GraphProperties properties;
        private final Log log;

        public TriggerHandler(GraphDatabaseAPI api, Log log) {
            properties = ((NodeManager)api.getDependencyResolver().resolveDependency(NodeManager.class)).newGraphProperties();
            this.log = log;
        }

        public static Map<String, Object> add(String name, String statement, Map<String, Object> selector) {
            return TriggerHandler.updateTriggers(name, Util.map("statement", statement, "selector", selector, "paused", false));
        }

        public static synchronized Map<String, Object> remove(String name) {
            return TriggerHandler.updateTriggers(name, null);
        }

        public static Map<String, Object> paused(String name) {
            Map<String, Object> triggerToPause = triggers.get(name);
            TriggerHandler.updateTriggers(name, Util.map("statement", triggerToPause.get("statement"), "selector", triggerToPause.get("selector"), "paused", true));
            return triggers.get(name);
        }

        public static Map<String, Object> resume(String name) {
            Map<String, Object> triggerToResume = triggers.get(name);
            TriggerHandler.updateTriggers(name, Util.map("statement", triggerToResume.get("statement"), "selector", triggerToResume.get("selector"), "paused", false));
            return triggers.get(name);
        }

        private static synchronized Map<String, Object> updateTriggers(String name, Map<String, Object> value) {
            try (Transaction tx = properties.getGraphDatabase().beginTx();){
                triggers.clear();
                String triggerProperty = (String)properties.getProperty(APOC_TRIGGER, (Object)"{}");
                triggers.putAll(Util.fromJson(triggerProperty, Map.class));
                Map<String, Object> previous = null;
                if (name != null) {
                    Map<String, Object> map = previous = value == null ? triggers.remove(name) : triggers.put(name, value);
                    if (value != null || previous != null) {
                        properties.setProperty(APOC_TRIGGER, (Object)Util.toJson(triggers));
                    }
                }
                tx.success();
                Map<String, Object> map = previous;
                return map;
            }
        }

        public static Map<String, Map<String, Object>> list() {
            TriggerHandler.updateTriggers(null, null);
            return triggers;
        }

        public Object beforeCommit(TransactionData txData) throws Exception {
            this.executeTriggers(txData, "before");
            return null;
        }

        private void executeTriggers(TransactionData txData, String phase) {
            if (triggers.containsKey("")) {
                TriggerHandler.updateTriggers(null, null);
            }
            GraphDatabaseService db = properties.getGraphDatabase();
            LinkedHashMap exceptions = new LinkedHashMap();
            Map params = Trigger.txDataParams(txData, phase);
            triggers.forEach((name, data) -> {
                if (data.get("paused").equals(false)) {
                    try (Transaction tx = db.beginTx();){
                        Map selector = (Map)data.get("selector");
                        if (this.when(selector, phase)) {
                            params.put("trigger", name);
                            Result result = db.execute((String)data.get("statement"), params);
                            Iterators.count((Iterator)result);
                            result.close();
                        }
                        tx.success();
                    }
                    catch (Exception e) {
                        this.log.warn("Error executing trigger " + name + " in phase " + phase, (Throwable)e);
                        exceptions.put(name, e.getMessage());
                    }
                }
            });
            if (!exceptions.isEmpty()) {
                throw new RuntimeException("Error executing triggers " + ((Object)exceptions).toString());
            }
        }

        private boolean when(Map<String, Object> selector, String phase) {
            if (selector == null) {
                return phase.equals("before");
            }
            return selector.getOrDefault("phase", "before").equals(phase);
        }

        public void afterCommit(TransactionData txData, Object state) {
            this.executeTriggers(txData, "after");
        }

        public void afterRollback(TransactionData txData, Object state) {
            this.executeTriggers(txData, "rollback");
        }
    }

    public static class TriggerInfo {
        public String name;
        public String query;
        public Map<String, Object> selector;
        public boolean installed;
        public boolean paused;

        public TriggerInfo(String name, String query, Map<String, Object> selector, boolean installed, boolean paused) {
            this.name = name;
            this.query = query;
            this.selector = selector;
            this.installed = installed;
            this.paused = paused;
        }
    }
}

