/*
 * Decompiled with CFR 0.152.
 */
package apoc.ttl;

import apoc.ApocConfiguration;
import apoc.util.Util;
import java.util.concurrent.TimeUnit;
import org.neo4j.graphdb.QueryStatistics;
import org.neo4j.graphdb.Result;
import org.neo4j.kernel.impl.util.ApocGroup;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;

public class TTLLifeCycle {
    public static final int INITIAL_DELAY = 30;
    public static final int DEFAULT_SCHEDULE = 60;
    private final JobScheduler scheduler;
    private final GraphDatabaseAPI db;
    private JobScheduler.JobHandle ttlIndexJobHandle;
    private JobScheduler.JobHandle ttlJobHandle;
    private Log log;

    public TTLLifeCycle(JobScheduler scheduler, GraphDatabaseAPI db, Log log) {
        this.scheduler = scheduler;
        this.log = log;
        this.db = db;
    }

    public void start() {
        boolean enabled = Util.toBoolean(ApocConfiguration.get("ttl.enabled", null));
        if (!enabled) {
            return;
        }
        long ttlSchedule = Util.toLong(ApocConfiguration.get("ttl.schedule", 60));
        this.ttlIndexJobHandle = this.scheduler.schedule(ApocGroup.TTL_GROUP, this::createTTLIndex, (long)((int)((double)ttlSchedule * 0.8)), TimeUnit.SECONDS);
        long limit = Util.toLong(ApocConfiguration.get("ttl.limit", 1000L));
        this.ttlJobHandle = this.scheduler.scheduleRecurring(ApocGroup.TTL_GROUP, () -> this.expireNodes(limit), ttlSchedule, ttlSchedule, TimeUnit.SECONDS);
    }

    public void expireNodes(long limit) {
        try {
            if (!Util.isWriteableInstance(this.db)) {
                return;
            }
            Result result = this.db.execute("MATCH (t:TTL) where t.ttl < timestamp() WITH t LIMIT {limit} DETACH DELETE t", Util.map("limit", limit));
            QueryStatistics stats = result.getQueryStatistics();
            result.close();
            if (stats.getNodesDeleted() > 0) {
                this.log.info("TTL: Expired %d nodes %d relationships", new Object[]{stats.getNodesDeleted(), stats.getRelationshipsDeleted()});
            }
        }
        catch (Exception e) {
            this.log.error("TTL: Error deleting expired nodes", (Throwable)e);
        }
    }

    public void createTTLIndex() {
        try {
            this.db.execute("CREATE INDEX ON :TTL(ttl)").close();
        }
        catch (Exception e) {
            this.log.error("TTL: Error creating index", (Throwable)e);
        }
    }

    public void stop() {
        if (this.ttlIndexJobHandle != null) {
            this.ttlIndexJobHandle.cancel(true);
        }
        if (this.ttlJobHandle != null) {
            this.ttlJobHandle.cancel(true);
        }
    }
}

