/*
 * Decompiled with CFR 0.152.
 */
package apoc.util;

import apoc.export.util.CountingInputStream;
import apoc.util.FileUtils;
import apoc.util.Util;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.MappingIterator;
import org.codehaus.jackson.map.ObjectMapper;
import org.neo4j.procedure.Name;

public class JsonUtil {
    public static ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    public static Object TOMB = new Object();
    private static final Configuration JSON_PATH_CONFIG = Configuration.builder().options(new Option[]{Option.DEFAULT_PATH_LEAF_TO_NULL, Option.SUPPRESS_EXCEPTIONS}).build();

    public static Stream<Object> loadJson(String url, Map<String, Object> headers, String payload) {
        return JsonUtil.loadJson(url, headers, payload, "", true);
    }

    public static Stream<Object> loadJson(String url, Map<String, Object> headers, String payload, String path, boolean failOnError) {
        try {
            FileUtils.checkReadAllowed(url);
            url = FileUtils.changeFileUrlIfImportDirectoryConstrained(url);
            CountingInputStream input = Util.openInputStream(url, headers, payload);
            JsonParser parser = OBJECT_MAPPER.getJsonFactory().createJsonParser((InputStream)input);
            MappingIterator it = OBJECT_MAPPER.readValues(parser, Object.class);
            Stream<Object> stream = StreamSupport.stream(Spliterators.spliteratorUnknownSize(it, 0), false);
            return path == null || path.isEmpty() ? stream : stream.map(value -> JsonPath.parse((Object)value, (Configuration)JSON_PATH_CONFIG).read(path, new Predicate[0]));
        }
        catch (IOException e) {
            String u = Util.cleanUrl(url);
            if (!failOnError) {
                return Stream.of(new Object[0]);
            }
            throw new RuntimeException("Can't read url " + u + " as json: " + e.getMessage(), e);
        }
    }

    public static Stream<Object> loadJson(@Name(value="url") String url) {
        return JsonUtil.loadJson(url, null, null, "", true);
    }

    public static <T> T parse(String json, String path, Class<T> type) {
        if (json == null || json.isEmpty()) {
            return null;
        }
        try {
            if (path == null || path.isEmpty()) {
                return (T)OBJECT_MAPPER.readValue(json, type);
            }
            return (T)JsonPath.parse((String)json, (Configuration)JSON_PATH_CONFIG).read(path, type, new Predicate[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Can't convert " + json + " to " + type.getSimpleName() + " with path " + path, e);
        }
    }

    static {
        OBJECT_MAPPER.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        OBJECT_MAPPER.configure(JsonParser.Feature.AUTO_CLOSE_SOURCE, false);
        OBJECT_MAPPER.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        OBJECT_MAPPER.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        OBJECT_MAPPER.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        OBJECT_MAPPER.configure(JsonParser.Feature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER, true);
        OBJECT_MAPPER.configure(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS, true);
    }

    static class NonClosingStream
    extends FilterInputStream {
        protected NonClosingStream(InputStream in) {
            super(in);
        }

        @Override
        public void close() throws IOException {
        }
    }
}

