/*
 * Decompiled with CFR 0.152.
 */
package apoc.util;

import apoc.export.util.CountingInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;

public interface StreamConnection {
    public InputStream getInputStream() throws IOException;

    public String getEncoding();

    public long getLength();

    default public CountingInputStream toCountingInputStream() throws IOException {
        return new CountingInputStream(this.getInputStream(), this.getLength());
    }

    public static class UrlStreamConnection
    implements StreamConnection {
        private final URLConnection con;

        public UrlStreamConnection(URLConnection con) {
            this.con = con;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.con.getInputStream();
        }

        @Override
        public String getEncoding() {
            return this.con.getContentEncoding();
        }

        @Override
        public long getLength() {
            return this.con.getContentLength();
        }
    }
}

