/*
 * Decompiled with CFR 0.152.
 */
package apoc.warmup;

import apoc.Pools;
import apoc.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageEngine;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.StoreAccess;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.TerminationGuard;

public class Warmup {
    private static final int BATCH_SIZE = 100000;
    private static final int PAGE_SIZE = 8192;
    @Context
    public GraphDatabaseAPI db;
    @Context
    public TerminationGuard guard;
    @Context
    public Log log;

    @Procedure
    @Description(value="apoc.warmup.run() - quickly loads all nodes and rels into memory by skipping one page at a time")
    public Stream<WarmupResult> run(@Name(value="loadProperties", defaultValue="false") boolean loadProperties, @Name(value="loadDynamicProperties", defaultValue="false") boolean loadDynamicProperties) {
        long nodesTotal = Util.nodeCount((GraphDatabaseService)this.db);
        long relsTotal = Util.relCount((GraphDatabaseService)this.db);
        StoreAccess storeAccess = new StoreAccess(((RecordStorageEngine)this.db.getDependencyResolver().resolveDependency(RecordStorageEngine.class)).testAccessNeoStores());
        NeoStores neoStore = storeAccess.getRawNeoStores();
        LinkedHashMap<StoreType, Records<Object>> records = new LinkedHashMap<StoreType, Records<Object>>();
        records.put(StoreType.NODE, new Records<NodeRecord>((RecordStore<NodeRecord>)neoStore.getNodeStore(), new NodeRecord(-1L), nodesTotal));
        records.put(StoreType.RELATIONSHIP, new Records<RelationshipRecord>((RecordStore<RelationshipRecord>)neoStore.getRelationshipStore(), new RelationshipRecord(-1L), relsTotal));
        records.put(StoreType.RELATIONSHIP_GROUP, new Records<RelationshipGroupRecord>(neoStore.getRelationshipGroupStore(), new RelationshipGroupRecord(-1L)));
        if (loadProperties) {
            records.put(StoreType.PROPERTY, new Records<PropertyRecord>((RecordStore<PropertyRecord>)neoStore.getPropertyStore(), new PropertyRecord(-1L)));
        }
        if (loadDynamicProperties) {
            records.put(StoreType.PROPERTY_STRING, new Records<DynamicRecord>(neoStore.getRecordStore(StoreType.PROPERTY_STRING), new DynamicRecord(-1L)));
            records.put(StoreType.PROPERTY_ARRAY, new Records<DynamicRecord>(neoStore.getRecordStore(StoreType.PROPERTY_ARRAY), new DynamicRecord(-1L)));
        }
        records.values().parallelStream().forEach(r -> r.load(this.db, this.guard));
        WarmupResult result = new WarmupResult(8192L, (Records)records.get(StoreType.NODE), (Records)records.get(StoreType.RELATIONSHIP), (Records)records.get(StoreType.RELATIONSHIP_GROUP), loadProperties, (Records)records.get(StoreType.PROPERTY), records.values().stream().mapToLong(r -> r.time).sum(), Util.transactionIsTerminated(this.guard), loadDynamicProperties, (Records)records.get(StoreType.PROPERTY_STRING), (Records)records.get(StoreType.PROPERTY_ARRAY));
        return Stream.of(result);
    }

    public static <R extends AbstractBaseRecord> long loadRecords(int recordsPerPage, long highestRecordId, RecordStore<R> recordStore, R record, GraphDatabaseAPI db, TerminationGuard guard) {
        long[] ids = new long[100000];
        long pages = 0L;
        int idx = 0;
        ArrayList<Future<Long>> futures = new ArrayList<Future<Long>>(100);
        for (long id = 0L; id <= highestRecordId; id += (long)recordsPerPage) {
            ids[idx++] = id;
            if (idx == 100000) {
                long[] submitted = (long[])ids.clone();
                idx = 0;
                futures.add(Util.inTxFuture(Pools.DEFAULT, (GraphDatabaseService)db, () -> Warmup.loadRecords(submitted, record, recordStore, guard)));
            }
            pages += Warmup.removeDone(futures, false);
        }
        if (idx > 0) {
            long[] submitted = Arrays.copyOf(ids, idx);
            futures.add(Util.inTxFuture(Pools.DEFAULT, (GraphDatabaseService)db, () -> Warmup.loadRecords(submitted, record, recordStore, guard)));
        }
        return pages += Warmup.removeDone(futures, true);
    }

    public static <R extends AbstractBaseRecord> long loadRecords(long[] submitted, R record, RecordStore<R> recordStore, TerminationGuard guard) {
        if (Util.transactionIsTerminated(guard)) {
            return 0L;
        }
        for (long recordId : submitted) {
            record.setId(recordId);
            record.clear();
            try {
                recordStore.getRecord(recordId, record, RecordLoad.NORMAL);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return submitted.length;
    }

    public static long removeDone(List<Future<Long>> futures, boolean wait) {
        long pages = 0L;
        if (wait || futures.size() > 25) {
            Iterator<Future<Long>> it = futures.iterator();
            while (it.hasNext()) {
                Future<Long> future = it.next();
                if (!wait && !future.isDone()) continue;
                try {
                    pages += future.get().longValue();
                }
                catch (InterruptedException | ExecutionException exception) {
                    // empty catch block
                }
                it.remove();
            }
        }
        return pages;
    }

    public static class WarmupResult {
        public final long pageSize;
        public final long totalTime;
        public final boolean transactionWasTerminated;
        public final long nodesPerPage;
        public final long nodesTotal;
        public final long nodePages;
        public final long nodesTime;
        public final long relsPerPage;
        public final long relsTotal;
        public final long relPages;
        public final long relsTime;
        public final long relGroupsPerPage;
        public final long relGroupsTotal;
        public final long relGroupPages;
        public final long relGroupsTime;
        public final boolean propertiesLoaded;
        public final boolean dynamicPropertiesLoaded;
        public long propsPerPage;
        public long propRecordsTotal;
        public long propPages;
        public long propsTime;
        public long stringPropsPerPage;
        public long stringPropRecordsTotal;
        public long stringPropPages;
        public long stringPropsTime;
        public long arrayPropsPerPage;
        public long arrayPropRecordsTotal;
        public long arrayPropPages;
        public long arrayPropsTime;

        public WarmupResult(long pageSize, Records nodes, Records rels, Records relGroups, boolean propertiesLoaded, Records props, long totalTime, boolean transactionWasTerminated, boolean dynamicPropertiesLoaded, Records stringProps, Records arrayProps) {
            this.pageSize = pageSize;
            this.transactionWasTerminated = transactionWasTerminated;
            this.totalTime = totalTime;
            this.propertiesLoaded = propertiesLoaded;
            this.dynamicPropertiesLoaded = dynamicPropertiesLoaded;
            this.nodesPerPage = nodes.recordsPerPage;
            this.nodesTotal = nodes.count;
            this.nodePages = nodes.pages;
            this.nodesTime = nodes.time;
            this.relsPerPage = rels.recordsPerPage;
            this.relsTotal = rels.count;
            this.relPages = rels.pages;
            this.relsTime = rels.time;
            this.relGroupsPerPage = relGroups.recordsPerPage;
            this.relGroupsTotal = relGroups.count;
            this.relGroupPages = relGroups.pages;
            this.relGroupsTime = relGroups.time;
            if (props != null) {
                this.propsPerPage = props.recordsPerPage;
                this.propRecordsTotal = props.count;
                this.propPages = props.pages;
                this.propsTime = props.time;
            }
            if (stringProps != null) {
                this.stringPropsPerPage = stringProps.recordsPerPage;
                this.stringPropRecordsTotal = stringProps.count;
                this.stringPropPages = stringProps.pages;
                this.stringPropsTime = stringProps.time;
            }
            if (arrayProps != null) {
                this.arrayPropsPerPage = arrayProps.recordsPerPage;
                this.arrayPropRecordsTotal = arrayProps.count;
                this.arrayPropPages = arrayProps.pages;
                this.arrayPropsTime = arrayProps.time;
            }
        }
    }

    static class Records<T extends AbstractBaseRecord> {
        long highId;
        long pageSize = 8192L;
        int recordsPerPage;
        RecordStore<T> store;
        T initalRecord;
        long pages;
        long count;
        long time;

        public Records(RecordStore<T> store, T initalRecord) {
            this(store, initalRecord, store.getHighestPossibleIdInUse() + 1L);
        }

        public Records(RecordStore<T> store, T initalRecord, long count) {
            this.store = store;
            this.initalRecord = initalRecord;
            this.highId = store.getHighestPossibleIdInUse();
            this.recordsPerPage = store.getRecordsPerPage();
            this.count = count;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void load(GraphDatabaseAPI db, TerminationGuard guard) {
            long start = System.nanoTime();
            try {
                this.pages = Warmup.loadRecords(this.recordsPerPage, this.highId, this.store, this.initalRecord, db, guard);
            }
            finally {
                this.time = TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - start);
            }
        }
    }
}

