/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.annotation.handler;

import java.lang.reflect.Field;
import org.ocpsoft.common.services.ServiceLoader;
import org.ocpsoft.common.util.Assert;
import org.ocpsoft.logging.Logger;
import org.ocpsoft.rewrite.annotation.Convert;
import org.ocpsoft.rewrite.annotation.api.FieldContext;
import org.ocpsoft.rewrite.annotation.api.HandlerChain;
import org.ocpsoft.rewrite.annotation.spi.FieldAnnotationHandler;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.exception.RewriteException;
import org.ocpsoft.rewrite.param.Converter;
import org.ocpsoft.rewrite.param.Parameter;
import org.ocpsoft.rewrite.param.ParameterConfiguration;
import org.ocpsoft.rewrite.spi.ConverterProvider;

public class ConvertHandler
extends FieldAnnotationHandler<Convert> {
    private final Logger log = Logger.getLogger(ConvertHandler.class);

    @Override
    public Class<Convert> handles() {
        return Convert.class;
    }

    @Override
    public int priority() {
        return 200;
    }

    @Override
    public void process(FieldContext context, Convert annotation, HandlerChain chain) {
        Field field = context.getJavaField();
        Parameter parameter = (Parameter)context.get(Parameter.class);
        if (parameter != null) {
            LazyConverterAdapter converter = null;
            converter = annotation.with() != Object.class ? LazyConverterAdapter.forConverterType(annotation.with()) : (annotation.id().length() > 0 ? LazyConverterAdapter.forConverterId(annotation.id()) : LazyConverterAdapter.forTargetType(field.getType()));
            if (!(parameter instanceof ParameterConfiguration)) {
                throw new RewriteException("Cannot add @" + Convert.class.getSimpleName() + " to [" + field + "] of class [" + field.getDeclaringClass() + "] because the parameter [" + parameter.getName() + "] is not writable.");
            }
            ((ParameterConfiguration)((Object)parameter)).convertedBy(converter);
            if (this.log.isTraceEnabled()) {
                this.log.trace("Attached converter to field [{}] of class [{}]: ", new Object[]{field.getName(), field.getDeclaringClass().getName(), converter});
            }
        }
        chain.proceed();
    }

    private static class LazyConverterAdapter
    implements Converter<Object> {
        private final Class<?> targetType;
        private final String converterId;
        private final Class<?> converterType;

        private LazyConverterAdapter(Class<?> targetType, String converterId, Class<?> converterType) {
            this.targetType = targetType;
            this.converterId = converterId;
            this.converterType = converterType;
        }

        public static LazyConverterAdapter forConverterType(Class<?> converterType) {
            return new LazyConverterAdapter(null, null, converterType);
        }

        public static LazyConverterAdapter forConverterId(String id) {
            return new LazyConverterAdapter(null, id, null);
        }

        public static LazyConverterAdapter forTargetType(Class<?> targetType) {
            return new LazyConverterAdapter(targetType, null, null);
        }

        @Override
        public Object convert(Rewrite event, EvaluationContext context, Object value) {
            Converter<?> converter = null;
            for (ConverterProvider provider : ServiceLoader.load(ConverterProvider.class)) {
                converter = this.targetType != null ? provider.getByTargetType(this.targetType) : (this.converterType != null ? provider.getByConverterType(this.converterType) : provider.getByConverterId(this.converterId));
                if (converter == null) continue;
                break;
            }
            Assert.notNull(converter, "Got no converter from any ConverterProvider for: " + this.toString());
            return converter.convert(event, context, value);
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append(this.getClass().getSimpleName());
            b.append(" for ");
            if (this.targetType != null) {
                b.append(" target type ");
                b.append(this.targetType.getName());
            } else if (this.converterType != null) {
                b.append(" converter type ");
                b.append(this.converterType.getName());
            } else {
                b.append(" id ");
                b.append(this.converterId);
            }
            return b.toString();
        }
    }
}

