/*
 * Decompiled with CFR 0.152.
 */
package org.openhealthtools.mdht.uml.cda.hitsp.tests;

import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.emf.common.util.Diagnostic;
import org.openhealthtools.mdht.uml.cda.Act;
import org.openhealthtools.mdht.uml.cda.AssignedAuthor;
import org.openhealthtools.mdht.uml.cda.AssignedCustodian;
import org.openhealthtools.mdht.uml.cda.Author;
import org.openhealthtools.mdht.uml.cda.CDAFactory;
import org.openhealthtools.mdht.uml.cda.ClinicalDocument;
import org.openhealthtools.mdht.uml.cda.Custodian;
import org.openhealthtools.mdht.uml.cda.CustodianOrganization;
import org.openhealthtools.mdht.uml.cda.Observation;
import org.openhealthtools.mdht.uml.cda.Organization;
import org.openhealthtools.mdht.uml.cda.Person;
import org.openhealthtools.mdht.uml.cda.Procedure;
import org.openhealthtools.mdht.uml.cda.Section;
import org.openhealthtools.mdht.uml.cda.SubstanceAdministration;
import org.openhealthtools.mdht.uml.cda.ccd.CCDFactory;
import org.openhealthtools.mdht.uml.cda.ccd.ProblemHealthStatusObservation;
import org.openhealthtools.mdht.uml.cda.hitsp.Condition;
import org.openhealthtools.mdht.uml.cda.hitsp.ConditionEntry;
import org.openhealthtools.mdht.uml.cda.hitsp.DiagnosticResultsSection;
import org.openhealthtools.mdht.uml.cda.hitsp.HITSPFactory;
import org.openhealthtools.mdht.uml.cda.hitsp.PastProcedure;
import org.openhealthtools.mdht.uml.cda.hitsp.PatientSummary;
import org.openhealthtools.mdht.uml.cda.hitsp.ProblemListSection;
import org.openhealthtools.mdht.uml.cda.hitsp.Result;
import org.openhealthtools.mdht.uml.cda.ihe.ActiveProblemsSection;
import org.openhealthtools.mdht.uml.cda.ihe.IHEFactory;
import org.openhealthtools.mdht.uml.cda.ihe.MedicationsSection;
import org.openhealthtools.mdht.uml.cda.ihe.NormalDose;
import org.openhealthtools.mdht.uml.cda.util.BasicValidationHandler;
import org.openhealthtools.mdht.uml.cda.util.CDAUtil;
import org.openhealthtools.mdht.uml.hl7.datatypes.CE;
import org.openhealthtools.mdht.uml.hl7.datatypes.CS;
import org.openhealthtools.mdht.uml.hl7.datatypes.DatatypesFactory;
import org.openhealthtools.mdht.uml.hl7.datatypes.II;
import org.openhealthtools.mdht.uml.hl7.datatypes.IVL_TS;
import org.openhealthtools.mdht.uml.hl7.datatypes.IVXB_TS;
import org.openhealthtools.mdht.uml.hl7.datatypes.ON;
import org.openhealthtools.mdht.uml.hl7.datatypes.PN;
import org.openhealthtools.mdht.uml.hl7.datatypes.ST;
import org.openhealthtools.mdht.uml.hl7.datatypes.TS;
import org.openhealthtools.mdht.uml.hl7.vocab.NullFlavor;

public class TestPatientSummary {
    public static final IVXB_TS TS_UNK = DatatypesFactory.eINSTANCE.createIVXB_TS();

    public TestPatientSummary() {
        TS_UNK.setNullFlavor(NullFlavor.UNK);
    }

    public static void main(String[] args) throws Exception {
        PatientSummary patientSummary = TestPatientSummary.createPatientSummary();
        ProblemListSection problemList = patientSummary.createProblemListSection();
        TestPatientSummary.fillProblemList(problemList);
        patientSummary.addSection(TestPatientSummary.createAllergiesSection());
        patientSummary.addSection((Section)TestPatientSummary.createMedicationsSection());
        patientSummary.addSection(TestPatientSummary.createDiagnosticResultsSection());
        System.out.println("***** Generate Patient Summary *****");
        TestPatientSummary.save((ClinicalDocument)patientSummary);
        System.out.println("\n\n***** Validate generated Patient Summary *****");
        TestPatientSummary.validate((ClinicalDocument)patientSummary);
        System.out.println("\n***** Validate minimal NIST sample *****");
        ClinicalDocument minimalSample = CDAUtil.load((InputStream)new FileInputStream("samples/CCD_HITSP_C32v2.5_Minimal_WithEntries_Valid.xml"));
        TestPatientSummary.validate(minimalSample);
        System.out.println("\n***** Validate complete NIST sample *****");
        ClinicalDocument completeSample = CDAUtil.load((InputStream)new FileInputStream("samples/HITSP_C32v2.5_Rev6_16Sections_Entries_MinimalErrors.xml"));
        TestPatientSummary.validate(completeSample);
        if (completeSample instanceof PatientSummary) {
            PatientSummary summary = (PatientSummary)completeSample;
            System.out.println(summary.getSurgeriesSection().getProcedures());
        }
    }

    private static Section createDiagnosticResultsSection() {
        DiagnosticResultsSection section = HITSPFactory.eINSTANCE.createDiagnosticResultsSection().init();
        Result result = HITSPFactory.eINSTANCE.createResult().init();
        section.addObservation((Observation)result);
        PastProcedure procedure = HITSPFactory.eINSTANCE.createPastProcedure().init();
        section.addProcedure((Procedure)procedure);
        return section;
    }

    public static PatientSummary createPatientSummary() {
        PatientSummary doc = HITSPFactory.eINSTANCE.createPatientSummary().init();
        II id = DatatypesFactory.eINSTANCE.createII("2.16.840.1.113883.3.72", "CCD_HITSP_C32v2.4_16SectionsWithEntries_Rev6_Notes");
        id.setAssigningAuthorityName("NIST Healthcare Project");
        doc.setId(id);
        CE code = DatatypesFactory.eINSTANCE.createCE("34133-9", "2.16.840.1.113883.6.1", "LOINC", "Summarization of episode note (CCD/CONF-1)");
        doc.setCode(code);
        TS ts = DatatypesFactory.eINSTANCE.createTS("20071204103022-0500");
        doc.setEffectiveTime(ts);
        CS langCode = DatatypesFactory.eINSTANCE.createCS();
        langCode.setCode("en-US");
        doc.setLanguageCode(langCode);
        ST title = DatatypesFactory.eINSTANCE.createST("Test Instance of CCD Guide and HITSP C32,C83 and C80 Profiles");
        doc.setTitle(title);
        CE confCode = DatatypesFactory.eINSTANCE.createCE("N", "2.16.840.1.113883.5.25");
        doc.setConfidentialityCode(confCode);
        Author author = CDAFactory.eINSTANCE.createAuthor();
        doc.getAuthors().add((Object)author);
        author.setTime(DatatypesFactory.eINSTANCE.createTS("20070916130000"));
        AssignedAuthor assignedAuthor = CDAFactory.eINSTANCE.createAssignedAuthor();
        author.setAssignedAuthor(assignedAuthor);
        assignedAuthor.getIds().add((Object)DatatypesFactory.eINSTANCE.createII("2.16.840.1.113883.3.72.5.2", "LJG"));
        Person person = CDAFactory.eINSTANCE.createPerson();
        assignedAuthor.setAssignedPerson(person);
        PN pn = DatatypesFactory.eINSTANCE.createPN();
        pn.addGiven("Len").addFamily("Gallagher");
        person.getNames().add((Object)pn);
        Organization organization = CDAFactory.eINSTANCE.createOrganization();
        assignedAuthor.setRepresentedOrganization(organization);
        II orgId = DatatypesFactory.eINSTANCE.createII("2.16.840.1.113883.3.72");
        orgId.setAssigningAuthorityName("NIST Healthcare (NIST-H)");
        organization.getIds().add((Object)orgId);
        ON on = DatatypesFactory.eINSTANCE.createON();
        on.addText("NIST HL7 Test Laboratory");
        organization.getNames().add((Object)on);
        organization.getTelecoms().add((Object)DatatypesFactory.eINSTANCE.createTEL("+1-301-975-3251"));
        Custodian custodian = CDAFactory.eINSTANCE.createCustodian();
        doc.setCustodian(custodian);
        AssignedCustodian assignedCustodian = CDAFactory.eINSTANCE.createAssignedCustodian();
        custodian.setAssignedCustodian(assignedCustodian);
        CustodianOrganization custodianOrganization = CDAFactory.eINSTANCE.createCustodianOrganization();
        assignedCustodian.setRepresentedCustodianOrganization(custodianOrganization);
        II custodianId = DatatypesFactory.eINSTANCE.createII("2.16.840.1.113883.3.72.5");
        custodianId.setAssigningAuthorityName("NIST Healthcare (NIST-H)");
        custodianOrganization.getIds().add((Object)custodianId);
        ON custodianName = DatatypesFactory.eINSTANCE.createON();
        custodianName.addText("NIST HL7 Test Laboratory");
        custodianOrganization.setName(custodianName);
        custodianOrganization.setTelecom(DatatypesFactory.eINSTANCE.createTEL("+1-301-975-3251"));
        custodianOrganization.setAddr(DatatypesFactory.eINSTANCE.createAD());
        return doc;
    }

    public static void fillProblemList(ActiveProblemsSection problemList) {
        Condition condition = HITSPFactory.eINSTANCE.createCondition().init();
        problemList.addAct((Act)condition);
        condition.getIds().add((Object)DatatypesFactory.eINSTANCE.createII("ec8a6ff8-ed4b-4f7e-82c3-e98e58b45de7"));
        IVL_TS effectiveTime = DatatypesFactory.eINSTANCE.createIVL_TS();
        effectiveTime.setLow(TS_UNK);
        condition.setEffectiveTime(effectiveTime);
        ConditionEntry problemEntry = condition.createConditionEntry();
        problemEntry.getIds().add((Object)DatatypesFactory.eINSTANCE.createII("ab1791b0-5c71-11db-b0de-0800200c9a66"));
        problemEntry.setCode(DatatypesFactory.eINSTANCE.createCD("64572001", "2.16.840.1.113883.6.96", "SNOMED-CT", "Condition"));
        problemEntry.getValues().add((Object)DatatypesFactory.eINSTANCE.createCD("233604007", "2.16.840.1.113883.6.96", "SNOMED-CT", "Pneumonia"));
        effectiveTime = DatatypesFactory.eINSTANCE.createIVL_TS("199701", null);
        effectiveTime.setHigh(TS_UNK);
        problemEntry.setEffectiveTime(effectiveTime);
        ProblemHealthStatusObservation healthStatus = CCDFactory.eINSTANCE.createProblemHealthStatusObservation().init();
        problemEntry.addObservation((Observation)healthStatus);
        CE healthStatusValue = DatatypesFactory.eINSTANCE.createCE("xyz", "2.16.840.1.113883.1.11.20.12", "ProblemHealthStatusCode", null);
        healthStatusValue.setCodeSystemVersion("20061017");
        healthStatus.getValues().add((Object)healthStatusValue);
    }

    public static Section createAllergiesSection() {
        Section section = CDAFactory.eINSTANCE.createSection();
        return section;
    }

    public static MedicationsSection createMedicationsSection() {
        MedicationsSection section = IHEFactory.eINSTANCE.createMedicationsSection().init();
        section.setTitle(DatatypesFactory.eINSTANCE.createST("Medications"));
        NormalDose meds = IHEFactory.eINSTANCE.createNormalDose().init();
        section.addSubstanceAdministration((SubstanceAdministration)meds);
        II id = DatatypesFactory.eINSTANCE.createII("cdbd33f0-6cde-11db-9fe1-0800200c9a66");
        meds.getIds().add((Object)id);
        return section;
    }

    public static void save(ClinicalDocument clinicalDocument) throws Exception {
        CDAUtil.save((ClinicalDocument)clinicalDocument, (OutputStream)System.out);
    }

    public static void validate(ClinicalDocument clinicalDocument) throws Exception {
        boolean valid = CDAUtil.validate((ClinicalDocument)clinicalDocument, (CDAUtil.ValidationHandler)new BasicValidationHandler(){

            public void handleError(Diagnostic diagnostic) {
                System.out.println("ERROR: " + diagnostic.getMessage());
            }
        });
        if (valid) {
            System.out.println("Document is valid");
        } else {
            System.out.println("Document is invalid");
        }
    }
}

