/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.html;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.mortbay.log.LogFactory;
import org.mortbay.util.LogSupport;

public abstract class Element {
    private static Log log = LogFactory.getLog(class$org$mortbay$html$Element == null ? (class$org$mortbay$html$Element = Element.class$("org.mortbay.html.Element")) : class$org$mortbay$html$Element);
    public static final String noAttributes = "";
    public static final String ALIGN = "align";
    public static final String LEFT = "left";
    public static final String RIGHT = "right";
    public static final String CENTER = "center";
    public static final String VALIGN = "valign";
    public static final String TOP = "top";
    public static final String BOTTOM = "bottom";
    public static final String MIDDLE = "middle";
    public static final String WIDTH = "width";
    public static final String HEIGHT = "height";
    public static final String SIZE = "size";
    public static final String COLOR = "color";
    public static final String BGCOLOR = "bgcolor";
    public static final String STYLE = "style";
    public static final String CLASS = "class";
    public static final String ID = "id";
    private int width = -1;
    private int height = -1;
    private int size = -1;
    private String attributes = null;
    protected Hashtable attributeMap = null;
    static /* synthetic */ Class class$org$mortbay$html$Element;

    public Element() {
    }

    public Element(String attributes) {
        this.attribute(attributes);
    }

    public abstract void write(Writer var1) throws IOException;

    public void write(OutputStream out) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(out);
        this.write(writer);
        ((Writer)writer).flush();
    }

    public void write(OutputStream out, String encoding) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(out, encoding);
        this.write(writer);
        ((Writer)writer).flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String attributes() {
        StringBuffer buf;
        if (this.attributes == null && this.attributeMap == null) {
            return noAttributes;
        }
        StringBuffer stringBuffer = buf = new StringBuffer(128);
        synchronized (stringBuffer) {
            if (this.attributeMap != null) {
                Enumeration e = this.attributeMap.keys();
                while (e.hasMoreElements()) {
                    buf.append(' ');
                    String a = (String)e.nextElement();
                    buf.append(a);
                    buf.append('=');
                    buf.append(this.attributeMap.get(a).toString());
                }
            }
            if (this.attributes != null && this.attributes.length() > 0) {
                if (!this.attributes.startsWith(" ")) {
                    buf.append(' ');
                }
                buf.append(this.attributes);
            }
        }
        return buf.toString();
    }

    public Element attributes(String attributes) {
        if (log.isDebugEnabled() && attributes != null && attributes.indexOf(61) >= 0) {
            log.debug("Set attribute with old method: " + attributes + " on " + this.getClass().getName());
        }
        if (attributes == null) {
            this.attributes = null;
            return this;
        }
        if (attributes == noAttributes) {
            return this;
        }
        this.attributes = this.attributes == null ? attributes : this.attributes + ' ' + attributes;
        return this;
    }

    public Element setAttributesFrom(Element e) {
        this.attributes = e.attributes;
        this.attributeMap = (Hashtable)e.attributeMap.clone();
        return this;
    }

    public Element attribute(String attributes) {
        if (log.isDebugEnabled() && attributes != null && attributes.indexOf(61) >= 0) {
            log.warn("Set attribute with old method: " + attributes + " on " + this.getClass().getName());
        }
        this.attributes = attributes == null || this.attributes == null || this.attributes == noAttributes || this.attributes.length() == 0 ? attributes : this.attributes + ' ' + attributes;
        return this;
    }

    public Element attribute(String attribute, Object value) {
        if (this.attributeMap == null) {
            this.attributeMap = new Hashtable(10);
        }
        if (value != null) {
            if (value instanceof String && ((String)value).indexOf(34) != -1) {
                String s = (String)value;
                int q = 0;
                while ((q = s.indexOf(34, q)) >= 0) {
                    s = s.substring(0, q) + "&quot;" + s.substring(++q);
                    q += 6;
                }
                value = s;
            }
            this.attributeMap.put(attribute, "\"" + value + '\"');
        }
        return this;
    }

    public Element attribute(String attribute, long value) {
        if (this.attributeMap == null) {
            this.attributeMap = new Hashtable(10);
        }
        this.attributeMap.put(attribute, Long.toString(value));
        return this;
    }

    public String toString() {
        try {
            StringWriter out = new StringWriter();
            this.write(out);
            out.flush();
            return out.toString();
        }
        catch (IOException e) {
            LogSupport.ignore(log, e);
            return null;
        }
    }

    public Element left() {
        return this.attribute(ALIGN, LEFT);
    }

    public Element right() {
        return this.attribute(ALIGN, RIGHT);
    }

    public Element center() {
        return this.attribute(ALIGN, CENTER);
    }

    public Element top() {
        return this.attribute(VALIGN, TOP);
    }

    public Element bottom() {
        return this.attribute(VALIGN, BOTTOM);
    }

    public Element middle() {
        return this.attribute(VALIGN, MIDDLE);
    }

    public Element width(int w) {
        this.width = w;
        return this.attribute(WIDTH, w);
    }

    public Element width(String w) {
        this.width = -1;
        return this.attribute(WIDTH, w);
    }

    public int width() {
        return this.width;
    }

    public Element height(int h) {
        this.height = h;
        return this.attribute(HEIGHT, h);
    }

    public Element height(String h) {
        this.height = -1;
        return this.attribute(HEIGHT, h);
    }

    public int height() {
        return this.height;
    }

    public Element size(int s) {
        this.size = s;
        return this.attribute(SIZE, s);
    }

    public Element size(String s) {
        this.size = -1;
        return this.attribute(SIZE, s);
    }

    public int size() {
        return this.size;
    }

    public Element color(String color) {
        return this.attribute(COLOR, color);
    }

    public Element bgColor(String color) {
        return this.attribute(BGCOLOR, color);
    }

    public Element cssClass(String c) {
        return this.attribute(CLASS, c);
    }

    public Element cssID(String id) {
        return this.attribute(ID, id);
    }

    public Element style(String style) {
        return this.attribute(STYLE, style);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

