/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.inferencer.fc.config;

import java.util.Iterator;
import org.openrdf.OpenRDFException;
import org.openrdf.model.BNode;
import org.openrdf.model.Graph;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.model.util.GraphUtil;
import org.openrdf.model.util.GraphUtilException;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.SP;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.parser.QueryParserUtil;
import org.openrdf.sail.config.DelegatingSailImplConfigBase;
import org.openrdf.sail.config.SailConfigException;
import org.openrdf.sail.config.SailImplConfig;
import org.openrdf.sail.inferencer.fc.config.CustomGraphQueryInferencerSchema;

public final class CustomGraphQueryInferencerConfig
extends DelegatingSailImplConfigBase {
    private QueryLanguage language;
    private String ruleQuery;
    private String matcherQuery;

    public CustomGraphQueryInferencerConfig() {
        super("openrdf:CustomGraphQueryInferencer");
    }

    public CustomGraphQueryInferencerConfig(SailImplConfig delegate) {
        super("openrdf:CustomGraphQueryInferencer", delegate);
    }

    public void setQueryLanguage(QueryLanguage language) {
        this.language = language;
    }

    public QueryLanguage getQueryLanguage() {
        return this.language;
    }

    public void setRuleQuery(String ruleQuery) {
        this.ruleQuery = ruleQuery;
    }

    public String getRuleQuery() {
        return this.ruleQuery;
    }

    public void setMatcherQuery(String matcherQuery) {
        this.matcherQuery = matcherQuery;
    }

    public String getMatcherQuery() {
        return this.matcherQuery;
    }

    public void parse(Graph graph, Resource implNode) throws SailConfigException {
        super.parse(graph, implNode);
        try {
            Literal language = GraphUtil.getOptionalObjectLiteral((Graph)graph, (Resource)implNode, (URI)CustomGraphQueryInferencerSchema.QUERY_LANGUAGE);
            if (null == language) {
                this.setQueryLanguage(QueryLanguage.SPARQL);
            } else {
                this.setQueryLanguage(QueryLanguage.valueOf((String)language.stringValue()));
                if (null == this.getQueryLanguage()) {
                    throw new SailConfigException("Valid value required for " + CustomGraphQueryInferencerSchema.QUERY_LANGUAGE + " property, found " + language);
                }
            }
            Iterator iter = GraphUtil.getObjectIterator((Graph)graph, (Resource)implNode, (URI)CustomGraphQueryInferencerSchema.RULE_QUERY, (Resource[])new Resource[0]);
            if (iter.hasNext()) {
                this.setRuleQuery(GraphUtil.getUniqueObjectLiteral((Graph)graph, (Resource)((Resource)iter.next()), (URI)SP.TEXT_PROPERTY).stringValue());
            }
            if ((iter = GraphUtil.getObjectIterator((Graph)graph, (Resource)implNode, (URI)CustomGraphQueryInferencerSchema.MATCHER_QUERY, (Resource[])new Resource[0])).hasNext()) {
                this.setMatcherQuery(GraphUtil.getUniqueObjectLiteral((Graph)graph, (Resource)((Resource)iter.next()), (URI)SP.TEXT_PROPERTY).stringValue());
            }
        }
        catch (GraphUtilException e) {
            throw new SailConfigException(e.getMessage(), (Throwable)e);
        }
    }

    public void validate() throws SailConfigException {
        super.validate();
        if (null == this.language) {
            throw new SailConfigException("No query language specified for " + this.getType() + " Sail.");
        }
        if (null == this.ruleQuery) {
            throw new SailConfigException("No rule query specified for " + this.getType() + " Sail.");
        }
        try {
            QueryParserUtil.parseGraphQuery((QueryLanguage)this.language, (String)this.ruleQuery, null);
        }
        catch (OpenRDFException e) {
            throw new SailConfigException("Problem occured parsing supplied rule query.", (Throwable)e);
        }
        if (null == this.matcherQuery) {
            throw new SailConfigException("No matcher query specified for " + this.getType() + " Sail.");
        }
        try {
            QueryParserUtil.parseGraphQuery((QueryLanguage)this.language, (String)this.matcherQuery, null);
        }
        catch (OpenRDFException e) {
            throw new SailConfigException("Problem occured parsing supplied matcher query.", (Throwable)e);
        }
    }

    public Resource export(Graph graph) {
        Resource implNode = super.export(graph);
        if (null != this.language) {
            graph.add(implNode, CustomGraphQueryInferencerSchema.QUERY_LANGUAGE, (Value)ValueFactoryImpl.getInstance().createLiteral(this.language.getName()), new Resource[0]);
        }
        this.addQueryNode(graph, implNode, CustomGraphQueryInferencerSchema.RULE_QUERY, this.ruleQuery);
        this.addQueryNode(graph, implNode, CustomGraphQueryInferencerSchema.MATCHER_QUERY, this.matcherQuery);
        return implNode;
    }

    private void addQueryNode(Graph graph, Resource implNode, URI predicate, String queryText) {
        if (null != queryText) {
            ValueFactoryImpl factory = ValueFactoryImpl.getInstance();
            BNode queryNode = factory.createBNode();
            graph.add(implNode, predicate, (Value)queryNode, new Resource[0]);
            graph.add((Resource)queryNode, RDF.TYPE, (Value)SP.CONSTRUCT_CLASS, new Resource[0]);
            graph.add((Resource)queryNode, SP.TEXT_PROPERTY, (Value)factory.createLiteral(queryText), new Resource[0]);
        }
    }
}

