/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.github;

import java.time.Duration;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FindSourceFiles;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.marker.Markers;
import org.openrewrite.yaml.JsonPathMatcher;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;

public class RemoveUnusedWorkflowDispatchInputs
extends Recipe {
    private static final Pattern INPUT_USAGE_PATTERN = Pattern.compile("(?:github *[.] *event *[.] *inputs *[.] *([A-Za-z_][A-Za-z0-9_-]*)|inputs *[.] *([A-Za-z_][A-Za-z0-9_-]*))");
    private static final JsonPathMatcher WORKFLOW_DISPATCH_INPUTS_MATCHER = new JsonPathMatcher("$.on.workflow_dispatch.inputs");

    public String getDisplayName() {
        return "Remove unused workflow dispatch inputs";
    }

    public String getDescription() {
        return "Remove workflow_dispatch inputs that are not referenced anywhere in the workflow file.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((Recipe)new FindSourceFiles(".github/workflows/*.yml"), (TreeVisitor)new YamlIsoVisitor<ExecutionContext>(){

            public Yaml.Document visitDocument(Yaml.Document document, ExecutionContext ctx) {
                final HashSet definedInputs = new HashSet();
                final HashSet usedInputs = new HashSet();
                new YamlIsoVisitor<ExecutionContext>(){

                    public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
                        Yaml.Block value;
                        Yaml.Mapping.Entry e = super.visitMappingEntry(entry, (Object)ctx);
                        if (WORKFLOW_DISPATCH_INPUTS_MATCHER.matches(this.getCursor()) && (value = e.getValue()) instanceof Yaml.Mapping) {
                            Yaml.Mapping inputs = (Yaml.Mapping)value;
                            for (Yaml.Mapping.Entry inputEntry : inputs.getEntries()) {
                                if (!(inputEntry.getKey() instanceof Yaml.Scalar)) continue;
                                definedInputs.add(inputEntry.getKey().getValue());
                            }
                        }
                        return e;
                    }

                    public Yaml.Scalar visitScalar(Yaml.Scalar scalar, ExecutionContext ctx) {
                        String value = scalar.getValue();
                        Matcher matcher = INPUT_USAGE_PATTERN.matcher(value);
                        while (matcher.find()) {
                            String inputName = matcher.group(1) != null ? matcher.group(1) : matcher.group(2);
                            if (inputName == null) continue;
                            usedInputs.add(inputName);
                        }
                        return super.visitScalar(scalar, (Object)ctx);
                    }
                }.visit((Tree)document, (Object)ctx);
                if (definedInputs.size() == usedInputs.size() || definedInputs.isEmpty()) {
                    return document;
                }
                return (Yaml.Document)Objects.requireNonNull((Yaml)new YamlIsoVisitor<ExecutionContext>(){

                    public // Could not load outer class - annotation placement on inner may be incorrect
                    @Nullable Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
                        String inputName;
                        if (WORKFLOW_DISPATCH_INPUTS_MATCHER.matches(this.getCursor().getParent().getParent()) && entry.getKey() instanceof Yaml.Scalar && definedInputs.contains(inputName = entry.getKey().getValue()) && !usedInputs.contains(inputName)) {
                            return null;
                        }
                        return super.visitMappingEntry(entry, (Object)ctx);
                    }

                    public @Nullable Yaml postVisit(Yaml tree, ExecutionContext ctx) {
                        Yaml.Mapping.Entry inputsEntry;
                        Yaml.Mapping inputs;
                        Yaml.Mapping.Entry entry;
                        if (tree instanceof Yaml.Mapping.Entry && "workflow_dispatch".equals((entry = (Yaml.Mapping.Entry)tree).getKey().getValue()) && entry.getValue() instanceof Yaml.Mapping && (inputs = (Yaml.Mapping)entry.getValue()).getEntries().size() == 1 && (inputsEntry = (Yaml.Mapping.Entry)inputs.getEntries().get(0)).getValue() instanceof Yaml.Mapping && ((Yaml.Mapping)inputsEntry.getValue()).getEntries().isEmpty()) {
                            return entry.withValue((Yaml.Block)new Yaml.Mapping(Tree.randomId(), Markers.EMPTY, " ", Collections.emptyList(), "", null, null));
                        }
                        return (Yaml)super.postVisit((Tree)tree, (Object)ctx);
                    }
                }.visit((Tree)document, (Object)ctx));
            }
        });
    }
}

