/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.github.security;

import java.util.regex.Pattern;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.github.IsGitHubActionsWorkflow;
import org.openrewrite.github.security.YamlHelper;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class UnpinnedDockerImagesRecipe
extends Recipe {
    private static final Pattern DOCKER_IMAGE_PATTERN = Pattern.compile("^(?:docker://)?([^/:]+(?:\\.[^/:]+)*(?::[0-9]+)?/)?([^/:]+(?:/[^/:]+)*):([^@]+)(?:@(.+))?$");
    private static final Pattern SHA256_DIGEST_PATTERN = Pattern.compile("^sha256:[a-f0-9]{64}$");

    public String getDisplayName() {
        return "Pin Docker images to digests";
    }

    public String getDescription() {
        return "Pin Docker images to specific digest hashes for security and reproducibility. Images pinned to tags can be changed by the image author, while digest pins are immutable. Based on [zizmor's unpinned-images audit](https://github.com/woodruffw/zizmor/blob/main/crates/zizmor/src/audit/unpinned_images.rs).";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((Recipe)new IsGitHubActionsWorkflow(), (TreeVisitor)new UnpinnedDockerImagesVisitor());
    }

    @Generated
    public UnpinnedDockerImagesRecipe() {
    }

    @Generated
    public String toString() {
        return "UnpinnedDockerImagesRecipe()";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UnpinnedDockerImagesRecipe)) {
            return false;
        }
        UnpinnedDockerImagesRecipe other = (UnpinnedDockerImagesRecipe)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UnpinnedDockerImagesRecipe;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    private static class UnpinnedDockerImagesVisitor
    extends YamlIsoVisitor<ExecutionContext> {
        private UnpinnedDockerImagesVisitor() {
        }

        public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
            String imageValue;
            Yaml.Mapping.Entry mappingEntry = super.visitMappingEntry(entry, (Object)ctx);
            if (this.isImageEntry(mappingEntry) && (imageValue = this.getImageValue(mappingEntry)) != null && this.isUnpinnedDockerImage(imageValue)) {
                return (Yaml.Mapping.Entry)SearchResult.found((Tree)mappingEntry, (String)("Docker image '" + imageValue + "' is not pinned to a digest. Consider pinning to a specific digest for security and reproducibility."));
            }
            return mappingEntry;
        }

        private boolean isImageEntry(Yaml.Mapping.Entry entry) {
            return "image".equals(entry.getKey().getValue());
        }

        private String getImageValue(Yaml.Mapping.Entry entry) {
            return YamlHelper.getScalarValue(entry.getValue());
        }

        private boolean isUnpinnedDockerImage(String imageValue) {
            String[] parts;
            String cleanImage = imageValue;
            if (cleanImage.startsWith("docker://")) {
                cleanImage = cleanImage.substring("docker://".length());
            }
            if (cleanImage.contains("@") && (parts = cleanImage.split("@", 2)).length == 2) {
                String digest = parts[1];
                return !SHA256_DIGEST_PATTERN.matcher(digest).matches();
            }
            return true;
        }
    }
}

