/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.logging.slf4j;

import java.util.function.Supplier;
import java.util.logging.Level;
import org.openrewrite.java.template.RecipeDescriptor;
import org.slf4j.Logger;

@RecipeDescriptor(name="Replace JUL `log(Level, Throwable, Supplier<String>)` with corresponding SLF4J method calls", description="Replace calls to `Logger.log(Level, Throwable, Supplier<String>)` with the corresponding SLF4J method calls.")
public class JulToSlf4jLambdaSupplierWithThrowable {

    @RecipeDescriptor(name="Replace JUL `logger.log(Level.ALL, e, Supplier<String>)` with SLF4J's `Logger.atTrace().log(Supplier<String>)`", description="Replace calls to `java.util.logging.Logger.log(Level.ALL, e, Supplier<String>)` with `org.slf4j.Logger.atTrace().log(Supplier<String>)`.")
    public static class JulToSlf4jSupplierAll {
        void before(java.util.logging.Logger logger, Supplier<String> supplier, Throwable e) {
            logger.log(Level.ALL, e, supplier);
        }

        void after(Logger logger, Supplier<String> supplier, Throwable e) {
            logger.atTrace().setCause(e).log(supplier);
        }
    }

    @RecipeDescriptor(name="Replace JUL `logger.log(Level.SEVERE, e, Supplier<String>)` with SLF4J's `Logger.atError().log(Supplier<String>)`", description="Replace calls to `java.util.logging.Logger.log(Level.SEVERE, e, Supplier<String>)` with `org.slf4j.Logger.atError().log(Supplier<String>)`.")
    public static class JulToSlf4jSupplierSevere {
        void before(java.util.logging.Logger logger, Supplier<String> supplier, Throwable e) {
            logger.log(Level.SEVERE, e, supplier);
        }

        void after(Logger logger, Supplier<String> supplier, Throwable e) {
            logger.atError().setCause(e).log(supplier);
        }
    }

    @RecipeDescriptor(name="Replace JUL `logger.log(Level.WARNING, e, Supplier<String>)` with SLF4J's `Logger.atWarn().log(Supplier<String>)`", description="Replace calls to `java.util.logging.Logger.log(Level.WARNING, e, Supplier<String>)` with `org.slf4j.Logger.atWarn().log(Supplier<String>)`.")
    public static class JulToSlf4jSupplierWarning {
        void before(java.util.logging.Logger logger, Supplier<String> supplier, Throwable e) {
            logger.log(Level.WARNING, e, supplier);
        }

        void after(Logger logger, Supplier<String> supplier, Throwable e) {
            logger.atWarn().setCause(e).log(supplier);
        }
    }

    @RecipeDescriptor(name="Replace JUL `logger.log(Level.INFO, e, Supplier<String>)` with SLF4J's `Logger.atInfo().log(Supplier<String>)`", description="Replace calls to `java.util.logging.Logger.log(Level.INFO, e, Supplier<String>)` with `org.slf4j.Logger.atInfo().log(Supplier<String>)`.")
    public static class JulToSlf4jSupplierInfo {
        void before(java.util.logging.Logger logger, Supplier<String> supplier, Throwable e) {
            logger.log(Level.INFO, e, supplier);
        }

        void after(Logger logger, Supplier<String> supplier, Throwable e) {
            logger.atInfo().setCause(e).log(supplier);
        }
    }

    @RecipeDescriptor(name="Replace JUL `logger.log(Level.CONFIG, e, Supplier<String>)` with SLF4J's `Logger.atInfo().log(Supplier<String>)`", description="Replace calls to `java.util.logging.Logger.log(Level.CONFIG, e, Supplier<String>)` with `org.slf4j.Logger.atInfo().log(Supplier<String>)`.")
    public static class JulToSlf4jSupplierConfig {
        void before(java.util.logging.Logger logger, Supplier<String> supplier, Throwable e) {
            logger.log(Level.CONFIG, e, supplier);
        }

        void after(Logger logger, Supplier<String> supplier, Throwable e) {
            logger.atInfo().setCause(e).log(supplier);
        }
    }

    @RecipeDescriptor(name="Replace JUL `logger.log(Level.FINE, e, Supplier<String>)` with SLF4J's `Logger.atDebug().log(Supplier<String>)`", description="Replace calls to `java.util.logging.Logger.log(Level.FINE, e, Supplier<String>)` with `org.slf4j.Logger.atDebug().log(Supplier<String>)`.")
    public static class JulToSlf4jSupplierFine {
        void before(java.util.logging.Logger logger, Supplier<String> supplier, Throwable e) {
            logger.log(Level.FINE, e, supplier);
        }

        void after(Logger logger, Supplier<String> supplier, Throwable e) {
            logger.atDebug().setCause(e).log(supplier);
        }
    }

    @RecipeDescriptor(name="Replace JUL `logger.log(Level.FINER, e, Supplier<String>)` with SLF4J's `Logger.atTrace().log(Supplier<String>)`", description="Replace calls to `java.util.logging.Logger.log(Level.FINER, e, Supplier<String>)` with `org.slf4j.Logger.atTrace().log(Supplier<String>)`.")
    public static class JulToSlf4jSupplierFiner {
        void before(java.util.logging.Logger logger, Supplier<String> supplier, Throwable e) {
            logger.log(Level.FINER, e, supplier);
        }

        void after(Logger logger, Supplier<String> supplier, Throwable e) {
            logger.atTrace().setCause(e).log(supplier);
        }
    }

    @RecipeDescriptor(name="Replace JUL `logger.log(Level.FINEST, e, Supplier<String>)` with SLF4J's `Logger.atTrace().log(Supplier<String>)`", description="Replace calls to `java.util.logging.Logger.log(Level.FINEST, e, Supplier<String>)` with `org.slf4j.Logger.atTrace().log(Supplier<String>)`.")
    public static class JulToSlf4jSupplierFinest {
        void before(java.util.logging.Logger logger, Supplier<String> supplier, Throwable e) {
            logger.log(Level.FINEST, e, supplier);
        }

        void after(Logger logger, Supplier<String> supplier, Throwable e) {
            logger.atTrace().setCause(e).log(supplier);
        }
    }
}

