/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.lang.var;

import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeTree;

final class DeclarationCheck {
    private DeclarationCheck() {
    }

    public static boolean isVarApplicable(Cursor cursor, J.VariableDeclarations vd) {
        if (DeclarationCheck.isField(vd, cursor) || DeclarationCheck.isMethodParameter(vd, cursor) || !DeclarationCheck.isSingleVariableDefinition(vd) || DeclarationCheck.initializedByTernary(vd)) {
            return false;
        }
        return DeclarationCheck.isInsideMethod(cursor) || DeclarationCheck.isInsideInitializer(cursor, 0);
    }

    private static boolean isSingleVariableDefinition(J.VariableDeclarations vd) {
        boolean isDeclarationOnly;
        boolean isPureAssigment;
        TypeTree typeExpression = vd.getTypeExpression();
        boolean definesSingleVariable = vd.getVariables().size() == 1;
        boolean bl = isPureAssigment = JavaType.Primitive.Null == vd.getType();
        if (!definesSingleVariable || isPureAssigment) {
            return false;
        }
        Expression initializer = ((J.VariableDeclarations.NamedVariable)vd.getVariables().get(0)).getInitializer();
        boolean bl2 = isDeclarationOnly = initializer == null;
        if (isDeclarationOnly) {
            return false;
        }
        initializer = initializer.unwrap();
        boolean isNullAssigment = J.Literal.isLiteralValue((Expression)initializer, null);
        boolean alreadyUseVar = typeExpression instanceof J.Identifier && "var".equals(((J.Identifier)typeExpression).getSimpleName());
        return !isNullAssigment && !alreadyUseVar;
    }

    public static boolean isPrimitive(J.VariableDeclarations vd) {
        TypeTree typeExpression = vd.getTypeExpression();
        return typeExpression instanceof J.Primitive;
    }

    public static boolean declarationHasType(J.VariableDeclarations vd, JavaType type) {
        TypeTree typeExpression = vd.getTypeExpression();
        return typeExpression != null && type.equals((Object)typeExpression.getType());
    }

    public static boolean useGenerics(J.VariableDeclarations vd) {
        TypeTree typeExpression = vd.getTypeExpression();
        boolean isGenericDefinition = typeExpression instanceof J.ParameterizedType;
        if (isGenericDefinition) {
            return true;
        }
        Expression initializer = ((J.VariableDeclarations.NamedVariable)vd.getVariables().get(0)).getInitializer();
        if (initializer == null) {
            return false;
        }
        return (initializer = initializer.unwrap()) instanceof J.NewClass && ((J.NewClass)initializer).getClazz() instanceof J.ParameterizedType;
    }

    public static boolean initializedByTernary(J.VariableDeclarations vd) {
        Expression initializer = ((J.VariableDeclarations.NamedVariable)vd.getVariables().get(0)).getInitializer();
        return initializer != null && initializer.unwrap() instanceof J.Ternary;
    }

    private static boolean isInsideMethod(Cursor cursor) {
        Object value = cursor.dropParentUntil(p -> p instanceof J.MethodDeclaration || p instanceof J.ClassDeclaration || p.equals("root")).getValue();
        boolean isNotRoot = !"root".equals(value);
        boolean isNotClassDeclaration = !(value instanceof J.ClassDeclaration);
        boolean isMethodDeclaration = value instanceof J.MethodDeclaration;
        return isNotRoot && isNotClassDeclaration && isMethodDeclaration;
    }

    private static boolean isField(J.VariableDeclarations vd, Cursor cursor) {
        Cursor parent = cursor.getParentTreeCursor();
        if (parent.getParent() == null) {
            return false;
        }
        Cursor grandparent = parent.getParentTreeCursor();
        return parent.getValue() instanceof J.Block && (grandparent.getValue() instanceof J.ClassDeclaration || grandparent.getValue() instanceof J.NewClass);
    }

    private static boolean isMethodParameter(J.VariableDeclarations vd, Cursor cursor) {
        J.MethodDeclaration methodDeclaration = (J.MethodDeclaration)cursor.firstEnclosing(J.MethodDeclaration.class);
        return methodDeclaration != null && methodDeclaration.getParameters().contains(vd);
    }

    private static boolean isInsideInitializer(Cursor cursor, int nestedBlockLevel) {
        boolean isNoPadding;
        boolean followedByTwoBlock;
        if ("root".equals(cursor.getValue())) {
            return false;
        }
        Object currentStatement = cursor.getValue();
        boolean isClassDeclaration = currentStatement instanceof J.ClassDeclaration;
        boolean bl = followedByTwoBlock = nestedBlockLevel >= 2;
        if (isClassDeclaration && followedByTwoBlock) {
            return true;
        }
        boolean isBlock = currentStatement instanceof J.Block;
        boolean bl2 = isNoPadding = !(currentStatement instanceof JRightPadded);
        if (isBlock) {
            ++nestedBlockLevel;
        } else if (isNoPadding) {
            nestedBlockLevel = 0;
        }
        return DeclarationCheck.isInsideInitializer(Objects.requireNonNull(cursor.getParent()), nestedBlockLevel);
    }

    public static boolean initializedByStaticMethod(@Nullable Expression initializer) {
        if (initializer == null) {
            return false;
        }
        if (!((initializer = initializer.unwrap()) instanceof J.MethodInvocation)) {
            return false;
        }
        J.MethodInvocation invocation = (J.MethodInvocation)initializer;
        if (invocation.getMethodType() == null) {
            return false;
        }
        return invocation.getMethodType().hasFlags(new Flag[]{Flag.Static});
    }
}

