/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.util;

import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

@NullMarked
public class ReplaceMathRandomWithThreadLocalRandomRecipe
extends Recipe {
    public String getDisplayName() {
        return "Replace `java.lang.Math random()` with `ThreadLocalRandom nextDouble()`";
    }

    public String getDescription() {
        return "Replace `java.lang.Math random()` with `ThreadLocalRandom nextDouble()` to reduce contention.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
            JavaTemplate javaMathRandom;
            JavaTemplate after;

            public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                JavaTemplate.Matcher matcher;
                if (this.javaMathRandom == null) {
                    this.javaMathRandom = JavaTemplate.builder((String)"Math.random()").build();
                }
                if ((matcher = this.javaMathRandom.matcher(this.getCursor())).find()) {
                    if (this.after == null) {
                        this.after = JavaTemplate.builder((String)"java.util.concurrent.ThreadLocalRandom.current().nextDouble()").build();
                    }
                    return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                }
                return super.visitMethodInvocation(elem, (Object)ctx);
            }
        };
        return Preconditions.check((TreeVisitor)new UsesMethod("java.lang.Math random(..)", true), (TreeVisitor)javaVisitor);
    }
}

