/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.util;

import java.util.List;
import java.util.Objects;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Space;

public class OptionalStreamRecipe
extends Recipe {
    private static final MethodMatcher mapMatcher = new MethodMatcher("java.util.stream.Stream map(java.util.function.Function)");
    private static final MethodMatcher filterMatcher = new MethodMatcher("java.util.stream.Stream filter(java.util.function.Predicate)");
    private static final MethodMatcher optionalGetMatcher = new MethodMatcher("java.util.Optional get()");
    private static final MethodMatcher optionalIsPresentMatcher = new MethodMatcher("java.util.Optional isPresent()");

    public String getDisplayName() {
        return "`Stream<Optional>` idiom recipe";
    }

    public String getDescription() {
        return "Migrate Java 8 `Optional<Stream>.filter(Optional::isPresent).map(Optional::get)` to Java 11 `.flatMap(Optional::stream)`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(optionalIsPresentMatcher), (TreeVisitor)new OptionalStreamVisitor());
    }

    private static class OptionalStreamVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private OptionalStreamVisitor() {
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation invocation, ExecutionContext ctx) {
            J.MethodInvocation mapInvocation = super.visitMethodInvocation(invocation, (Object)ctx);
            if (!mapMatcher.matches((MethodCall)mapInvocation) || !optionalGetMatcher.matches((Expression)mapInvocation.getArguments().get(0))) {
                return mapInvocation;
            }
            Expression mapSelectExpr = mapInvocation.getSelect();
            if (!filterMatcher.matches(mapSelectExpr)) {
                return mapInvocation;
            }
            J.MethodInvocation filterInvocation = (J.MethodInvocation)mapSelectExpr;
            if (!optionalIsPresentMatcher.matches((Expression)filterInvocation.getArguments().get(0))) {
                return mapInvocation;
            }
            JRightPadded filterSelect = Objects.requireNonNull(filterInvocation.getPadding().getSelect());
            JRightPadded mapSelect = Objects.requireNonNull(mapInvocation.getPadding().getSelect());
            JavaType.Method mapInvocationType = Objects.requireNonNull(mapInvocation.getMethodType());
            J.MethodInvocation flatMapInvocation = (J.MethodInvocation)JavaTemplate.builder((String)"#{any(java.util.stream.Stream)}.flatMap(Optional::stream)").imports(new String[]{"java.util.Optional"}).build().apply(this.updateCursor((Tree)mapInvocation), mapInvocation.getCoordinates().replace(), new Object[]{filterSelect.getElement()});
            Space flatMapComments = filterSelect.getAfter().withComments(ListUtils.concatAll((List)filterSelect.getAfter().getComments(), (List)mapSelect.getAfter().getComments()));
            return flatMapInvocation.getPadding().withSelect(filterSelect.withAfter(flatMapComments)).withMethodType(mapInvocationType.withName("flatMap")).withPrefix(mapInvocation.getPrefix());
        }
    }
}

