/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.staticanalysis.MultipleVariableDeclarationsVisitor;
import org.openrewrite.staticanalysis.java.JavaFileChecker;

public class MultipleVariableDeclarations
extends Recipe {
    public String getDisplayName() {
        return "No multiple variable declarations";
    }

    public String getDescription() {
        return "Places each variable declaration in its own statement and on its own line. Using one variable declaration per line encourages commenting and can increase readability.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-S1659");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(2L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check(new JavaFileChecker(), (TreeVisitor)new MultipleVariableDeclarationsVisitor());
    }
}

