/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.SemanticallyEqual;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;

@Incubating(since="7.25.0")
public class CombineSemanticallyEqualCatchBlocks
extends Recipe {
    public String getDisplayName() {
        return "Combine semantically equal catch blocks";
    }

    public String getDescription() {
        return "Combine catches in a try that contain semantically equivalent blocks. No change will be made when a caught exception exists if combining catches may change application behavior or type attribution is missing.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-S2147");
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new CombineSemanticallyEqualCatchBlocksVisitor();
    }

    private static class CombineSemanticallyEqualCatchBlocksVisitor
    extends JavaVisitor<ExecutionContext> {
        private CombineSemanticallyEqualCatchBlocksVisitor() {
        }

        public J visitTry(J.Try tryable, ExecutionContext ctx) {
            J.Try t = (J.Try)super.visitTry(tryable, (Object)ctx);
            LinkedHashMap<J.Try.Catch, List> semanticallyEqualCatchesMap = new LinkedHashMap<J.Try.Catch, List>();
            List catches = t.getCatches();
            for (int i = 0; i < catches.size(); ++i) {
                J.Try.Catch from = (J.Try.Catch)catches.get(i);
                for (int j = i + 1; j < catches.size(); ++j) {
                    J.Try.Catch to = (J.Try.Catch)catches.get(j);
                    if (!SemanticallyEqual.areEqual((J)from.getBody(), (J)to.getBody()) || !CombineSemanticallyEqualCatchBlocksVisitor.containSameComments(from.getBody(), to.getBody())) continue;
                    List semanticallyEqualCatch = semanticallyEqualCatchesMap.computeIfAbsent(from, k -> new ArrayList());
                    semanticallyEqualCatch.add(to);
                }
            }
            if (!semanticallyEqualCatchesMap.isEmpty()) {
                HashMap parentChildClassRelationship = new HashMap();
                for (int i = 0; i < catches.size(); ++i) {
                    J.Try.Catch from = (J.Try.Catch)catches.get(i);
                    for (int j = i + 1; j < catches.size(); ++j) {
                        J.Try.Catch to = (J.Try.Catch)catches.get(j);
                        for (NameTree fromException : CombineSemanticallyEqualCatchBlocksVisitor.getCaughtExceptions(from)) {
                            for (NameTree toException : CombineSemanticallyEqualCatchBlocksVisitor.getCaughtExceptions(to)) {
                                JavaType.FullyQualified fromType = TypeUtils.asFullyQualified((JavaType)fromException.getType());
                                JavaType.FullyQualified toType = TypeUtils.asFullyQualified((JavaType)toException.getType());
                                if (fromType == null || toType == null || !TypeUtils.isAssignableTo((JavaType)toType, (JavaType)fromType)) continue;
                                Map subTypesMap = parentChildClassRelationship.computeIfAbsent(from, key -> new HashMap());
                                Set childClassIdentifiers = subTypesMap.computeIfAbsent(to, key -> new HashSet());
                                if (!(fromException instanceof J.Identifier)) continue;
                                childClassIdentifiers.add((J.Identifier)fromException);
                            }
                        }
                    }
                }
                HashMap<J.Try.Catch, List> combineCatchesMap = new HashMap<J.Try.Catch, List>();
                for (Map.Entry semanticallyEqualCatches : semanticallyEqualCatchesMap.entrySet()) {
                    J.Try.Catch from = (J.Try.Catch)semanticallyEqualCatches.getKey();
                    block7: for (J.Try.Catch to : (List)semanticallyEqualCatches.getValue()) {
                        int indexFrom = catches.indexOf(from);
                        int indexTo = catches.indexOf(to);
                        if (indexTo - indexFrom != 1) {
                            int end = indexTo - 1;
                            for (int start = indexFrom + 1; start <= end; ++start) {
                                J.Try.Catch mayChangeApplicationBehavior = (J.Try.Catch)catches.get(start);
                                if (parentChildClassRelationship.containsKey(mayChangeApplicationBehavior) && ((Map)parentChildClassRelationship.get(t.getCatches().get(start))).containsKey(to) && !semanticallyEqualCatchesMap.containsKey(mayChangeApplicationBehavior)) continue block7;
                            }
                        }
                        List toCatches = combineCatchesMap.computeIfAbsent(from, key -> new ArrayList());
                        toCatches.add(to);
                    }
                }
                for (Map.Entry catchMapEntry : combineCatchesMap.entrySet()) {
                    this.doAfterVisit((TreeVisitor)new CombineCatches((J.Try.Catch)catchMapEntry.getKey(), (List)catchMapEntry.getValue(), parentChildClassRelationship.getOrDefault(catchMapEntry.getKey(), Collections.emptyMap())));
                    this.doAfterVisit((TreeVisitor)new RemoveCatches((List)catchMapEntry.getValue()));
                }
            }
            return t;
        }

        private static boolean containSameComments(J.Block body1, J.Block body2) {
            CommentVisitor commentVisitor = new CommentVisitor();
            commentVisitor.visit((Tree)body1, body2);
            return commentVisitor.isEqual.get();
        }

        private static List<NameTree> getCaughtExceptions(J.Try.Catch aCatch) {
            TypeTree typeExpr = ((J.VariableDeclarations)aCatch.getParameter().getTree()).getTypeExpression();
            if (typeExpr instanceof J.MultiCatch) {
                return ((J.MultiCatch)typeExpr).getAlternatives();
            }
            if (typeExpr != null) {
                return Collections.singletonList(typeExpr);
            }
            return Collections.emptyList();
        }

        private static class CombineCatches
        extends JavaVisitor<ExecutionContext> {
            private final J.Try.Catch scope;
            private final List<J.Try.Catch> equivalentCatches;
            private final Map<J.Try.Catch, Set<J.Identifier>> childClassesToExclude;

            CombineCatches(J.Try.Catch scope, List<J.Try.Catch> equivalentCatches, Map<J.Try.Catch, Set<J.Identifier>> childClassesToExclude) {
                this.scope = scope;
                this.equivalentCatches = equivalentCatches;
                this.childClassesToExclude = childClassesToExclude;
            }

            public J visitMultiCatch(J.MultiCatch multiCatch, ExecutionContext ctx) {
                J.Try.Catch parent;
                J.MultiCatch m = (J.MultiCatch)super.visitMultiCatch(multiCatch, (Object)ctx);
                Cursor parentCursor = this.getCursor().dropParentUntil(is -> is instanceof J.Try.Catch || is instanceof J.Try);
                if (parentCursor.getValue() instanceof J.Try.Catch && (parent = (J.Try.Catch)parentCursor.getValue()) == this.scope) {
                    List<JRightPadded<NameTree>> combinedCatches = this.combineEquivalentCatches();
                    m = (J.MultiCatch)this.maybeAutoFormat((J)m, (J)m.getPadding().withAlternatives(combinedCatches), ctx);
                }
                return m;
            }

            public J visitCatch(J.Try.Catch _catch, ExecutionContext ctx) {
                J.Try.Catch c = (J.Try.Catch)super.visitCatch(_catch, (Object)ctx);
                if (c == this.scope && !(((J.VariableDeclarations)c.getParameter().getTree()).getTypeExpression() instanceof J.MultiCatch) && ((J.VariableDeclarations)c.getParameter().getTree()).getTypeExpression() != null) {
                    List<JRightPadded<NameTree>> combinedCatches = this.combineEquivalentCatches();
                    c = (J.Try.Catch)this.maybeAutoFormat((J)c, (J)c.withParameter(c.getParameter().withTree((J)((J.VariableDeclarations)c.getParameter().getTree()).withTypeExpression((TypeTree)new J.MultiCatch(Tree.randomId(), Space.EMPTY, Markers.EMPTY, combinedCatches)))), ctx);
                }
                return c;
            }

            private List<JRightPadded<NameTree>> combineEquivalentCatches() {
                HashSet<J.Identifier> removeIdentifiers = new HashSet<J.Identifier>();
                ArrayList<JRightPadded<NameTree>> combinedCatches = new ArrayList<JRightPadded<NameTree>>();
                for (J.Try.Catch equivalentCatch : this.equivalentCatches) {
                    TypeTree typeExpr;
                    Set<J.Identifier> childClasses = this.childClassesToExclude.get(equivalentCatch);
                    if (childClasses != null) {
                        removeIdentifiers.addAll(childClasses);
                    }
                    if ((typeExpr = ((J.VariableDeclarations)equivalentCatch.getParameter().getTree()).getTypeExpression()) instanceof J.MultiCatch) {
                        for (JRightPadded alternative : ((J.MultiCatch)typeExpr).getPadding().getAlternatives()) {
                            NameTree name = (NameTree)alternative.getElement();
                            if (name instanceof J.Identifier) {
                                if (removeIdentifiers.contains((J.Identifier)name)) continue;
                                combinedCatches.add((JRightPadded<NameTree>)alternative.withElement((Object)((J.Identifier)name).withPrefix(Space.EMPTY)));
                                continue;
                            }
                            if (name instanceof J.FieldAccess) {
                                combinedCatches.add((JRightPadded<NameTree>)alternative.withElement((Object)((J.FieldAccess)name).withPrefix(Space.EMPTY)));
                                continue;
                            }
                            combinedCatches.add((JRightPadded<NameTree>)alternative);
                        }
                        continue;
                    }
                    if (typeExpr instanceof J.Identifier) {
                        J.Identifier identifier = (J.Identifier)typeExpr;
                        if (removeIdentifiers.contains(identifier)) continue;
                        combinedCatches.add((JRightPadded<NameTree>)JRightPadded.build((Object)identifier.withPrefix(Space.EMPTY)));
                        continue;
                    }
                    if (!(typeExpr instanceof J.FieldAccess)) continue;
                    combinedCatches.add((JRightPadded<NameTree>)JRightPadded.build((Object)((J.FieldAccess)typeExpr).withPrefix(Space.EMPTY)));
                }
                TypeTree scopeExpr = ((J.VariableDeclarations)this.scope.getParameter().getTree()).getTypeExpression();
                if (scopeExpr instanceof J.MultiCatch) {
                    List alternatives = ((J.MultiCatch)scopeExpr).getPadding().getAlternatives();
                    for (int i = alternatives.size() - 1; i >= 0; --i) {
                        NameTree name = (NameTree)((JRightPadded)alternatives.get(i)).getElement();
                        if (name instanceof J.Identifier && !removeIdentifiers.contains(name)) {
                            combinedCatches.add(0, (JRightPadded<NameTree>)((JRightPadded)alternatives.get(i)).withElement((Object)((J.Identifier)name).withPrefix(Space.EMPTY)));
                            continue;
                        }
                        if (name instanceof J.Identifier) continue;
                        combinedCatches.add(0, (JRightPadded<NameTree>)((JRightPadded)alternatives.get(i)));
                    }
                } else if (scopeExpr instanceof J.Identifier && !removeIdentifiers.contains(scopeExpr)) {
                    combinedCatches.add(0, (JRightPadded<NameTree>)JRightPadded.build((Object)((J.Identifier)scopeExpr).withPrefix(Space.EMPTY)));
                } else if (scopeExpr instanceof J.FieldAccess) {
                    combinedCatches.add(0, (JRightPadded<NameTree>)JRightPadded.build((Object)((J.FieldAccess)scopeExpr).withPrefix(Space.EMPTY)));
                }
                return combinedCatches;
            }
        }

        static class RemoveCatches
        extends JavaVisitor<ExecutionContext> {
            private final List<J.Try.Catch> removeCatches;

            RemoveCatches(@Nullable List<// Could not load outer class - annotation placement on inner may be incorrect
            J.Try.Catch> removeCatches) {
                this.removeCatches = removeCatches;
            }

            public @Nullable J visitMultiCatch(J.MultiCatch multiCatch, ExecutionContext ctx) {
                Cursor parentCursor = this.getCursor().dropParentUntil(is -> is instanceof J.Try.Catch || is instanceof J.Try);
                if (this.removeCatches != null && parentCursor.getValue() instanceof J.Try.Catch && this.removeCatches.contains((J.Try.Catch)parentCursor.getValue())) {
                    return null;
                }
                return super.visitMultiCatch(multiCatch, (Object)ctx);
            }

            public @Nullable J visitCatch(J.Try.Catch _catch, ExecutionContext ctx) {
                if (this.removeCatches != null && this.removeCatches.contains(_catch)) {
                    return null;
                }
                return super.visitCatch(_catch, (Object)ctx);
            }
        }

        private static class CommentVisitor
        extends JavaIsoVisitor<J> {
            AtomicBoolean isEqual = new AtomicBoolean(true);
            private final boolean compareMethodArguments = false;

            private CommentVisitor() {
            }

            private boolean nullMissMatch(Object obj1, Object obj2) {
                return obj1 == null && obj2 != null || obj1 != null && obj2 == null;
            }

            private boolean doesNotContainSameComments(Space space1, Space space2) {
                if (space1 == null && space2 == null) {
                    return false;
                }
                if (space1 == null || space2 == null || space1.getComments().size() != space2.getComments().size()) {
                    return true;
                }
                for (int i = 0; i < space1.getComments().size(); ++i) {
                    Comment comment1 = (Comment)space1.getComments().get(i);
                    Comment comment2 = (Comment)space2.getComments().get(i);
                    if (comment1.printComment(this.getCursor().getParentOrThrow()).equals(comment2.printComment(this.getCursor().getParentOrThrow()))) continue;
                    return true;
                }
                return false;
            }

            public Expression visitExpression(Expression expression, J j) {
                if (this.isEqual.get() && !TypeUtils.isOfType((JavaType)expression.getType(), (JavaType)((Expression)j).getType())) {
                    this.isEqual.set(false);
                    return expression;
                }
                Expression compareTo = (Expression)j;
                if (this.doesNotContainSameComments(expression.getPrefix(), compareTo.getPrefix())) {
                    this.isEqual.set(false);
                }
                return expression;
            }

            public J.Annotation visitAnnotation(J.Annotation annotation, J j) {
                if (this.isEqual.get()) {
                    if (!(j instanceof J.Annotation)) {
                        this.isEqual.set(false);
                        return annotation;
                    }
                    J.Annotation compareTo = (J.Annotation)j;
                    if (!TypeUtils.isOfType((JavaType)annotation.getType(), (JavaType)compareTo.getType()) || this.nullMissMatch(annotation.getArguments(), compareTo.getArguments()) || annotation.getArguments() != null && compareTo.getArguments() != null && annotation.getArguments().size() != compareTo.getArguments().size() || this.doesNotContainSameComments(annotation.getPrefix(), compareTo.getPrefix())) {
                        this.isEqual.set(false);
                        return annotation;
                    }
                    this.visitTypeName(annotation.getAnnotationType(), (J)compareTo.getAnnotationType());
                    if (annotation.getArguments() != null && compareTo.getArguments() != null) {
                        for (int i = 0; i < annotation.getArguments().size(); ++i) {
                            this.visit((Tree)annotation.getArguments().get(i), (J)compareTo.getArguments().get(i));
                        }
                    }
                }
                return annotation;
            }

            public J.AnnotatedType visitAnnotatedType(J.AnnotatedType annotatedType, J j) {
                if (this.isEqual.get()) {
                    if (!(j instanceof J.AnnotatedType)) {
                        this.isEqual.set(false);
                        return annotatedType;
                    }
                    J.AnnotatedType compareTo = (J.AnnotatedType)j;
                    if (!TypeUtils.isOfType((JavaType)annotatedType.getType(), (JavaType)compareTo.getType()) || annotatedType.getAnnotations().size() != compareTo.getAnnotations().size() || this.doesNotContainSameComments(annotatedType.getPrefix(), compareTo.getPrefix())) {
                        this.isEqual.set(false);
                        return annotatedType;
                    }
                    this.visitTypeName(annotatedType.getTypeExpression(), (J)compareTo.getTypeExpression());
                    for (int i = 0; i < annotatedType.getAnnotations().size(); ++i) {
                        this.visit((Tree)annotatedType.getAnnotations().get(i), (J)compareTo.getAnnotations().get(i));
                    }
                }
                return annotatedType;
            }

            public J.ArrayAccess visitArrayAccess(J.ArrayAccess arrayAccess, J j) {
                if (this.isEqual.get()) {
                    if (!(j instanceof J.ArrayAccess)) {
                        this.isEqual.set(false);
                        return arrayAccess;
                    }
                    J.ArrayAccess compareTo = (J.ArrayAccess)j;
                    if (this.nullMissMatch(arrayAccess.getType(), compareTo.getType()) || !TypeUtils.isOfType((JavaType)arrayAccess.getType(), (JavaType)compareTo.getType()) || this.doesNotContainSameComments(arrayAccess.getPrefix(), compareTo.getPrefix())) {
                        this.isEqual.set(false);
                        return arrayAccess;
                    }
                    this.visit((Tree)arrayAccess.getIndexed(), compareTo.getIndexed());
                    this.visit((Tree)arrayAccess.getDimension(), compareTo.getDimension());
                }
                return arrayAccess;
            }

            public J.ArrayDimension visitArrayDimension(J.ArrayDimension arrayDimension, J j) {
                if (this.isEqual.get()) {
                    if (!(j instanceof J.ArrayDimension)) {
                        this.isEqual.set(false);
                        return arrayDimension;
                    }
                    J.ArrayDimension compareTo = (J.ArrayDimension)j;
                    if (this.doesNotContainSameComments(arrayDimension.getPrefix(), compareTo.getPrefix())) {
                        this.isEqual.set(false);
                        return arrayDimension;
                    }
                    this.visit((Tree)arrayDimension.getIndex(), compareTo.getIndex());
                }
                return arrayDimension;
            }

            public J.ArrayType visitArrayType(J.ArrayType arrayType, J j) {
                if (this.isEqual.get()) {
                    if (!(j instanceof J.ArrayType)) {
                        this.isEqual.set(false);
                        return arrayType;
                    }
                    J.ArrayType compareTo = (J.ArrayType)j;
                    if (!TypeUtils.isOfType((JavaType)arrayType.getType(), (JavaType)compareTo.getType()) || this.doesNotContainSameComments(arrayType.getPrefix(), compareTo.getPrefix()) || this.nullMissMatch(arrayType.getAnnotations(), compareTo.getAnnotations()) || arrayType.getAnnotations().size() != compareTo.getAnnotations().size()) {
                        this.isEqual.set(false);
                        return arrayType;
                    }
                    for (int i = 0; i < arrayType.getAnnotations().size(); ++i) {
                        this.visit((Tree)arrayType.getAnnotations().get(i), (J)compareTo.getAnnotations().get(i));
                        if (this.isEqual.get()) continue;
                        return arrayType;
                    }
                    this.visitTypeName(arrayType.getElementType(), (J)compareTo.getElementType());
                }
                return arrayType;
            }

            public J.Assert visitAssert(J.Assert _assert, J j) {
                if (this.isEqual.get()) {
                    if (!(j instanceof J.Assert)) {
                        this.isEqual.set(false);
                        return _assert;
                    }
                    J.Assert compareTo = (J.Assert)j;
                    if (this.nullMissMatch(_assert.getDetail(), compareTo.getDetail()) || this.doesNotContainSameComments(_assert.getPrefix(), compareTo.getPrefix())) {
                        this.isEqual.set(false);
                        return _assert;
                    }
                    this.visit((Tree)_assert.getCondition(), compareTo.getCondition());
                    if (_assert.getDetail() != null && compareTo.getDetail() != null) {
                        this.visit((Tree)_assert.getDetail().getElement(), (J)compareTo.getDetail().getElement());
                    }
                }
                return _assert;
            }

            public J.Assignment visitAssignment(J.Assignment assignment, J j) {
                if (this.isEqual.get()) {
                    if (!(j instanceof J.Assignment)) {
                        this.isEqual.set(false);
                        return assignment;
                    }
                    J.Assignment compareTo = (J.Assignment)j;
                    if (this.nullMissMatch(assignment.getType(), compareTo.getType()) || !TypeUtils.isOfType((JavaType)assignment.getType(), (JavaType)compareTo.getType()) || this.doesNotContainSameComments(assignment.getPrefix(), compareTo.getPrefix())) {
                        this.isEqual.set(false);
                        return assignment;
                    }
                    this.visit((Tree)assignment.getAssignment(), compareTo.getAssignment());
                    this.visit((Tree)assignment.getVariable(), compareTo.getVariable());
                }
                return assignment;
            }

            public J.AssignmentOperation visitAssignmentOperation(J.AssignmentOperation assignOp, J j) {
                if (this.isEqual.get()) {
                    if (!(j instanceof J.AssignmentOperation)) {
                        this.isEqual.set(false);
                        return assignOp;
                    }
                    J.AssignmentOperation compareTo = (J.AssignmentOperation)j;
                    if (this.nullMissMatch(assignOp.getType(), compareTo.getType()) || !TypeUtils.isOfType((JavaType)assignOp.getType(), (JavaType)compareTo.getType()) || this.doesNotContainSameComments(assignOp.getPrefix(), compareTo.getPrefix())) {
                        this.isEqual.set(false);
                        return assignOp;
                    }
                    this.visit((Tree)assignOp.getAssignment(), compareTo.getAssignment());
                    this.visit((Tree)assignOp.getVariable(), compareTo.getVariable());
                }
                return assignOp;
            }

            public J.Binary visitBinary(J.Binary binary, J j) {
                if (this.isEqual.get()) {
                    if (!(j instanceof J.Binary)) {
                        this.isEqual.set(false);
                        return binary;
                    }
                    J.Binary compareTo = (J.Binary)j;
                    if (this.nullMissMatch(binary.getType(), compareTo.getType()) || !TypeUtils.isOfType((JavaType)binary.getType(), (JavaType)compareTo.getType()) || binary.getOperator() != compareTo.getOperator() || this.doesNotContainSameComments(binary.getPadding().getOperator().getBefore(), compareTo.getPadding().getOperator().getBefore()) || this.doesNotContainSameComments(binary.getPrefix(), compareTo.getPrefix())) {
                        this.isEqual.set(false);
                        return binary;
                    }
                    this.visit((Tree)binary.getLeft(), compareTo.getLeft());
                    this.visit((Tree)binary.getRight(), compareTo.getRight());
                }
                return binary;
            }

            public J.Block visitBlock(J.Block block, J j) {
                if (this.isEqual.get()) {
                    if (!(j instanceof J.Block)) {
                        this.isEqual.set(false);
                        return block;
                    }
                    J.Block compareTo = (J.Block)j;
                    if (block.getStatements().size() != compareTo.getStatements().size() || this.doesNotContainSameComments(block.getPrefix(), compareTo.getPrefix()) || this.doesNotContainSameComments(block.getEnd(), compareTo.getEnd())) {
                        this.isEqual.set(false);
                        return block;
                    }
                    for (int i = 0; i < block.getStatements().size(); ++i) {
                        this.visit((Tree)block.getStatements().get(i), (J)compareTo.getStatements().get(i));
                    }
                }
                return block;
            }

            public J.Break visitBreak(J.Break breakStatement, J j) {
                if (this.isEqual.get()) {
                    if (!(j instanceof J.Break)) {
                        this.isEqual.set(false);
                        return breakStatement;
                    }
                    J.Break compareTo = (J.Break)j;
                    if (this.nullMissMatch(breakStatement.getLabel(), compareTo.getLabel()) || this.doesNotContainSameComments(breakStatement.getPrefix(), compareTo.getPrefix())) {
                        this.isEqual.set(false);
                        return breakStatement;
                    }
                    if (breakStatement.getLabel() != null && compareTo.getLabel() != null) {
                        this.visit((Tree)breakStatement.getLabel(), compareTo.getLabel());
                    }
                }
                return breakStatement;
            }

            public J.Case visitCase(J.Case _case, J j) {
                if (this.isEqual.get()) {
                    if (!(j instanceof J.Case)) {
                        this.isEqual.set(false);
                        return _case;
                    }
                    J.Case compareTo = (J.Case)j;
                    if (_case.getStatements().size() != compareTo.getStatements().size() || this.doesNotContainSameComments(_case.getPrefix(), compareTo.getPrefix())) {
                        this.isEqual.set(false);
                        return _case;
                    }
                    this.visit((Tree)_case.getCaseLabels().get(0), (J)compareTo.getCaseLabels().get(0));
                    for (int i = 0; i < _case.getStatements().size(); ++i) {
                        this.visit((Tree)_case.getStatements().get(i), (J)compareTo.getStatements().get(i));
                    }
                }
                return _case;
            }

            public J.Try.Catch visitCatch(J.Try.Catch _catch, J j) {
                if (this.isEqual.get()) {
                    if (!(j instanceof J.Try.Catch)) {
                        this.isEqual.set(false);
                        return _catch;
                    }
                    J.Try.Catch compareTo = (J.Try.Catch)j;
                    if (this.doesNotContainSameComments(_catch.getPrefix(), compareTo.getPrefix())) {
                        this.isEqual.set(false);
                        return _catch;
                    }
                    this.visit((Tree)_catch.getParameter(), compareTo.getParameter());
                    this.visit((Tree)_catch.getBody(), compareTo.getBody());
                }
                return _catch;
            }

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, J j) {
                if (this.isEqual.get()) {
                    int i;
                    if (!(j instanceof J.ClassDeclaration)) {
                        this.isEqual.set(false);
                        return classDecl;
                    }
                    J.ClassDeclaration compareTo = (J.ClassDeclaration)j;
                    if (!TypeUtils.isOfType((JavaType)classDecl.getType(), (JavaType)compareTo.getType()) || classDecl.getModifiers().size() != compareTo.getModifiers().size() || !new HashSet(classDecl.getModifiers()).containsAll(compareTo.getModifiers()) || classDecl.getKind() != compareTo.getKind() || classDecl.getLeadingAnnotations().size() != compareTo.getLeadingAnnotations().size() || this.nullMissMatch(classDecl.getExtends(), compareTo.getExtends()) || this.nullMissMatch(classDecl.getTypeParameters(), compareTo.getTypeParameters()) || classDecl.getTypeParameters() != null && compareTo.getTypeParameters() != null && classDecl.getTypeParameters().size() != compareTo.getTypeParameters().size() || this.nullMissMatch(classDecl.getImplements(), compareTo.getImplements()) || classDecl.getImplements() != null && compareTo.getImplements() != null && classDecl.getImplements().size() != compareTo.getImplements().size() || this.doesNotContainSameComments(classDecl.getPrefix(), compareTo.getPrefix())) {
                        this.isEqual.set(false);
                        return classDecl;
                    }
                    this.visit((Tree)classDecl.getName(), compareTo.getName());
                    for (i = 0; i < classDecl.getLeadingAnnotations().size(); ++i) {
                        this.visit((Tree)classDecl.getLeadingAnnotations().get(i), (J)compareTo.getLeadingAnnotations().get(i));
                    }
                    if (classDecl.getExtends() != null && compareTo.getExtends() != null) {
                        this.visit((Tree)classDecl.getExtends(), compareTo.getExtends());
                    }
                    if (classDecl.getTypeParameters() != null && compareTo.getTypeParameters() != null) {
                        for (i = 0; i < classDecl.getTypeParameters().size(); ++i) {
                            this.visit((Tree)classDecl.getTypeParameters().get(i), (J)compareTo.getTypeParameters().get(i));
                        }
                    }
                    if (classDecl.getImplements() != null && compareTo.getImplements() != null) {
                        for (i = 0; i < classDecl.getImplements().size(); ++i) {
                            this.visit((Tree)classDecl.getImplements().get(i), (J)compareTo.getImplements().get(i));
                        }
                    }
                    this.visit((Tree)classDecl.getBody(), compareTo.getBody());
                }
                return classDecl;
            }

            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, J j) {
                if (this.isEqual.get()) {
                    int i;
                    if (!(j instanceof J.CompilationUnit)) {
                        this.isEqual.set(false);
                        return cu;
                    }
                    J.CompilationUnit compareTo = (J.CompilationUnit)j;
                    if (this.nullMissMatch(cu.getPackageDeclaration(), compareTo.getPackageDeclaration()) || cu.getImports().size() != compareTo.getImports().size() || cu.getClasses().size() != compareTo.getClasses().size() || this.doesNotContainSameComments(cu.getPrefix(), compareTo.getPrefix())) {
                        this.isEqual.set(false);
                        return cu;
                    }
                    if (cu.getPackageDeclaration() != null && compareTo.getPackageDeclaration() != null) {
                        this.visit((Tree)cu.getPackageDeclaration(), compareTo.getPackageDeclaration());
                    }
                    for (i = 0; i < cu.getImports().size(); ++i) {
                        this.visit((Tree)cu.getImports().get(i), (J)compareTo.getImports().get(i));
                    }
                    for (i = 0; i < cu.getClasses().size(); ++i) {
                        this.visit((Tree)cu.getClasses().get(i), (J)compareTo.getClasses().get(i));
                    }
                }
                return cu;
            }

            public <T extends J> J.ControlParentheses<T> visitControlParentheses(J.ControlParentheses<T> controlParens, J j) {
                if (this.isEqual.get()) {
                    if (!(j instanceof J.ControlParentheses)) {
                        this.isEqual.set(false);
                        return controlParens;
                    }
                    J.ControlParentheses compareTo = (J.ControlParentheses)j;
                    if (!TypeUtils.isOfType((JavaType)controlParens.getType(), (JavaType)compareTo.getType()) || this.doesNotContainSameComments(controlParens.getPrefix(), compareTo.getPrefix())) {
                        this.isEqual.set(false);
                        return controlParens;
                    }
                    this.visit((Tree)controlParens.getTree(), compareTo.getTree());
                }
                return controlParens;
            }

            public J.Continue visitContinue(J.Continue continueStatement, J j) {
                if (this.isEqual.get()) {
                    if (!(j instanceof J.Continue)) {
                        this.isEqual.set(false);
                        return continueStatement;
                    }
                    J.Continue compareTo = (J.Continue)j;
                    if (this.nullMissMatch(continueStatement.getLabel(), compareTo.getLabel()) || this.doesNotContainSameComments(continueStatement.getPrefix(), compareTo.getPrefix())) {
                        this.isEqual.set(false);
                        return continueStatement;
                    }
                    if (continueStatement.getLabel() != null && compareTo.getLabel() != null) {
                        this.visit((Tree)continueStatement.getLabel(), compareTo.getLabel());
                    }
                }
                return continueStatement;
            }

            public J.DoWhileLoop visitDoWhileLoop(J.DoWhileLoop doWhileLoop, J j) {
                if (this.isEqual.get()) {
                    if (!(j instanceof J.DoWhileLoop)) {
                        this.isEqual.set(false);
                        return doWhileLoop;
                    }
                    J.DoWhileLoop compareTo = (J.DoWhileLoop)j;
                    if (this.doesNotContainSameComments(doWhileLoop.getPrefix(), compareTo.getPrefix())) {
                        this.isEqual.set(false);
                        return doWhileLoop;
                    }
                    this.visit((Tree)doWhileLoop.getWhileCondition(), compareTo.getWhileCondition());
                    this.visit((Tree)doWhileLoop.getBody(), compareTo.getBody());
                }
                return doWhileLoop;
            }

            public J.If.Else visitElse(J.If.Else else_, J j) {
                if (this.isEqual.get()) {
                    if (!(j instanceof J.If.Else)) {
                        this.isEqual.set(false);
                        return else_;
                    }
                    J.If.Else compareTo = (J.If.Else)j;
                    if (this.doesNotContainSameComments(else_.getPrefix(), compareTo.getPrefix())) {
                        this.isEqual.set(false);
                        return else_;
                    }
                    this.visit((Tree)else_.getBody(), compareTo.getBody());
                }
                return else_;
            }

            public J.Empty visitEmpty(J.Empty empty, J j) {
                if (this.isEqual.get()) {
                    if (!(j instanceof J.Empty)) {
                        this.isEqual.set(false);
                        return empty;
                    }
                    J.Empty compareTo = (J.Empty)j;
                    if (empty.getType() == null && compareTo.getType() != null || empty.getType() != null && compareTo.getType() == null || this.doesNotContainSameComments(empty.getPrefix(), compareTo.getPrefix())) {
                        this.isEqual.set(false);
                        return empty;
                    }
                }
                return empty;
            }

            public J.EnumValue visitEnumValue(J.EnumValue _enum, J j) {
                if (this.isEqual.get()) {
                    if (!(j instanceof J.EnumValue)) {
                        this.isEqual.set(false);
                        return _enum;
                    }
                    J.EnumValue compareTo = (J.EnumValue)j;
                    if (this.nullMissMatch(_enum.getAnnotations(), compareTo.getAnnotations()) || _enum.getAnnotations().size() != compareTo.getAnnotations().size() || this.doesNotContainSameComments(_enum.getPrefix(), compareTo.getPrefix())) {
                        this.isEqual.set(false);
                        return _enum;
                    }
                    this.visit((Tree)_enum.getName(), compareTo.getName());
                    for (int i = 0; i < _enum.getAnnotations().size(); ++i) {
                        this.visit((Tree)_enum.getAnnotations().get(i), (J)compareTo.getAnnotations().get(i));
                    }
                    if (_enum.getInitializer() != null && compareTo.getInitializer() != null) {
                        this.visit((Tree)_enum.getInitializer(), compareTo.getInitializer());
                    }
                }
                return _enum;
            }

            public J.EnumValueSet visitEnumValueSet(J.EnumValueSet enums, J j) {
                if (this.isEqual.get()) {
                    if (!(j instanceof J.EnumValueSet)) {
                        this.isEqual.set(false);
                        return enums;
                    }
                    J.EnumValueSet compareTo = (J.EnumValueSet)j;
                    if (enums.getEnums().size() != compareTo.getEnums().size() || this.doesNotContainSameComments(enums.getPrefix(), compareTo.getPrefix())) {
                        this.isEqual.set(false);
                        return enums;
                    }
                    for (int i = 0; i < enums.getEnums().size(); ++i) {
                        this.visit((Tree)enums.getEnums().get(i), (J)compareTo.getEnums().get(i));
                    }
                }
                return enums;
            }

            public J.FieldAccess visitFieldAccess(J.FieldAccess fieldAccess, J j) {
                if (this.isEqual.get()) {
                    if (!(j instanceof J.FieldAccess)) {
                        this.isEqual.set(false);
                        return fieldAccess;
                    }
                    J.FieldAccess compareTo = (J.FieldAccess)j;
                    if (!TypeUtils.isOfType((JavaType)fieldAccess.getType(), (JavaType)compareTo.getType()) || !TypeUtils.isOfType((JavaType)fieldAccess.getTarget().getType(), (JavaType)compareTo.getTarget().getType()) || this.doesNotContainSameComments(fieldAccess.getPrefix(), compareTo.getPrefix())) {
                        this.isEqual.set(false);
                        return fieldAccess;
                    }
                    this.visit((Tree)fieldAccess.getName(), compareTo.getName());
                }
                return fieldAccess;
            }

            public J.ForEachLoop visitForEachLoop(J.ForEachLoop forLoop, J j) {
                if (this.isEqual.get()) {
                    if (!(j instanceof J.ForEachLoop)) {
                        this.isEqual.set(false);
                        return forLoop;
                    }
                    J.ForEachLoop compareTo = (J.ForEachLoop)j;
                    if (this.doesNotContainSameComments(forLoop.getPrefix(), compareTo.getPrefix())) {
                        this.isEqual.set(false);
                        return forLoop;
                    }
                    this.visit((Tree)forLoop.getControl(), compareTo.getControl());
                    this.visit((Tree)forLoop.getBody(), compareTo.getBody());
                }
                return forLoop;
            }

            public J.ForEachLoop.Control visitForEachControl(J.ForEachLoop.Control control, J j) {
                if (this.isEqual.get()) {
                    if (!(j instanceof J.ForEachLoop.Control)) {
                        this.isEqual.set(false);
                        return control;
                    }
                    J.ForEachLoop.Control compareTo = (J.ForEachLoop.Control)j;
                    if (this.doesNotContainSameComments(control.getPrefix(), compareTo.getPrefix())) {
                        this.isEqual.set(false);
                        return control;
                    }
                    this.visit((Tree)control.getVariable(), compareTo.getVariable());
                    this.visit((Tree)control.getIterable(), compareTo.getIterable());
                }
                return control;
            }

            public J.ForLoop visitForLoop(J.ForLoop forLoop, J j) {
                if (this.isEqual.get()) {
                    if (!(j instanceof J.ForLoop)) {
                        this.isEqual.set(false);
                        return forLoop;
                    }
                    J.ForLoop compareTo = (J.ForLoop)j;
                    if (this.doesNotContainSameComments(forLoop.getPrefix(), compareTo.getPrefix())) {
                        this.isEqual.set(false);
                        return forLoop;
                    }
                    this.visit((Tree)forLoop.getControl(), compareTo.getControl());
                    this.visit((Tree)forLoop.getBody(), compareTo.getBody());
                }
                return forLoop;
            }

            public J.ForLoop.Control visitForControl(J.ForLoop.Control control, J j) {
                if (this.isEqual.get()) {
                    int i;
                    if (!(j instanceof J.ForLoop.Control)) {
                        this.isEqual.set(false);
                        return control;
                    }
                    J.ForLoop.Control compareTo = (J.ForLoop.Control)j;
                    if (control.getInit().size() != compareTo.getInit().size() || control.getUpdate().size() != compareTo.getUpdate().size() || this.doesNotContainSameComments(control.getPrefix(), compareTo.getPrefix())) {
                        this.isEqual.set(false);
                        return control;
                    }
                    this.visit((Tree)control.getCondition(), compareTo.getCondition());
                    for (i = 0; i < control.getInit().size(); ++i) {
                        this.visit((Tree)control.getInit().get(i), (J)compareTo.getInit().get(i));
                    }
                    for (i = 0; i < control.getUpdate().size(); ++i) {
                        this.visit((Tree)control.getUpdate().get(i), (J)compareTo.getUpdate().get(i));
                    }
                }
                return control;
            }

            public J.Identifier visitIdentifier(J.Identifier identifier, J j) {
                if (this.isEqual.get()) {
                    if (!(j instanceof J.Identifier)) {
                        this.isEqual.set(false);
                        return identifier;
                    }
                    J.Identifier compareTo = (J.Identifier)j;
                    if (!identifier.getSimpleName().equals(compareTo.getSimpleName()) || !TypeUtils.isOfType((JavaType)identifier.getType(), (JavaType)compareTo.getType()) || this.doesNotContainSameComments(identifier.getPrefix(), compareTo.getPrefix())) {
                        this.isEqual.set(false);
                        return identifier;
                    }
                }
                return identifier;
            }

            public J.If visitIf(J.If iff, J j) {
                if (this.isEqual.get()) {
                    if (!(j instanceof J.If)) {
                        this.isEqual.set(false);
                        return iff;
                    }
                    J.If compareTo = (J.If)j;
                    if (this.nullMissMatch(iff.getElsePart(), compareTo.getElsePart()) || this.doesNotContainSameComments(iff.getPrefix(), compareTo.getPrefix())) {
                        this.isEqual.set(false);
                        return iff;
                    }
                    this.visit((Tree)iff.getIfCondition(), compareTo.getIfCondition());
                    this.visit((Tree)iff.getThenPart(), compareTo.getThenPart());
                    if (iff.getElsePart() != null && compareTo.getElsePart() != null) {
                        this.visit((Tree)iff.getElsePart(), compareTo.getElsePart());
                    }
                }
                return iff;
            }

            public J.Import visitImport(J.Import _import, J j) {
                if (this.isEqual.get()) {
                    if (!(j instanceof J.Import)) {
                        this.isEqual.set(false);
                        return _import;
                    }
                    J.Import compareTo = (J.Import)j;
                    if (!(_import.isStatic() == compareTo.isStatic() && _import.getPackageName().equals(compareTo.getPackageName()) && _import.getClassName().equals(compareTo.getClassName()) && TypeUtils.isOfType((JavaType)_import.getQualid().getType(), (JavaType)compareTo.getQualid().getType()))) {
                        this.isEqual.set(false);
                        return _import;
                    }
                }
                return _import;
            }

            public J.InstanceOf visitInstanceOf(J.InstanceOf instanceOf, J j) {
                if (this.isEqual.get()) {
                    if (!(j instanceof J.InstanceOf)) {
                        this.isEqual.set(false);
                        return instanceOf;
                    }
                    J.InstanceOf compareTo = (J.InstanceOf)j;
                    if (!TypeUtils.isOfType((JavaType)instanceOf.getType(), (JavaType)compareTo.getType()) || this.doesNotContainSameComments(instanceOf.getPrefix(), compareTo.getPrefix())) {
                        this.isEqual.set(false);
                        return instanceOf;
                    }
                    this.visit((Tree)instanceOf.getClazz(), compareTo.getClazz());
                    this.visit((Tree)instanceOf.getExpression(), compareTo.getExpression());
                }
                return instanceOf;
            }

            public J.Label visitLabel(J.Label label, J j) {
                if (this.isEqual.get()) {
                    if (!(j instanceof J.Label)) {
                        this.isEqual.set(false);
                        return label;
                    }
                    J.Label compareTo = (J.Label)j;
                    if (this.doesNotContainSameComments(label.getPrefix(), compareTo.getPrefix())) {
                        this.isEqual.set(false);
                        return label;
                    }
                    this.visit((Tree)label.getLabel(), compareTo.getLabel());
                    this.visit((Tree)label.getStatement(), compareTo.getStatement());
                }
                return label;
            }

            public J.Lambda visitLambda(J.Lambda lambda, J j) {
                if (this.isEqual.get()) {
                    if (!(j instanceof J.Lambda)) {
                        this.isEqual.set(false);
                        return lambda;
                    }
                    J.Lambda compareTo = (J.Lambda)j;
                    if (lambda.getParameters().isParenthesized() != compareTo.getParameters().isParenthesized() || lambda.getParameters().getParameters().size() != compareTo.getParameters().getParameters().size() || this.doesNotContainSameComments(lambda.getPrefix(), compareTo.getPrefix()) || this.doesNotContainSameComments(lambda.getArrow(), compareTo.getArrow())) {
                        this.isEqual.set(false);
                        return lambda;
                    }
                    this.visit((Tree)lambda.getBody(), compareTo.getBody());
                    for (int i = 0; i < lambda.getParameters().getParameters().size(); ++i) {
                        this.visit((Tree)lambda.getParameters().getParameters().get(i), (J)compareTo.getParameters().getParameters().get(i));
                    }
                }
                return lambda;
            }

            public J.Literal visitLiteral(J.Literal literal, J j) {
                if (this.isEqual.get()) {
                    if (!(j instanceof J.Literal)) {
                        this.isEqual.set(false);
                        return literal;
                    }
                    J.Literal compareTo = (J.Literal)j;
                    if (!TypeUtils.isOfType((JavaType)literal.getType(), (JavaType)compareTo.getType()) || !Objects.equals(literal.getValue(), compareTo.getValue()) || this.doesNotContainSameComments(literal.getPrefix(), compareTo.getPrefix())) {
                        this.isEqual.set(false);
                        return literal;
                    }
                }
                return literal;
            }

            public J.MemberReference visitMemberReference(J.MemberReference memberRef, J j) {
                if (this.isEqual.get()) {
                    if (!(j instanceof J.MemberReference)) {
                        this.isEqual.set(false);
                        return memberRef;
                    }
                    J.MemberReference compareTo = (J.MemberReference)j;
                    if (!TypeUtils.isOfType((JavaType)memberRef.getType(), (JavaType)compareTo.getType()) || !TypeUtils.isOfType((JavaType)memberRef.getVariableType(), (JavaType)compareTo.getVariableType()) || !TypeUtils.isOfType((JavaType)memberRef.getMethodType(), (JavaType)compareTo.getMethodType()) || this.nullMissMatch(memberRef.getTypeParameters(), compareTo.getTypeParameters()) || memberRef.getTypeParameters() != null && compareTo.getTypeParameters() != null && memberRef.getTypeParameters().size() != compareTo.getTypeParameters().size() || this.doesNotContainSameComments(memberRef.getPrefix(), compareTo.getPrefix())) {
                        this.isEqual.set(false);
                        return memberRef;
                    }
                    this.visit((Tree)memberRef.getReference(), compareTo.getReference());
                    this.visit((Tree)memberRef.getContaining(), compareTo.getContaining());
                    if (memberRef.getTypeParameters() != null && compareTo.getTypeParameters() != null) {
                        for (int i = 0; i < memberRef.getTypeParameters().size(); ++i) {
                            this.visit((Tree)memberRef.getTypeParameters().get(i), (J)compareTo.getTypeParameters().get(i));
                        }
                    }
                }
                return memberRef;
            }

            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, J j) {
                if (this.isEqual.get()) {
                    int i;
                    if (!(j instanceof J.MethodDeclaration)) {
                        this.isEqual.set(false);
                        return method;
                    }
                    J.MethodDeclaration compareTo = (J.MethodDeclaration)j;
                    if (!TypeUtils.isOfType((JavaType)method.getMethodType(), (JavaType)compareTo.getMethodType()) || method.getModifiers().size() != compareTo.getModifiers().size() || !new HashSet(method.getModifiers()).containsAll(compareTo.getModifiers()) || method.getLeadingAnnotations().size() != compareTo.getLeadingAnnotations().size() || method.getParameters().size() != compareTo.getParameters().size() || this.nullMissMatch(method.getReturnTypeExpression(), compareTo.getReturnTypeExpression()) || this.nullMissMatch(method.getTypeParameters(), compareTo.getTypeParameters()) || method.getTypeParameters() != null && compareTo.getTypeParameters() != null && method.getTypeParameters().size() != compareTo.getTypeParameters().size() || this.nullMissMatch(method.getThrows(), compareTo.getThrows()) || method.getThrows() != null && compareTo.getThrows() != null && method.getThrows().size() != compareTo.getThrows().size() || this.nullMissMatch(method.getBody(), compareTo.getBody()) || method.getBody().getStatements() != null && compareTo.getBody().getStatements() != null && method.getBody().getStatements().size() != compareTo.getBody().getStatements().size() || this.doesNotContainSameComments(method.getPrefix(), compareTo.getPrefix())) {
                        this.isEqual.set(false);
                        return method;
                    }
                    this.visit((Tree)method.getName(), compareTo.getName());
                    for (i = 0; i < method.getLeadingAnnotations().size(); ++i) {
                        this.visit((Tree)method.getLeadingAnnotations().get(i), (J)compareTo.getLeadingAnnotations().get(i));
                    }
                    for (i = 0; i < method.getParameters().size(); ++i) {
                        this.visit((Tree)method.getParameters().get(i), (J)compareTo.getParameters().get(i));
                    }
                    if (method.getReturnTypeExpression() != null && compareTo.getReturnTypeExpression() != null) {
                        this.visitTypeName(method.getReturnTypeExpression(), (J)compareTo.getReturnTypeExpression());
                    }
                    if (method.getTypeParameters() != null && compareTo.getTypeParameters() != null) {
                        for (i = 0; i < method.getTypeParameters().size(); ++i) {
                            this.visit((Tree)method.getTypeParameters().get(i), (J)compareTo.getTypeParameters().get(i));
                        }
                    }
                    if (method.getThrows() != null && compareTo.getThrows() != null) {
                        for (i = 0; i < method.getThrows().size(); ++i) {
                            this.visitTypeName((NameTree)method.getThrows().get(i), (J)compareTo.getThrows().get(i));
                        }
                    }
                    if (method.getBody() != null && compareTo.getBody() != null) {
                        this.visit((Tree)method.getBody(), compareTo.getBody());
                    }
                }
                return method;
            }

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, J j) {
                if (this.isEqual.get()) {
                    int i;
                    if (!(j instanceof J.MethodInvocation)) {
                        this.isEqual.set(false);
                        return method;
                    }
                    J.MethodInvocation compareTo = (J.MethodInvocation)j;
                    if (!TypeUtils.isOfType((JavaType)method.getMethodType(), (JavaType)compareTo.getMethodType()) || this.nullMissMatch(method.getSelect(), compareTo.getSelect()) || method.getArguments().size() != compareTo.getArguments().size() || method.getTypeParameters() != null && compareTo.getTypeParameters() != null && method.getTypeParameters().size() != compareTo.getTypeParameters().size() || this.doesNotContainSameComments(method.getPrefix(), compareTo.getPrefix())) {
                        this.isEqual.set(false);
                        return method;
                    }
                    this.visit((Tree)method.getName(), compareTo.getName());
                    this.visit((Tree)method.getSelect(), compareTo.getSelect());
                    boolean containsLiteral = false;
                    for (i = 0; i < method.getArguments().size(); ++i) {
                        if (!(method.getArguments().get(i) instanceof J.Literal) && !(compareTo.getArguments().get(i) instanceof J.Literal)) continue;
                        containsLiteral = true;
                        break;
                    }
                    if (!(containsLiteral || !this.nullMissMatch(method.getMethodType(), compareTo.getMethodType()) && TypeUtils.isOfType((JavaType)method.getMethodType(), (JavaType)compareTo.getMethodType()))) {
                        this.isEqual.set(false);
                        return method;
                    }
                    if (containsLiteral) {
                        for (i = 0; i < method.getArguments().size(); ++i) {
                            this.visit((Tree)method.getArguments().get(i), (J)compareTo.getArguments().get(i));
                        }
                    }
                    if (method.getTypeParameters() != null && compareTo.getTypeParameters() != null) {
                        for (i = 0; i < method.getTypeParameters().size(); ++i) {
                            this.visit((Tree)method.getTypeParameters().get(i), (J)compareTo.getTypeParameters().get(i));
                        }
                    }
                }
                return method;
            }

            public J.MultiCatch visitMultiCatch(J.MultiCatch multiCatch, J j) {
                if (this.isEqual.get()) {
                    int i;
                    if (!(j instanceof J.MultiCatch)) {
                        this.isEqual.set(false);
                        return multiCatch;
                    }
                    J.MultiCatch compareTo = (J.MultiCatch)j;
                    if (!(multiCatch.getType() instanceof JavaType.MultiCatch) || !(compareTo.getType() instanceof JavaType.MultiCatch) || ((JavaType.MultiCatch)multiCatch.getType()).getThrowableTypes().size() != ((JavaType.MultiCatch)compareTo.getType()).getThrowableTypes().size() || multiCatch.getAlternatives().size() != compareTo.getAlternatives().size() || this.doesNotContainSameComments(multiCatch.getPrefix(), compareTo.getPrefix())) {
                        this.isEqual.set(false);
                        return multiCatch;
                    }
                    for (i = 0; i < ((JavaType.MultiCatch)multiCatch.getType()).getThrowableTypes().size(); ++i) {
                        JavaType second;
                        JavaType first = (JavaType)((JavaType.MultiCatch)multiCatch.getType()).getThrowableTypes().get(i);
                        if (TypeUtils.isOfType((JavaType)first, (JavaType)(second = (JavaType)((JavaType.MultiCatch)compareTo.getType()).getThrowableTypes().get(i)))) continue;
                        this.isEqual.set(false);
                        return multiCatch;
                    }
                    for (i = 0; i < multiCatch.getAlternatives().size(); ++i) {
                        this.visit((Tree)multiCatch.getAlternatives().get(i), (J)compareTo.getAlternatives().get(i));
                    }
                }
                return multiCatch;
            }

            public J.NewArray visitNewArray(J.NewArray newArray, J j) {
                if (this.isEqual.get()) {
                    int i;
                    if (!(j instanceof J.NewArray)) {
                        this.isEqual.set(false);
                        return newArray;
                    }
                    J.NewArray compareTo = (J.NewArray)j;
                    if (!TypeUtils.isOfType((JavaType)newArray.getType(), (JavaType)compareTo.getType()) || newArray.getDimensions().size() != compareTo.getDimensions().size() || this.nullMissMatch(newArray.getTypeExpression(), compareTo.getTypeExpression()) || this.nullMissMatch(newArray.getInitializer(), compareTo.getInitializer()) || newArray.getInitializer() != null && compareTo.getInitializer() != null && newArray.getInitializer().size() != compareTo.getInitializer().size() || this.doesNotContainSameComments(newArray.getPrefix(), compareTo.getPrefix())) {
                        this.isEqual.set(false);
                        return newArray;
                    }
                    for (i = 0; i < newArray.getDimensions().size(); ++i) {
                        this.visit((Tree)newArray.getDimensions().get(i), (J)compareTo.getDimensions().get(i));
                    }
                    if (newArray.getTypeExpression() != null && compareTo.getTypeExpression() != null) {
                        this.visit((Tree)newArray.getTypeExpression(), compareTo.getTypeExpression());
                    }
                    if (newArray.getInitializer() != null && compareTo.getInitializer() != null) {
                        for (i = 0; i < newArray.getInitializer().size(); ++i) {
                            this.visit((Tree)newArray.getInitializer().get(i), (J)compareTo.getInitializer().get(i));
                        }
                    }
                }
                return newArray;
            }

            public J.NewClass visitNewClass(J.NewClass newClass, J j) {
                if (this.isEqual.get()) {
                    int i;
                    if (!(j instanceof J.NewClass)) {
                        this.isEqual.set(false);
                        return newClass;
                    }
                    J.NewClass compareTo = (J.NewClass)j;
                    if (!TypeUtils.isOfType((JavaType)newClass.getType(), (JavaType)compareTo.getType()) || !TypeUtils.isOfType((JavaType)newClass.getConstructorType(), (JavaType)compareTo.getConstructorType()) || this.nullMissMatch(newClass.getEnclosing(), compareTo.getEnclosing()) || this.nullMissMatch(newClass.getClazz(), compareTo.getClazz()) || this.nullMissMatch(newClass.getConstructorType(), compareTo.getConstructorType()) || this.nullMissMatch(newClass.getBody(), compareTo.getBody()) || this.nullMissMatch(newClass.getArguments(), compareTo.getArguments()) || newClass.getArguments().size() != compareTo.getArguments().size() || this.doesNotContainSameComments(newClass.getPrefix(), compareTo.getPrefix()) || this.doesNotContainSameComments(newClass.getNew(), compareTo.getNew())) {
                        this.isEqual.set(false);
                        return newClass;
                    }
                    if (newClass.getEnclosing() != null && compareTo.getEnclosing() != null) {
                        this.visit((Tree)newClass.getEnclosing(), compareTo.getEnclosing());
                    }
                    if (newClass.getClazz() != null && compareTo.getClazz() != null) {
                        this.visit((Tree)newClass.getClazz(), compareTo.getClazz());
                    }
                    if (newClass.getBody() != null && compareTo.getBody() != null) {
                        this.visit((Tree)newClass.getBody(), compareTo.getBody());
                    }
                    boolean containsLiteral = false;
                    for (i = 0; i < newClass.getArguments().size(); ++i) {
                        if (!(newClass.getArguments().get(i) instanceof J.Literal) && !(compareTo.getArguments().get(i) instanceof J.Literal)) continue;
                        containsLiteral = true;
                        break;
                    }
                    if (!containsLiteral && (this.nullMissMatch(newClass.getConstructorType(), compareTo.getConstructorType()) || newClass.getConstructorType() != null && compareTo.getConstructorType() != null && !TypeUtils.isOfType((JavaType)newClass.getConstructorType(), (JavaType)compareTo.getConstructorType()))) {
                        this.isEqual.set(false);
                        return newClass;
                    }
                    if (containsLiteral) {
                        for (i = 0; i < newClass.getArguments().size(); ++i) {
                            this.visit((Tree)newClass.getArguments().get(i), (J)compareTo.getArguments().get(i));
                        }
                    }
                }
                return newClass;
            }

            public J.Package visitPackage(J.Package pkg, J j) {
                if (this.isEqual.get()) {
                    if (!(j instanceof J.Package)) {
                        this.isEqual.set(false);
                        return pkg;
                    }
                    J.Package compareTo = (J.Package)j;
                    if (pkg.getAnnotations().size() != compareTo.getAnnotations().size() || !pkg.getExpression().toString().equals(compareTo.getExpression().toString())) {
                        this.isEqual.set(false);
                        return pkg;
                    }
                    for (int i = 0; i < pkg.getAnnotations().size(); ++i) {
                        this.visit((Tree)pkg.getAnnotations().get(i), (J)compareTo.getAnnotations().get(i));
                    }
                }
                return pkg;
            }

            public J.ParameterizedType visitParameterizedType(J.ParameterizedType type, J j) {
                if (this.isEqual.get()) {
                    if (!(j instanceof J.ParameterizedType)) {
                        this.isEqual.set(false);
                        return type;
                    }
                    J.ParameterizedType compareTo = (J.ParameterizedType)j;
                    if (!TypeUtils.isOfType((JavaType)type.getType(), (JavaType)compareTo.getType()) || this.nullMissMatch(type.getTypeParameters(), compareTo.getTypeParameters()) || type.getTypeParameters() != null && compareTo.getTypeParameters() != null && type.getTypeParameters().size() != compareTo.getTypeParameters().size() || this.doesNotContainSameComments(type.getPrefix(), compareTo.getPrefix())) {
                        this.isEqual.set(false);
                        return type;
                    }
                    if (type.getTypeParameters() != null && compareTo.getTypeParameters() != null) {
                        for (int i = 0; i < type.getTypeParameters().size(); ++i) {
                            this.visit((Tree)type.getTypeParameters().get(i), (J)compareTo.getTypeParameters().get(i));
                        }
                    }
                }
                return type;
            }

            public <T extends J> J.Parentheses<T> visitParentheses(J.Parentheses<T> parens, J j) {
                if (this.isEqual.get()) {
                    if (!(j instanceof J.Parentheses)) {
                        this.isEqual.set(false);
                        return parens;
                    }
                    J.Parentheses compareTo = (J.Parentheses)j;
                    if (this.doesNotContainSameComments(parens.getPrefix(), compareTo.getPrefix())) {
                        this.isEqual.set(false);
                        return parens;
                    }
                    this.visit((Tree)parens.getTree(), compareTo.getTree());
                }
                return parens;
            }

            public J.Primitive visitPrimitive(J.Primitive primitive, J j) {
                if (this.isEqual.get()) {
                    if (!(j instanceof J.Primitive)) {
                        this.isEqual.set(false);
                        return primitive;
                    }
                    J.Primitive compareTo = (J.Primitive)j;
                    if (!TypeUtils.isOfType((JavaType)primitive.getType(), (JavaType)compareTo.getType()) || this.doesNotContainSameComments(primitive.getPrefix(), compareTo.getPrefix())) {
                        this.isEqual.set(false);
                        return primitive;
                    }
                }
                return primitive;
            }

            public J.Return visitReturn(J.Return _return, J j) {
                if (this.isEqual.get()) {
                    if (!(j instanceof J.Return)) {
                        this.isEqual.set(false);
                        return _return;
                    }
                    J.Return compareTo = (J.Return)j;
                    if (this.nullMissMatch(_return.getExpression(), compareTo.getExpression()) || this.doesNotContainSameComments(_return.getPrefix(), compareTo.getPrefix())) {
                        this.isEqual.set(false);
                        return _return;
                    }
                    if (_return.getExpression() != null && compareTo.getExpression() != null) {
                        this.visit((Tree)_return.getExpression(), compareTo.getExpression());
                    }
                }
                return _return;
            }

            public J.Switch visitSwitch(J.Switch _switch, J j) {
                if (this.isEqual.get()) {
                    if (!(j instanceof J.Switch)) {
                        this.isEqual.set(false);
                        return _switch;
                    }
                    J.Switch compareTo = (J.Switch)j;
                    if (this.doesNotContainSameComments(_switch.getPrefix(), compareTo.getPrefix())) {
                        this.isEqual.set(false);
                        return _switch;
                    }
                    this.visit((Tree)_switch.getCases(), compareTo.getCases());
                }
                return _switch;
            }

            public J.Synchronized visitSynchronized(J.Synchronized _sync, J j) {
                if (this.isEqual.get()) {
                    if (!(j instanceof J.Synchronized)) {
                        this.isEqual.set(false);
                        return _sync;
                    }
                    J.Synchronized compareTo = (J.Synchronized)j;
                    if (this.doesNotContainSameComments(_sync.getPrefix(), compareTo.getPrefix())) {
                        this.isEqual.set(false);
                        return _sync;
                    }
                    this.visit((Tree)_sync.getLock(), compareTo.getLock());
                    this.visit((Tree)_sync.getBody(), compareTo.getBody());
                }
                return _sync;
            }

            public J.Ternary visitTernary(J.Ternary ternary, J j) {
                if (this.isEqual.get()) {
                    if (!(j instanceof J.Ternary)) {
                        this.isEqual.set(false);
                        return ternary;
                    }
                    J.Ternary compareTo = (J.Ternary)j;
                    if (!TypeUtils.isOfType((JavaType)ternary.getType(), (JavaType)compareTo.getType()) || this.doesNotContainSameComments(ternary.getPrefix(), compareTo.getPrefix())) {
                        this.isEqual.set(false);
                        return ternary;
                    }
                    this.visit((Tree)ternary.getCondition(), compareTo.getCondition());
                    this.visit((Tree)ternary.getTruePart(), compareTo.getTruePart());
                    this.visit((Tree)ternary.getFalsePart(), compareTo.getFalsePart());
                }
                return ternary;
            }

            public J.Throw visitThrow(J.Throw thrown, J j) {
                if (this.isEqual.get()) {
                    if (!(j instanceof J.Throw)) {
                        this.isEqual.set(false);
                        return thrown;
                    }
                    J.Throw compareTo = (J.Throw)j;
                    if (this.doesNotContainSameComments(thrown.getPrefix(), compareTo.getPrefix())) {
                        this.isEqual.set(false);
                        return thrown;
                    }
                    this.visit((Tree)thrown.getException(), compareTo.getException());
                }
                return thrown;
            }

            public J.Try visitTry(J.Try _try, J j) {
                if (this.isEqual.get()) {
                    int i;
                    if (!(j instanceof J.Try)) {
                        this.isEqual.set(false);
                        return _try;
                    }
                    J.Try compareTo = (J.Try)j;
                    if (_try.getCatches().size() != compareTo.getCatches().size() || this.nullMissMatch(_try.getFinally(), compareTo.getFinally()) || this.nullMissMatch(_try.getResources(), compareTo.getResources()) || _try.getResources() != null && compareTo.getResources() != null && _try.getResources().size() != compareTo.getResources().size() || this.doesNotContainSameComments(_try.getPrefix(), compareTo.getPrefix())) {
                        this.isEqual.set(false);
                        return _try;
                    }
                    this.visit((Tree)_try.getBody(), compareTo.getBody());
                    for (i = 0; i < _try.getCatches().size(); ++i) {
                        this.visit((Tree)_try.getCatches().get(i), (J)compareTo.getCatches().get(i));
                    }
                    if (_try.getResources() != null && compareTo.getResources() != null) {
                        for (i = 0; i < _try.getResources().size(); ++i) {
                            this.visit((Tree)_try.getResources().get(i), (J)compareTo.getResources().get(i));
                        }
                    }
                    if (_try.getFinally() != null && compareTo.getFinally() != null) {
                        this.visit((Tree)_try.getFinally(), compareTo.getFinally());
                    }
                }
                return _try;
            }

            public J.Try.Resource visitTryResource(J.Try.Resource tryResource, J j) {
                if (this.isEqual.get()) {
                    if (!(j instanceof J.Try.Resource)) {
                        this.isEqual.set(false);
                        return tryResource;
                    }
                    J.Try.Resource compareTo = (J.Try.Resource)j;
                    if (tryResource.isTerminatedWithSemicolon() != compareTo.isTerminatedWithSemicolon() || this.doesNotContainSameComments(tryResource.getPrefix(), compareTo.getPrefix())) {
                        this.isEqual.set(false);
                        return tryResource;
                    }
                    this.visit((Tree)tryResource.getVariableDeclarations(), compareTo.getVariableDeclarations());
                }
                return tryResource;
            }

            public J.TypeCast visitTypeCast(J.TypeCast typeCast, J j) {
                if (this.isEqual.get()) {
                    if (!(j instanceof J.TypeCast)) {
                        this.isEqual.set(false);
                        return typeCast;
                    }
                    J.TypeCast compareTo = (J.TypeCast)j;
                    if (this.doesNotContainSameComments(typeCast.getPrefix(), compareTo.getPrefix())) {
                        this.isEqual.set(false);
                        return typeCast;
                    }
                    this.visit((Tree)typeCast.getClazz(), compareTo.getClazz());
                    this.visit((Tree)typeCast.getExpression(), compareTo.getExpression());
                }
                return typeCast;
            }

            public J.TypeParameter visitTypeParameter(J.TypeParameter typeParam, J j) {
                if (this.isEqual.get()) {
                    int i;
                    if (!(j instanceof J.TypeParameter)) {
                        this.isEqual.set(false);
                        return typeParam;
                    }
                    J.TypeParameter compareTo = (J.TypeParameter)j;
                    if (typeParam.getAnnotations().size() != compareTo.getAnnotations().size() || this.nullMissMatch(typeParam.getBounds(), compareTo.getBounds()) || typeParam.getBounds().size() != compareTo.getBounds().size() || this.doesNotContainSameComments(typeParam.getPrefix(), compareTo.getPrefix())) {
                        this.isEqual.set(false);
                        return typeParam;
                    }
                    this.visit((Tree)typeParam.getName(), compareTo.getName());
                    for (i = 0; i < typeParam.getAnnotations().size(); ++i) {
                        this.visit((Tree)typeParam.getAnnotations().get(i), (J)compareTo.getAnnotations().get(i));
                    }
                    if (typeParam.getBounds() != null && compareTo.getBounds() != null) {
                        for (i = 0; i < typeParam.getBounds().size(); ++i) {
                            this.visit((Tree)typeParam.getBounds().get(i), (J)compareTo.getBounds().get(i));
                        }
                    }
                }
                return typeParam;
            }

            public J.Unary visitUnary(J.Unary unary, J j) {
                if (this.isEqual.get()) {
                    if (!(j instanceof J.Unary)) {
                        this.isEqual.set(false);
                        return unary;
                    }
                    J.Unary compareTo = (J.Unary)j;
                    if (this.nullMissMatch(unary.getType(), compareTo.getType()) || !TypeUtils.isOfType((JavaType)unary.getType(), (JavaType)compareTo.getType()) || unary.getOperator() != compareTo.getOperator() || this.doesNotContainSameComments(unary.getPrefix(), compareTo.getPrefix())) {
                        this.isEqual.set(false);
                        return unary;
                    }
                    this.visit((Tree)unary.getExpression(), compareTo.getExpression());
                }
                return unary;
            }

            public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, J j) {
                if (this.isEqual.get()) {
                    int i;
                    if (!(j instanceof J.VariableDeclarations)) {
                        this.isEqual.set(false);
                        return multiVariable;
                    }
                    J.VariableDeclarations compareTo = (J.VariableDeclarations)j;
                    if (!TypeUtils.isOfType((JavaType)multiVariable.getType(), (JavaType)compareTo.getType()) || this.nullMissMatch(multiVariable.getTypeExpression(), compareTo.getTypeExpression()) || multiVariable.getVariables().size() != compareTo.getVariables().size() || multiVariable.getLeadingAnnotations().size() != compareTo.getLeadingAnnotations().size() || this.doesNotContainSameComments(multiVariable.getPrefix(), compareTo.getPrefix()) || this.doesNotContainSameComments(multiVariable.getVarargs(), compareTo.getVarargs())) {
                        this.isEqual.set(false);
                        return multiVariable;
                    }
                    if (multiVariable.getTypeExpression() != null && compareTo.getTypeExpression() != null) {
                        this.visitTypeName(multiVariable.getTypeExpression(), (J)compareTo.getTypeExpression());
                    }
                    for (i = 0; i < multiVariable.getLeadingAnnotations().size(); ++i) {
                        this.visit((Tree)multiVariable.getLeadingAnnotations().get(i), (J)compareTo.getLeadingAnnotations().get(i));
                    }
                    for (i = 0; i < multiVariable.getVariables().size(); ++i) {
                        this.visit((Tree)multiVariable.getVariables().get(i), (J)compareTo.getVariables().get(i));
                    }
                }
                return multiVariable;
            }

            public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, J j) {
                if (this.isEqual.get()) {
                    if (!(j instanceof J.VariableDeclarations.NamedVariable)) {
                        this.isEqual.set(false);
                        return variable;
                    }
                    J.VariableDeclarations.NamedVariable compareTo = (J.VariableDeclarations.NamedVariable)j;
                    if (!TypeUtils.isOfType((JavaType)variable.getType(), (JavaType)compareTo.getType()) || this.nullMissMatch(variable.getInitializer(), compareTo.getInitializer()) || this.doesNotContainSameComments(variable.getPrefix(), compareTo.getPrefix())) {
                        this.isEqual.set(false);
                        return variable;
                    }
                    this.visit((Tree)variable.getName(), compareTo.getName());
                    if (variable.getInitializer() != null && compareTo.getInitializer() != null) {
                        this.visit((Tree)variable.getInitializer(), compareTo.getInitializer());
                    }
                }
                return variable;
            }

            public J.WhileLoop visitWhileLoop(J.WhileLoop whileLoop, J j) {
                if (this.isEqual.get()) {
                    if (!(j instanceof J.WhileLoop)) {
                        this.isEqual.set(false);
                        return whileLoop;
                    }
                    J.WhileLoop compareTo = (J.WhileLoop)j;
                    if (this.doesNotContainSameComments(whileLoop.getPrefix(), compareTo.getPrefix())) {
                        this.isEqual.set(false);
                        return whileLoop;
                    }
                    this.visit((Tree)whileLoop.getBody(), compareTo.getBody());
                    this.visit((Tree)whileLoop.getCondition(), compareTo.getCondition());
                }
                return whileLoop;
            }

            public J.Wildcard visitWildcard(J.Wildcard wildcard, J j) {
                if (this.isEqual.get()) {
                    if (!(j instanceof J.Wildcard)) {
                        this.isEqual.set(false);
                        return wildcard;
                    }
                    J.Wildcard compareTo = (J.Wildcard)j;
                    if (wildcard.getBound() != compareTo.getBound() || this.nullMissMatch(wildcard.getBoundedType(), compareTo.getBoundedType()) || this.doesNotContainSameComments(wildcard.getPrefix(), compareTo.getPrefix())) {
                        this.isEqual.set(false);
                        return wildcard;
                    }
                    if (wildcard.getBoundedType() != null && compareTo.getBoundedType() != null) {
                        this.visitTypeName(wildcard.getBoundedType(), (J)compareTo.getBoundedType());
                    }
                }
                return wildcard;
            }

            public <N extends NameTree> N visitTypeName(N firstTypeName, J j) {
                if (this.isEqual.get() && (!(j instanceof NameTree) && !TypeUtils.isOfType((JavaType)firstTypeName.getType(), (JavaType)((NameTree)j).getType()) || this.doesNotContainSameComments(firstTypeName.getPrefix(), j.getPrefix()))) {
                    this.isEqual.set(false);
                    return firstTypeName;
                }
                return firstTypeName;
            }
        }
    }
}

