/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.Collections;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeUtils;

public class EqualsToContentEquals
extends Recipe {
    private static final TreeVisitor<?, ExecutionContext> PRECONDITION = Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.lang.CharSequence", Boolean.valueOf(false)), new UsesType("java.lang.StringBuffer", Boolean.valueOf(false)), new UsesType("java.lang.StringBuilder", Boolean.valueOf(false))});

    public String getDisplayName() {
        return "Use `String.contentEquals(CharSequence)` instead of `String.equals(CharSequence.toString())`";
    }

    public String getDescription() {
        return "Use `String.contentEquals(CharSequence)` instead of `String.equals(CharSequence.toString())`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check(PRECONDITION, (TreeVisitor)new EqualsToContentEqualsVisitor());
    }

    private static class EqualsToContentEqualsVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private static final MethodMatcher EQUALS_MATCHER = new MethodMatcher("String equals(Object)");
        private static final MethodMatcher TOSTRING_MATCHER = new MethodMatcher("java.lang.* toString()");

        private EqualsToContentEqualsVisitor() {
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation mi, ExecutionContext ctx) {
            J.MethodInvocation m = super.visitMethodInvocation(mi, (Object)ctx);
            if (!EQUALS_MATCHER.matches((MethodCall)m)) {
                return m;
            }
            Expression equalsArgument = (Expression)m.getArguments().get(0);
            if (!TOSTRING_MATCHER.matches(equalsArgument)) {
                return m;
            }
            J.MethodInvocation inv = (J.MethodInvocation)equalsArgument;
            Expression toStringSelect = inv.getSelect();
            if (toStringSelect == null || !TypeUtils.isAssignableTo((String)"java.lang.CharSequence", (JavaType)toStringSelect.getType())) {
                return m;
            }
            return m.withArguments(Collections.singletonList(toStringSelect)).withName(m.getName().withSimpleName("contentEquals"));
        }
    }
}

