/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.marker.Markers;

public class RemoveInstanceOfPatternMatch
extends Recipe {
    public String getDisplayName() {
        return "Removes from code Java 14's `instanceof` pattern matching";
    }

    public String getDescription() {
        return "Adds an explicit variable declaration at the beginning of `if` statement instead of `instanceof` pattern matching.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(1L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesJavaVersion(14), (TreeVisitor)new RemoveInstanceOfPatternMatchVisitor());
    }

    private static class RemoveInstanceOfPatternMatchVisitor
    extends JavaVisitor<ExecutionContext> {
        private VariableUsage variableUsage;

        private RemoveInstanceOfPatternMatchVisitor() {
        }

        public J visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
            this.variableUsage = VariableUsageAnalyzer.analyze((J)cu);
            J.CompilationUnit result = (J.CompilationUnit)super.visitCompilationUnit(cu, (Object)ctx);
            this.variableUsage = null;
            return result;
        }

        public J visitInstanceOf(J.InstanceOf instanceOf, ExecutionContext ctx) {
            return super.visitInstanceOf(instanceOf.withPattern(null), (Object)ctx);
        }

        public J visitIdentifier(J.Identifier identifier, ExecutionContext ctx) {
            J.InstanceOf instanceOf = this.variableUsage.conditions.get(identifier);
            if (instanceOf != null) {
                J.Parentheses<J> result = this.autoFormat((J)this.typeCast((TypeTree)instanceOf.getClazz(), instanceOf.getExpression()), ctx);
                Object parent = this.getCursor().getParentTreeCursor().getValue();
                if (parent instanceof J.MethodInvocation) {
                    result = this.parentheses((J)result);
                }
                return result.withPrefix(identifier.getPrefix());
            }
            return identifier;
        }

        public J.If visitIf(J.If iff, ExecutionContext ctx) {
            J.If result = (J.If)super.visitIf(iff, (Object)ctx);
            this.updateCursor((Tree)result);
            Set<J.InstanceOf> thenInstanceOfs = this.variableUsage.thenParts.get(iff);
            if (thenInstanceOfs != null) {
                if (!(result.getThenPart() instanceof J.Block)) {
                    result = (J.If)this.autoFormat((J)result.withThenPart((Statement)J.Block.createEmptyBlock().withStatements(Collections.singletonList(result.getThenPart()))), ctx);
                    this.updateCursor((Tree)result);
                }
                Iterator<J.InstanceOf> iter = this.variableUsage.declarations.get(iff).descendingIterator();
                while (iter.hasNext()) {
                    J.InstanceOf instanceOf = iter.next();
                    if (!thenInstanceOfs.contains(instanceOf)) continue;
                    Cursor blockCursor = new Cursor(this.getCursor(), (Object)result.getThenPart());
                    result = result.withThenPart((Statement)this.addVariableDeclaration(blockCursor, instanceOf, ctx));
                    this.updateCursor((Tree)result);
                }
            }
            Set<J.InstanceOf> elseInstanceOfs = this.variableUsage.elseParts.get(iff.getElsePart());
            J.If.Else elsePart = result.getElsePart();
            if (elsePart != null && elseInstanceOfs != null) {
                if (!(elsePart.getBody() instanceof J.Block)) {
                    result = (J.If)this.autoFormat((J)result.withElsePart(elsePart.withBody((Statement)J.Block.createEmptyBlock().withStatements(Collections.singletonList(elsePart.getBody())))), ctx);
                    this.updateCursor((Tree)result);
                    elsePart = result.getElsePart();
                }
                if (elsePart != null) {
                    Iterator<J.InstanceOf> iter = this.variableUsage.declarations.get(iff).descendingIterator();
                    while (iter.hasNext()) {
                        J.InstanceOf instanceOf = iter.next();
                        if (!elseInstanceOfs.contains(instanceOf)) continue;
                        Cursor blockCursor = new Cursor(new Cursor(this.getCursor(), (Object)elsePart), (Object)elsePart.getBody());
                        result = result.withElsePart(elsePart.withBody((Statement)this.addVariableDeclaration(blockCursor, instanceOf, ctx)));
                    }
                }
            }
            return result;
        }

        private J.Block addVariableDeclaration(Cursor blockCursor, J.InstanceOf instanceOf, ExecutionContext ctx) {
            J.Block block = (J.Block)blockCursor.getValue();
            JavaTemplate template = JavaTemplate.builder((String)"#{} #{} = (#{}) #{any()};").contextSensitive().build();
            return (J.Block)template.apply(blockCursor, block.getCoordinates().firstStatement(), new Object[]{instanceOf.getClazz().toString(), ((J.Identifier)Objects.requireNonNull(instanceOf.getPattern())).getSimpleName(), instanceOf.getClazz().toString(), this.visit((Tree)instanceOf.getExpression(), ctx)});
        }

        private J.TypeCast typeCast(TypeTree typeTree, Expression expression) {
            return new J.TypeCast(Tree.randomId(), Space.EMPTY, Markers.EMPTY, new J.ControlParentheses(Tree.randomId(), Space.EMPTY, Markers.EMPTY, this.padRight(typeTree)), expression);
        }

        private <T extends J> J.Parentheses<T> parentheses(T tree) {
            return new J.Parentheses(Tree.randomId(), Space.EMPTY, Markers.EMPTY, this.padRight(tree));
        }

        private <T> JRightPadded<T> padRight(T tree) {
            return new JRightPadded(tree, Space.EMPTY, Markers.EMPTY);
        }
    }

    private static class VariableUsageAnalyzer
    extends JavaIsoVisitor<J> {
        private final Map<String, J.InstanceOf> currentScope = new HashMap<String, J.InstanceOf>();
        private final Map<J.InstanceOf, J> parentTrees = new HashMap<J.InstanceOf, J>();
        private final VariableUsage variableUsage = new VariableUsage();

        private VariableUsageAnalyzer() {
        }

        public static VariableUsage analyze(J tree) {
            VariableUsageAnalyzer collector = new VariableUsageAnalyzer();
            collector.visit((Tree)tree, tree);
            collector.currentScope.clear();
            return collector.variableUsage;
        }

        public J.If visitIf(J.If iff, J contextTree) {
            return iff.withIfCondition((J.ControlParentheses)this.visitAndCast((Tree)iff.getIfCondition(), iff)).withThenPart(Objects.requireNonNull((Statement)this.visitAndCast((Tree)iff.getThenPart(), iff))).withElsePart((J.If.Else)this.visitAndCast((Tree)iff.getElsePart(), iff));
        }

        public J.Ternary visitTernary(J.Ternary ternary, J contextTree) {
            return super.visitTernary(ternary, (Object)ternary);
        }

        public J.InstanceOf visitInstanceOf(J.InstanceOf instanceOf, J contextTree) {
            if (instanceOf.getPattern() instanceof J.Identifier) {
                String variableName = ((J.Identifier)instanceOf.getPattern()).getSimpleName();
                this.currentScope.put(variableName, instanceOf);
                this.parentTrees.put(instanceOf, contextTree);
                if (contextTree instanceof J.If) {
                    this.variableUsage.declarations.computeIfAbsent((J.If)contextTree, k -> new LinkedList()).add(instanceOf);
                }
            }
            this.visit((Tree)instanceOf.getExpression(), contextTree);
            return instanceOf;
        }

        public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, J contextTree) {
            this.currentScope.remove(variable.getSimpleName());
            this.visit((Tree)variable.getInitializer(), contextTree);
            return variable;
        }

        public J.Identifier visitIdentifier(J.Identifier identifier, J contextTree) {
            J.InstanceOf instanceOf = this.currentScope.get(identifier.getSimpleName());
            if (instanceOf != null) {
                J parentTree = this.parentTrees.get(instanceOf);
                switch (this.getUsageContext(parentTree).ordinal()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        this.variableUsage.conditions.put(identifier, instanceOf);
                        break;
                    }
                    case 2: {
                        this.variableUsage.thenParts.computeIfAbsent((J.If)parentTree, k -> new HashSet()).add(instanceOf);
                        break;
                    }
                    case 3: {
                        this.currentScope.get(identifier.getSimpleName());
                        this.variableUsage.elseParts.computeIfAbsent(((J.If)parentTree).getElsePart(), k -> new HashSet()).add(instanceOf);
                    }
                }
            }
            return identifier;
        }

        private UsageContext getUsageContext(J parentTree) {
            if (parentTree instanceof J.If) {
                J.If iff = (J.If)parentTree;
                Iterator iter = this.getCursor().getPath();
                while (iter.hasNext()) {
                    Object tree = iter.next();
                    if (tree.equals(iff.getIfCondition())) {
                        return UsageContext.CONDITION;
                    }
                    if (tree.equals(iff.getThenPart())) {
                        return UsageContext.THEN_PART;
                    }
                    if (!tree.equals(iff.getElsePart())) continue;
                    return UsageContext.ELSE_PART;
                }
            } else if (parentTree instanceof J.Ternary) {
                return UsageContext.CONDITION;
            }
            return UsageContext.NONE;
        }
    }

    private static class VariableUsage {
        public Map<J.If, Deque<J.InstanceOf>> declarations = new HashMap<J.If, Deque<J.InstanceOf>>();
        public Map<J.Identifier, J.InstanceOf> conditions = new HashMap<J.Identifier, J.InstanceOf>();
        public Map<J.If, Set<J.InstanceOf>> thenParts = new HashMap<J.If, Set<J.InstanceOf>>();
        public Map<J.If.Else, Set<J.InstanceOf>> elseParts = new HashMap<J.If.Else, Set<J.InstanceOf>>();

        private VariableUsage() {
        }
    }

    private static enum UsageContext {
        NONE,
        CONDITION,
        THEN_PART,
        ELSE_PART;

    }
}

