/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.net.URI;
import java.net.URL;
import org.openrewrite.java.template.RecipeDescriptor;

@RecipeDescriptor(name="URL Equals and Hash Code", description="Uses of `equals()` and `hashCode()` cause `java.net.URL` to make blocking internet connections. Instead, use `java.net.URI`.", tags={"RSPEC-2112"})
public class URLEqualsHashCode {

    @RecipeDescriptor(name="URL Hash Code", description="Uses of `hashCode()` cause `java.net.URL` to make blocking internet connections. Instead, use `java.net.URI`.", tags={"RSPEC-2112"})
    public static class URLHashCode {
        int before(URL a) {
            return a.hashCode();
        }

        int after(URL a) {
            return URI.create(a.toString()).hashCode();
        }
    }

    @RecipeDescriptor(name="URL Equals", description="Uses of `equals()` cause `java.net.URL` to make blocking internet connections. Instead, use `java.net.URI`.", tags={"RSPEC-2112"})
    public static class URLEquals {
        boolean before(URL a, URL b) {
            return a.equals(b);
        }

        boolean after(URL a, URL b) {
            return URI.create(a.toString()).equals(URI.create(b.toString()));
        }
    }
}

