/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.hamcrest;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeUtils;

public class HamcrestMatcherToAssertJ
extends Recipe {
    @Option(displayName="Hamcrest Matcher", description="The Hamcrest `Matcher` to migrate to JUnit5.", example="equalTo", required=false)
    @Nullable
    String matcher;
    @Option(displayName="AssertJ Assertion", description="The AssertJ method to migrate to.", example="isEqualTo", required=false)
    @Nullable
    String assertion;
    @Option(displayName="Argument Type", description="The type of the argument to the Hamcrest `Matcher`.", example="java.math.BigDecimal", required=false)
    @Nullable
    String argumentType;

    public String getDisplayName() {
        return "Migrate from Hamcrest `Matcher` to AssertJ";
    }

    public String getDescription() {
        return "Migrate from Hamcrest `Matcher` to AssertJ assertions.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod("org.hamcrest.*Matchers " + this.matcher + "(..)"), (TreeVisitor)new MigrateToAssertJVisitor());
    }

    public HamcrestMatcherToAssertJ() {
    }

    @ConstructorProperties(value={"matcher", "assertion", "argumentType"})
    public HamcrestMatcherToAssertJ(@Nullable String matcher, @Nullable String assertion, @Nullable String argumentType) {
        this.matcher = matcher;
        this.assertion = assertion;
        this.argumentType = argumentType;
    }

    private class MigrateToAssertJVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private final MethodMatcher assertThatMatcher = new MethodMatcher("org.hamcrest.MatcherAssert assertThat(..)");
        private final MethodMatcher matchersMatcher;
        private final MethodMatcher subMatcher;
        private final MethodMatcher CLOSE_TO_MATCHER;

        private MigrateToAssertJVisitor() {
            this.matchersMatcher = new MethodMatcher("org.hamcrest.*Matchers " + HamcrestMatcherToAssertJ.this.matcher + "(..)");
            this.subMatcher = new MethodMatcher("org.hamcrest.*Matchers *(org.hamcrest.Matcher)");
            this.CLOSE_TO_MATCHER = new MethodMatcher("org.hamcrest.Matchers closeTo(..)");
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)ctx);
            if (this.assertThatMatcher.matches((MethodCall)mi)) {
                return this.replace(mi, ctx);
            }
            return mi;
        }

        private J.MethodInvocation replace(J.MethodInvocation mi, ExecutionContext ctx) {
            List mia = mi.getArguments();
            Expression reasonArgument = mia.size() == 3 ? (Expression)mia.get(0) : null;
            Expression actualArgument = (Expression)mia.get(mia.size() - 2);
            Expression matcherArgument = (Expression)mia.get(mia.size() - 1);
            if (!this.matchersMatcher.matches(matcherArgument) || this.subMatcher.matches(matcherArgument)) {
                return mi;
            }
            if (HamcrestMatcherToAssertJ.this.argumentType != null && !TypeUtils.isOfClassType((JavaType)actualArgument.getType(), (String)HamcrestMatcherToAssertJ.this.argumentType)) {
                return mi;
            }
            String actual = this.typeToIndicator(actualArgument.getType());
            J.MethodInvocation matcherArgumentMethod = (J.MethodInvocation)matcherArgument;
            JavaTemplate template = JavaTemplate.builder((String)String.format("assertThat(%s)" + (reasonArgument != null ? ".as(#{any(String)})" : "") + ".%s(%s)", actual, HamcrestMatcherToAssertJ.this.assertion, this.getArgumentsTemplate(matcherArgumentMethod))).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3.24"})).staticImports(new String[]{"org.assertj.core.api.Assertions.assertThat", "org.assertj.core.api.Assertions.within"}).build();
            this.maybeAddImport("org.assertj.core.api.Assertions", "assertThat");
            this.maybeAddImport("org.assertj.core.api.Assertions", "within");
            this.maybeRemoveImport("org.hamcrest.Matchers." + HamcrestMatcherToAssertJ.this.matcher);
            this.maybeRemoveImport("org.hamcrest.CoreMatchers." + HamcrestMatcherToAssertJ.this.matcher);
            this.maybeRemoveImport("org.hamcrest.MatcherAssert");
            this.maybeRemoveImport("org.hamcrest.MatcherAssert.assertThat");
            ArrayList<Expression> templateArguments = new ArrayList<Expression>();
            templateArguments.add(actualArgument);
            if (reasonArgument != null) {
                templateArguments.add(reasonArgument);
            }
            for (Expression originalArgument : matcherArgumentMethod.getArguments()) {
                if (originalArgument instanceof J.Empty) continue;
                templateArguments.add(originalArgument);
            }
            return (J.MethodInvocation)template.apply(this.getCursor(), mi.getCoordinates().replace(), templateArguments.toArray());
        }

        private String getArgumentsTemplate(J.MethodInvocation matcherArgument) {
            List methodArguments = matcherArgument.getArguments();
            if (this.CLOSE_TO_MATCHER.matches((MethodCall)matcherArgument)) {
                return String.format("%s, within(%s)", this.typeToIndicator(((Expression)methodArguments.get(0)).getType()), this.typeToIndicator(((Expression)methodArguments.get(1)).getType()));
            }
            return methodArguments.stream().filter(a -> !(a instanceof J.Empty)).map(a -> this.typeToIndicator(a.getType())).collect(Collectors.joining(", "));
        }

        private String typeToIndicator(JavaType type) {
            if (type instanceof JavaType.Array) {
                String str = (type = ((JavaType.Array)type).getElemType()) instanceof JavaType.Primitive || type.toString().startsWith("java.") ? type.toString().replaceAll("<.*>", "") : "java.lang.Object";
                return String.format("#{anyArray(%s)}", str);
            }
            String str = type instanceof JavaType.Primitive || type.toString().startsWith("java.") ? type.toString().replaceAll("<.*>", "") : "java.lang.Object";
            return String.format("#{any(%s)}", str);
        }
    }
}

