/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.junit5;

import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.ChangeType;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.FindImports;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markup;

public class UpdateTestAnnotation
extends Recipe {
    public String getDisplayName() {
        return "Migrate JUnit 4 `@Test` annotations to JUnit 5";
    }

    public String getDescription() {
        return "Update usages of JUnit 4's `@org.junit.Test` annotation to JUnit 5's `org.junit.jupiter.api.Test` annotation.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("org.junit.Test", Boolean.valueOf(false)), new FindImports("org.junit.Test", null).getVisitor()}), (TreeVisitor)new UpdateTestAnnotationVisitor());
    }

    private static class UpdateTestAnnotationVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private static final AnnotationMatcher JUNIT4_TEST = new AnnotationMatcher("@org.junit.Test");
        @Nullable
        private JavaParser.Builder<?, ?> javaParser;

        private UpdateTestAnnotationVisitor() {
        }

        private JavaParser.Builder<?, ?> javaParser(ExecutionContext ctx) {
            if (this.javaParser == null) {
                this.javaParser = JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"junit-jupiter-api-5.9", "apiguardian-api-1.1"});
            }
            return this.javaParser;
        }

        public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
            J.CompilationUnit c = super.visitCompilationUnit(cu, (Object)ctx);
            Set nameTreeSet = c.findType("org.junit.Test");
            if (!nameTreeSet.isEmpty()) {
                c = (J.CompilationUnit)new ChangeType("org.junit.Test", "org.junit.jupiter.api.Test", Boolean.valueOf(true)).getVisitor().visitNonNull((Tree)c, (Object)ctx);
            }
            this.maybeRemoveImport("org.junit.Test");
            this.doAfterVisit((TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

                public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
                    J.CompilationUnit c = cu;
                    c = c.withClasses(ListUtils.map((List)c.getClasses(), clazz -> (J.ClassDeclaration)this.visit((Tree)clazz, ctx)));
                    c = c.withImports(ListUtils.map((List)c.getImports(), anImport -> (J.Import)this.visit((Tree)anImport, ctx)));
                    return c;
                }

                public J.Import visitImport(J.Import anImport, ExecutionContext ctx) {
                    if ("org.junit.Test".equals(anImport.getTypeName())) {
                        return (J.Import)Markup.error((Tree)anImport, (Throwable)new IllegalStateException("This import should have been removed by this recipe."));
                    }
                    return anImport;
                }

                public JavaType visitType(@Nullable JavaType javaType, ExecutionContext ctx) {
                    if (TypeUtils.isOfClassType((JavaType)javaType, (String)"org.junit.Test")) {
                        this.getCursor().putMessageOnFirstEnclosing(J.class, "danglingTestRef", (Object)true);
                    }
                    return javaType;
                }

                public J postVisit(J tree, ExecutionContext ctx) {
                    if (((Boolean)this.getCursor().getMessage("danglingTestRef", (Object)false)).booleanValue()) {
                        return (J)Markup.warn((Tree)tree, (Throwable)new IllegalStateException("This still has a type of `org.junit.Test`"));
                    }
                    return tree;
                }
            });
            return c;
        }

        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
            ChangeTestAnnotation cta = new ChangeTestAnnotation();
            J.MethodDeclaration m = (J.MethodDeclaration)cta.visitNonNull((Tree)method, ctx, this.getCursor().getParentOrThrow());
            if (m != method) {
                if (cta.expectedException != null) {
                    m = (J.MethodDeclaration)JavaTemplate.builder((String)"org.junit.jupiter.api.function.Executable o = () -> #{};").contextSensitive().javaParser(this.javaParser(ctx)).build().apply(this.updateCursor((Tree)m), m.getCoordinates().replaceBody(), new Object[]{m.getBody()});
                    assert (m.getBody() != null);
                    J.Lambda lambda = (J.Lambda)((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)m.getBody().getStatements().get(0)).getVariables().get(0)).getInitializer();
                    assert (lambda != null);
                    if (cta.expectedException instanceof J.FieldAccess && TypeUtils.isAssignableTo((String)"org.junit.Test$None", (JavaType)((J.FieldAccess)cta.expectedException).getTarget().getType())) {
                        m = (J.MethodDeclaration)JavaTemplate.builder((String)"assertDoesNotThrow(#{any(org.junit.jupiter.api.function.Executable)});").javaParser(this.javaParser(ctx)).staticImports(new String[]{"org.junit.jupiter.api.Assertions.assertDoesNotThrow"}).build().apply(this.updateCursor((Tree)m), m.getCoordinates().replaceBody(), new Object[]{lambda});
                        this.maybeAddImport("org.junit.jupiter.api.Assertions", "assertDoesNotThrow");
                    } else {
                        m = (J.MethodDeclaration)JavaTemplate.builder((String)"assertThrows(#{any(java.lang.Class)}, #{any(org.junit.jupiter.api.function.Executable)});").javaParser(this.javaParser(ctx)).staticImports(new String[]{"org.junit.jupiter.api.Assertions.assertThrows"}).build().apply(this.updateCursor((Tree)m), m.getCoordinates().replaceBody(), new Object[]{cta.expectedException, lambda});
                        this.maybeAddImport("org.junit.jupiter.api.Assertions", "assertThrows");
                    }
                }
                if (cta.timeout != null) {
                    m = (J.MethodDeclaration)JavaTemplate.builder((String)"@Timeout(value = #{any(long)}, unit = TimeUnit.MILLISECONDS)").javaParser(this.javaParser(ctx)).imports(new String[]{"org.junit.jupiter.api.Timeout", "java.util.concurrent.TimeUnit"}).build().apply(this.updateCursor((Tree)m), m.getCoordinates().addAnnotation(Comparator.comparing(J.Annotation::getSimpleName)), new Object[]{cta.timeout});
                    this.maybeAddImport("org.junit.jupiter.api.Timeout");
                    this.maybeAddImport("java.util.concurrent.TimeUnit");
                }
                this.maybeAddImport("org.junit.jupiter.api.Test");
            }
            return super.visitMethodDeclaration(m, (Object)ctx);
        }

        private static class ChangeTestAnnotation
        extends JavaIsoVisitor<ExecutionContext> {
            @Nullable
            Expression expectedException;
            @Nullable
            Expression timeout;
            boolean found;
            @Nullable
            private JavaParser.Builder<?, ?> javaParser;

            private ChangeTestAnnotation() {
            }

            private JavaParser.Builder<?, ?> javaParser(ExecutionContext ctx) {
                if (this.javaParser == null) {
                    this.javaParser = JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"junit-jupiter-api-5.9", "apiguardian-api-1.1"});
                }
                return this.javaParser;
            }

            public J.Annotation visitAnnotation(J.Annotation a, ExecutionContext ctx) {
                if (!this.found && JUNIT4_TEST.matches(a)) {
                    this.found = true;
                    if (a.getArguments() != null) {
                        for (Expression arg : a.getArguments()) {
                            if (!(arg instanceof J.Assignment)) continue;
                            J.Assignment assign = (J.Assignment)arg;
                            String assignParamName = ((J.Identifier)assign.getVariable()).getSimpleName();
                            Expression e = assign.getAssignment();
                            if ("expected".equals(assignParamName)) {
                                this.expectedException = e;
                                continue;
                            }
                            if (!"timeout".equals(assignParamName)) continue;
                            this.timeout = e;
                        }
                    }
                    a = a.getAnnotationType() instanceof J.FieldAccess ? (J.Annotation)JavaTemplate.builder((String)"@org.junit.jupiter.api.Test").javaParser(this.javaParser(ctx)).build().apply(this.getCursor(), a.getCoordinates().replace(), new Object[0]) : a.withArguments(null).withType((JavaType)JavaType.ShallowClass.build((String)"org.junit.jupiter.api.Test"));
                }
                return a;
            }
        }
    }
}

