/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.junit5;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.ChangeMethodTargetToStatic;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeUtils;

public class AssertToAssertions
extends Recipe {
    public String getDisplayName() {
        return "JUnit 4 `Assert` To JUnit Jupiter `Assertions`";
    }

    public String getDescription() {
        return "Change JUnit 4's `org.junit.Assert` into JUnit Jupiter's `org.junit.jupiter.api.Assertions`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType("org.junit.Assert", Boolean.valueOf(false)), (TreeVisitor)new AssertToAssertionsVisitor());
    }

    public static class AssertToAssertionsVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private static final JavaType ASSERTION_TYPE = JavaType.buildType((String)"org.junit.Assert");
        private static final List<String> JUNIT_ASSERT_METHOD_NAMES = Arrays.asList("assertArrayEquals", "assertEquals", "assertFalse", "assertNotEquals", "assertNotNull", "assertNotSame", "assertNull", "assertSame", "assertThrows", "assertTrue", "fail");

        public @Nullable J preVisit(J tree, ExecutionContext ctx) {
            if (tree instanceof JavaSourceFile) {
                JavaSourceFile c = (JavaSourceFile)tree;
                boolean hasWildcardAssertImport = false;
                for (J.Import imp : c.getImports()) {
                    if (!"org.junit.Assert.*".equals(imp.getQualid().toString())) continue;
                    hasWildcardAssertImport = true;
                    break;
                }
                if (hasWildcardAssertImport) {
                    this.maybeAddImport("org.junit.jupiter.api.Assertions", "*", false);
                    this.maybeRemoveImport("org.junit.Assert.*");
                }
            }
            return tree;
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
            if (!AssertToAssertionsVisitor.isJunitAssertMethod(m)) {
                return m;
            }
            this.doAfterVisit(new ChangeMethodTargetToStatic("org.junit.Assert " + m.getSimpleName() + "(..)", "org.junit.jupiter.api.Assertions", null, null, Boolean.valueOf(true)).getVisitor());
            List args = m.getPadding().getArguments().getPadding().getElements();
            Expression firstArg = (Expression)((JRightPadded)args.get(0)).getElement();
            if (args.size() == 2 && ("assertSame".equals(m.getSimpleName()) || "assertNotSame".equals(m.getSimpleName()) || "assertEquals".equals(m.getSimpleName()) || "assertNotEquals".equals(m.getSimpleName()))) {
                return m;
            }
            if (TypeUtils.isString((JavaType)firstArg.getType())) {
                List<JRightPadded> newArgs = new ArrayList(args);
                JRightPadded first = (JRightPadded)newArgs.remove(0);
                JRightPadded lastArg = (JRightPadded)args.get(args.size() - 1);
                boolean lastArgComments = !lastArg.getAfter().getComments().isEmpty();
                newArgs = ListUtils.mapFirst(newArgs, e -> e.withElement((Object)((Expression)((Expression)e.getElement()).withPrefix(((Expression)first.getElement()).getPrefix()))));
                newArgs = ListUtils.mapLast(newArgs, e -> e.withAfter(Space.EMPTY));
                newArgs.add(first.withElement((Object)((Expression)((Expression)first.getElement()).withPrefix(lastArgComments ? lastArg.getAfter().withComments(ListUtils.mapLast((List)lastArg.getAfter().getComments(), c -> c.withSuffix(((Expression)lastArg.getElement()).getPrefix().getWhitespace()))) : ((Expression)lastArg.getElement()).getPrefix()))).withAfter(lastArgComments ? Space.build((String)lastArg.getAfter().getLastWhitespace(), Collections.emptyList()) : lastArg.getAfter()));
                m = m.getPadding().withArguments(m.getPadding().getArguments().getPadding().withElements(newArgs));
            }
            return m;
        }

        private static boolean isJunitAssertMethod(J.MethodInvocation method) {
            if (method.getMethodType() != null && TypeUtils.isOfType((JavaType)ASSERTION_TYPE, (JavaType)method.getMethodType().getDeclaringType())) {
                return !"assertThat".equals(method.getSimpleName());
            }
            if (method.getMethodType() == null && JUNIT_ASSERT_METHOD_NAMES.contains(method.getSimpleName())) {
                return true;
            }
            if (!(method.getSelect() instanceof J.Identifier)) {
                return false;
            }
            J.Identifier receiver = (J.Identifier)method.getSelect();
            if (!(receiver.getType() instanceof JavaType.FullyQualified)) {
                return false;
            }
            JavaType.FullyQualified receiverType = (JavaType.FullyQualified)receiver.getType();
            return "org.junit.Assert".equals(receiverType.getFullyQualifiedName());
        }
    }
}

