/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.cleanup;

import org.junit.jupiter.api.Assertions;
import org.openrewrite.java.template.RecipeDescriptor;

@RecipeDescriptor(name="Remove JUnit `assertTrue(true)` and `assertFalse(false)`", description="These assertions are redundant and do not provide any value. They can be safely removed.")
public class AssertLiteralBooleanRemoved {
    void assertFalseBefore(String message) {
        Assertions.assertFalse((boolean)false, (String)message);
    }

    void assertTrueBefore(String message) {
        Assertions.assertTrue((boolean)true, (String)message);
    }

    void assertFalseBefore() {
        Assertions.assertFalse((boolean)false);
    }

    void assertTrueBefore() {
        Assertions.assertTrue((boolean)true);
    }

    void after() {
    }
}

