/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.junit5;

import java.util.List;
import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.trait.Annotated;
import org.openrewrite.java.trait.Literal;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeUtils;

public class CsvSourceToValueSource
extends Recipe {
    private static final AnnotationMatcher CSV_SOURCE_MATCHER = new AnnotationMatcher("@org.junit.jupiter.params.provider.CsvSource");
    private static final AnnotationMatcher VALUE_SOURCE_MATCHER = new AnnotationMatcher("@org.junit.jupiter.params.provider.ValueSource");

    public String getDisplayName() {
        return "Replace `@CsvSource` with `@ValueSource` for single method arguments";
    }

    public String getDescription() {
        return "Replaces JUnit 5's `@CsvSource` annotation with `@ValueSource` when the parameterized test has only a single method argument.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType("org.junit.jupiter.params.provider.CsvSource", Boolean.valueOf(false)), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                J.MethodDeclaration m = super.visitMethodDeclaration(method, (Object)ctx);
                if (m.getParameters().size() != 1 || m.getParameters().get(0) instanceof J.Empty) {
                    return m;
                }
                J.VariableDeclarations param = (J.VariableDeclarations)m.getParameters().get(0);
                if (TypeUtils.isAssignableTo((String)"org.junit.jupiter.params.aggregator.ArgumentsAccessor", (JavaType)param.getType()) || !param.getLeadingAnnotations().isEmpty()) {
                    return m;
                }
                for (J.Annotation annotation : m.getLeadingAnnotations()) {
                    Optional annotated = new Annotated.Matcher(CSV_SOURCE_MATCHER).get((Tree)annotation, this.getCursor());
                    if (!annotated.isPresent() || annotation.getArguments() == null || annotation.getArguments().size() != 1) continue;
                    if (((Annotated)annotated.get()).getAttribute("textBlock").isPresent()) {
                        return m;
                    }
                    String paramType = this.getParameterType((J.VariableDeclarations)m.getParameters().get(0));
                    if (paramType == null) {
                        return m;
                    }
                    if ("String".equals(paramType)) {
                        this.maybeRemoveImport("org.junit.jupiter.params.provider.CsvSource");
                        this.maybeAddImport("org.junit.jupiter.params.provider.ValueSource");
                        Expression templateArg = annotation.getArguments().get(0) instanceof J.Assignment ? ((J.Assignment)annotation.getArguments().get(0)).getAssignment() : (Expression)annotation.getArguments().get(0);
                        J.MethodDeclaration updated = (J.MethodDeclaration)JavaTemplate.builder((String)"@ValueSource(strings = {})").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"junit-jupiter-params-5"})).imports(new String[]{"org.junit.jupiter.params.provider.ValueSource"}).build().apply(this.getCursor(), annotation.getCoordinates().replace(), new Object[0]);
                        return updated.withLeadingAnnotations(ListUtils.map((List)updated.getLeadingAnnotations(), ann -> VALUE_SOURCE_MATCHER.matches(ann) ? ann.withArguments(ListUtils.map((List)ann.getArguments(), arg -> ((J.Assignment)arg).withAssignment((Expression)templateArg.withPrefix(Space.SINGLE_SPACE)))) : ann));
                    }
                    Optional valueAttribute = ((Annotated)annotated.get()).getDefaultAttribute("value");
                    if (!valueAttribute.isPresent()) {
                        return m;
                    }
                    List values = ((Literal)valueAttribute.get()).getStrings();
                    if (values.isEmpty()) {
                        return m;
                    }
                    String valueSourceAnnotationTemplate = this.buildValueSourceAnnotation(paramType, values);
                    if (valueSourceAnnotationTemplate == null) {
                        return m;
                    }
                    this.maybeRemoveImport("org.junit.jupiter.params.provider.CsvSource");
                    this.maybeAddImport("org.junit.jupiter.params.provider.ValueSource");
                    return (J.MethodDeclaration)JavaTemplate.builder((String)valueSourceAnnotationTemplate).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"junit-jupiter-params-5"})).imports(new String[]{"org.junit.jupiter.params.provider.ValueSource"}).build().apply(this.getCursor(), annotation.getCoordinates().replace(), new Object[0]);
                }
                return m;
            }

            private @Nullable String buildValueSourceAnnotation(String paramType, List<String> values) {
                String formattedValues;
                String attributeName;
                switch (paramType) {
                    case "int": 
                    case "Integer": {
                        attributeName = "ints";
                        formattedValues = this.format(values);
                        break;
                    }
                    case "long": 
                    case "Long": {
                        attributeName = "longs";
                        formattedValues = this.formatLongValues(values);
                        break;
                    }
                    case "double": 
                    case "Double": {
                        attributeName = "doubles";
                        formattedValues = this.format(values);
                        break;
                    }
                    case "float": 
                    case "Float": {
                        attributeName = "floats";
                        formattedValues = this.formatFloatValues(values);
                        break;
                    }
                    case "boolean": 
                    case "Boolean": {
                        attributeName = "booleans";
                        formattedValues = this.format(values);
                        break;
                    }
                    case "char": 
                    case "Character": {
                        attributeName = "chars";
                        formattedValues = this.formatCharValues(values);
                        break;
                    }
                    case "byte": 
                    case "Byte": {
                        attributeName = "bytes";
                        formattedValues = this.format(values);
                        break;
                    }
                    case "short": 
                    case "Short": {
                        attributeName = "shorts";
                        formattedValues = this.format(values);
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                if (values.size() == 1) {
                    return "@ValueSource(" + attributeName + " = " + formattedValues + ")";
                }
                return "@ValueSource(" + attributeName + " = {" + formattedValues + "})";
            }

            private String format(List<String> values) {
                return String.join((CharSequence)", ", (CharSequence[])values.stream().map(String::trim).toArray(String[]::new));
            }

            private String formatLongValues(List<String> values) {
                return String.join((CharSequence)", ", (CharSequence[])values.stream().map(v -> v.trim().endsWith("L") || v.trim().endsWith("l") ? v.trim() : v.trim() + "L").toArray(String[]::new));
            }

            private String formatFloatValues(List<String> values) {
                return String.join((CharSequence)", ", (CharSequence[])values.stream().map(v -> v.trim().endsWith("f") || v.trim().endsWith("F") ? v.trim() : v.trim() + "f").toArray(String[]::new));
            }

            private String formatCharValues(List<String> values) {
                return String.join((CharSequence)", ", (CharSequence[])values.stream().map(v -> "'" + v.trim() + "'").toArray(String[]::new));
            }

            private @Nullable String getParameterType(J.VariableDeclarations param) {
                if (param.getType() == null) {
                    return null;
                }
                if (param.getTypeAsFullyQualified() != null) {
                    return param.getTypeAsFullyQualified().getClassName();
                }
                if (param.getType() instanceof JavaType.Primitive) {
                    JavaType.Primitive primitive = (JavaType.Primitive)param.getType();
                    switch (primitive) {
                        case Boolean: {
                            return "boolean";
                        }
                        case Byte: {
                            return "byte";
                        }
                        case Char: {
                            return "char";
                        }
                        case Double: {
                            return "double";
                        }
                        case Float: {
                            return "float";
                        }
                        case Int: {
                            return "int";
                        }
                        case Long: {
                            return "long";
                        }
                        case Short: {
                            return "short";
                        }
                    }
                }
                return null;
            }
        });
    }
}

