/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class FileRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "`FileRules` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster rules related to expressions dealing with files.\n[Source](https://error-prone.picnic.tech/refasterrules/FileRules).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new PathOfUriRecipe(), new PathInstanceRecipe(), new FilesReadStringWithCharsetRecipe(), new FilesReadStringRecipe(), new FilesCreateTempFileToFileRecipe(), new FilesCreateTempFileInCustomDirectoryToFileRecipe(), new PathToFileMkDirsFilesExistsRecipe(), new FileMkDirsFileExistsRecipe(), new FilesNewBufferedReaderPathOfRecipe(), new FilesNewBufferedReaderToPathRecipe(), new FilesNewBufferedReaderPathOfWithCharsetRecipe(), new FilesNewBufferedReaderToPathWithCharsetRecipe()});
    }

    @NullMarked
    public static class PathOfUriRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `FileRules.PathOfUri`";
        }

        public String getDescription() {
            return "Prefer the more idiomatic `Path#of(URI)` over `Paths#get(URI)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"java.nio.file.Paths.get(#{uri:any(java.net.URI)})").bindType("java.nio.file.Path").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.nio.file.Paths");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.nio.file.Path.of(#{uri:any(java.net.URI)})").bindType("java.nio.file.Path").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.net.URI", Boolean.valueOf(true)), new UsesType("java.nio.file.Path", Boolean.valueOf(true)), new UsesType("java.nio.file.Paths", Boolean.valueOf(true)), new UsesMethod("java.nio.file.Paths get(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class PathInstanceRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `FileRules.PathInstance`";
        }

        public String getDescription() {
            return "Avoid redundant conversions from `Path` to `File`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{path:any(java.nio.file.Path)}.toFile().toPath()").bindType("java.nio.file.Path").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{path:any(java.nio.file.Path)}").bindType("java.nio.file.Path").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.nio.file.Path", Boolean.valueOf(true)), new UsesMethod("java.io.File toPath(..)", true), new UsesMethod("java.nio.file.Path toFile(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class FilesReadStringWithCharsetRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `FileRules.FilesReadStringWithCharset`";
        }

        public String getDescription() {
            return "Prefer `Files#readString(Path, Charset)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitNewClass(J.NewClass elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"new String(java.nio.file.Files.readAllBytes(#{path:any(java.nio.file.Path)}), #{charset:any(java.nio.charset.Charset)})").bindType("java.lang.String").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.nio.file.Files.readString(#{path:any(java.nio.file.Path)}, #{charset:any(java.nio.charset.Charset)})").bindType("java.lang.String").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitNewClass(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.nio.charset.Charset", Boolean.valueOf(true)), new UsesType("java.nio.file.Files", Boolean.valueOf(true)), new UsesType("java.nio.file.Path", Boolean.valueOf(true)), new UsesMethod("java.lang.String <init>(..)", true), new UsesMethod("java.nio.file.Files readAllBytes(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class FilesReadStringRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `FileRules.FilesReadString`";
        }

        public String getDescription() {
            return "Prefer `Files#readString(Path)` over more verbose alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"java.nio.file.Files.readString(#{path:any(java.nio.file.Path)}, java.nio.charset.StandardCharsets.UTF_8)").bindType("java.lang.String").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.nio.charset.StandardCharsets");
                        this.maybeRemoveImport("java.nio.charset.StandardCharsets.UTF_8");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.nio.file.Files.readString(#{path:any(java.nio.file.Path)})").bindType("java.lang.String").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.nio.file.Files", Boolean.valueOf(true)), new UsesType("java.nio.file.Path", Boolean.valueOf(true)), new UsesMethod("java.nio.file.Files readString(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class FilesCreateTempFileToFileRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `Files#createTempFile(String, String, FileAttribute[])` over alternatives that create files with more liberal permissions";
        }

        public String getDescription() {
            return "Note that `File#createTempFile` treats the given prefix as a path, and ignores all but\n its file name. That is, the actual prefix used is derived from all characters following the\n final file separator (if any). This is not the case with `Files#createTempFile`, which\n will instead throw an `IllegalArgumentException` if the prefix contains any file\n separators.";
        }

        public Set<String> getTags() {
            return Collections.singleton("RSPEC-S5443");
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"java.io.File.createTempFile(#{prefix:any(java.lang.String)}, #{suffix:any(java.lang.String)})").bindType("java.io.File").build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.nio.file.Files.createTempFile(#{prefix:any(java.lang.String)}, #{suffix:any(java.lang.String)}).toFile()").bindType("java.io.File").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"java.io.File.createTempFile(#{prefix:any(java.lang.String)}, #{suffix:any(java.lang.String)}, null)").bindType("java.io.File").build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.nio.file.Files.createTempFile(#{prefix:any(java.lang.String)}, #{suffix:any(java.lang.String)}).toFile()").bindType("java.io.File").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.io.File", Boolean.valueOf(true)), new UsesMethod("java.io.File createTempFile(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class FilesCreateTempFileInCustomDirectoryToFileRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `Files#createTempFile(Path, String, String, FileAttribute[])` over alternatives that create files with more liberal permissions";
        }

        public String getDescription() {
            return "Note that `File#createTempFile` treats the given prefix as a path, and ignores all but\n its file name. That is, the actual prefix used is derived from all characters following the\n final file separator (if any). This is not the case with `Files#createTempFile`, which\n will instead throw an `IllegalArgumentException` if the prefix contains any file\n separators.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"java.io.File.createTempFile(#{prefix:any(java.lang.String)}, #{suffix:any(java.lang.String)}, #{directory:any(java.io.File)})").bindType("java.io.File").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.nio.file.Files.createTempFile(#{directory:any(java.io.File)}.toPath(), #{prefix:any(java.lang.String)}, #{suffix:any(java.lang.String)}).toFile()").bindType("java.io.File").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(2), matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.io.File", Boolean.valueOf(true)), new UsesMethod("java.io.File createTempFile(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class PathToFileMkDirsFilesExistsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `FileRules.PathToFileMkDirsFilesExists`";
        }

        public String getDescription() {
            return "Invoke `File#mkdirs()` before `Files#exists(Path, LinkOption...)` to avoid concurrency issues.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitBinary(J.Binary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"java.nio.file.Files.exists(#{path:any(java.nio.file.Path)}) || #{path}.toFile().mkdirs()").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{path:any(java.nio.file.Path)}.toFile().mkdirs() || java.nio.file.Files.exists(#{path})").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitBinary(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.nio.file.Files", Boolean.valueOf(true)), new UsesType("java.nio.file.Path", Boolean.valueOf(true)), new UsesMethod("java.io.File mkdirs(..)", true), new UsesMethod("java.nio.file.Files exists(..)", true), new UsesMethod("java.nio.file.Path toFile(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class FileMkDirsFileExistsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `FileRules.FileMkDirsFileExists`";
        }

        public String getDescription() {
            return "Invoke `File#mkdirs()` before `File#exists()` to avoid concurrency issues.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitBinary(J.Binary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{file:any(java.io.File)}.exists() || #{file}.mkdirs()").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{file:any(java.io.File)}.mkdirs() || #{file}.exists()").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitBinary(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.io.File", Boolean.valueOf(true)), new UsesMethod("java.io.File exists(..)", true), new UsesMethod("java.io.File mkdirs(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class FilesNewBufferedReaderPathOfRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `FileRules.FilesNewBufferedReaderPathOf`";
        }

        public String getDescription() {
            return "Prefer `Files#newBufferedReader(Path)` over more verbose or contrived alternatives.";
        }

        public Set<String> getTags() {
            return new HashSet<String>(Arrays.asList("RSPEC-S1943", "RSPEC-S2095"));
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"java.nio.file.Files.newBufferedReader(java.nio.file.Path.of(#{path:any(java.lang.String)}), java.nio.charset.StandardCharsets.UTF_8)").bindType("java.io.BufferedReader").build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.nio.charset.StandardCharsets");
                        this.maybeRemoveImport("java.nio.charset.StandardCharsets.UTF_8");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.nio.file.Files.newBufferedReader(java.nio.file.Path.of(#{path:any(java.lang.String)}))").bindType("java.io.BufferedReader").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"new java.io.BufferedReader(new java.io.InputStreamReader(new java.io.FileInputStream(#{path:any(java.lang.String)})))").bindType("java.io.BufferedReader").build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.io.InputStreamReader");
                        this.maybeRemoveImport("java.io.FileInputStream");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.nio.file.Files.newBufferedReader(java.nio.file.Path.of(#{path:any(java.lang.String)}))").bindType("java.io.BufferedReader").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }

                public J visitNewClass(J.NewClass elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"java.nio.file.Files.newBufferedReader(java.nio.file.Path.of(#{path:any(java.lang.String)}), java.nio.charset.StandardCharsets.UTF_8)").bindType("java.io.BufferedReader").build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.nio.charset.StandardCharsets");
                        this.maybeRemoveImport("java.nio.charset.StandardCharsets.UTF_8");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.nio.file.Files.newBufferedReader(java.nio.file.Path.of(#{path:any(java.lang.String)}))").bindType("java.io.BufferedReader").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"new java.io.BufferedReader(new java.io.InputStreamReader(new java.io.FileInputStream(#{path:any(java.lang.String)})))").bindType("java.io.BufferedReader").build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.io.InputStreamReader");
                        this.maybeRemoveImport("java.io.FileInputStream");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.nio.file.Files.newBufferedReader(java.nio.file.Path.of(#{path:any(java.lang.String)}))").bindType("java.io.BufferedReader").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitNewClass(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.io.BufferedReader", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.io.FileInputStream", Boolean.valueOf(true)), new UsesType("java.io.InputStreamReader", Boolean.valueOf(true)), new UsesMethod("java.io.BufferedReader <init>(..)", true), new UsesMethod("java.io.FileInputStream <init>(..)", true), new UsesMethod("java.io.InputStreamReader <init>(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.nio.file.Files", Boolean.valueOf(true)), new UsesType("java.nio.file.Path", Boolean.valueOf(true)), new UsesMethod("java.nio.file.Files newBufferedReader(..)", true), new UsesMethod("java.nio.file.Path of(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class FilesNewBufferedReaderToPathRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `FileRules.FilesNewBufferedReaderToPath`";
        }

        public String getDescription() {
            return "Prefer `Files#newBufferedReader(Path)` over more verbose or contrived alternatives.";
        }

        public Set<String> getTags() {
            return new HashSet<String>(Arrays.asList("RSPEC-S1943", "RSPEC-S2095"));
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"java.nio.file.Files.newBufferedReader(#{file:any(java.io.File)}.toPath(), java.nio.charset.StandardCharsets.UTF_8)").bindType("java.io.BufferedReader").build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.nio.charset.StandardCharsets");
                        this.maybeRemoveImport("java.nio.charset.StandardCharsets.UTF_8");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.nio.file.Files.newBufferedReader(#{file:any(java.io.File)}.toPath())").bindType("java.io.BufferedReader").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"new java.io.BufferedReader(new java.io.InputStreamReader(new java.io.FileInputStream(#{file:any(java.io.File)})))").bindType("java.io.BufferedReader").build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.io.InputStreamReader");
                        this.maybeRemoveImport("java.io.FileInputStream");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.nio.file.Files.newBufferedReader(#{file:any(java.io.File)}.toPath())").bindType("java.io.BufferedReader").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }

                public J visitNewClass(J.NewClass elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"java.nio.file.Files.newBufferedReader(#{file:any(java.io.File)}.toPath(), java.nio.charset.StandardCharsets.UTF_8)").bindType("java.io.BufferedReader").build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.nio.charset.StandardCharsets");
                        this.maybeRemoveImport("java.nio.charset.StandardCharsets.UTF_8");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.nio.file.Files.newBufferedReader(#{file:any(java.io.File)}.toPath())").bindType("java.io.BufferedReader").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"new java.io.BufferedReader(new java.io.InputStreamReader(new java.io.FileInputStream(#{file:any(java.io.File)})))").bindType("java.io.BufferedReader").build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.io.InputStreamReader");
                        this.maybeRemoveImport("java.io.FileInputStream");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.nio.file.Files.newBufferedReader(#{file:any(java.io.File)}.toPath())").bindType("java.io.BufferedReader").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitNewClass(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.io.BufferedReader", Boolean.valueOf(true)), new UsesType("java.io.File", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.io.FileInputStream", Boolean.valueOf(true)), new UsesType("java.io.InputStreamReader", Boolean.valueOf(true)), new UsesMethod("java.io.BufferedReader <init>(..)", true), new UsesMethod("java.io.FileInputStream <init>(..)", true), new UsesMethod("java.io.InputStreamReader <init>(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.nio.file.Files", Boolean.valueOf(true)), new UsesMethod("java.io.File toPath(..)", true), new UsesMethod("java.nio.file.Files newBufferedReader(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class FilesNewBufferedReaderPathOfWithCharsetRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `FileRules.FilesNewBufferedReaderPathOfWithCharset`";
        }

        public String getDescription() {
            return "Prefer `Files#newBufferedReader(Path, Charset)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitNewClass(J.NewClass elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"new java.io.BufferedReader(new java.io.InputStreamReader(new java.io.FileInputStream(#{path:any(java.lang.String)}), #{charset:any(java.nio.charset.Charset)}))").bindType("java.io.BufferedReader").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.io.InputStreamReader");
                        this.maybeRemoveImport("java.io.FileInputStream");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.nio.file.Files.newBufferedReader(java.nio.file.Path.of(#{path:any(java.lang.String)}), #{charset:any(java.nio.charset.Charset)})").bindType("java.io.BufferedReader").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitNewClass(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.io.BufferedReader", Boolean.valueOf(true)), new UsesType("java.io.FileInputStream", Boolean.valueOf(true)), new UsesType("java.io.InputStreamReader", Boolean.valueOf(true)), new UsesType("java.nio.charset.Charset", Boolean.valueOf(true)), new UsesMethod("java.io.BufferedReader <init>(..)", true), new UsesMethod("java.io.FileInputStream <init>(..)", true), new UsesMethod("java.io.InputStreamReader <init>(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class FilesNewBufferedReaderToPathWithCharsetRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `FileRules.FilesNewBufferedReaderToPathWithCharset`";
        }

        public String getDescription() {
            return "Prefer `Files#newBufferedReader(Path, Charset)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitNewClass(J.NewClass elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"new java.io.BufferedReader(new java.io.InputStreamReader(new java.io.FileInputStream(#{file:any(java.io.File)}), #{charset:any(java.nio.charset.Charset)}))").bindType("java.io.BufferedReader").build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.io.InputStreamReader");
                        this.maybeRemoveImport("java.io.FileInputStream");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.nio.file.Files.newBufferedReader(#{file:any(java.io.File)}.toPath(), #{charset:any(java.nio.charset.Charset)})").bindType("java.io.BufferedReader").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitNewClass(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.io.BufferedReader", Boolean.valueOf(true)), new UsesType("java.io.File", Boolean.valueOf(true)), new UsesType("java.io.FileInputStream", Boolean.valueOf(true)), new UsesType("java.io.InputStreamReader", Boolean.valueOf(true)), new UsesType("java.nio.charset.Charset", Boolean.valueOf(true)), new UsesMethod("java.io.BufferedReader <init>(..)", true), new UsesMethod("java.io.FileInputStream <init>(..)", true), new UsesMethod("java.io.InputStreamReader <init>(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }
}

