/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.groovy.format;

import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.groovy.GroovyIsoVisitor;
import org.openrewrite.groovy.format.MinimumViableSpacingVisitor;
import org.openrewrite.groovy.format.OmitParenthesesForLastArgumentLambdaVisitor;
import org.openrewrite.java.format.AutodetectGeneralFormatStyle;
import org.openrewrite.java.format.BlankLinesVisitor;
import org.openrewrite.java.format.NormalizeFormatVisitor;
import org.openrewrite.java.format.NormalizeLineBreaksVisitor;
import org.openrewrite.java.format.NormalizeTabsOrSpacesVisitor;
import org.openrewrite.java.format.RemoveTrailingWhitespaceVisitor;
import org.openrewrite.java.format.SpacesVisitor;
import org.openrewrite.java.format.TabsAndIndentsVisitor;
import org.openrewrite.java.format.WrappingAndBracesVisitor;
import org.openrewrite.java.style.BlankLinesStyle;
import org.openrewrite.java.style.EmptyForInitializerPadStyle;
import org.openrewrite.java.style.EmptyForIteratorPadStyle;
import org.openrewrite.java.style.IntelliJ;
import org.openrewrite.java.style.SpacesStyle;
import org.openrewrite.java.style.TabsAndIndentsStyle;
import org.openrewrite.java.style.WrappingAndBracesStyle;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.style.GeneralFormatStyle;
import org.openrewrite.style.Style;

public class AutoFormatVisitor<P>
extends GroovyIsoVisitor<P> {
    private final @Nullable Tree stopAfter;

    public AutoFormatVisitor() {
        this(null);
    }

    public AutoFormatVisitor(@Nullable Tree stopAfter) {
        this.stopAfter = stopAfter;
    }

    public J visit(@Nullable Tree tree, P p, Cursor cursor) {
        JavaSourceFile cu = tree instanceof JavaSourceFile ? (JavaSourceFile)tree : (JavaSourceFile)cursor.firstEnclosingOrThrow(JavaSourceFile.class);
        J t = (J)new NormalizeFormatVisitor(this.stopAfter).visit(tree, p, cursor.fork());
        t = (J)new BlankLinesVisitor((BlankLinesStyle)Style.from(BlankLinesStyle.class, (SourceFile)cu, IntelliJ::blankLines), this.stopAfter).visit((Tree)t, p, cursor.fork());
        t = (J)new WrappingAndBracesVisitor((WrappingAndBracesStyle)Style.from(WrappingAndBracesStyle.class, (SourceFile)cu, IntelliJ::wrappingAndBraces), this.stopAfter).visit((Tree)t, p, cursor.fork());
        TabsAndIndentsStyle tabsAndIndentsStyle = (TabsAndIndentsStyle)Style.from(TabsAndIndentsStyle.class, (SourceFile)cu, IntelliJ::tabsAndIndents);
        SpacesStyle spacesStyle = (SpacesStyle)Style.from(SpacesStyle.class, (SourceFile)cu, IntelliJ::spaces);
        t = (J)new SpacesVisitor(spacesStyle, (EmptyForInitializerPadStyle)cu.getStyle(EmptyForInitializerPadStyle.class), (EmptyForIteratorPadStyle)Style.from(EmptyForIteratorPadStyle.class, (SourceFile)cu), this.stopAfter).visit((Tree)t, p, cursor.fork());
        t = (J)new NormalizeTabsOrSpacesVisitor(tabsAndIndentsStyle, this.stopAfter).visit((Tree)t, p, cursor.fork());
        t = new TabsAndIndentsVisitor(tabsAndIndentsStyle, spacesStyle, this.stopAfter).visit((Tree)t, p, cursor.fork());
        t = (J)new NormalizeLineBreaksVisitor(Optional.ofNullable((GeneralFormatStyle)Style.from(GeneralFormatStyle.class, (SourceFile)cu)).orElse(AutodetectGeneralFormatStyle.autodetectGeneralFormatStyle((JavaSourceFile)cu)), this.stopAfter).visit((Tree)t, p, cursor.fork());
        t = (J)new RemoveTrailingWhitespaceVisitor(this.stopAfter).visit((Tree)t, p, cursor.fork());
        t = (J)new OmitParenthesesForLastArgumentLambdaVisitor(this.stopAfter).visitNonNull((Tree)t, p, cursor.fork());
        t = (J)new MinimumViableSpacingVisitor(this.stopAfter).visitNonNull((Tree)t, p, cursor.fork());
        return t;
    }
}

