/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.text.Normalizer;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.Incubating;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaKeywordUtils;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Statement;

@Incubating(since="7.25.0")
public final class VariableNameUtils {
    private VariableNameUtils() {
    }

    public static String generateVariableName(String baseName, Cursor scope, GenerationStrategy strategy) {
        Set<String> namesInScope = VariableNameUtils.findNamesInScope(scope);
        String newName = baseName;
        if (GenerationStrategy.INCREMENT_NUMBER == strategy) {
            int count;
            char c;
            StringBuilder postFix = new StringBuilder();
            char[] charArray = baseName.toCharArray();
            for (int i = charArray.length - 1; i >= 0 && Character.isDigit(c = charArray[i]); --i) {
                postFix.append(c);
            }
            baseName = baseName.substring(0, baseName.length() - postFix.length());
            int n = count = postFix.length() == 0 ? 0 : Integer.parseInt(postFix.reverse().toString());
            while (namesInScope.contains(newName) || JavaKeywordUtils.isReservedKeyword(newName) || JavaKeywordUtils.isReservedLiteral(newName)) {
                newName = baseName + ++count;
            }
        }
        return newName;
    }

    public static String normalizeName(String name) {
        if (name.isEmpty() || Normalizer.isNormalized(name, Normalizer.Form.NFKD)) {
            return name;
        }
        String normalized = Normalizer.normalize(name, Normalizer.Form.NFKD);
        return normalized.replaceAll("\\p{M}", "");
    }

    public static Set<String> findNamesInScope(Cursor scope) {
        JavaSourceFile compilationUnit = (JavaSourceFile)scope.firstEnclosing(JavaSourceFile.class);
        if (compilationUnit == null) {
            throw new IllegalStateException("A JavaSourceFile is required in the cursor path.");
        }
        HashSet<String> names = new HashSet<String>();
        VariableNameScopeVisitor variableNameScopeVisitor = new VariableNameScopeVisitor(scope);
        variableNameScopeVisitor.visit(compilationUnit, names);
        return names;
    }

    public static Set<String> findInheritedNames(J.ClassDeclaration classDeclaration) {
        HashSet<String> names = new HashSet<String>();
        if (classDeclaration.getType() != null) {
            VariableNameUtils.addInheritedClassFields(classDeclaration, classDeclaration.getType().getSupertype(), names);
        }
        return names;
    }

    private static void addInheritedClassFields(J.ClassDeclaration classDeclaration, @Nullable JavaType.FullyQualified superClass, Set<String> names) {
        if (superClass != null) {
            boolean isSamePackage = classDeclaration.getType() != null && classDeclaration.getType().getPackageName().equals(superClass.getPackageName());
            superClass.getMembers().forEach(m -> {
                if (Flag.hasFlags(m.getFlagsBitMap(), Flag.Public) || Flag.hasFlags(m.getFlagsBitMap(), Flag.Protected) || !Flag.hasFlags(m.getFlagsBitMap(), Flag.Private) && isSamePackage) {
                    names.add(m.getName());
                }
            });
            VariableNameUtils.addInheritedClassFields(classDeclaration, superClass.getSupertype(), names);
        }
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof VariableNameUtils;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @NonNull
    @Generated
    public String toString() {
        return "VariableNameUtils()";
    }

    public static enum GenerationStrategy {
        INCREMENT_NUMBER;

    }

    private static final class VariableNameScopeVisitor
    extends JavaIsoVisitor<Set<String>> {
        private final Cursor scope;
        private final Map<Cursor, Set<String>> nameScopes;
        private final Stack<Cursor> currentScope;

        public VariableNameScopeVisitor(Cursor scope) {
            this.scope = scope;
            this.nameScopes = new LinkedHashMap<Cursor, Set<String>>();
            this.currentScope = new Stack();
        }

        private Cursor aggregateNameScope() {
            return this.getCursor().dropParentUntil(is -> is instanceof JavaSourceFile || is instanceof J.ClassDeclaration || is instanceof J.MethodDeclaration || is instanceof J.Block || is instanceof J.ForLoop || is instanceof J.ForEachLoop || is instanceof J.Case || is instanceof J.Try || is instanceof J.Try.Catch || is instanceof J.Lambda);
        }

        @Override
        public Statement visitStatement(Statement statement, Set<String> namesInScope) {
            J s = super.visitStatement(statement, namesInScope);
            Cursor aggregatedScope = this.aggregateNameScope();
            if (this.currentScope.isEmpty() || this.currentScope.peek() != aggregatedScope) {
                Set namesInAggregatedScope = this.nameScopes.computeIfAbsent(aggregatedScope, k -> new HashSet());
                if (!this.currentScope.isEmpty() && aggregatedScope.isScopeInPath((Tree)this.currentScope.peek().getValue())) {
                    namesInAggregatedScope.addAll((Collection)this.nameScopes.get(this.currentScope.peek()));
                }
                this.currentScope.push(aggregatedScope);
            }
            return s;
        }

        public @Nullable J preVisit(J tree, Set<String> namesInScope) {
            return ((J)this.scope.getValue()).isScope(tree) ? (J)this.scope.getValue() : (J)super.preVisit((Tree)tree, namesInScope);
        }

        public @Nullable J postVisit(J tree, Set<String> namesInScope) {
            if (!this.currentScope.isEmpty() && this.currentScope.peek().getValue().equals(tree)) {
                this.currentScope.pop();
            }
            if (this.scope.getValue().equals(tree)) {
                Cursor aggregatedScope = this.getCursor().getValue() instanceof JavaSourceFile ? this.getCursor() : this.aggregateNameScope();
                Set<String> names = this.nameScopes.get(aggregatedScope);
                namesInScope.addAll(names);
                this.nameScopes.forEach((key, value) -> {
                    if (key.isScopeInPath((Tree)this.scope.getValue())) {
                        namesInScope.addAll((Collection<String>)value);
                    }
                });
                return tree;
            }
            return (J)super.postVisit((Tree)tree, namesInScope);
        }

        @Override
        public J.Import visitImport(J.Import _import, Set<String> namesInScope) {
            return _import;
        }

        @Override
        public J.Package visitPackage(J.Package pkg, Set<String> namesInScope) {
            return pkg;
        }

        @Override
        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, Set<String> namesInScope) {
            classDecl.getBody().getStatements().forEach(o -> {
                if (o instanceof J.VariableDeclarations) {
                    J.VariableDeclarations variableDeclarations = (J.VariableDeclarations)o;
                    variableDeclarations.getVariables().forEach(v -> this.nameScopes.computeIfAbsent(this.getCursor(), k -> new HashSet()).add(v.getSimpleName()));
                }
            });
            this.addImportedStaticFieldNames((JavaSourceFile)this.getCursor().firstEnclosing(JavaSourceFile.class), this.getCursor());
            if (classDecl.getType() != null) {
                namesInScope.addAll(VariableNameUtils.findInheritedNames(classDecl));
            }
            return super.visitClassDeclaration(classDecl, namesInScope);
        }

        @Override
        public J.InstanceOf visitInstanceOf(J.InstanceOf instanceOf, Set<String> strings) {
            Set<String> names;
            if (instanceOf.getPattern() instanceof J.Identifier && (names = this.nameScopes.get(this.currentScope.peek())) != null) {
                names.add(((J.Identifier)instanceOf.getPattern()).getSimpleName());
            }
            return super.visitInstanceOf(instanceOf, strings);
        }

        @Override
        public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, Set<String> strings) {
            Set<String> names = this.nameScopes.get(this.currentScope.peek());
            if (names != null) {
                names.add(variable.getSimpleName());
            }
            return super.visitVariable(variable, strings);
        }

        @Override
        public J.Identifier visitIdentifier(J.Identifier identifier, Set<String> namesInScope) {
            J v = super.visitIdentifier(identifier, namesInScope);
            if (((J.Identifier)v).getType() instanceof JavaType.Class && ((JavaType.Class)((J.Identifier)v).getType()).getKind() == JavaType.FullyQualified.Kind.Enum) {
                namesInScope.add(((J.Identifier)v).getSimpleName());
            }
            return v;
        }

        private void addImportedStaticFieldNames(@Nullable JavaSourceFile cu, Cursor classCursor) {
            if (cu != null) {
                List<J.Import> imports = cu.getImports();
                imports.forEach(i -> {
                    if (i.isStatic()) {
                        Set namesAtCursor = this.nameScopes.computeIfAbsent(classCursor, k -> new HashSet());
                        if (this.isValidImportName(i.getQualid().getTarget().getType(), i.getQualid().getSimpleName())) {
                            namesAtCursor.add(i.getQualid().getSimpleName());
                        }
                    }
                });
            }
        }

        private boolean isValidImportName(@Nullable JavaType targetType, String name) {
            return targetType == null || targetType instanceof JavaType.FullyQualified && ((JavaType.FullyQualified)targetType).getMembers().stream().anyMatch(o -> o.getName().equals(name));
        }
    }
}

