/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.format;

import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.style.WrappingAndBracesStyle;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.style.LineWrapSetting;

public class WrappingAndBracesVisitor<P>
extends JavaIsoVisitor<P> {
    private final @Nullable Tree stopAfter;
    private final WrappingAndBracesStyle style;

    public WrappingAndBracesVisitor(WrappingAndBracesStyle style) {
        this(style, null);
    }

    public WrappingAndBracesVisitor(WrappingAndBracesStyle style, @Nullable Tree stopAfter) {
        this.style = style;
        this.stopAfter = stopAfter;
    }

    @Override
    public Statement visitStatement(Statement statement, P p) {
        J j = super.visitStatement(statement, (Object)p);
        Tree parentTree = (Tree)this.getCursor().getParentTreeCursor().getValue();
        if (parentTree instanceof J.Block && !(j instanceof J.EnumValueSet) && !StringUtils.hasLineBreak((String)j.getPrefix().getWhitespace())) {
            j = (Statement)j.withPrefix(this.withNewline(j.getPrefix()));
        }
        return j;
    }

    @Override
    public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, P p) {
        J variableDeclarations = super.visitVariableDeclarations(multiVariable, (Object)p);
        String whitespace = ((J.VariableDeclarations)variableDeclarations).getPrefix().getWhitespace().replaceFirst("^[\\n\\s]+\\n", "\n");
        WrappingAndBracesStyle.Annotations annotationsStyle = null;
        Cursor possiblyBlock = this.getCursor().dropParentUntil(J.class::isInstance);
        if (possiblyBlock.getValue() instanceof J.Block) {
            annotationsStyle = possiblyBlock.getParent() != null && possiblyBlock.getParent().getValue() instanceof J.ClassDeclaration ? this.style.getFieldAnnotations() : this.style.getLocalVariableAnnotations();
            variableDeclarations = ((J.VariableDeclarations)variableDeclarations).withLeadingAnnotations(this.wrapAnnotations(((J.VariableDeclarations)variableDeclarations).getLeadingAnnotations(), whitespace, annotationsStyle));
        } else if (this.getCursor().getParent(3) != null && (this.getCursor().getParent(3).getValue() instanceof J.ClassDeclaration || this.getCursor().getParent(3).getValue() instanceof J.MethodDeclaration)) {
            annotationsStyle = this.style.getParameterAnnotations();
            variableDeclarations = ((J.VariableDeclarations)variableDeclarations).withLeadingAnnotations(this.wrapAnnotations(((J.VariableDeclarations)variableDeclarations).getLeadingAnnotations(), whitespace, annotationsStyle));
        }
        if (!((J.VariableDeclarations)variableDeclarations).getLeadingAnnotations().isEmpty() && annotationsStyle != null) {
            variableDeclarations = !((J.VariableDeclarations)variableDeclarations).getModifiers().isEmpty() ? ((J.VariableDeclarations)variableDeclarations).withModifiers(this.withNewline(((J.VariableDeclarations)variableDeclarations).getModifiers(), whitespace, annotationsStyle)) : ((J.VariableDeclarations)variableDeclarations).withTypeExpression((TypeTree)((J.VariableDeclarations)variableDeclarations).getTypeExpression().withPrefix(this.wrapElement(((J.VariableDeclarations)variableDeclarations).getTypeExpression().getPrefix(), whitespace, annotationsStyle)));
        }
        return variableDeclarations;
    }

    @Override
    public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, P p) {
        J m = super.visitMethodDeclaration(method, (Object)p);
        String whitespace = ((J.MethodDeclaration)m).getPrefix().getWhitespace().replaceFirst("^[\\n\\s]+\\n", "\n");
        if (!((J.MethodDeclaration)(m = ((J.MethodDeclaration)m).withLeadingAnnotations(this.wrapAnnotations(((J.MethodDeclaration)m).getLeadingAnnotations(), whitespace, this.style.getMethodAnnotations())))).getLeadingAnnotations().isEmpty() && this.style.getMethodAnnotations() != null) {
            m = !((J.MethodDeclaration)m).getModifiers().isEmpty() ? ((J.MethodDeclaration)m).withModifiers(this.withNewline(((J.MethodDeclaration)m).getModifiers(), whitespace, this.style.getMethodAnnotations())) : (((J.MethodDeclaration)m).getAnnotations().getTypeParameters() != null ? ((J.MethodDeclaration)m).getAnnotations().withTypeParameters(((J.MethodDeclaration)m).getAnnotations().getTypeParameters().withPrefix(this.wrapElement(((J.MethodDeclaration)m).getAnnotations().getTypeParameters().getPrefix(), whitespace, this.style.getMethodAnnotations()))) : (((J.MethodDeclaration)m).getReturnTypeExpression() != null ? ((J.MethodDeclaration)m).withReturnTypeExpression((TypeTree)((J.MethodDeclaration)m).getReturnTypeExpression().withPrefix(this.wrapElement(((J.MethodDeclaration)m).getReturnTypeExpression().getPrefix(), whitespace, this.style.getMethodAnnotations()))) : ((J.MethodDeclaration)m).withName(((J.MethodDeclaration)m).getName().withPrefix(this.wrapElement(((J.MethodDeclaration)m).getName().getPrefix(), whitespace, this.style.getMethodAnnotations())))));
        }
        return m;
    }

    @Override
    public J.If.Else visitElse(J.If.Else else_, P p) {
        boolean hasBody;
        J e = super.visitElse(else_, (Object)p);
        boolean bl = hasBody = ((J.If.Else)e).getBody() instanceof J.Block || ((J.If.Else)e).getBody() instanceof J.If;
        if (hasBody) {
            if (this.style.getIfStatement().getElseOnNewLine().booleanValue() && !StringUtils.hasLineBreak((String)((J.If.Else)e).getPrefix().getWhitespace())) {
                e = ((J.If.Else)e).withPrefix(((J.If.Else)e).getPrefix().withWhitespace("\n" + ((J.If.Else)e).getPrefix().getWhitespace()));
            } else if (!this.style.getIfStatement().getElseOnNewLine().booleanValue() && StringUtils.hasLineBreak((String)((J.If.Else)e).getPrefix().getWhitespace())) {
                e = ((J.If.Else)e).withPrefix(Space.EMPTY);
            }
        }
        return e;
    }

    @Override
    public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, P p) {
        J j = super.visitClassDeclaration(classDecl, (Object)p);
        String whitespace = ((J.ClassDeclaration)j).getPrefix().getWhitespace().replaceFirst("^[\\n\\s]+\\n", "\n");
        if (!((J.ClassDeclaration)(j = ((J.ClassDeclaration)j).withLeadingAnnotations(this.wrapAnnotations(((J.ClassDeclaration)j).getLeadingAnnotations(), whitespace, this.style.getClassAnnotations())))).getLeadingAnnotations().isEmpty() && this.style.getClassAnnotations() != null) {
            if (!((J.ClassDeclaration)j).getModifiers().isEmpty()) {
                j = ((J.ClassDeclaration)j).withModifiers(this.withNewline(((J.ClassDeclaration)j).getModifiers(), whitespace, this.style.getClassAnnotations()));
            } else {
                J.ClassDeclaration.Kind kind = ((J.ClassDeclaration)j).getPadding().getKind();
                if (!StringUtils.hasLineBreak((String)kind.getPrefix().getWhitespace())) {
                    j = ((J.ClassDeclaration)j).getPadding().withKind(kind.withPrefix(this.wrapElement(kind.getPrefix(), whitespace, this.style.getClassAnnotations())));
                }
            }
        }
        return j;
    }

    @Override
    public J.EnumValue visitEnumValue(J.EnumValue _enum, P p) {
        J enumValue = super.visitEnumValue(_enum, (Object)p);
        String whitespace = ((J.EnumValue)enumValue).getPrefix().getWhitespace().replaceFirst("^[\\n\\s]+\\n", "\n");
        if (!((J.EnumValue)(enumValue = ((J.EnumValue)enumValue).withAnnotations(this.wrapAnnotations(((J.EnumValue)enumValue).getAnnotations(), whitespace, this.style.getEnumFieldAnnotations())))).getAnnotations().isEmpty() && this.style.getEnumFieldAnnotations() != null) {
            enumValue = ((J.EnumValue)enumValue).withName(((J.EnumValue)enumValue).getName().withPrefix(this.wrapElement(((J.EnumValue)enumValue).getName().getPrefix(), whitespace, this.style.getEnumFieldAnnotations())));
        }
        return enumValue;
    }

    @Override
    public J.Block visitBlock(J.Block block, P p) {
        J b = super.visitBlock(block, (Object)p);
        if (!((J.Block)b).getEnd().getWhitespace().contains("\n")) {
            b = ((J.Block)b).withEnd(this.withNewline(((J.Block)b).getEnd()));
        }
        return b;
    }

    public @Nullable J postVisit(J tree, P p) {
        if (this.stopAfter != null && this.stopAfter.isScope((Tree)tree)) {
            this.getCursor().putMessageOnFirstEnclosing(JavaSourceFile.class, "stop", (Object)true);
        }
        return (J)super.postVisit((Tree)tree, p);
    }

    public @Nullable J visit(@Nullable Tree tree, P p) {
        if (this.getCursor().getNearestMessage("stop") != null) {
            return (J)tree;
        }
        return (J)super.visit(tree, p);
    }

    private List<J.Annotation> wrapAnnotations(List<J.Annotation> annotations, String whitespace, @Nullable WrappingAndBracesStyle.Annotations annotationsStyle) {
        if (annotationsStyle == null) {
            return annotations;
        }
        return ListUtils.map(annotations, (index, ann) -> {
            if (annotationsStyle.getWrap() == LineWrapSetting.DoNotWrap && StringUtils.hasLineBreak((String)ann.getPrefix().getWhitespace())) {
                ann = ann.withPrefix(ann.getPrefix().withWhitespace(Space.SINGLE_SPACE.getWhitespace()));
            } else if (annotationsStyle.getWrap() == LineWrapSetting.WrapAlways && index > 0) {
                ann = ann.withPrefix(ann.getPrefix().withWhitespace((whitespace.startsWith("\n") ? "" : "\n") + whitespace));
            }
            return ann;
        });
    }

    private Space wrapElement(Space prefix, String whitespace, @Nullable WrappingAndBracesStyle.Annotations annotationsStyle) {
        if (prefix.getComments().isEmpty() && annotationsStyle != null) {
            if (annotationsStyle.getWrap() == LineWrapSetting.DoNotWrap && (StringUtils.hasLineBreak((String)prefix.getWhitespace()) || prefix.isEmpty())) {
                return prefix.withWhitespace(Space.SINGLE_SPACE.getWhitespace());
            }
            if (annotationsStyle.getWrap() == LineWrapSetting.WrapAlways) {
                return prefix.withWhitespace((whitespace.startsWith("\n") ? "" : "\n") + whitespace);
            }
        }
        return prefix;
    }

    private Space withNewline(Space prefix) {
        if (prefix.getComments().isEmpty()) {
            return prefix.withWhitespace((StringUtils.hasLineBreak((String)prefix.getWhitespace()) ? "" : "\n") + prefix.getWhitespace());
        }
        if (prefix.getComments().get(prefix.getComments().size() - 1).isMultiline()) {
            return prefix.withComments(ListUtils.mapLast(prefix.getComments(), c -> Objects.requireNonNull(c).withSuffix("\n")));
        }
        return prefix;
    }

    private List<J.Modifier> withNewline(List<J.Modifier> modifiers, String whitespace, @Nullable WrappingAndBracesStyle.Annotations annotationsStyle) {
        return ListUtils.mapFirst(modifiers, mod -> Objects.requireNonNull(mod).withPrefix(this.wrapElement(mod.getPrefix(), whitespace, annotationsStyle)));
    }
}

