/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.internal.template;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import lombok.Generated;
import org.intellij.lang.annotations.Language;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.PropertyPlaceholderHelper;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.RandomizeIdVisitor;
import org.openrewrite.java.internal.template.AnnotationTemplateGenerator;
import org.openrewrite.java.internal.template.BlockStatementTemplateGenerator;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaCoordinates;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Loop;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;

public class JavaTemplateParser {
    private static final PropertyPlaceholderHelper placeholderHelper = new PropertyPlaceholderHelper("#{", "}", null);
    private static final String TEMPLATE_CACHE_MESSAGE_KEY = "__org.openrewrite.java.internal.template.JavaTemplateParser.cache__";
    private static final String PACKAGE_STUB = "package #{}; class $Template {}";
    private static final String PARAMETER_STUB = "abstract class $Template { abstract void $template(#{}); }";
    private static final String LAMBDA_PARAMETER_STUB = "class $Template { { Object o = (#{}) -> {}; } }";
    private static final String EXTENDS_STUB = "class $Template extends #{} {}";
    private static final String IMPLEMENTS_STUB = "class $Template implements #{} {}";
    private static final String THROWS_STUB = "abstract class $Template { abstract void $template() throws #{}; }";
    private static final String TYPE_PARAMS_STUB = "class $Template<#{}> {}";
    @Language(value="java")
    private static final String SUBSTITUTED_ANNOTATION = "@java.lang.annotation.Documented public @interface SubAnnotation { int value(); }";
    private final Parser.Builder parser;
    private final Consumer<String> onAfterVariableSubstitution;
    private final Consumer<String> onBeforeParseTemplate;
    private final Set<String> imports;
    private final boolean contextSensitive;
    private final BlockStatementTemplateGenerator statementTemplateGenerator;
    private final AnnotationTemplateGenerator annotationTemplateGenerator;

    public JavaTemplateParser(boolean contextSensitive, Parser.Builder parser, Consumer<String> onAfterVariableSubstitution, Consumer<String> onBeforeParseTemplate, Set<String> imports, String bindType) {
        this(parser, onAfterVariableSubstitution, onBeforeParseTemplate, imports, contextSensitive, new BlockStatementTemplateGenerator(imports, contextSensitive, bindType), new AnnotationTemplateGenerator(imports));
    }

    protected JavaTemplateParser(Parser.Builder parser, Consumer<String> onAfterVariableSubstitution, Consumer<String> onBeforeParseTemplate, Set<String> imports, boolean contextSensitive, BlockStatementTemplateGenerator statementTemplateGenerator, AnnotationTemplateGenerator annotationTemplateGenerator) {
        this.parser = parser;
        this.onAfterVariableSubstitution = onAfterVariableSubstitution;
        this.onBeforeParseTemplate = onBeforeParseTemplate;
        this.imports = imports;
        this.contextSensitive = contextSensitive;
        this.statementTemplateGenerator = statementTemplateGenerator;
        this.annotationTemplateGenerator = annotationTemplateGenerator;
    }

    public List<Statement> parseParameters(Cursor cursor, String template) {
        String stub = this.addImports(this.substitute(PARAMETER_STUB, template));
        this.onBeforeParseTemplate.accept(stub);
        return this.cache(cursor, stub, () -> {
            JavaSourceFile cu = this.compileTemplate(stub);
            J.MethodDeclaration m = (J.MethodDeclaration)cu.getClasses().get(0).getBody().getStatements().get(0);
            return m.getParameters();
        });
    }

    public J.Lambda.Parameters parseLambdaParameters(Cursor cursor, String template) {
        String stub = this.addImports(this.substitute(LAMBDA_PARAMETER_STUB, template));
        this.onBeforeParseTemplate.accept(stub);
        return (J.Lambda.Parameters)this.cache(cursor, stub, () -> {
            JavaSourceFile cu = this.compileTemplate(stub);
            J.Block b = (J.Block)cu.getClasses().get(0).getBody().getStatements().get(0);
            J.VariableDeclarations v = (J.VariableDeclarations)b.getStatements().get(0);
            J.Lambda l = (J.Lambda)v.getVariables().get(0).getInitializer();
            assert (l != null);
            return Collections.singletonList(l.getParameters());
        }).get(0);
    }

    public J parseExpression(Cursor cursor, String template, Collection<JavaType.GenericTypeVariable> typeVariables, Space.Location location) {
        return (J)this.cacheIfContextFree(cursor, new ContextFreeCacheKey(template, typeVariables.stream().map(TypeUtils::toGenericTypeString).sorted().collect(Collectors.toList()), Expression.class, this.imports), tmpl -> this.statementTemplateGenerator.template(cursor, (String)tmpl, typeVariables, location, JavaCoordinates.Mode.REPLACEMENT), stub -> {
            this.onBeforeParseTemplate.accept((String)stub);
            JavaSourceFile cu = this.compileTemplate((String)stub);
            return this.statementTemplateGenerator.listTemplatedTrees(cu, Expression.class);
        }).get(0);
    }

    public TypeTree parseExtends(Cursor cursor, String template) {
        String stub = this.addImports(this.substitute(EXTENDS_STUB, template));
        this.onBeforeParseTemplate.accept(stub);
        return (TypeTree)this.cache(cursor, stub, () -> {
            JavaSourceFile cu = this.compileTemplate(stub);
            TypeTree anExtends = cu.getClasses().get(0).getExtends();
            assert (anExtends != null);
            return Collections.singletonList(anExtends);
        }).get(0);
    }

    public List<TypeTree> parseImplements(Cursor cursor, String template) {
        String stub = this.addImports(this.substitute(IMPLEMENTS_STUB, template));
        this.onBeforeParseTemplate.accept(stub);
        return this.cache(cursor, stub, () -> {
            JavaSourceFile cu = this.compileTemplate(stub);
            List<TypeTree> anImplements = cu.getClasses().get(0).getImplements();
            assert (anImplements != null);
            return anImplements;
        });
    }

    public List<NameTree> parseThrows(Cursor cursor, String template) {
        String stub = this.addImports(this.substitute(THROWS_STUB, template));
        this.onBeforeParseTemplate.accept(stub);
        return this.cache(cursor, stub, () -> {
            JavaSourceFile cu = this.compileTemplate(stub);
            J.MethodDeclaration m = (J.MethodDeclaration)cu.getClasses().get(0).getBody().getStatements().get(0);
            List<NameTree> aThrows = m.getThrows();
            assert (aThrows != null);
            return aThrows;
        });
    }

    public List<J.TypeParameter> parseTypeParameters(Cursor cursor, String template) {
        String stub = this.addImports(this.substitute(TYPE_PARAMS_STUB, template));
        this.onBeforeParseTemplate.accept(stub);
        return this.cache(cursor, stub, () -> {
            JavaSourceFile cu = this.compileTemplate(stub);
            List<J.TypeParameter> tps = cu.getClasses().get(0).getTypeParameters();
            assert (tps != null);
            return tps;
        });
    }

    public <J2 extends J> List<J2> parseBlockStatements(Cursor cursor, Class<J2> expected, String template, Collection<JavaType.GenericTypeVariable> typeVariables, Space.Location location, JavaCoordinates.Mode mode) {
        return this.cacheIfContextFree(cursor, new ContextFreeCacheKey(template, typeVariables.stream().map(TypeUtils::toGenericTypeString).sorted().collect(Collectors.toList()), expected, this.imports), tmpl -> this.statementTemplateGenerator.template(cursor, (String)tmpl, typeVariables, location, mode), stub -> {
            this.onBeforeParseTemplate.accept((String)stub);
            JavaSourceFile cu = this.compileTemplate((String)stub);
            return this.statementTemplateGenerator.listTemplatedTrees(cu, expected);
        });
    }

    public J.MethodInvocation parseMethod(Cursor cursor, String template, Collection<JavaType.GenericTypeVariable> typeVariables, Space.Location location) {
        J.MethodInvocation method = (J.MethodInvocation)cursor.getValue();
        String methodWithReplacedNameAndArgs = method.getSelect() == null ? template : method.getSelect().print(cursor) + "." + template;
        String stub = this.statementTemplateGenerator.template(cursor, methodWithReplacedNameAndArgs, typeVariables, location, JavaCoordinates.Mode.REPLACEMENT);
        this.onBeforeParseTemplate.accept(stub);
        JavaSourceFile cu = this.compileTemplate(stub);
        return (J.MethodInvocation)this.statementTemplateGenerator.listTemplatedTrees(cu, Statement.class).get(0);
    }

    public J.MethodInvocation parseMethodArguments(Cursor cursor, String template, Collection<JavaType.GenericTypeVariable> typeVariables, Space.Location location) {
        J.MethodInvocation method = (J.MethodInvocation)cursor.getValue();
        String methodWithReplacementArgs = method.withArguments(Collections.emptyList()).printTrimmed(cursor.getParentOrThrow()).replaceAll("\\)$", template + (this.isStatement(cursor) ? ");" : ")"));
        String stub = this.statementTemplateGenerator.template(cursor, methodWithReplacementArgs, typeVariables, location, JavaCoordinates.Mode.REPLACEMENT);
        this.onBeforeParseTemplate.accept(stub);
        JavaSourceFile cu = this.compileTemplate(stub);
        return (J.MethodInvocation)this.statementTemplateGenerator.listTemplatedTrees(cu, Statement.class).get(0);
    }

    private boolean isStatement(Cursor cursor) {
        if (!(cursor.getValue() instanceof Statement)) {
            return false;
        }
        if (cursor.getValue() instanceof Expression) {
            J parent = (J)cursor.getParentTreeCursor().getValue();
            return parent instanceof J.Block || parent instanceof J.If && ((J.If)parent).getThenPart() == cursor.getValue() || parent instanceof J.If.Else && ((J.If.Else)parent).getBody() == cursor.getValue() || parent instanceof Loop && ((Loop)parent).getBody() == cursor.getValue();
        }
        return false;
    }

    public List<J.Annotation> parseAnnotations(Cursor cursor, String template) {
        String cacheKey = this.addImports(this.annotationTemplateGenerator.cacheKey(cursor, template));
        return this.cache(cursor, cacheKey, () -> {
            String stub = this.annotationTemplateGenerator.template(cursor, template);
            this.onBeforeParseTemplate.accept(stub);
            JavaSourceFile cu = this.compileTemplate(stub);
            return this.annotationTemplateGenerator.listAnnotations(cu);
        });
    }

    public Expression parsePackage(Cursor cursor, String template) {
        String stub = this.substitute(PACKAGE_STUB, template);
        this.onBeforeParseTemplate.accept(stub);
        return (Expression)this.cache(cursor, stub, () -> {
            JavaSourceFile cu = this.compileTemplate(stub);
            Expression expression = cu.getPackageDeclaration().getExpression();
            return Collections.singletonList(expression);
        }).get(0);
    }

    private String substitute(String stub, String template) {
        String beforeParse = placeholderHelper.replacePlaceholders(stub, k -> template);
        this.onAfterVariableSubstitution.accept(beforeParse);
        return beforeParse;
    }

    private String addImports(String stub) {
        if (!this.imports.isEmpty()) {
            StringBuilder withImports = new StringBuilder();
            for (String anImport : this.imports) {
                withImports.append(anImport);
            }
            withImports.append(stub);
            return withImports.toString();
        }
        return stub;
    }

    private JavaSourceFile compileTemplate(@Language(value="java") String stub) {
        InMemoryExecutionContext ctx = new InMemoryExecutionContext();
        ctx.putMessage("org.openrewrite.java.skipSourceSetTypeGeneration", (Object)true);
        ctx.putMessage("org.openrewrite.requirePrintEqualsInput", (Object)false);
        Parser jp = this.parser.build();
        return (stub.contains("@SubAnnotation") ? jp.reset().parse((ExecutionContext)ctx, new String[]{stub, SUBSTITUTED_ANNOTATION}) : jp.reset().parse((ExecutionContext)ctx, new String[]{stub})).findFirst().filter(JavaSourceFile.class::isInstance).map(JavaSourceFile.class::cast).orElseThrow(() -> new IllegalArgumentException("Could not parse as Java:\n" + stub));
    }

    private <J2 extends J> List<J2> cacheIfContextFree(Cursor cursor, ContextFreeCacheKey key, UnaryOperator<String> stubMapper, Function<String, List<? extends J>> treeMapper) {
        if (cursor.getParent() == null) {
            throw new IllegalArgumentException("Expecting `cursor` to have a parent element");
        }
        if (!this.contextSensitive) {
            return this.cache(cursor, key, () -> (List)treeMapper.apply((String)stubMapper.apply(key.getTemplate())));
        }
        return treeMapper.apply((String)stubMapper.apply(key.getTemplate()));
    }

    private <J2 extends J> List<J2> cache(Cursor cursor, Object key, Supplier<List<? extends J>> ifAbsent) {
        List<? extends J> js = null;
        Timer.Sample sample = Timer.start();
        Cursor root = cursor.getRoot();
        HashMap<Object, List<? extends J>> cache = (HashMap<Object, List<? extends J>>)root.getMessage(TEMPLATE_CACHE_MESSAGE_KEY);
        if (cache == null) {
            cache = new HashMap<Object, List<? extends J>>();
            root.putMessage(TEMPLATE_CACHE_MESSAGE_KEY, cache);
        } else {
            js = (List<? extends J>)cache.get(key);
        }
        if (js == null) {
            js = ifAbsent.get();
            cache.put(key, js);
            sample.stop(Timer.builder((String)"rewrite.template.cache").tag("result", "miss").register((MeterRegistry)Metrics.globalRegistry));
        } else {
            sample.stop(Timer.builder((String)"rewrite.template.cache").tag("result", "hit").register((MeterRegistry)Metrics.globalRegistry));
        }
        return ListUtils.map(js, j -> (J)new RandomizeIdVisitor().visit((Tree)j, 0));
    }

    private static final class ContextFreeCacheKey {
        private final String template;
        private final List<String> typeVariables;
        private final Class<? extends J> expected;
        private final Set<String> imports;

        @Generated
        public ContextFreeCacheKey(String template, List<String> typeVariables, Class<? extends J> expected, Set<String> imports) {
            this.template = template;
            this.typeVariables = typeVariables;
            this.expected = expected;
            this.imports = imports;
        }

        @Generated
        public String getTemplate() {
            return this.template;
        }

        @Generated
        public List<String> getTypeVariables() {
            return this.typeVariables;
        }

        @Generated
        public Class<? extends J> getExpected() {
            return this.expected;
        }

        @Generated
        public Set<String> getImports() {
            return this.imports;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ContextFreeCacheKey)) {
                return false;
            }
            ContextFreeCacheKey other = (ContextFreeCacheKey)o;
            String this$template = this.getTemplate();
            String other$template = other.getTemplate();
            if (this$template == null ? other$template != null : !this$template.equals(other$template)) {
                return false;
            }
            List<String> this$typeVariables = this.getTypeVariables();
            List<String> other$typeVariables = other.getTypeVariables();
            if (this$typeVariables == null ? other$typeVariables != null : !((Object)this$typeVariables).equals(other$typeVariables)) {
                return false;
            }
            Class<? extends J> this$expected = this.getExpected();
            Class<? extends J> other$expected = other.getExpected();
            if (this$expected == null ? other$expected != null : !this$expected.equals(other$expected)) {
                return false;
            }
            Set<String> this$imports = this.getImports();
            Set<String> other$imports = other.getImports();
            return !(this$imports == null ? other$imports != null : !((Object)this$imports).equals(other$imports));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $template = this.getTemplate();
            result = result * 59 + ($template == null ? 43 : $template.hashCode());
            List<String> $typeVariables = this.getTypeVariables();
            result = result * 59 + ($typeVariables == null ? 43 : ((Object)$typeVariables).hashCode());
            Class<? extends J> $expected = this.getExpected();
            result = result * 59 + ($expected == null ? 43 : $expected.hashCode());
            Set<String> $imports = this.getImports();
            result = result * 59 + ($imports == null ? 43 : ((Object)$imports).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "JavaTemplateParser.ContextFreeCacheKey(template=" + this.getTemplate() + ", typeVariables=" + this.getTypeVariables() + ", expected=" + this.getExpected() + ", imports=" + this.getImports() + ")";
        }
    }
}

