/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.Iterator;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.SourceFile;
import org.openrewrite.SourceFileWithReferences;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.trait.Reference;

public class UsesType<P>
extends TreeVisitor<Tree, P> {
    private final @Nullable String fullyQualifiedType;
    private final @Nullable Predicate<JavaType> typePattern;
    private final Reference.Matcher referenceMatcher;
    private final @Nullable Boolean includeImplicit;

    public UsesType(String fullyQualifiedType, @Nullable Boolean includeImplicit) {
        if (fullyQualifiedType.contains("*")) {
            this.fullyQualifiedType = null;
            if (fullyQualifiedType.indexOf(42) == fullyQualifiedType.length() - 1) {
                int dotdot = fullyQualifiedType.indexOf("..");
                if (dotdot == -1 && fullyQualifiedType.charAt(fullyQualifiedType.length() - 2) == '.') {
                    PackagePattern packagePattern;
                    this.typePattern = packagePattern = new PackagePattern(fullyQualifiedType.substring(0, fullyQualifiedType.length() - 2));
                    this.referenceMatcher = packagePattern;
                } else if (dotdot == fullyQualifiedType.length() - 3) {
                    PackagePrefixPattern packagePrefixPattern;
                    this.typePattern = packagePrefixPattern = new PackagePrefixPattern(fullyQualifiedType.substring(0, dotdot));
                    this.referenceMatcher = packagePrefixPattern;
                } else {
                    GenericPattern genericPattern;
                    this.typePattern = genericPattern = new GenericPattern(Pattern.compile(StringUtils.aspectjNameToPattern((String)fullyQualifiedType)));
                    this.referenceMatcher = genericPattern;
                }
            } else {
                GenericPattern genericPattern;
                this.typePattern = genericPattern = new GenericPattern(Pattern.compile(StringUtils.aspectjNameToPattern((String)fullyQualifiedType)));
                this.referenceMatcher = genericPattern;
            }
        } else {
            this.fullyQualifiedType = fullyQualifiedType;
            this.typePattern = null;
            this.referenceMatcher = new ExactMatch(fullyQualifiedType);
        }
        this.includeImplicit = includeImplicit;
    }

    public boolean isAcceptable(SourceFile sourceFile, P p) {
        return sourceFile instanceof JavaSourceFile || sourceFile instanceof SourceFileWithReferences;
    }

    public @Nullable Tree visit(@Nullable Tree tree, P p) {
        SourceFileWithReferences sourceFile;
        SourceFileWithReferences.References references;
        Iterator iterator;
        if (tree instanceof JavaSourceFile) {
            JavaSourceFile cu;
            JavaSourceFile c = cu = (JavaSourceFile)Objects.requireNonNull(tree);
            for (JavaType type : c.getTypesInUse().getTypesInUse()) {
                JavaType checkType = type instanceof JavaType.Primitive ? type : TypeUtils.asFullyQualified(type);
                if ((c = this.maybeMark(c, checkType)) == cu) continue;
                return c;
            }
            for (J.Import anImport : c.getImports()) {
                if (!(anImport.isStatic() ? (c = this.maybeMark(c, TypeUtils.asFullyQualified(anImport.getQualid().getTarget().getType()))) != cu : (c = this.maybeMark(c, TypeUtils.asFullyQualified(anImport.getQualid().getType()))) != cu)) continue;
                return c;
            }
            if (Boolean.TRUE.equals(this.includeImplicit)) {
                for (JavaType.Method method : c.getTypesInUse().getUsedMethods()) {
                    if ((c = this.maybeMark(c, method.getDeclaringType())) != cu) {
                        return c;
                    }
                    if ((c = this.maybeMark(c, method.getReturnType())) != cu) {
                        return c;
                    }
                    for (JavaType parameterType : method.getParameterTypes()) {
                        if ((c = this.maybeMark(c, parameterType)) == cu) continue;
                        return c;
                    }
                }
            }
        } else if (tree instanceof SourceFileWithReferences && (iterator = (references = (sourceFile = (SourceFileWithReferences)tree).getReferences()).findMatches(this.referenceMatcher).iterator()).hasNext()) {
            Reference ignored = (Reference)iterator.next();
            return SearchResult.found((Tree)sourceFile);
        }
        return tree;
    }

    private JavaSourceFile maybeMark(JavaSourceFile c, @Nullable JavaType type) {
        if (type == null) {
            return c;
        }
        if (this.typePattern != null && TypeUtils.isAssignableTo(this.typePattern, type) || this.fullyQualifiedType != null && TypeUtils.isAssignableTo(this.fullyQualifiedType, type)) {
            return (JavaSourceFile)SearchResult.found((Tree)c);
        }
        return c;
    }

    @Generated
    public @Nullable String getFullyQualifiedType() {
        return this.fullyQualifiedType;
    }

    @Generated
    public @Nullable Predicate<JavaType> getTypePattern() {
        return this.typePattern;
    }

    private static final class PackagePattern
    implements Predicate<JavaType>,
    Reference.Matcher {
        private final String name;

        @Override
        public boolean test(JavaType type) {
            return type instanceof JavaType.FullyQualified && ((JavaType.FullyQualified)type).getFullyQualifiedName().startsWith(this.name) && ((JavaType.FullyQualified)type).getPackageName().equals(this.name);
        }

        public boolean matchesReference(Reference reference) {
            return reference.getKind() == Reference.Kind.TYPE && reference.getValue().startsWith(this.name + '.');
        }

        public Reference.Renamer createRenamer(String newName) {
            return reference -> newName;
        }

        @Generated
        public PackagePattern(String name) {
            this.name = name;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PackagePattern)) {
                return false;
            }
            PackagePattern other = (PackagePattern)o;
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "UsesType.PackagePattern(name=" + this.getName() + ")";
        }
    }

    private static final class PackagePrefixPattern
    implements Predicate<JavaType>,
    Reference.Matcher {
        private final String prefix;
        private final String subPackagePrefix;

        public PackagePrefixPattern(String prefix) {
            this.prefix = prefix;
            this.subPackagePrefix = prefix + '.';
        }

        @Override
        public boolean test(JavaType type) {
            if (type instanceof JavaType.FullyQualified) {
                String packageName = ((JavaType.FullyQualified)type).getPackageName();
                return packageName.equals(this.prefix) || packageName.startsWith(this.subPackagePrefix);
            }
            return false;
        }

        public boolean matchesReference(Reference reference) {
            return reference.getKind() == Reference.Kind.TYPE && reference.getValue().startsWith(this.subPackagePrefix);
        }

        public Reference.Renamer createRenamer(String newName) {
            return reference -> newName;
        }

        @Generated
        public String getPrefix() {
            return this.prefix;
        }

        @Generated
        public String getSubPackagePrefix() {
            return this.subPackagePrefix;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PackagePrefixPattern)) {
                return false;
            }
            PackagePrefixPattern other = (PackagePrefixPattern)o;
            String this$prefix = this.getPrefix();
            String other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
                return false;
            }
            String this$subPackagePrefix = this.getSubPackagePrefix();
            String other$subPackagePrefix = other.getSubPackagePrefix();
            return !(this$subPackagePrefix == null ? other$subPackagePrefix != null : !this$subPackagePrefix.equals(other$subPackagePrefix));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
            String $subPackagePrefix = this.getSubPackagePrefix();
            result = result * 59 + ($subPackagePrefix == null ? 43 : $subPackagePrefix.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "UsesType.PackagePrefixPattern(prefix=" + this.getPrefix() + ", subPackagePrefix=" + this.getSubPackagePrefix() + ")";
        }
    }

    private static final class GenericPattern
    implements Predicate<JavaType>,
    Reference.Matcher {
        private final Pattern pattern;

        @Override
        public boolean test(JavaType type) {
            if (type instanceof JavaType.FullyQualified) {
                return this.pattern.matcher(((JavaType.FullyQualified)type).getFullyQualifiedName()).matches();
            }
            if (type instanceof JavaType.Primitive) {
                return this.pattern.matcher(((JavaType.Primitive)type).getKeyword()).matches();
            }
            return false;
        }

        public boolean matchesReference(Reference reference) {
            return reference.getKind() == Reference.Kind.TYPE && this.pattern.matcher(reference.getValue()).matches();
        }

        public Reference.Renamer createRenamer(String newName) {
            return reference -> newName;
        }

        @Generated
        public GenericPattern(Pattern pattern) {
            this.pattern = pattern;
        }

        @Generated
        public Pattern getPattern() {
            return this.pattern;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GenericPattern)) {
                return false;
            }
            GenericPattern other = (GenericPattern)o;
            Pattern this$pattern = this.getPattern();
            Pattern other$pattern = other.getPattern();
            return !(this$pattern == null ? other$pattern != null : !this$pattern.equals(other$pattern));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Pattern $pattern = this.getPattern();
            result = result * 59 + ($pattern == null ? 43 : $pattern.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "UsesType.GenericPattern(pattern=" + this.getPattern() + ")";
        }
    }

    private static final class ExactMatch
    implements Reference.Matcher {
        private final String qualifiedName;

        public boolean matchesReference(Reference reference) {
            return reference.getKind() == Reference.Kind.TYPE && this.qualifiedName.equals(reference.getValue());
        }

        public Reference.Renamer createRenamer(String newName) {
            return reference -> newName;
        }

        @Generated
        public ExactMatch(String qualifiedName) {
            this.qualifiedName = qualifiedName;
        }

        @Generated
        public String getQualifiedName() {
            return this.qualifiedName;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExactMatch)) {
                return false;
            }
            ExactMatch other = (ExactMatch)o;
            String this$qualifiedName = this.getQualifiedName();
            String other$qualifiedName = other.getQualifiedName();
            return !(this$qualifiedName == null ? other$qualifiedName != null : !this$qualifiedName.equals(other$qualifiedName));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $qualifiedName = this.getQualifiedName();
            result = result * 59 + ($qualifiedName == null ? 43 : $qualifiedName.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "UsesType.ExactMatch(qualifiedName=" + this.getQualifiedName() + ")";
        }
    }
}

