/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Incubating;
import org.openrewrite.java.JavaTypeVisitor;
import org.openrewrite.java.internal.JavaReflectionTypeMapping;
import org.openrewrite.java.internal.JavaTypeCache;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.JavaType;

public class TypeUtils {
    private static final JavaType.Class TYPE_OBJECT = JavaType.ShallowClass.build("java.lang.Object");
    private static final Set<String> COMMON_JAVA_LANG_TYPES = new HashSet<String>(Arrays.asList("Appendable", "AutoCloseable", "Boolean", "Byte", "Character", "CharSequence", "Class", "ClassLoader", "Cloneable", "Comparable", "Double", "Enum", "Error", "Exception", "Float", "FunctionalInterface", "Integer", "Iterable", "Long", "Math", "Number", "Object", "Readable", "Record", "Runnable", "Short", "String", "StringBuffer", "StringBuilder", "System", "Thread", "Throwable", "Void"));
    private static final Map<JavaType.Primitive, JavaType> BOXED_TYPES = new EnumMap<JavaType.Primitive, JavaType>(JavaType.Primitive.class);

    private TypeUtils() {
    }

    public static boolean isObject(@Nullable JavaType type) {
        return type instanceof JavaType.FullyQualified && "java.lang.Object".equals(((JavaType.FullyQualified)type).getFullyQualifiedName());
    }

    public static @Nullable String findQualifiedJavaLangTypeName(String name) {
        return COMMON_JAVA_LANG_TYPES.contains(name) ? "java.lang." + name : null;
    }

    public static boolean isString(@Nullable JavaType type) {
        return type == JavaType.Primitive.String || type instanceof JavaType.Class && "java.lang.String".equals(((JavaType.Class)type).getFullyQualifiedName());
    }

    public static String toFullyQualifiedName(String fqn) {
        return fqn.replace('$', '.');
    }

    public static boolean fullyQualifiedNamesAreEqual(@Nullable String fqn1, @Nullable String fqn2) {
        if (fqn1 != null && fqn2 != null) {
            return fqn1.equals(fqn2) || fqn1.length() == fqn2.length() && TypeUtils.toFullyQualifiedName(fqn1).equals(TypeUtils.toFullyQualifiedName(fqn2));
        }
        return fqn1 == null && fqn2 == null;
    }

    public static boolean isOfType(@Nullable JavaType type1, @Nullable JavaType type2) {
        return TypeUtils.isOfType(type1, type2, ComparisonContext.BOUND);
    }

    public static boolean isOfType(@Nullable JavaType type1, @Nullable JavaType type2, ComparisonContext context) {
        if (type1 == type2 && !(type1 instanceof JavaType.Unknown)) {
            return true;
        }
        if (TypeUtils.isString(type1) && TypeUtils.isString(type2)) {
            return true;
        }
        if (type1 instanceof JavaType.Method && type2 instanceof JavaType.Method) {
            return TypeUtils.isOfTypeMethod((JavaType.Method)type1, (JavaType.Method)type2, context);
        }
        if (type1 instanceof JavaType.Variable && type2 instanceof JavaType.Variable) {
            return TypeUtils.isOfTypeVariable((JavaType.Variable)type1, (JavaType.Variable)type2, context);
        }
        if (type1 instanceof JavaType.Annotation && type2 instanceof JavaType.Annotation) {
            return TypeUtils.isOfTypeAnnotation((JavaType.Annotation)type1, (JavaType.Annotation)type2);
        }
        return TypeUtils.isOfTypeCore(type1, type2, context);
    }

    private static boolean isOfTypeMethod(JavaType.Method type1, JavaType.Method type2, ComparisonContext context) {
        int index;
        if (!(type1.getName().equals(type2.getName()) && type1.getFlagsBitMap() == type2.getFlagsBitMap() && TypeUtils.isOfType(type1.getDeclaringType(), type2.getDeclaringType(), context) && TypeUtils.isOfType(type1.getReturnType(), type2.getReturnType(), context) && type1.getThrownExceptions().size() == type2.getThrownExceptions().size() && type1.getParameterTypes().size() == type2.getParameterTypes().size())) {
            return false;
        }
        for (index = 0; index < type1.getParameterTypes().size(); ++index) {
            if (TypeUtils.isOfType(type1.getParameterTypes().get(index), type2.getParameterTypes().get(index), context)) continue;
            return false;
        }
        for (index = 0; index < type1.getThrownExceptions().size(); ++index) {
            if (TypeUtils.isOfType(type1.getThrownExceptions().get(index), type2.getThrownExceptions().get(index), context)) continue;
            return false;
        }
        return true;
    }

    private static boolean isOfTypeVariable(JavaType.Variable var1, JavaType.Variable var2, ComparisonContext context) {
        return TypeUtils.isOfType(var1.getType(), var2.getType(), context) && TypeUtils.isOfType(var1.getOwner(), var2.getOwner(), context) && var1.getName().equals(var2.getName());
    }

    private static boolean isOfTypeAnnotation(JavaType.Annotation annotation1, JavaType.Annotation annotation2) {
        if (!TypeUtils.isOfType(annotation1.getType(), annotation2.getType())) {
            return false;
        }
        List<JavaType.Annotation.ElementValue> values1 = annotation1.getValues();
        List<JavaType.Annotation.ElementValue> values2 = annotation2.getValues();
        if (values1.size() != values2.size()) {
            return false;
        }
        for (int i = 0; i < values1.size(); ++i) {
            if (TypeUtils.isOfTypeAnnotationElement(values1.get(i), values2.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isOfTypeAnnotationElement(JavaType.Annotation.ElementValue value1, JavaType.Annotation.ElementValue value2) {
        if (!TypeUtils.isOfType(value1.getElement(), value2.getElement())) {
            return false;
        }
        if (value1 instanceof JavaType.Annotation.SingleElementValue) {
            JavaType.Annotation.SingleElementValue singleValue1 = (JavaType.Annotation.SingleElementValue)value1;
            if (value2 instanceof JavaType.Annotation.SingleElementValue) {
                JavaType.Annotation.SingleElementValue singleValue2 = (JavaType.Annotation.SingleElementValue)value2;
                return TypeUtils.isOfType(singleValue1.getReferenceValue(), singleValue2.getReferenceValue()) && Objects.equals(singleValue1.getConstantValue(), singleValue2.getConstantValue());
            }
            JavaType.Annotation.ArrayElementValue arrayValue2 = (JavaType.Annotation.ArrayElementValue)value2;
            return arrayValue2.getReferenceValues() != null && arrayValue2.getReferenceValues().length == 1 && TypeUtils.isOfType(singleValue1.getReferenceValue(), arrayValue2.getReferenceValues()[0]) || arrayValue2.getConstantValues() != null && arrayValue2.getConstantValues().length == 1 && Objects.equals(singleValue1.getConstantValue(), arrayValue2.getConstantValues()[0]);
        }
        if (value2 instanceof JavaType.Annotation.ArrayElementValue) {
            JavaType.Annotation.ArrayElementValue arrayValue1 = (JavaType.Annotation.ArrayElementValue)value1;
            JavaType.Annotation.ArrayElementValue arrayValue2 = (JavaType.Annotation.ArrayElementValue)value2;
            if (arrayValue1.getConstantValues() != null) {
                Object[] constantValues1 = arrayValue1.getConstantValues();
                if (arrayValue2.getConstantValues() == null || arrayValue2.getConstantValues().length != constantValues1.length) {
                    return false;
                }
                for (int i = 0; i < constantValues1.length; ++i) {
                    if (Objects.equals(constantValues1[i], arrayValue2.getConstantValues()[i])) continue;
                    return false;
                }
                return true;
            }
            if (arrayValue1.getReferenceValues() != null) {
                JavaType[] referenceValues1 = arrayValue1.getReferenceValues();
                if (arrayValue2.getReferenceValues() == null || arrayValue2.getReferenceValues().length != referenceValues1.length) {
                    return false;
                }
                for (int i = 0; i < referenceValues1.length; ++i) {
                    if (TypeUtils.isOfType(referenceValues1[i], arrayValue2.getReferenceValues()[i])) continue;
                    return false;
                }
                return true;
            }
        } else {
            return TypeUtils.isOfTypeAnnotationElement(value2, value1);
        }
        return false;
    }

    private static boolean isOfTypeCore(@Nullable JavaType to, @Nullable JavaType from, ComparisonContext context) {
        if (TypeUtils.isPseudoType(to) || TypeUtils.isPseudoType(from)) {
            return false;
        }
        if (to == from) {
            return true;
        }
        if (context.getInference() == ComparisonContext.InferenceDirection.TO && TypeUtils.isTypeVariable(to) || context.getInference() == ComparisonContext.InferenceDirection.FROM && TypeUtils.isTypeVariable(from)) {
            return TypeUtils.isAssignableToCore(to, from, context);
        }
        if (to instanceof JavaType.GenericTypeVariable && from instanceof JavaType.GenericTypeVariable) {
            return TypeUtils.isOfTypeGeneric((JavaType.GenericTypeVariable)to, (JavaType.GenericTypeVariable)from, context);
        }
        if (to instanceof JavaType.FullyQualified && from instanceof JavaType.FullyQualified) {
            return TypeUtils.isOfTypeFullyQualified((JavaType.FullyQualified)to, (JavaType.FullyQualified)from, context);
        }
        if (to instanceof JavaType.Primitive && from instanceof JavaType.Primitive) {
            return TypeUtils.isOfTypePrimitive((JavaType.Primitive)to, (JavaType.Primitive)from, context);
        }
        if (to instanceof JavaType.Array && from instanceof JavaType.Array) {
            return TypeUtils.isOfTypeArray((JavaType.Array)to, (JavaType.Array)from, context);
        }
        if (to instanceof JavaType.Intersection && from instanceof JavaType.Intersection) {
            return TypeUtils.isOfTypeList(((JavaType.Intersection)to).getBounds(), ((JavaType.Intersection)from).getBounds(), context);
        }
        if (to instanceof JavaType.MultiCatch && from instanceof JavaType.MultiCatch) {
            return TypeUtils.isOfTypeList(((JavaType.MultiCatch)to).getThrowableTypes(), ((JavaType.MultiCatch)from).getThrowableTypes(), context);
        }
        return false;
    }

    private static boolean isOfTypeGeneric(JavaType.GenericTypeVariable to, JavaType.GenericTypeVariable from, ComparisonContext context) {
        if (!to.getName().equals(from.getName()) || to.getVariance() != from.getVariance() || to.getBounds().size() != from.getBounds().size()) {
            return false;
        }
        for (int i = 0; i < to.getBounds().size(); ++i) {
            if (TypeUtils.isOfTypeCore(to.getBounds().get(i), from.getBounds().get(i), context)) continue;
            return false;
        }
        return true;
    }

    private static boolean isOfTypeFullyQualified(JavaType.FullyQualified to, JavaType.FullyQualified from, ComparisonContext context) {
        if (!TypeUtils.fullyQualifiedNamesAreEqual(to.getFullyQualifiedName(), from.getFullyQualifiedName())) {
            return false;
        }
        if (to instanceof JavaType.Class && from instanceof JavaType.Class) {
            return true;
        }
        if (to instanceof JavaType.Parameterized && from instanceof JavaType.Parameterized) {
            if (context.isComparing(to, from)) {
                return true;
            }
            if (to.getTypeParameters().size() != from.getTypeParameters().size()) {
                return false;
            }
            List<JavaType> toTypeParams = to.getTypeParameters();
            List<JavaType> fromTypeParams = from.getTypeParameters();
            for (int i = 0; i < toTypeParams.size(); ++i) {
                if (TypeUtils.isOfTypeCore(toTypeParams.get(i), fromTypeParams.get(i), context.enterComparison(to, from))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean isOfTypePrimitive(JavaType.Primitive to, JavaType.Primitive from, ComparisonContext context) {
        return to == from;
    }

    private static boolean isOfTypeArray(JavaType.Array to, JavaType.Array from, ComparisonContext context) {
        if (to.getElemType() instanceof JavaType.Primitive || from.getElemType() instanceof JavaType.Primitive) {
            return to.getElemType() == from.getElemType();
        }
        return TypeUtils.isOfTypeCore(to.getElemType(), from.getElemType(), context);
    }

    private static boolean isOfTypeList(List<JavaType> to, List<JavaType> from, ComparisonContext context) {
        if (to.size() != from.size() || to.stream().anyMatch(e -> !(e instanceof JavaType.FullyQualified)) || from.stream().anyMatch(e -> !(e instanceof JavaType.FullyQualified))) {
            return false;
        }
        JavaType.FullyQualified[] toFq = (JavaType.FullyQualified[])to.stream().map(e -> (JavaType.FullyQualified)e).sorted(Comparator.comparing(JavaType.FullyQualified::getFullyQualifiedName)).toArray(JavaType.FullyQualified[]::new);
        JavaType.FullyQualified[] fromFq = (JavaType.FullyQualified[])from.stream().map(e -> (JavaType.FullyQualified)e).sorted(Comparator.comparing(JavaType.FullyQualified::getFullyQualifiedName)).toArray(JavaType.FullyQualified[]::new);
        for (int i = 0; i < toFq.length; ++i) {
            if (TypeUtils.isOfTypeCore(toFq[i], fromFq[i], context)) continue;
            return false;
        }
        return true;
    }

    public static boolean isOfClassType(@Nullable JavaType type, String fqn) {
        if (type instanceof JavaType.FullyQualified) {
            return TypeUtils.fullyQualifiedNamesAreEqual(((JavaType.FullyQualified)type).getFullyQualifiedName(), fqn);
        }
        if (type instanceof JavaType.Variable) {
            return TypeUtils.isOfClassType(((JavaType.Variable)type).getType(), fqn);
        }
        if (type instanceof JavaType.Method) {
            return TypeUtils.isOfClassType(((JavaType.Method)type).getReturnType(), fqn);
        }
        if (type instanceof JavaType.Array) {
            return TypeUtils.isOfClassType(((JavaType.Array)type).getElemType(), fqn);
        }
        if (type instanceof JavaType.Primitive) {
            return type == JavaType.Primitive.fromKeyword(fqn);
        }
        return false;
    }

    @Incubating(since="8.1.4")
    public static boolean isOfTypeWithName(@Nullable JavaType.FullyQualified type, boolean matchOverride, Predicate<String> matcher) {
        if (type == null || type instanceof JavaType.Unknown) {
            return false;
        }
        if (matcher.test(type.getFullyQualifiedName())) {
            return true;
        }
        if (matchOverride) {
            if (!"java.lang.Object".equals(type.getFullyQualifiedName()) && TypeUtils.isOfTypeWithName(TYPE_OBJECT, true, matcher)) {
                return true;
            }
            if (TypeUtils.isOfTypeWithName(type.getSupertype(), true, matcher)) {
                return true;
            }
            for (JavaType.FullyQualified anInterface : type.getInterfaces()) {
                if (!TypeUtils.isOfTypeWithName(anInterface, true, matcher)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isAssignableTo(@Nullable JavaType to, @Nullable JavaType from) {
        return TypeUtils.isAssignableTo(to, from, ComparisonContext.BOUND);
    }

    public static boolean isAssignableTo(@Nullable JavaType to, @Nullable JavaType from, ComparisonContext context) {
        try {
            if (to == from && !(to instanceof JavaType.Unknown)) {
                return true;
            }
            if (to == JavaType.Primitive.String) {
                to = BOXED_TYPES.get(to);
            }
            if (from == JavaType.Primitive.String) {
                from = BOXED_TYPES.get(from);
            }
            if (to instanceof JavaType.Method && from instanceof JavaType.Method) {
                return TypeUtils.isAssignableToMethod((JavaType.Method)to, (JavaType.Method)from, context);
            }
            if (to instanceof JavaType.Variable && from instanceof JavaType.Variable) {
                return TypeUtils.isAssignableToVariable((JavaType.Variable)to, (JavaType.Variable)from, context);
            }
            if (to instanceof JavaType.Annotation && from instanceof JavaType.Annotation) {
                return TypeUtils.isOfTypeAnnotation((JavaType.Annotation)to, (JavaType.Annotation)from);
            }
            return TypeUtils.isAssignableToCore(to, from, context);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isAssignableToMethod(JavaType.Method type1, JavaType.Method type2, ComparisonContext context) {
        if (!(type1.getName().equals(type2.getName()) && Flag.hasFlags(type1.getFlagsBitMap(), Flag.Static) == Flag.hasFlags(type2.getFlagsBitMap(), Flag.Static) && TypeUtils.isAssignableTo(type1.getDeclaringType(), type2.getDeclaringType(), context) && TypeUtils.isAssignableTo(type1.getReturnType(), type2.getReturnType(), context))) {
            return false;
        }
        for (int index = 0; index < type1.getParameterTypes().size(); ++index) {
            if (TypeUtils.isAssignableTo(type1.getParameterTypes().get(index), type2.getParameterTypes().get(index), context)) continue;
            return false;
        }
        return true;
    }

    private static boolean isAssignableToVariable(JavaType.Variable var1, JavaType.Variable var2, ComparisonContext mode) {
        return TypeUtils.isAssignableTo(var1.getType(), var2.getType(), mode) && TypeUtils.isAssignableTo(var1.getOwner(), var2.getOwner(), mode) && var1.getName().equals(var2.getName());
    }

    private static boolean isAssignableToCore(@Nullable JavaType to, @Nullable JavaType from, ComparisonContext context) {
        if (TypeUtils.isPseudoType(to) || TypeUtils.isPseudoType(from)) {
            return false;
        }
        if (from == JavaType.Primitive.Null) {
            return !(to instanceof JavaType.Primitive);
        }
        if (to == from || TypeUtils.isObject(to)) {
            return true;
        }
        if (context.getInference() == ComparisonContext.InferenceDirection.FROM && TypeUtils.isTypeVariable(from)) {
            return true;
        }
        if (to instanceof JavaType.GenericTypeVariable) {
            return TypeUtils.isAssignableToGeneric((JavaType.GenericTypeVariable)to, from, context);
        }
        if (from instanceof JavaType.GenericTypeVariable) {
            return TypeUtils.isAssignableFromGeneric(to, (JavaType.GenericTypeVariable)from, context);
        }
        if (to instanceof JavaType.Intersection) {
            List<JavaType> bounds = ((JavaType.Intersection)to).getBounds();
            return bounds.stream().allMatch(e -> TypeUtils.isAssignableToCore(e, from, context));
        }
        if (to instanceof JavaType.MultiCatch) {
            List<JavaType> throwableTypes = ((JavaType.MultiCatch)to).getThrowableTypes();
            return throwableTypes.stream().anyMatch(e -> TypeUtils.isAssignableToCore(e, from, context));
        }
        if (from instanceof JavaType.Intersection) {
            List<JavaType> bounds = ((JavaType.Intersection)from).getBounds();
            return bounds.stream().anyMatch(e -> TypeUtils.isAssignableToCore(to, e, context));
        }
        if (from instanceof JavaType.MultiCatch) {
            List<JavaType> throwableTypes = ((JavaType.MultiCatch)from).getThrowableTypes();
            return throwableTypes.stream().allMatch(e -> TypeUtils.isAssignableToCore(to, e, context));
        }
        if (to instanceof JavaType.FullyQualified) {
            return TypeUtils.isAssignableToFullyQualified((JavaType.FullyQualified)to, from, context);
        }
        if (to instanceof JavaType.Array) {
            return TypeUtils.isAssignableToArray((JavaType.Array)to, from, context);
        }
        if (to instanceof JavaType.Primitive) {
            return TypeUtils.isAssignableToPrimitive((JavaType.Primitive)to, from, context);
        }
        return false;
    }

    private static boolean isAssignableToGeneric(JavaType.GenericTypeVariable to, JavaType from, ComparisonContext context) {
        if (TypeUtils.isWildcard(to) || context.getInference() == ComparisonContext.InferenceDirection.TO) {
            if (to.getBounds().isEmpty()) {
                return true;
            }
            JavaType target = TypeUtils.getBounds(to);
            JavaType source = from;
            if (TypeUtils.isWildcard(from) && TypeUtils.isWildcard(to)) {
                JavaType.GenericTypeVariable fromGeneric = (JavaType.GenericTypeVariable)from;
                if (fromGeneric.getBounds().isEmpty()) {
                    return false;
                }
                if (fromGeneric.getVariance() != to.getVariance()) {
                    return false;
                }
                source = Objects.requireNonNull(TypeUtils.getBounds(fromGeneric));
            }
            switch (to.getVariance()) {
                case COVARIANT: {
                    return TypeUtils.isAssignableToCore(target, source, context);
                }
                case CONTRAVARIANT: {
                    return TypeUtils.isAssignableToCore(source, target, context.flipInference());
                }
            }
            assert (context.getInference() == ComparisonContext.InferenceDirection.TO);
            return TypeUtils.isAssignableToCore(target, source, context);
        }
        if (!(from instanceof JavaType.GenericTypeVariable)) {
            return false;
        }
        JavaType.GenericTypeVariable fromGeneric = (JavaType.GenericTypeVariable)from;
        if (to.getName().equals(fromGeneric.getName())) {
            return TypeUtils.isOfTypeCore(to, from, context);
        }
        for (JavaType bound : fromGeneric.getBounds()) {
            if (!TypeUtils.isAssignableToCore(to, bound, context)) continue;
            return true;
        }
        return false;
    }

    private static boolean isAssignableFromGeneric(JavaType to, JavaType.GenericTypeVariable from, ComparisonContext context) {
        if (from.getVariance() == JavaType.GenericTypeVariable.Variance.CONTRAVARIANT) {
            return TypeUtils.isAssignableToCore(TypeUtils.getBounds(from), to, context.flipInference());
        }
        return TypeUtils.isAssignableToCore(to, TypeUtils.getBounds(from), context);
    }

    private static boolean isAssignableToFullyQualified(JavaType.FullyQualified to, @Nullable JavaType from, ComparisonContext context) {
        if (from instanceof JavaType.FullyQualified) {
            JavaType.FullyQualified classFrom = (JavaType.FullyQualified)from;
            if (!TypeUtils.fullyQualifiedNamesAreEqual(to.getFullyQualifiedName(), classFrom.getFullyQualifiedName())) {
                if (TypeUtils.isAssignableToFullyQualified(to, TypeUtils.maybeResolveParameters(classFrom, classFrom.getSupertype()), context)) {
                    return true;
                }
                for (JavaType.FullyQualified i : classFrom.getInterfaces()) {
                    if (!TypeUtils.isAssignableToFullyQualified(to, TypeUtils.maybeResolveParameters(classFrom, i), context)) continue;
                    return true;
                }
                return false;
            }
            if (!(to instanceof JavaType.Parameterized)) {
                return true;
            }
            if (context.isComparing(to, from)) {
                return true;
            }
            if (!(from instanceof JavaType.Parameterized)) {
                for (JavaType typeParameter : to.getTypeParameters()) {
                    if (TypeUtils.isWildcard(typeParameter) && ((JavaType.GenericTypeVariable)typeParameter).getBounds().isEmpty()) continue;
                    return false;
                }
                return true;
            }
            JavaType.Parameterized fromParameterized = (JavaType.Parameterized)from;
            List<JavaType> toParameters = to.getTypeParameters();
            List<JavaType> fromParameters = fromParameterized.getTypeParameters();
            if (toParameters.size() != fromParameters.size()) {
                return false;
            }
            for (int i = 0; i < toParameters.size(); ++i) {
                JavaType toParam = toParameters.get(i);
                JavaType fromParam = fromParameters.get(i);
                if (TypeUtils.isWildcard(toParam) && TypeUtils.isAssignableToCore(toParam, fromParam, context.enterComparison(to, from)) || !TypeUtils.isWildcard(toParam) && TypeUtils.isOfTypeCore(toParam, fromParam, context.enterComparison(to, from))) continue;
                return false;
            }
            return true;
        }
        if (from instanceof JavaType.Array) {
            String fqn = to.getFullyQualifiedName();
            return "java.io.Serializable".equals(fqn) || "java.lang.Cloneable".equals(fqn);
        }
        if (from instanceof JavaType.Primitive) {
            return TypeUtils.isAssignableToFullyQualified(to, BOXED_TYPES.get(from), context);
        }
        return false;
    }

    private static @Nullable JavaType maybeResolveParameters(JavaType.FullyQualified source, @Nullable JavaType.FullyQualified target) {
        if (!(source instanceof JavaType.Parameterized) || !(target instanceof JavaType.Parameterized)) {
            return target;
        }
        JavaType.Parameterized src = (JavaType.Parameterized)source;
        JavaType.Parameterized tgt = (JavaType.Parameterized)target;
        if (src.getTypeParameters().size() != src.getType().getTypeParameters().size()) {
            return tgt;
        }
        IdentityHashMap<JavaType.GenericTypeVariable, JavaType> typeVariableMap = new IdentityHashMap<JavaType.GenericTypeVariable, JavaType>();
        for (int i = 0; i < src.getTypeParameters().size(); ++i) {
            if (!(src.getType().getTypeParameters().get(i) instanceof JavaType.GenericTypeVariable)) continue;
            typeVariableMap.put((JavaType.GenericTypeVariable)src.getType().getTypeParameters().get(i), src.getTypeParameters().get(i));
        }
        ArrayList<JavaType> resolvedTypeParameters = new ArrayList<JavaType>();
        for (JavaType tp : target.getTypeParameters()) {
            resolvedTypeParameters.add(TypeUtils.resolveTypeParameters(tp, typeVariableMap));
        }
        return tgt.withTypeParameters(resolvedTypeParameters);
    }

    private static JavaType resolveTypeParameters(JavaType type, Map<JavaType.GenericTypeVariable, JavaType> replacements) {
        return Objects.requireNonNull(new JavaTypeVisitor<Map<JavaType.GenericTypeVariable, JavaType>>(){

            @Override
            public JavaType visitGenericTypeVariable(JavaType.GenericTypeVariable generic, Map<JavaType.GenericTypeVariable, JavaType> replacements) {
                if (!replacements.containsKey(generic)) {
                    replacements.put(generic, generic);
                    JavaType.GenericTypeVariable resolved = (JavaType.GenericTypeVariable)super.visitGenericTypeVariable(generic, replacements);
                    replacements.put(generic, resolved);
                    return resolved;
                }
                return replacements.get(generic);
            }

            @Override
            public JavaType visitClass(JavaType.Class aClass, Map<JavaType.GenericTypeVariable, JavaType> replacements) {
                return aClass;
            }
        }.visit(type, replacements));
    }

    private static boolean isAssignableToArray(JavaType.Array to, JavaType from, ComparisonContext context) {
        if (from instanceof JavaType.Array) {
            JavaType.Array fromArray = (JavaType.Array)from;
            if (to.getElemType() instanceof JavaType.Primitive || fromArray.getElemType() instanceof JavaType.Primitive) {
                return to.getElemType() == fromArray.getElemType();
            }
            return TypeUtils.isAssignableToCore(to.getElemType(), fromArray.getElemType(), context);
        }
        return false;
    }

    private static boolean isAssignableToPrimitive(JavaType.Primitive to, @Nullable JavaType from, ComparisonContext context) {
        if (from instanceof JavaType.FullyQualified) {
            JavaType.FullyQualified fromFq = (JavaType.FullyQualified)from;
            JavaType.Primitive fromPrimitive = JavaType.Primitive.fromClassName(fromFq.getFullyQualifiedName());
            return TypeUtils.isAssignableToPrimitive(to, fromPrimitive, context);
        }
        if (from instanceof JavaType.Primitive) {
            JavaType.Primitive fromPrimitive = (JavaType.Primitive)from;
            switch (fromPrimitive) {
                case Void: 
                case None: 
                case Null: 
                case String: {
                    return false;
                }
                case Boolean: {
                    return fromPrimitive == to;
                }
            }
            switch (to) {
                case Byte: 
                case Char: {
                    return fromPrimitive == to;
                }
                case Short: {
                    switch (fromPrimitive) {
                        case Byte: 
                        case Char: 
                        case Short: {
                            return true;
                        }
                    }
                    return false;
                }
                case Int: {
                    switch (fromPrimitive) {
                        case Byte: 
                        case Char: 
                        case Short: 
                        case Int: {
                            return true;
                        }
                    }
                    return false;
                }
                case Long: {
                    switch (fromPrimitive) {
                        case Byte: 
                        case Char: 
                        case Short: 
                        case Int: 
                        case Long: {
                            return true;
                        }
                    }
                    return false;
                }
                case Float: {
                    return fromPrimitive != JavaType.Primitive.Double;
                }
                case Double: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private static @Nullable JavaType getBounds(JavaType.GenericTypeVariable type) {
        if (type.getBounds().isEmpty()) {
            return null;
        }
        if (type.getBounds().size() == 1) {
            return type.getBounds().get(0);
        }
        return new JavaType.Intersection(type.getBounds());
    }

    private static boolean isTypeVariable(JavaType type) {
        if (TypeUtils.isWildcard(type)) {
            JavaType.GenericTypeVariable generic = (JavaType.GenericTypeVariable)type;
            return !generic.getBounds().isEmpty() && TypeUtils.isTypeVariable(generic.getBounds().get(0));
        }
        return type instanceof JavaType.GenericTypeVariable;
    }

    private static boolean isWildcard(JavaType type) {
        return type instanceof JavaType.GenericTypeVariable && ((JavaType.GenericTypeVariable)type).getName().equals("?");
    }

    private static boolean isPseudoType(@Nullable JavaType type) {
        return type == null || type instanceof JavaType.Unknown || type instanceof JavaType.Variable || type instanceof JavaType.Method || type instanceof JavaType.Annotation;
    }

    public static boolean isAssignableTo(String to, @Nullable JavaType from) {
        try {
            if (from instanceof JavaType.FullyQualified) {
                Object fromRawType;
                int lessThanIndex;
                if (from instanceof JavaType.Parameterized && (lessThanIndex = to.indexOf(60)) == ((String)(fromRawType = ((JavaType.Parameterized)from).getType().getFullyQualifiedName())).length() && to.startsWith((String)fromRawType) && to.equals(from.toString())) {
                    return true;
                }
                JavaType.FullyQualified classFrom = (JavaType.FullyQualified)from;
                if (TypeUtils.fullyQualifiedNamesAreEqual(to, classFrom.getFullyQualifiedName()) || TypeUtils.isAssignableTo(to, (JavaType)classFrom.getSupertype())) {
                    return true;
                }
                for (JavaType.FullyQualified i : classFrom.getInterfaces()) {
                    if (!TypeUtils.isAssignableTo(to, (JavaType)i)) continue;
                    return true;
                }
                return false;
            }
            if (from instanceof JavaType.GenericTypeVariable) {
                JavaType.GenericTypeVariable genericFrom = (JavaType.GenericTypeVariable)from;
                for (JavaType bound : genericFrom.getBounds()) {
                    if (!TypeUtils.isAssignableTo(to, bound)) continue;
                    return true;
                }
            } else if (from instanceof JavaType.Primitive) {
                JavaType.Primitive toPrimitive = JavaType.Primitive.fromKeyword(to);
                if (toPrimitive != null) {
                    return TypeUtils.isAssignableTo(toPrimitive, from);
                }
                if ("java.lang.String".equals(to)) {
                    return TypeUtils.isAssignableTo(JavaType.Primitive.String, from);
                }
            } else {
                if (from instanceof JavaType.Variable) {
                    return TypeUtils.isAssignableTo(to, ((JavaType.Variable)from).getType());
                }
                if (from instanceof JavaType.Method) {
                    return TypeUtils.isAssignableTo(to, ((JavaType.Method)from).getReturnType());
                }
                if (from instanceof JavaType.Intersection) {
                    for (JavaType bound : ((JavaType.Intersection)from).getBounds()) {
                        if (!TypeUtils.isAssignableTo(to, bound)) continue;
                        return true;
                    }
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return to.equals("java.lang.Object");
    }

    public static boolean isAssignableTo(Pattern to, @Nullable JavaType from) {
        return TypeUtils.isAssignableTo((JavaType type) -> {
            if (type instanceof JavaType.FullyQualified) {
                return to.matcher(((JavaType.FullyQualified)type).getFullyQualifiedName()).matches();
            }
            if (type instanceof JavaType.Primitive) {
                return to.matcher(((JavaType.Primitive)type).getKeyword()).matches();
            }
            return false;
        }, from);
    }

    public static boolean isAssignableTo(Predicate<JavaType> predicate, @Nullable JavaType from) {
        try {
            if (from instanceof JavaType.FullyQualified) {
                JavaType.FullyQualified classFrom = (JavaType.FullyQualified)from;
                if (predicate.test(classFrom) || TypeUtils.isAssignableTo(predicate, (JavaType)classFrom.getSupertype())) {
                    return true;
                }
                for (JavaType.FullyQualified anInterface : classFrom.getInterfaces()) {
                    if (!TypeUtils.isAssignableTo(predicate, (JavaType)anInterface)) continue;
                    return true;
                }
                return false;
            }
            if (from instanceof JavaType.GenericTypeVariable) {
                JavaType.GenericTypeVariable genericFrom = (JavaType.GenericTypeVariable)from;
                for (JavaType bound : genericFrom.getBounds()) {
                    if (!TypeUtils.isAssignableTo(predicate, bound)) continue;
                    return true;
                }
            } else {
                if (from instanceof JavaType.Variable) {
                    return TypeUtils.isAssignableTo(predicate, ((JavaType.Variable)from).getType());
                }
                if (from instanceof JavaType.Method) {
                    return TypeUtils.isAssignableTo(predicate, ((JavaType.Method)from).getReturnType());
                }
                if (from instanceof JavaType.Primitive) {
                    JavaType.Primitive primitive = (JavaType.Primitive)from;
                    return predicate.test(primitive);
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public static @Nullable JavaType.Class asClass(@Nullable JavaType type) {
        return type instanceof JavaType.Class ? (JavaType.Class)type : null;
    }

    public static @Nullable JavaType.Parameterized asParameterized(@Nullable JavaType type) {
        return type instanceof JavaType.Parameterized ? (JavaType.Parameterized)type : null;
    }

    public static @Nullable JavaType.Array asArray(@Nullable JavaType type) {
        return type instanceof JavaType.Array ? (JavaType.Array)type : null;
    }

    public static @Nullable JavaType.GenericTypeVariable asGeneric(@Nullable JavaType type) {
        return type instanceof JavaType.GenericTypeVariable ? (JavaType.GenericTypeVariable)type : null;
    }

    public static @Nullable JavaType.Primitive asPrimitive(@Nullable JavaType type) {
        return type instanceof JavaType.Primitive ? (JavaType.Primitive)type : null;
    }

    public static @Nullable JavaType.FullyQualified asFullyQualified(@Nullable JavaType type) {
        if (type instanceof JavaType.FullyQualified && !(type instanceof JavaType.Unknown)) {
            return (JavaType.FullyQualified)type;
        }
        return null;
    }

    public static boolean isOverride(@Nullable JavaType.Method method) {
        return TypeUtils.findOverriddenMethod(method).isPresent();
    }

    public static Optional<JavaType.Method> findOverriddenMethod(@Nullable JavaType.Method method) {
        Optional<JavaType.Method> methodResult;
        JavaType.FullyQualified dt;
        block2: {
            JavaType.FullyQualified i;
            if (method == null) {
                return Optional.empty();
            }
            dt = method.getDeclaringType();
            List<JavaType> argTypes = method.getParameterTypes();
            methodResult = TypeUtils.findDeclaredMethod(dt.getSupertype(), method.getName(), argTypes);
            if (methodResult.isPresent()) break block2;
            Iterator<JavaType.FullyQualified> iterator = dt.getInterfaces().iterator();
            while (iterator.hasNext() && !(methodResult = TypeUtils.findDeclaredMethod(i = iterator.next(), method.getName(), argTypes)).isPresent()) {
            }
        }
        return methodResult.filter(m -> !m.getFlags().contains((Object)Flag.Private)).filter(m -> !m.getFlags().contains((Object)Flag.Static)).filter(m -> m.getFlags().contains((Object)Flag.Public) || m.getDeclaringType().getPackageName().equals(dt.getPackageName()));
    }

    public static Optional<JavaType.Method> findDeclaredMethod(@Nullable JavaType.FullyQualified clazz, String name, List<JavaType> argumentTypes) {
        if (clazz == null) {
            return Optional.empty();
        }
        for (JavaType.Method method : clazz.getMethods()) {
            if (!TypeUtils.methodHasSignature(clazz, method, name, argumentTypes)) continue;
            return Optional.of(method);
        }
        Optional<JavaType.Method> methodResult = TypeUtils.findDeclaredMethod(clazz.getSupertype(), name, argumentTypes);
        if (methodResult.isPresent()) {
            return methodResult;
        }
        for (JavaType.FullyQualified i : clazz.getInterfaces()) {
            methodResult = TypeUtils.findDeclaredMethod(i, name, argumentTypes);
            if (!methodResult.isPresent()) continue;
            return methodResult;
        }
        return Optional.empty();
    }

    private static boolean methodHasSignature(JavaType.FullyQualified clazz, JavaType.Method m, String name, List<JavaType> argTypes) {
        if (!name.equals(m.getName())) {
            return false;
        }
        List<JavaType> mArgs = m.getParameterTypes();
        if (mArgs.size() != argTypes.size()) {
            return false;
        }
        IdentityHashMap<JavaType, JavaType> parameterMap = new IdentityHashMap<JavaType, JavaType>();
        List<JavaType> declaringTypeParams = m.getDeclaringType().getTypeParameters();
        List<JavaType> typeParameters = clazz.getTypeParameters();
        if (typeParameters.size() != declaringTypeParams.size()) {
            return false;
        }
        for (int j = 0; j < typeParameters.size(); ++j) {
            JavaType typeAttributed = typeParameters.get(j);
            JavaType generic = declaringTypeParams.get(j);
            parameterMap.put(generic, typeAttributed);
        }
        for (int i = 0; i < mArgs.size(); ++i) {
            JavaType actual;
            JavaType declared = mArgs.get(i);
            if (TypeUtils.isOfType(declared, actual = argTypes.get(i)) || parameterMap.get(declared) == actual) continue;
            return false;
        }
        return true;
    }

    public static boolean isWellFormedType(@Nullable JavaType type) {
        return TypeUtils.isWellFormedType(type, new HashSet<JavaType>());
    }

    public static boolean isWellFormedType(@Nullable JavaType type, Set<JavaType> seen) {
        if (type == null || type instanceof JavaType.Unknown) {
            return false;
        }
        return TypeUtils.isWellFormedType0(type, seen);
    }

    private static boolean isWellFormedType0(JavaType type, Set<JavaType> seen) {
        if (!seen.add(type)) {
            return true;
        }
        if (type instanceof JavaType.Parameterized) {
            JavaType.Parameterized parameterized = (JavaType.Parameterized)type;
            return TypeUtils.isWellFormedType(parameterized.getType(), seen) && parameterized.getTypeParameters().stream().allMatch(it -> TypeUtils.isWellFormedType(it, seen));
        }
        if (type instanceof JavaType.Array) {
            JavaType.Array arr = (JavaType.Array)type;
            return TypeUtils.isWellFormedType(arr.getElemType(), seen);
        }
        if (type instanceof JavaType.GenericTypeVariable) {
            JavaType.GenericTypeVariable gen = (JavaType.GenericTypeVariable)type;
            return gen.getBounds().stream().allMatch(it -> TypeUtils.isWellFormedType(it, seen));
        }
        if (type instanceof JavaType.Variable) {
            JavaType.Variable var = (JavaType.Variable)type;
            return TypeUtils.isWellFormedType(var.getType(), seen) && TypeUtils.isWellFormedType(var.getOwner(), seen);
        }
        if (type instanceof JavaType.MultiCatch) {
            JavaType.MultiCatch mc = (JavaType.MultiCatch)type;
            return mc.getThrowableTypes().stream().allMatch(it -> TypeUtils.isWellFormedType(it, seen));
        }
        if (type instanceof JavaType.Method) {
            JavaType.Method m = (JavaType.Method)type;
            return TypeUtils.isWellFormedType(m.getReturnType(), seen) && TypeUtils.isWellFormedType(m.getDeclaringType(), seen) && m.getParameterTypes().stream().allMatch(it -> TypeUtils.isWellFormedType(it, seen));
        }
        return true;
    }

    public static JavaType.FullyQualified unknownIfNull(@Nullable JavaType.FullyQualified t) {
        if (t == null) {
            return JavaType.Unknown.getInstance();
        }
        return t;
    }

    public static JavaType unknownIfNull(@Nullable JavaType t) {
        if (t == null) {
            return JavaType.Unknown.getInstance();
        }
        return t;
    }

    static boolean deepEquals(@Nullable List<? extends JavaType> ts1, @Nullable List<? extends JavaType> ts2) {
        if (ts1 == null || ts2 == null) {
            return ts1 == null && ts2 == null;
        }
        if (ts1.size() != ts2.size()) {
            return false;
        }
        for (int i = 0; i < ts1.size(); ++i) {
            JavaType t1 = ts1.get(i);
            JavaType t2 = ts2.get(i);
            if (!(t1 == null ? t2 != null : !TypeUtils.deepEquals(t1, t2))) continue;
            return false;
        }
        return true;
    }

    static boolean deepEquals(@Nullable JavaType t, @Nullable JavaType t2) {
        return t == null ? t2 == null : t == t2 || t.equals(t2);
    }

    public static String toString(JavaType type) {
        return TypeUtils.toString(type, new IdentityHashMap<JavaType, Boolean>());
    }

    private static String toString(JavaType type, IdentityHashMap<JavaType, Boolean> recursiveTypes) {
        if (type instanceof JavaType.Primitive) {
            return ((JavaType.Primitive)type).getKeyword();
        }
        if (type instanceof JavaType.Class) {
            return ((JavaType.Class)type).getFullyQualifiedName();
        }
        if (type instanceof JavaType.Parameterized) {
            JavaType.Parameterized parameterized = (JavaType.Parameterized)type;
            String base = TypeUtils.toString(parameterized.getType(), recursiveTypes);
            StringJoiner joiner = new StringJoiner(", ", "<", ">");
            for (JavaType parameter : parameterized.getTypeParameters()) {
                joiner.add(TypeUtils.toString(parameter, recursiveTypes));
            }
            return base + joiner;
        }
        if (type instanceof JavaType.GenericTypeVariable) {
            JavaType.GenericTypeVariable genericType = (JavaType.GenericTypeVariable)type;
            if (!genericType.getName().equals("?")) {
                return genericType.getName();
            }
            if (genericType.getVariance() == JavaType.GenericTypeVariable.Variance.INVARIANT || genericType.getBounds().size() != 1) {
                return "?";
            }
            if (recursiveTypes.containsKey(genericType)) {
                recursiveTypes.put(genericType, true);
                return "?";
            }
            recursiveTypes.put(genericType, false);
            String variance = genericType.getVariance() == JavaType.GenericTypeVariable.Variance.COVARIANT ? "? extends " : "? super ";
            String bound = TypeUtils.toString(genericType.getBounds().get(0), recursiveTypes);
            if (!recursiveTypes.get(genericType).booleanValue()) {
                recursiveTypes.remove(genericType);
                return variance + bound;
            }
            return "?";
        }
        if (type instanceof JavaType.Array) {
            return TypeUtils.toString(((JavaType.Array)type).getElemType(), recursiveTypes) + "[]";
        }
        if (type instanceof JavaType.Intersection) {
            JavaType.Intersection intersection = (JavaType.Intersection)type;
            StringJoiner joiner = new StringJoiner(" & ");
            for (JavaType bound : intersection.getBounds()) {
                joiner.add(TypeUtils.toString(bound, recursiveTypes));
            }
            return joiner.toString();
        }
        if (type instanceof JavaType.MultiCatch) {
            JavaType.MultiCatch multiCatch = (JavaType.MultiCatch)type;
            StringJoiner joiner = new StringJoiner(" | ");
            for (JavaType throwableType : multiCatch.getThrowableTypes()) {
                joiner.add(TypeUtils.toString(throwableType, recursiveTypes));
            }
            return joiner.toString();
        }
        if (type instanceof JavaType.Method) {
            return TypeUtils.toString(((JavaType.Method)type).getReturnType(), recursiveTypes);
        }
        if (type instanceof JavaType.Variable) {
            return TypeUtils.toString(((JavaType.Variable)type).getType(), recursiveTypes);
        }
        return type.toString();
    }

    public static String toGenericTypeString(JavaType.GenericTypeVariable type) {
        if (type.getVariance() != JavaType.GenericTypeVariable.Variance.COVARIANT || type.getBounds().isEmpty()) {
            return type.getName();
        }
        StringJoiner bounds = new StringJoiner(" & ");
        for (JavaType bound : type.getBounds()) {
            bounds.add(TypeUtils.toString(bound));
        }
        return type.getName() + " extends " + bounds;
    }

    static {
        JavaReflectionTypeMapping typeMapping = new JavaReflectionTypeMapping(new JavaTypeCache());
        BOXED_TYPES.put(JavaType.Primitive.Boolean, typeMapping.type((Type)((Object)Boolean.class)));
        BOXED_TYPES.put(JavaType.Primitive.Byte, typeMapping.type((Type)((Object)Byte.class)));
        BOXED_TYPES.put(JavaType.Primitive.Char, typeMapping.type((Type)((Object)Character.class)));
        BOXED_TYPES.put(JavaType.Primitive.Short, typeMapping.type((Type)((Object)Short.class)));
        BOXED_TYPES.put(JavaType.Primitive.Int, typeMapping.type((Type)((Object)Integer.class)));
        BOXED_TYPES.put(JavaType.Primitive.Long, typeMapping.type((Type)((Object)Long.class)));
        BOXED_TYPES.put(JavaType.Primitive.Float, typeMapping.type((Type)((Object)Float.class)));
        BOXED_TYPES.put(JavaType.Primitive.Double, typeMapping.type((Type)((Object)Double.class)));
        BOXED_TYPES.put(JavaType.Primitive.String, typeMapping.type((Type)((Object)String.class)));
        BOXED_TYPES.put(JavaType.Primitive.Void, JavaType.Unknown.getInstance());
        BOXED_TYPES.put(JavaType.Primitive.None, JavaType.Unknown.getInstance());
        BOXED_TYPES.put(JavaType.Primitive.Null, JavaType.Unknown.getInstance());
    }

    public static class ComparisonContext {
        public static final ComparisonContext INFER = new ComparisonContext(null, null, InferenceDirection.TO, null);
        public static final ComparisonContext BOUND = new ComparisonContext(null, null, InferenceDirection.NONE, null);
        private final @Nullable JavaType to;
        private final @Nullable JavaType from;
        private final InferenceDirection inference;
        private final @Nullable ComparisonContext parent;

        private ComparisonContext(@Nullable JavaType to, @Nullable JavaType from, InferenceDirection inference, @Nullable ComparisonContext parent) {
            this.to = to;
            this.from = from;
            this.inference = inference;
            this.parent = parent;
        }

        public boolean isComparing(JavaType to, JavaType from) {
            return Objects.equals(this.to, to) && Objects.equals(this.from, from) || this.parent != null && this.parent.isComparing(to, from);
        }

        public ComparisonContext enterComparison(JavaType to, JavaType from) {
            return new ComparisonContext(to, from, this.inference, this);
        }

        public ComparisonContext flipInference() {
            return new ComparisonContext(null, null, this.inference.flip(), this);
        }

        InferenceDirection getInference() {
            return this.inference;
        }

        static enum InferenceDirection {
            TO,
            FROM,
            NONE;


            public InferenceDirection flip() {
                switch (this.ordinal()) {
                    case 0: {
                        return FROM;
                    }
                    case 1: {
                        return TO;
                    }
                }
                return NONE;
            }
        }
    }
}

