/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.internal.parser;

import java.util.List;
import org.objectweb.asm.AnnotationVisitor;
import org.openrewrite.java.internal.parser.AnnotationAttributeApplier;
import org.openrewrite.java.internal.parser.AnnotationDeserializer;
import org.openrewrite.java.internal.parser.AnnotationVisitorCreator;

class AnnotationApplier {
    AnnotationApplier() {
    }

    public static void applyAnnotations(String annotationsStr, AnnotationVisitorCreator visitAnnotation) {
        if (annotationsStr.isEmpty()) {
            return;
        }
        List<AnnotationDeserializer.AnnotationInfo> annotations = AnnotationDeserializer.parseAnnotations(annotationsStr);
        for (AnnotationDeserializer.AnnotationInfo annotationInfo : annotations) {
            AnnotationApplier.applyAnnotation(annotationInfo, visitAnnotation);
        }
    }

    public static void applyAnnotation(String annotationStr, AnnotationVisitorCreator visitAnnotation) {
        if (!annotationStr.startsWith("@")) {
            return;
        }
        AnnotationDeserializer.AnnotationInfo annotationInfo = AnnotationDeserializer.parseAnnotation(annotationStr);
        AnnotationApplier.applyAnnotation(annotationInfo, visitAnnotation);
    }

    private static void applyAnnotation(AnnotationDeserializer.AnnotationInfo annotationInfo, AnnotationVisitorCreator visitAnnotation) {
        AnnotationVisitor av = visitAnnotation.create(annotationInfo.getDescriptor(), true);
        if (av != null) {
            AnnotationAttributeApplier.applyAttributes(av, annotationInfo.getAttributes());
            av.visitEnd();
        }
    }
}

