/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.internal.parser;

import java.util.ArrayList;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.objectweb.asm.AnnotationVisitor;
import org.openrewrite.java.internal.parser.AnnotationSerializer;

class AnnotationCollectorHelper {
    AnnotationCollectorHelper() {
    }

    static AnnotationVisitor createCollector(String annotationDescriptor, List<String> collectedAnnotations) {
        return new AnnotationValueCollector(result -> {
            String serializedAnnotation = result.isEmpty() ? AnnotationSerializer.serializeSimpleAnnotation(annotationDescriptor) : AnnotationSerializer.serializeAnnotationWithAttributes(annotationDescriptor, result.toArray(new String[0]));
            collectedAnnotations.add(serializedAnnotation);
        });
    }

    static class AnnotationValueCollector
    extends AnnotationVisitor {
        private final ResultCallback callback;
        private final List<String> collectedValues = new ArrayList<String>();

        AnnotationValueCollector(ResultCallback callback) {
            super(589824);
            this.callback = callback;
        }

        public void visit(@Nullable String name, Object value) {
            String serializedValue = AnnotationSerializer.serializeValue(value);
            this.addCollectedValue(name, serializedValue);
        }

        public void visitEnum(@Nullable String name, String descriptor, String value) {
            String serializedValue = AnnotationSerializer.serializeEnumConstant(descriptor, value);
            this.addCollectedValue(name, serializedValue);
        }

        public AnnotationVisitor visitAnnotation(@Nullable String name, String nestedAnnotationDescriptor) {
            return new AnnotationValueCollector(result -> {
                String nestedAnnotation = result.isEmpty() ? AnnotationSerializer.serializeSimpleAnnotation(nestedAnnotationDescriptor) : AnnotationSerializer.serializeAnnotationWithAttributes(nestedAnnotationDescriptor, result.toArray(new String[0]));
                this.addCollectedValue(name, nestedAnnotation);
            });
        }

        public AnnotationVisitor visitArray(@Nullable String name) {
            return new ArrayValueCollector(arrayValues -> {
                String arrayValue = AnnotationSerializer.serializeArray(arrayValues.toArray(new String[0]));
                this.addCollectedValue(name, arrayValue);
            });
        }

        public void visitEnd() {
            this.callback.onResult(this.collectedValues);
        }

        private void addCollectedValue(@Nullable String name, String value) {
            if (name == null) {
                this.collectedValues.add(value);
            } else {
                this.collectedValues.add(AnnotationSerializer.serializeAttribute(name, value));
            }
        }
    }

    @FunctionalInterface
    static interface ResultCallback {
        public void onResult(List<String> var1);
    }

    static class ArrayValueCollector
    extends AnnotationVisitor {
        private final List<String> arrayValues = new ArrayList<String>();
        private final ResultCallback callback;

        ArrayValueCollector(ResultCallback callback) {
            super(589824);
            this.callback = callback;
        }

        public void visit(@Nullable String name, Object value) {
            this.arrayValues.add(AnnotationSerializer.serializeValue(value));
        }

        public void visitEnum(@Nullable String name, String descriptor, String value) {
            this.arrayValues.add(AnnotationSerializer.serializeEnumConstant(descriptor, value));
        }

        public AnnotationVisitor visitAnnotation(@Nullable String name, String descriptor) {
            return new AnnotationValueCollector(result -> {
                String annotation = result.isEmpty() ? AnnotationSerializer.serializeSimpleAnnotation(descriptor) : AnnotationSerializer.serializeAnnotationWithAttributes(descriptor, result.toArray(new String[0]));
                this.arrayValues.add(annotation);
            });
        }

        public void visitEnd() {
            this.callback.onResult(this.arrayValues);
        }
    }
}

