/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.graph;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.openrewrite.maven.tree.GroupArtifactVersion;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.maven.tree.ResolvedGroupArtifactVersion;
import org.openrewrite.semver.DependencyMatcher;

public class DependencyTreeWalker {
    public static void walk(List<ResolvedDependency> roots, @Nullable DependencyMatcher matcher, Callback callback) {
        ArrayDeque<ResolvedDependency> path = new ArrayDeque<ResolvedDependency>();
        for (ResolvedDependency root : roots) {
            DependencyTreeWalker.walkRecursive(root, matcher, path, callback);
        }
    }

    public static void walk(ResolvedDependency root, @Nullable DependencyMatcher matcher, Callback callback) {
        ArrayDeque<ResolvedDependency> path = new ArrayDeque<ResolvedDependency>();
        DependencyTreeWalker.walkRecursive(root, matcher, path, callback);
    }

    private static void walkRecursive(ResolvedDependency dependency, @Nullable DependencyMatcher matcher, Deque<ResolvedDependency> path, Callback callback) {
        if (DependencyTreeWalker.containsDependency(path, dependency)) {
            return;
        }
        path.addFirst(dependency);
        if (matcher == null || matcher.matches(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion())) {
            callback.accept(dependency, new ArrayDeque<ResolvedDependency>(path));
        }
        for (ResolvedDependency child : dependency.getDependencies()) {
            DependencyTreeWalker.walkRecursive(child, matcher, path, callback);
        }
        path.removeFirst();
    }

    private static boolean containsDependency(Deque<ResolvedDependency> path, ResolvedDependency dependency) {
        for (ResolvedDependency dep : path) {
            if (!dep.getGroupId().equals(dependency.getGroupId()) || !dep.getArtifactId().equals(dependency.getArtifactId())) continue;
            return true;
        }
        return false;
    }

    public static String renderPath(String scopeOrConfig, Deque<ResolvedDependency> dependencyPath) {
        if (dependencyPath.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int depth = 0;
        for (ResolvedDependency dep : dependencyPath) {
            if (depth == 0) {
                sb.append(DependencyTreeWalker.formatDependency(dep.getGav()));
            } else {
                DependencyTreeWalker.appendIndentedLine(sb, depth - 1, DependencyTreeWalker.formatDependency(dep.getGav()));
            }
            ++depth;
        }
        DependencyTreeWalker.appendIndentedLine(sb, depth - 1, scopeOrConfig);
        return sb.toString();
    }

    private static void appendIndentedLine(StringBuilder tree, int depth, String content) {
        tree.append("\n");
        for (int i = 0; i < depth; ++i) {
            tree.append("     ");
        }
        tree.append("\\--- ").append(content);
    }

    private static String formatDependency(ResolvedGroupArtifactVersion gav) {
        return gav.getGroupId() + ":" + gav.getArtifactId() + ":" + gav.getVersion();
    }

    @FunctionalInterface
    public static interface Callback {
        public void accept(ResolvedDependency var1, Deque<ResolvedDependency> var2);
    }

    public static class Matches<S> {
        private final Map<S, Set<GroupArtifactVersion>> scopeToDirectDependency = new HashMap<S, Set<GroupArtifactVersion>>();
        private final Map<GroupArtifactVersion, Set<GroupArtifactVersion>> directDependencyToTargetDependency = new HashMap<GroupArtifactVersion, Set<GroupArtifactVersion>>();

        public void collect(S scope, ResolvedDependency root, DependencyMatcher matcher, @Nullable Callback callback) {
            DependencyTreeWalker.walk(root, matcher, (matched, path) -> {
                ResolvedDependency directDependency = (ResolvedDependency)path.getLast();
                GroupArtifactVersion directGav = directDependency.getGav().asGroupArtifactVersion();
                GroupArtifactVersion matchedGav = matched.getGav().asGroupArtifactVersion();
                this.scopeToDirectDependency.computeIfAbsent(scope, __ -> new HashSet()).add(directGav);
                this.directDependencyToTargetDependency.computeIfAbsent(directGav, __ -> new HashSet()).add(matchedGav);
                if (callback != null) {
                    callback.accept(matched, path);
                }
            });
        }

        public Map<S, Set<GroupArtifactVersion>> byScope() {
            return this.scopeToDirectDependency;
        }

        public Map<GroupArtifactVersion, Set<GroupArtifactVersion>> byDirectDependency() {
            return this.directDependencyToTargetDependency;
        }

        public boolean isEmpty() {
            return this.directDependencyToTargetDependency.isEmpty();
        }
    }
}

